/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.LDAPRestore;
import com.netscape.admin.dirserv.task.ListDB;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class RestoreDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private boolean _isLocal;
    private String _baseDir;
    private JPanel _contentPanel;
    private JPanel _mainPanel;
    private JTextField _tfDirectory;
    private JComboBox _comboAvailableBackups;
    private JButton _bBrowse;
    private boolean _isCancelled = true;
    private boolean _userProvidedBackupList = false;
    private static final String HELP_TOKEN = "tasks-restore-help";
    private static ResourceSet _resource = DSUtil._resource;
    private final String NO_BACKUPS_FOUND = _resource.getString("restoredialog", "nobackupsfound-label");
    private final JLabel LOOKING_FOR_BACKUPS = UIFactory.makeJLabel("restoredialog", "lookingforbackups", _resource);

    public RestoreDialog(DSFramework dSFramework) {
        super((Frame)((Object)dSFramework), null, true, 11);
        this._framework = dSFramework;
        ((Dialog)((Object)this)).setTitle(_resource.getString("restoredialog", "title"));
        this._contentPanel = new JPanel(new GridBagLayout());
        this._isLocal = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        JLabel jLabel = UIFactory.makeJLabel("restoredialog", "lavailablebackups", _resource);
        this._comboAvailableBackups = new JComboBox();
        this._comboAvailableBackups.addActionListener(this);
        jLabel.setLabelFor(this._comboAvailableBackups);
        this._comboAvailableBackups.setToolTipText(jLabel.getToolTipText());
        String string = this._isLocal ? "ldirectory" : "ldirectoryonserver";
        JLabel jLabel2 = UIFactory.makeJLabel("restoredialog", string, _resource);
        this._tfDirectory = UIFactory.makeJTextField(this, "restoredialog", string, null, 30, _resource);
        jLabel2.setLabelFor(this._tfDirectory);
        this._bBrowse = UIFactory.makeJButton(this, "restoredialog", "bbrowse", _resource);
        this._bBrowse.setEnabled(this._isLocal);
        String string2 = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
        String string3 = (String)this._framework.getServerObject().getServerInfo().get("ServerInstance");
        this._baseDir = string2 + '/' + string3 + "/bak";
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        this._contentPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = -1;
        jPanel.add((Component)this._tfDirectory, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._bBrowse, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this._contentPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this._contentPanel.add((Component)this._comboAvailableBackups, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets.top = 0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this._mainPanel = new JPanel(new GridBagLayout());
        this.setComponent(this._mainPanel);
        this.showComponent(this._contentPanel);
        this.setFocusComponent(this._tfDirectory);
        this.setOKButtonEnabled(false);
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void setAvailableBackups(String[] stringArray) {
        this._comboAvailableBackups.removeAllItems();
        int n = 0;
        while (n < stringArray.length) {
            this._comboAvailableBackups.addItem(stringArray[n]);
            ++n;
        }
        if (stringArray.length == 0) {
            this._comboAvailableBackups.addItem(this.NO_BACKUPS_FOUND);
        }
        this._userProvidedBackupList = true;
    }

    public void setDefaultBackup(String string) {
        this._comboAvailableBackups.setSelectedItem(string);
    }

    public void pack() {
        if (!this._userProvidedBackupList) {
            String string = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
            String string2 = (String)this._framework.getServerObject().getServerInfo().get("ServerInstance");
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            String string3 = string + '/' + string2 + "/bak/" + simpleDateFormat.format(date);
            this._comboAvailableBackups.addItem(string3);
            super.pack();
            this._comboAvailableBackups.removeItem(string3);
        } else {
            super.pack();
        }
    }

    public void show() {
        if (!this._userProvidedBackupList) {
            this.showComponent(this.LOOKING_FOR_BACKUPS);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    ListDB listDB = new ListDB(RestoreDialog.this._framework.getServerObject().getServerInfo());
                    String[] stringArray = listDB.getBackupList();
                    SwingUtilities.invokeLater(new Runnable(this, stringArray){
                        private final /* synthetic */ String[] val$backups;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$backups = stringArray;
                        }

                        public void run() {
                            int n = 0;
                            while (n < this.val$backups.length) {
                                RestoreDialog.access$200(1.access$100(this.this$1)).addItem(this.val$backups[n]);
                                ++n;
                            }
                            if (this.val$backups.length == 0) {
                                RestoreDialog.access$200(1.access$100(this.this$1)).addItem(RestoreDialog.access$300(1.access$100(this.this$1)));
                            }
                            RestoreDialog.access$400(1.access$100(this.this$1)).setText("");
                            RestoreDialog.access$600(1.access$100(this.this$1), RestoreDialog.access$500(1.access$100(this.this$1)));
                        }
                    });
                }

                static /* synthetic */ RestoreDialog access$100(1 var0) {
                    return var0.RestoreDialog.this;
                }
            });
            thread.start();
            super.show();
        } else {
            super.show();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        if (object2 == this._bBrowse) {
            String string;
            String string2 = this._tfDirectory.getText().trim();
            if (string2.length() == 0) {
                if (DSFileDialog.getDefaultDirectory() == null) {
                    DSFileDialog.setDefaultDirectory(this._baseDir);
                }
            } else {
                DSFileDialog.setDefaultDirectory(string2);
            }
            if ((string = DSFileDialog.browseDirectories(false, this._bBrowse)) != null) {
                this._tfDirectory.setText(string);
            }
        } else if (object2 == this._comboAvailableBackups && (object = this._comboAvailableBackups.getSelectedItem()) != this.NO_BACKUPS_FOUND) {
            this._tfDirectory.setText((String)object);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._tfDirectory.getDocument()) {
            this.setOKButtonEnabled(!this._tfDirectory.getText().trim().equals(""));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    protected void okInvoked() {
        String string = this._tfDirectory.getText();
        int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "warning", (String[])null, "restoredialog", _resource);
        if (n == 0) {
            super.okInvoked();
            new LDAPRestore(this._framework, string);
            this._isCancelled = false;
        }
    }

    private void showComponent(JComponent jComponent) {
        this._mainPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof JLabel) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
        } else {
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
        }
        this._mainPanel.add((Component)jComponent, gridBagConstraints);
        this._mainPanel.revalidate();
        this._mainPanel.repaint();
    }

    static /* synthetic */ JComboBox access$200(RestoreDialog restoreDialog) {
        return restoreDialog._comboAvailableBackups;
    }

    static /* synthetic */ String access$300(RestoreDialog restoreDialog) {
        return restoreDialog.NO_BACKUPS_FOUND;
    }

    static /* synthetic */ JTextField access$400(RestoreDialog restoreDialog) {
        return restoreDialog._tfDirectory;
    }

    static /* synthetic */ JPanel access$500(RestoreDialog restoreDialog) {
        return restoreDialog._contentPanel;
    }

    static /* synthetic */ void access$600(RestoreDialog restoreDialog, JComponent jComponent) {
        restoreDialog.showComponent(jComponent);
    }
}

