/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.SubtreeSelectionDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.LDAPExport;
import com.netscape.admin.dirserv.task.LDAPSearchExport;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPConnection;

class ExportDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    DSFramework _framework;
    private JPanel _contentPanel;
    private JTextField _tfFile;
    private JButton _bBrowse;
    private JTextField _tfSubtree;
    private JButton _bBrowseSubtree;
    private JRadioButton _rbAllSuffixes;
    private JRadioButton _rbSubtree;
    private JRadioButton _rbInConsole;
    private JRadioButton _rbInServer;
    private SubtreeSelectionDialog _dlg;
    private boolean _isCancelled = true;
    private boolean _isLocal;
    private String _defaultPath;
    private static final String HELP_TOKEN = "tasks-export-help";
    private static ResourceSet _resource = DSUtil._resource;

    public ExportDialog(DSFramework dSFramework) {
        super((Frame)((Object)dSFramework), null, true, 11);
        this._framework = dSFramework;
        ((Dialog)((Object)this)).setTitle(_resource.getString("exportdialog", "title"));
        this.createContentPanel();
        this.setComponent(this._contentPanel);
        this.setFocusComponent(this._tfFile);
        this.setOKButtonEnabled(false);
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bBrowse) {
            this.actionBrowse();
        } else if (object == this._rbAllSuffixes || object == this._rbSubtree) {
            this._bBrowseSubtree.setEnabled(this._rbSubtree.isSelected());
            this._tfSubtree.setEnabled(this._rbSubtree.isSelected());
        } else if (object == this._rbInConsole || object == this._rbInServer) {
            this._bBrowse.setEnabled(this._rbInConsole.isSelected());
        } else if (object == this._bBrowseSubtree) {
            this.actionBrowseSubtree();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        String string = this._tfFile.getText().trim();
        boolean bl = !string.equals("");
        this.setOKButtonEnabled(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    protected void okInvoked() {
        boolean bl = this._isLocal || this._rbInServer.isSelected();
        boolean bl2 = this.testExportFileAndConnection();
        String string = null;
        if (this._rbSubtree.isSelected()) {
            string = this._tfSubtree.getText().trim();
        }
        if (!bl2) {
            super.okInvoked();
            if (bl) {
                new LDAPExport(this._framework, this._tfFile.getText(), string);
            } else {
                new LDAPSearchExport(this._framework, this._tfFile.getText(), string);
            }
        }
    }

    private void createContentPanel() {
        JPanel jPanel;
        Object object;
        Object object2;
        this._contentPanel = new JPanel(new GridBagLayout());
        this._isLocal = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        if (this._isLocal) {
            object2 = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
            object = (String)this._framework.getServerObject().getServerInfo().get("ServerInstance");
            this._defaultPath = (String)object2 + '/' + (String)object + "/ldif";
        } else {
            this._defaultPath = ".";
        }
        object2 = UIFactory.makeJLabel("exportdialog", "lfile", _resource);
        this._tfFile = UIFactory.makeJTextField(this, "exportdialog", "lfile", null, 30, _resource);
        ((JLabel)object2).setLabelFor(this._tfFile);
        this._bBrowse = UIFactory.makeJButton(this, "exportdialog", "bbrowse", _resource);
        this._rbInConsole = UIFactory.makeJRadioButton(this, "exportdialog", "rbinconsole", false, _resource);
        this._rbInServer = UIFactory.makeJRadioButton(this, "exportdialog", "rbinserver", false, _resource);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._rbInConsole);
        ((ButtonGroup)object).add(this._rbInServer);
        this._rbInServer.setSelected(false);
        this._rbInConsole.setSelected(true);
        this._rbAllSuffixes = UIFactory.makeJRadioButton(this, "exportdialog", "rballsuffixes", false, _resource);
        this._rbSubtree = UIFactory.makeJRadioButton(this, "exportdialog", "rbsubtree", false, _resource);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._rbAllSuffixes);
        ((ButtonGroup)object).add(this._rbSubtree);
        this._rbInServer.setSelected(false);
        this._rbInConsole.setSelected(true);
        this._tfSubtree = UIFactory.makeJTextField(null, "", "", null, 30, _resource);
        this._bBrowseSubtree = UIFactory.makeJButton(this, "exportdialog", "bbrowsesubtree", _resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this._contentPanel.add((Component)object2, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        this._contentPanel.add((Component)this._tfFile, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this._contentPanel.add((Component)this._bBrowse, gridBagConstraints);
        if (!this._isLocal) {
            jPanel = new JPanel(new GridBagLayout());
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.gridwidth = 3;
            jPanel.add((Component)this._rbInConsole, gridBagConstraints);
            gridBagConstraints.insets.left = UIFactory.getComponentSpace();
            gridBagConstraints.gridwidth = -1;
            jPanel.add((Component)this._rbInServer, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.top = UIFactory.getComponentSpace();
            this._contentPanel.add((Component)jPanel, gridBagConstraints);
            this._contentPanel.add((Component)new JSeparator(0), gridBagConstraints);
        }
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 4;
        this._contentPanel.add((Component)this._rbAllSuffixes, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)this._rbSubtree, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        this._contentPanel.add((Component)this._tfSubtree, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)this._bBrowseSubtree, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets.top = 0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this._rbInConsole.setSelected(true);
        this._bBrowse.setSelected(this._rbInConsole.isSelected());
        this._rbAllSuffixes.setSelected(true);
        this._bBrowseSubtree.setEnabled(this._rbSubtree.isSelected());
        this._tfSubtree.setEnabled(this._rbSubtree.isSelected());
    }

    private void actionBrowse() {
        String string;
        String string2 = this._tfFile.getText().trim();
        String[] stringArray = new String[]{"ldif"};
        String[] stringArray2 = new String[]{_resource.getString("exportdialog", "ldif-description")};
        if (DSFileDialog.getDefaultDirectory() == null) {
            DSFileDialog.setDefaultDirectory(this._defaultPath);
        }
        if ((string = DSFileDialog.browseFiles(string2, true, stringArray, stringArray2, this._bBrowse)) != null) {
            this._tfFile.setText(string);
        }
    }

    private void actionBrowseSubtree() {
        if (this._dlg == null) {
            this._dlg = new SubtreeSelectionDialog(this._framework);
        }
        this._dlg.packAndShow();
        if (this._dlg.isOk()) {
            this._tfSubtree.setText(this._dlg.getDN());
        }
    }

    private boolean testExportFileAndConnection() {
        String[] stringArray;
        LDAPConnection lDAPConnection;
        boolean bl = false;
        boolean bl2 = this._isLocal || this._rbInServer.isSelected();
        boolean bl3 = this._rbInConsole.isSelected() || this._isLocal;
        String string = this._tfFile.getText().trim();
        File file = new File(string);
        if (bl3) {
            if (!file.isAbsolute()) {
                string = DSFileDialog.getDefaultDirectory() != null ? DSFileDialog.getDefaultDirectory() + File.separator + string : this._defaultPath + File.separator + string;
            }
            file = new File(string);
        } else if (!file.isAbsolute()) {
            lDAPConnection = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
            stringArray = (String[])this._framework.getServerObject().getServerInfo().get("ServerInstance");
            string = (String)lDAPConnection + '/' + (String)stringArray + "/ldif/" + string;
        }
        if (!bl && bl3 && DSUtil.fileExists(file)) {
            lDAPConnection = new LDAPConnection[]{DSUtil.inverseAbreviateString(string, 40)};
            int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-delete-export-file", (String[])lDAPConnection, "exportdialog", _resource);
            boolean bl4 = bl = n != 0;
        }
        if (!bl && !bl2) {
            try {
                lDAPConnection = new FileOutputStream(file);
            }
            catch (Exception exception) {
                stringArray = new String[]{DSUtil.inverseAbreviateString(string, 40)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "cannotwritefile-title", "cannotwritefile-msg", stringArray, "exportdialog", _resource);
                bl = true;
            }
            if (!bl && !DSUtil.isLocalDirectoryManager(lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection())) {
                int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "needtobedirectorymanager", (String[])null, "exportdialog", _resource);
                bl = 0 != n;
            }
        }
        this._tfFile.setText(string);
        return bl;
    }
}

