/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.task.CGIReportTask;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.TaskPage;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommManager;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.topology.ServerNode;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPException;

public class CGITask
extends TaskObject
implements CommClient {
    private boolean _fFinished = false;
    protected String _sCmd = null;
    private String _sAdminURL = null;
    protected boolean _success = false;
    protected int _errorCode = 0;
    private String _reply = null;
    protected GenericProgressDialog _statusDialog;
    protected String _section = "";
    private boolean _async = true;
    protected boolean _serverRemovedDialogDisplayed = false;
    private IPage _viewInstance;
    static final ResourceSet _resource = DSUtil._resource;

    public boolean run(IPage iPage) {
        if (this._sCmd == null) {
            Debug.println((String)("Could not get execref for " + this.getDN()));
            return false;
        }
        return this.run(iPage, this._sCmd);
    }

    boolean run(IPage iPage, String string) {
        this._viewInstance = iPage;
        if (this._consoleInfo.get("admin35") != null) {
            string = this.getCommand();
        }
        this._sAdminURL = this._consoleInfo.getAdminURL();
        if (this._sAdminURL == null) {
            Debug.println((String)("Could not get adminURL for " + this.getDN()));
            return false;
        }
        String string2 = (String)this._consoleInfo.get(string);
        if (string2 == null) {
            string2 = (String)this._consoleInfo.get("ServerInstance");
        }
        String string3 = this._sAdminURL + string2 + "/" + string;
        Framework framework = null;
        if (iPage != null) {
            framework = (Framework)iPage.getFramework();
            framework.setBusyCursor(true);
        }
        try {
            this._errorCode = 0;
            this._success = false;
            this._fFinished = false;
            Hashtable hashtable = (Hashtable)this._consoleInfo.get("arguments");
            ByteArrayInputStream byteArrayInputStream = null;
            if (hashtable != null && !hashtable.isEmpty()) {
                byteArrayInputStream = CGIReportTask.encode(hashtable);
            }
            Debug.println((String)("Posting " + string3));
            int n = 2;
            if (this._async) {
                n |= 1;
            }
            HttpManager httpManager = new HttpManager();
            httpManager.setResponseTimeout(180000);
            Debug.println((String)("CGITask.run(): response timeout is " + httpManager.getResponseTimeout() + " ms"));
            CommManager.setSendUTF8((boolean)true);
            Debug.println((String)("CGITask.run(): before post this=" + (Object)((Object)this) + " cmd=" + string3));
            if (byteArrayInputStream == null) {
                httpManager.post(new URL(string3), (CommClient)this, null, null, 0, n);
            } else {
                httpManager.post(new URL(string3), (CommClient)this, null, (InputStream)byteArrayInputStream, byteArrayInputStream.available(), n);
            }
            Debug.println((String)("CGITask.run(): after post this=" + (Object)((Object)this) + " cmd=" + string3));
            this.awaitSuccess();
            Debug.println((String)("Command executed: " + string3));
        }
        catch (Exception exception) {
            if (exception instanceof ConnectException) {
                if (SwingUtilities.isEventDispatchThread()) {
                    DSUtil.showErrorDialog(null, "admin-down", "", "dirtask");
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                DSUtil.showErrorDialog(null, "admin-down", "", "dirtask");
                            }
                        });
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            Debug.println((String)("Command " + string3 + " failed: " + exception));
        }
        if (framework != null) {
            framework.setBusyCursor(false);
        }
        return this._success;
    }

    public String username(Object object, CommRecord commRecord) {
        return (String)this._consoleInfo.get("AdminUsername");
    }

    public String password(Object object, CommRecord commRecord) {
        return (String)this._consoleInfo.get("AdminUserPassword");
    }

    public synchronized void awaitSuccess() {
        while (!this._fFinished) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void finish() {
        this._fFinished = true;
        Debug.println((String)("CGITask.finish(): before notifyAll this=" + (Object)((Object)this) + " cmd=" + this._sCmd + " adminURL=" + this._sAdminURL));
        ((Object)((Object)this)).notifyAll();
        Debug.println((String)("CGITask.finish(): after notifyAll this=" + (Object)((Object)this) + " cmd=" + this._sCmd + " adminURL=" + this._sAdminURL));
    }

    public void replyHandler(InputStream inputStream, CommRecord commRecord) {
        this._serverRemovedDialogDisplayed = false;
        Debug.println((String)("CGITask.replyHandler(): BEGIN this=" + (Object)((Object)this) + " cr=" + commRecord));
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            boolean bl = false;
            while (!bl && (this._reply = bufferedReader.readLine()) != null) {
                Debug.println((String)("CGITask.replyHandler: read [" + this._reply + "]"));
                if (this._reply.indexOf("error:could not read config file") >= 0) {
                    if (this._serverRemovedDialogDisplayed) continue;
                    if (SwingUtilities.isEventDispatchThread()) {
                        DSUtil.showErrorDialog(null, "server-uninstalled", "", "dirtask");
                        DSAdmin dSAdmin = this.findServerObject(this._viewInstance);
                        if (dSAdmin != null) {
                            dSAdmin.notifyServerRemoved();
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DSUtil.showErrorDialog(null, "server-uninstalled", "", "dirtask");
                                DSAdmin dSAdmin = CGITask.this.findServerObject(CGITask.this._viewInstance);
                                if (dSAdmin != null) {
                                    dSAdmin.notifyServerRemoved();
                                }
                            }
                        });
                    }
                    this._serverRemovedDialogDisplayed = true;
                    this._errorCode = 2;
                    this._success = false;
                    bl = true;
                    continue;
                }
                if (this._reply.startsWith("NMC_Status:") || this._reply.startsWith("NMC_STATUS:")) {
                    int n = this._reply.indexOf(":");
                    String string = this._reply.substring(n + 1).trim();
                    this._errorCode = Integer.parseInt(string);
                    this._success = this._errorCode == 0;
                    bl = true;
                    continue;
                }
                if (this._statusDialog == null || this._reply.startsWith("Content-type: text/html") || this._reply.startsWith("NMC")) continue;
                this._statusDialog.appendTextToTextArea(this._reply + "\n");
            }
        }
        catch (Exception exception) {
            Debug.println((String)("CGITask.replyHandler: " + exception.toString()));
        }
        Debug.println((String)("CGITask.replyHandler(): END this=" + (Object)((Object)this) + " cr=" + commRecord));
        this.finish();
    }

    public void errorHandler(Exception exception, CommRecord commRecord) {
        Debug.println((String)("CGITask.errorHandler: " + exception));
        if (exception instanceof InterruptedIOException) {
            Debug.println((int)0, (String)"CGITask.errorHandler: response timeout has elapsed");
            Debug.println((int)0, (String)"CGITask.errorHandler: it might be not big enough");
        }
        this.finish();
    }

    public String getDN() {
        return this._consoleInfo.getCurrentDN();
    }

    public String getReply() {
        return this._reply;
    }

    private String getCommand() {
        String string = (String)this._consoleInfo.get("execref");
        if (string != null) {
            return "bin/" + string;
        }
        return null;
    }

    private void showDialog(JFrame jFrame, String string, String string2, boolean bl) {
        if (bl) {
            DSUtil.showErrorDialog((Component)jFrame, string, string2, "dirtask");
        } else {
            DSUtil.showInformationDialog((Component)jFrame, string, string2, "dirtask");
        }
    }

    protected void showResultDialog(boolean bl) {
        if (bl) {
            this.showDialog(null, this._section + "-success", "", false);
        } else {
            this.showDialog(null, this._section + "-failed", "", true);
        }
    }

    protected void showResultDialog(int n, String string) {
        String string2 = "error-" + Integer.toString(n) + "-msg";
        String string3 = this._section + "-failed-title";
        DSUtil.showErrorDialog(null, string3, string2, string, "dirtask");
    }

    protected void setAsync(boolean bl) {
        this._async = bl;
    }

    protected DSAdmin findServerObject(IPage iPage) {
        DSAdmin dSAdmin = null;
        if (iPage instanceof TaskPage) {
            DSFramework dSFramework = (DSFramework)iPage.getFramework();
            dSAdmin = dSFramework.getServerObject();
        } else if (iPage instanceof ResourcePage) {
            ResourcePage resourcePage = (ResourcePage)iPage;
            ServerNode serverNode = (ServerNode)resourcePage.getSelection()[0];
            dSAdmin = (DSAdmin)serverNode.getServerObject();
        }
        if (dSAdmin == null) {
            Debug.println((int)0, (String)("CGITask.findServerObject: cannot find server object from " + iPage));
        }
        return dSAdmin;
    }

    protected boolean isSSLEnabled(IPage iPage) {
        int n;
        DSAdmin dSAdmin = this.findServerObject(iPage);
        try {
            n = dSAdmin != null ? dSAdmin.getSecurityState() : DSAdmin.SECURITY_DISABLE;
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)"CGITask.isSSLEnabled: can't read nsslapd-security");
            Debug.println((int)0, (String)"CGITask.isSSLEnabled: considering SSL as disabled");
            n = DSAdmin.SECURITY_DISABLE;
        }
        return n == DSAdmin.SECURITY_ENABLE;
    }

    protected String findInstanceName(IPage iPage) {
        String string;
        DSAdmin dSAdmin = this.findServerObject(iPage);
        if (dSAdmin != null) {
            string = dSAdmin.getInstanceName();
        } else {
            Debug.println((int)0, (String)("CGITask.findInstanceName: can't find name from " + iPage));
            string = "no-name";
        }
        return string;
    }

    public String toString() {
        return "CGITask cmd=" + this._sCmd + " adminURL=" + this._sAdminURL + " async=" + this._async;
    }
}

