/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.AgreementStatus;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.PendingChangesSearcher;
import com.netscape.admin.dirserv.status.PendingChangesWarningDialog;
import com.netscape.admin.dirserv.status.ReplicationStatusCellRenderer;
import com.netscape.admin.dirserv.status.ReplicationStatusTableModel;
import com.netscape.admin.dirserv.status.SortTableHeaderRenderer;
import com.netscape.admin.dirserv.status.StatusRefreshPanel;
import com.netscape.admin.dirserv.status.TableViewOptions;
import com.netscape.admin.dirserv.status.ViewOptionsDialog;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class StatusReplicationPanel
extends StatusRefreshPanel
implements TableColumnModelListener,
ListSelectionListener {
    private JButton _bViewOptions;
    private JButton _bViewPendingChanges;
    private AgreementStatus[] _agreementStatus;
    private ReplicationStatusTableModel _tableModel;
    private JTable _table;
    private boolean _tableInitialized;
    private ViewOptionsDialog _viewDlg;
    private TableViewOptions _viewOptions;
    private TableViewOptions _defaultViewOptions;
    private boolean _ignoreColumnModelEvents = false;
    private boolean _showPendingChangesWarning = true;
    private String[] _toolTips;
    private final JLabel REFRESH_LABEL = new JLabel(this._resource.getString("replicationpanel", "reading-label"));
    private static final String REPLICATION_STATUS_SORTED_BY = "REPLICATION_STATUS_SORTED_BY";
    private static final String REPLICATION_STATUS_SORT_ASCENDING = "REPLICATION_STATUS_SORT_ASCENDING";
    private static final String REPLICATION_STATUS_VISIBLE_COLUMNS = "REPLICATION_STATUS_VISIBLE_COLUMNS";
    private static final String REPLICATION_STATUS_COLUMN_ORDER = "REPLICATION_STATUS_COLUMN_ORDER";
    private static final String REPLICATION_STATUS_SHOW_PENDINGCHANGES_WARNING = "REPLICATION_STATUS_SHOW_PENDINGCHANGES_WARNING";
    private Preferences _preferences = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0").getPreferences("DS_MISCELLANEOUS");
    static /* synthetic */ Class class$java$lang$String;

    public StatusReplicationPanel(IStatusModel iStatusModel) {
        super(iStatusModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bViewOptions) {
            this.actionViewOptions();
        } else if (object == this._bViewPendingChanges) {
            this.actionViewPendingChanges();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        this._bViewPendingChanges.setEnabled(n != -1);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (!this._ignoreColumnModelEvents && tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
            TableColumnModel tableColumnModel = (TableColumnModel)tableColumnModelEvent.getSource();
            int n = -1;
            TableColumn tableColumn = tableColumnModel.getColumn(tableColumnModelEvent.getFromIndex());
            int n2 = -1;
            TableColumn tableColumn2 = tableColumnModel.getColumn(tableColumnModelEvent.getToIndex());
            int n3 = this._viewOptions.columns.length;
            int n4 = 0;
            while (n4 < n3 && (n == -1 || n2 == -1)) {
                TableColumn tableColumn3 = this._viewOptions.columns[n4].column;
                if (tableColumn3 == tableColumn) {
                    n = n4;
                } else if (tableColumn3 == tableColumn2) {
                    n2 = n4;
                }
                ++n4;
            }
            int n5 = this._viewOptions.columns[n].position;
            this._viewOptions.columns[n].position = this._viewOptions.columns[n2].position;
            this._viewOptions.columns[n2].position = n5;
            String string = "";
            int n6 = 0;
            while (n6 < this._viewOptions.columns.length) {
                string = n6 == 0 ? string + String.valueOf(this._viewOptions.columns[n6].position) : string + " " + this._viewOptions.columns[n6].position;
                ++n6;
            }
            this._preferences.set(REPLICATION_STATUS_COLUMN_ORDER, string);
        }
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected void initResources() {
        this._helpToken = "status-replication-help";
        this._taRights = new MultilineLabel(this._resource.getString("replicationpanel", "rights-label"), 4, 50);
        this._taError = new MultilineLabel(2, 50);
    }

    protected void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            try {
                if (this.hasRights()) {
                    if (this._contentPane == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                StatusReplicationPanel.this.showComponent(StatusReplicationPanel.this.REFRESH_LABEL, true);
                            }
                        });
                        this.createContentPane();
                        this.createDefaultViewOptions();
                        this.createViewOptions();
                        this._showPendingChangesWarning = this._preferences.getBoolean(REPLICATION_STATUS_SHOW_PENDINGCHANGES_WARNING, true);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                StatusReplicationPanel.this._lUpdating.setVisible(true);
                            }
                        });
                    }
                    this._agreementStatus = this.readAgreements();
                    this.sortAgreements(this._agreementStatus, this._viewOptions.sortedBy, this._viewOptions.sortAscending);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusReplicationPanel.this._tableModel.updateData(StatusReplicationPanel.this._agreementStatus);
                            if (!StatusReplicationPanel.this._tableInitialized) {
                                StatusReplicationPanel.this.updateTableWithViewOptions(StatusReplicationPanel.this._viewOptions);
                                StatusReplicationPanel.this._tableInitialized = true;
                            }
                            StatusReplicationPanel.this.showComponent(StatusReplicationPanel.this._contentPane, false);
                            StatusReplicationPanel.this._lUpdating.setVisible(false);
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusReplicationPanel.this.showComponent(StatusReplicationPanel.this._taRights, true);
                        }
                    });
                }
            }
            catch (NullPointerException nullPointerException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusReplicationPanel.this.showComponent(StatusReplicationPanel.this._taRights, true);
                    }
                });
            }
            catch (LDAPException lDAPException) {
                final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusReplicationPanel.this._taError.setText(StatusReplicationPanel.this._resource.getString("replicationpanel", "error-reloading-label", stringArray));
                        StatusReplicationPanel.this.showComponent(StatusReplicationPanel.this._taError, true);
                    }
                });
            }
            this._isReloading = false;
        }
    }

    protected JPanel createButtonPanel() {
        this._bHelp = UIFactory.makeJButton(this, "refreshpanel", "bhelp", this._resource);
        this._bViewOptions = UIFactory.makeJButton(this, "replicationpanel", "bviewoptions", this._resource);
        this._bViewPendingChanges = UIFactory.makeJButton(this, "replicationpanel", "bviewpendingchanges", this._resource);
        this._bViewPendingChanges.setEnabled(false);
        this._bHelp.setVisible(false);
        this._bViewPendingChanges.setVisible(false);
        this._bViewOptions.setVisible(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)this._bViewOptions, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel.add((Component)this._bViewPendingChanges, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._bHelp, gridBagConstraints);
        return jPanel;
    }

    protected void showComponent(JComponent jComponent, boolean bl) {
        super.showComponent(jComponent, bl);
        this._bViewOptions.setVisible(!bl);
        this._bViewPendingChanges.setVisible(!bl);
    }

    private boolean hasRights() throws LDAPException {
        boolean bl = true;
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        try {
            String[] stringArray = new String[]{"dn"};
            LDAPEntry lDAPEntry = lDAPConnection.read("cn=replication, cn=config", stringArray);
            bl = lDAPEntry != null;
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                bl = false;
            }
            throw lDAPException;
        }
        return bl;
    }

    private void createContentPane() {
        Serializable serializable;
        String[] stringArray = new String[]{this._resource.getString("replicationpanel", "suffix-header"), this._resource.getString("replicationpanel", "remotereplica-header"), this._resource.getString("replicationpanel", "description-header"), this._resource.getString("replicationpanel", "state-header"), this._resource.getString("replicationpanel", "summary-header"), this._resource.getString("replicationpanel", "numberchangessent-header"), this._resource.getString("replicationpanel", "lastupdatestart-header"), this._resource.getString("replicationpanel", "lastupdateend-header"), this._resource.getString("replicationpanel", "lastupdatemessage-header"), this._resource.getString("replicationpanel", "lastinitializationmessage-header"), this._resource.getString("replicationpanel", "lastinitializationstart-header"), this._resource.getString("replicationpanel", "lastinitializationend-header")};
        String[] stringArray2 = new String[]{this._resource.getString("replicationpanel", "suffix-ttip"), this._resource.getString("replicationpanel", "remotereplica-ttip"), this._resource.getString("replicationpanel", "description-ttip"), this._resource.getString("replicationpanel", "state-ttip"), this._resource.getString("replicationpanel", "summary-ttip"), this._resource.getString("replicationpanel", "numberchangessent-ttip"), this._resource.getString("replicationpanel", "lastupdatestart-ttip"), this._resource.getString("replicationpanel", "lastupdateend-ttip"), this._resource.getString("replicationpanel", "lastupdatemessage-ttip"), this._resource.getString("replicationpanel", "lastinitializationmessage-ttip"), this._resource.getString("replicationpanel", "lastinitializationstart-ttip"), this._resource.getString("replicationpanel", "lastinitializationend-ttip")};
        this._toolTips = stringArray2;
        this._contentPane = new JPanel(new GridBagLayout());
        JPanel jPanel = this.createRefreshArea();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this._contentPane.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = UIFactory.makeJLabel("replicationpanel", "lagreements", this._resource);
        this._tableModel = new ReplicationStatusTableModel();
        this._tableModel.setHeaders(stringArray);
        this._table = new JTable(this._tableModel);
        this._table.setAutoResizeMode(3);
        this._table.setColumnSelectionAllowed(false);
        this._table.getSelectionModel().setSelectionMode(0);
        this._table.getSelectionModel().addListSelectionListener(this);
        jLabel.setLabelFor(this._table);
        ReplicationStatusCellRenderer replicationStatusCellRenderer = new ReplicationStatusCellRenderer();
        replicationStatusCellRenderer.setToolTips(this._toolTips);
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusReplicationPanel.class$("java.lang.String")) : class$java$lang$String, replicationStatusCellRenderer);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = StatusReplicationPanel.this._table.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = StatusReplicationPanel.this._table.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    ((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortAscending = !((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortAscending;
                    ((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortedBy = n2;
                    SortTableHeaderRenderer sortTableHeaderRenderer = (SortTableHeaderRenderer)((Object)((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.columns[0].column.getHeaderRenderer());
                    sortTableHeaderRenderer.setSortAscending(((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortAscending);
                    sortTableHeaderRenderer.setSortColumn(((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortedBy);
                    StatusReplicationPanel.this._preferences.set(StatusReplicationPanel.REPLICATION_STATUS_SORTED_BY, ((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortedBy);
                    StatusReplicationPanel.this._preferences.set(StatusReplicationPanel.REPLICATION_STATUS_SORT_ASCENDING, ((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortAscending);
                    StatusReplicationPanel.this.sortAgreements(StatusReplicationPanel.this._agreementStatus, ((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortedBy, ((StatusReplicationPanel)StatusReplicationPanel.this)._viewOptions.sortAscending);
                    StatusReplicationPanel.this._table.tableChanged(new TableModelEvent(StatusReplicationPanel.this._tableModel));
                }
            }
        };
        JTableHeader jTableHeader = this._table.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        tableColumnModel.addColumnModelListener(this);
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        SortTableHeaderRenderer sortTableHeaderRenderer = new SortTableHeaderRenderer();
        sortTableHeaderRenderer.setDefaultHeaderRenderer(tableColumnModel.getColumn(0).getHeaderRenderer());
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            serializable.setHeaderRenderer((TableCellRenderer)((Object)sortTableHeaderRenderer));
        }
        serializable = new JScrollPane(this._table, 20, 30);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPane.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this._contentPane.add((Component)serializable, gridBagConstraints);
    }

    private void createDefaultViewOptions() {
        this._defaultViewOptions = new TableViewOptions();
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[tableColumnModel.getColumnCount()];
        int n = 0;
        while (n < tableColumnArray.length) {
            tableColumnArray[n] = tableColumnModel.getColumn(n);
            ++n;
        }
        this._defaultViewOptions.init(tableColumnArray, 0, true);
        if (this._toolTips != null) {
            int n2 = 0;
            while (n2 < this._defaultViewOptions.columns.length) {
                this._defaultViewOptions.columns[n2].toolTip = this._toolTips[n2];
                ++n2;
            }
        }
        this._defaultViewOptions.columns[0].isVisible = true;
        this._defaultViewOptions.columns[1].isVisible = true;
        this._defaultViewOptions.columns[3].isVisible = true;
        this._defaultViewOptions.columns[4].isVisible = true;
    }

    private void createViewOptions() {
        this._viewOptions = new TableViewOptions();
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[tableColumnModel.getColumnCount()];
        int n = 0;
        while (n < tableColumnArray.length) {
            tableColumnArray[n] = tableColumnModel.getColumn(n);
            ++n;
        }
        int n2 = this._preferences.getInt(REPLICATION_STATUS_SORTED_BY, this._defaultViewOptions.sortedBy);
        boolean bl = this._preferences.getBoolean(REPLICATION_STATUS_SORT_ASCENDING, this._defaultViewOptions.sortAscending);
        this._viewOptions.init(tableColumnArray, n2, bl);
        SortTableHeaderRenderer sortTableHeaderRenderer = (SortTableHeaderRenderer)((Object)this._viewOptions.columns[0].column.getHeaderRenderer());
        sortTableHeaderRenderer.setSortAscending(this._viewOptions.sortAscending);
        sortTableHeaderRenderer.setSortColumn(this._viewOptions.sortedBy);
        String string = "";
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < this._defaultViewOptions.columns.length) {
            if (this._defaultViewOptions.columns[n3].isVisible) {
                string = bl2 ? string + " " + n3 : string + String.valueOf(n3);
                bl2 = true;
            }
            ++n3;
        }
        String string2 = this._preferences.getString(REPLICATION_STATUS_VISIBLE_COLUMNS, string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                this._viewOptions.columns[n4].isVisible = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string3 = "";
        int n5 = 0;
        while (n5 < this._defaultViewOptions.columns.length) {
            string3 = n5 != 0 ? string3 + " " + this._defaultViewOptions.columns[n5].position : string3 + String.valueOf(this._defaultViewOptions.columns[n5].position);
            ++n5;
        }
        String string4 = this._preferences.getString(REPLICATION_STATUS_COLUMN_ORDER, string3);
        stringTokenizer = new StringTokenizer(string4);
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n7;
                this._viewOptions.columns[n6].position = n7 = Integer.parseInt(stringTokenizer.nextToken());
                if (this._toolTips != null) {
                    this._viewOptions.columns[n6].toolTip = this._toolTips[n6];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n6;
        }
    }

    private AgreementStatus[] readAgreements() throws LDAPException {
        AgreementStatus[] agreementStatusArray;
        ArrayList<AgreementStatus> arrayList = new ArrayList<AgreementStatus>();
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=mapping tree, cn=config", 2, "objectclass=nsDS5ReplicationAgreement", (String[])null, false);
        while (lDAPSearchResults.hasMoreElements()) {
            agreementStatusArray = lDAPSearchResults.next();
            ReplicationAgreement replicationAgreement = new ReplicationAgreement();
            ReplicationAgreement.updateAgreement((LDAPEntry)agreementStatusArray, replicationAgreement);
            AgreementStatus agreementStatus = new AgreementStatus();
            AgreementStatus.updateFromAgreement(agreementStatus, replicationAgreement);
            arrayList.add(agreementStatus);
        }
        agreementStatusArray = new AgreementStatus[arrayList.size()];
        arrayList.toArray(agreementStatusArray);
        return agreementStatusArray;
    }

    private void sortAgreements(AgreementStatus[] agreementStatusArray, int n, boolean bl) {
        String[] stringArray = new String[agreementStatusArray.length];
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < agreementStatusArray.length) {
                    stringArray[n2] = agreementStatusArray[n2].suffix;
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < agreementStatusArray.length) {
                    stringArray[n3] = agreementStatusArray[n3].remoteReplica;
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < agreementStatusArray.length) {
                    stringArray[n4] = agreementStatusArray[n4].description;
                    ++n4;
                }
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < agreementStatusArray.length) {
                    stringArray[n5] = agreementStatusArray[n5].state;
                    ++n5;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                while (n6 < agreementStatusArray.length) {
                    stringArray[n6] = agreementStatusArray[n6].summary;
                    ++n6;
                }
                break;
            }
            case 5: {
                int n7 = 0;
                while (n7 < agreementStatusArray.length) {
                    stringArray[n7] = agreementStatusArray[n7].numberChangesSent;
                    ++n7;
                }
                break;
            }
            case 6: {
                int n8 = 0;
                while (n8 < agreementStatusArray.length) {
                    stringArray[n8] = agreementStatusArray[n8].lastUpdateStart;
                    ++n8;
                }
                break;
            }
            case 7: {
                int n9 = 0;
                while (n9 < agreementStatusArray.length) {
                    stringArray[n9] = agreementStatusArray[n9].lastUpdateEnd;
                    ++n9;
                }
                break;
            }
            case 8: {
                int n10 = 0;
                while (n10 < agreementStatusArray.length) {
                    stringArray[n10] = agreementStatusArray[n10].lastUpdateMessage;
                    ++n10;
                }
                break;
            }
            case 9: {
                int n11 = 0;
                while (n11 < agreementStatusArray.length) {
                    stringArray[n11] = agreementStatusArray[n11].lastInitMessage;
                    ++n11;
                }
                break;
            }
            case 10: {
                int n12 = 0;
                while (n12 < agreementStatusArray.length) {
                    stringArray[n12] = agreementStatusArray[n12].lastInitStart;
                    ++n12;
                }
                break;
            }
            case 11: {
                int n13 = 0;
                while (n13 < agreementStatusArray.length) {
                    stringArray[n13] = agreementStatusArray[n13].lastInitEnd;
                    ++n13;
                }
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
        int n14 = 0;
        while (n14 < stringArray.length - 1) {
            int n15 = n14 + 1;
            while (n15 < stringArray.length) {
                boolean bl2;
                boolean bl3 = bl ? stringArray[n14].compareTo(stringArray[n15]) > 0 : (bl2 = stringArray[n15].compareTo(stringArray[n14]) > 0);
                if (bl2) {
                    String string = stringArray[n14];
                    stringArray[n14] = stringArray[n15];
                    stringArray[n15] = string;
                    AgreementStatus agreementStatus = agreementStatusArray[n14];
                    agreementStatusArray[n14] = agreementStatusArray[n15];
                    agreementStatusArray[n15] = agreementStatus;
                }
                ++n15;
            }
            ++n14;
        }
    }

    private void actionViewOptions() {
        if (this._viewDlg == null) {
            this._viewDlg = new ViewOptionsDialog((JFrame)((Object)this._model.getFramework()), this._viewOptions, this._defaultViewOptions);
            this._viewDlg.pack();
        }
        this._viewDlg.updateDialogFromViewOptions(this._viewOptions);
        this._viewDlg.show();
        if (!this._viewDlg.isCancelled()) {
            this._viewDlg.updateViewOptionsFromDialog(this._viewOptions);
            this.sortAgreements(this._agreementStatus, this._viewOptions.sortedBy, this._viewOptions.sortAscending);
            this.updateTableWithViewOptions(this._viewOptions);
            this._table.tableChanged(new TableModelEvent(this._tableModel));
            SortTableHeaderRenderer sortTableHeaderRenderer = (SortTableHeaderRenderer)((Object)this._viewOptions.columns[0].column.getHeaderRenderer());
            sortTableHeaderRenderer.setSortAscending(this._viewOptions.sortAscending);
            sortTableHeaderRenderer.setSortColumn(this._viewOptions.sortedBy);
            this._preferences.set(REPLICATION_STATUS_SORTED_BY, this._viewOptions.sortedBy);
            this._preferences.set(REPLICATION_STATUS_SORT_ASCENDING, this._viewOptions.sortAscending);
            String string = "";
            String string2 = "";
            boolean bl = false;
            int n = 0;
            while (n < this._viewOptions.columns.length) {
                if (this._viewOptions.columns[n].isVisible) {
                    if (bl) {
                        string = string + " " + n;
                    } else {
                        bl = true;
                        string = string + String.valueOf(n);
                    }
                }
                string2 = n == 0 ? string2 + String.valueOf(this._viewOptions.columns[n].position) : string2 + " " + this._viewOptions.columns[n].position;
                ++n;
            }
            this._preferences.set(REPLICATION_STATUS_VISIBLE_COLUMNS, string);
            this._preferences.set(REPLICATION_STATUS_COLUMN_ORDER, string2);
        }
    }

    private void actionViewPendingChanges() {
        Object object;
        boolean bl = true;
        if (this._showPendingChangesWarning) {
            object = new PendingChangesWarningDialog((JFrame)((Object)this._model.getFramework()));
            ((PendingChangesWarningDialog)((Object)object)).packAndShow();
            this._showPendingChangesWarning = ((PendingChangesWarningDialog)((Object)object)).continueShowingDialog();
            if (!this._showPendingChangesWarning) {
                this._preferences.set(REPLICATION_STATUS_SHOW_PENDINGCHANGES_WARNING, this._showPendingChangesWarning);
            }
            boolean bl2 = bl = !((PendingChangesWarningDialog)((Object)object)).isCancelled();
        }
        if (bl) {
            object = this._table.getSelectionModel();
            int n = object.getMinSelectionIndex();
            PendingChangesSearcher pendingChangesSearcher = new PendingChangesSearcher();
            pendingChangesSearcher.setLDAPConnection(this.getServerInfo().getLDAPConnection());
            pendingChangesSearcher.setAgreementDn(this._agreementStatus[n].dn);
            pendingChangesSearcher.setFrame((JFrame)((Object)this._model.getFramework()));
            pendingChangesSearcher.start();
        }
    }

    private void updateTableWithViewOptions(TableViewOptions tableViewOptions) {
        int n;
        int n2;
        this._ignoreColumnModelEvents = true;
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        int n3 = tableColumnModel.getColumnCount();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(n4));
            --n4;
        }
        int n5 = 0;
        while (n5 < tableViewOptions.columns.length) {
            n2 = 0;
            n = 0;
            while (n < tableViewOptions.columns.length && n2 == 0) {
                int n6 = n2 = tableViewOptions.columns[n].position == n5 ? 1 : 0;
                if (n2 != 0 && tableViewOptions.columns[n].isVisible) {
                    tableColumnModel.addColumn(tableViewOptions.columns[n].column);
                }
                ++n;
            }
            ++n5;
        }
        n2 = 0;
        n = 0;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        SortTableHeaderRenderer sortTableHeaderRenderer = (SortTableHeaderRenderer)((Object)this._viewOptions.columns[0].column.getHeaderRenderer());
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            sortTableHeaderRenderer.setSortColumn(n);
            Component component = sortTableHeaderRenderer.getTableCellRendererComponent(this._table, tableColumn.getHeaderValue(), true, true, 0, n);
            TableCellRenderer tableCellRenderer = this._table.getCellRenderer(0, n);
            int n7 = (int)component.getPreferredSize().getWidth();
            int n8 = 0;
            while (n8 < this._table.getRowCount()) {
                component = tableCellRenderer.getTableCellRendererComponent(this._table, this._table.getValueAt(n8, n), true, true, n8, n);
                int n9 = (int)component.getPreferredSize().getWidth();
                n7 = Math.max(n7, n9);
                ++n8;
            }
            tableColumn.setPreferredWidth(n7 += this._table.getIntercellSpacing().width);
            n2 += n7;
            ++n;
        }
        sortTableHeaderRenderer.setSortColumn(this._viewOptions.sortedBy);
        int n10 = this.getWidth() - 2 * UIFactory.getComponentSpace();
        if (n2 > n10) {
            this._table.setAutoResizeMode(0);
        } else {
            this._table.setAutoResizeMode(3);
        }
        this._ignoreColumnModelEvents = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

