/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.DSStatusPage;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.IStatusPanel;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public abstract class StatusRefreshPanel
extends JPanel
implements ActionListener,
IStatusPanel {
    protected String _section;
    protected ResourceSet _resource = DSStatusPage._resource;
    protected JTextArea _taRights;
    protected JTextArea _taError;
    protected String _helpToken;
    private JPanel _innerPane;
    protected JPanel _contentPane;
    private JButton _refreshButton;
    private JCheckBox _refreshCheckbox;
    protected JLabel _lUpdating;
    private boolean _doRefresh = false;
    private Thread _periodicalRefresher;
    private Thread _refresher;
    protected JButton _bHelp;
    protected boolean _isReloading;
    protected IStatusModel _model;

    public StatusRefreshPanel() {
    }

    public StatusRefreshPanel(IStatusModel iStatusModel) {
        this(iStatusModel, false);
    }

    public StatusRefreshPanel(IStatusModel iStatusModel, boolean bl) {
        this._model = iStatusModel;
        this.initResources();
        this.basicLayout(bl);
        this.refresh();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._refreshButton) {
            this.refresh();
        } else if (object == this._refreshCheckbox) {
            if (this._refreshCheckbox.isSelected()) {
                this.startRefresher();
            } else {
                this.stopRefresher();
            }
        } else if (object == this._bHelp) {
            this.invokeHelp();
        }
    }

    public void startRefresher() {
        this._doRefresh = true;
        if (this._periodicalRefresher == null) {
            this._periodicalRefresher = new Thread(){

                public void run() {
                    while (StatusRefreshPanel.this._doRefresh) {
                        StatusRefreshPanel.this.readAndUpdate();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    StatusRefreshPanel.this._periodicalRefresher = null;
                }
            };
            this._periodicalRefresher.start();
        }
    }

    public void stopRefresher() {
        this._doRefresh = false;
    }

    public boolean isRefreshing() {
        boolean bl = false;
        if (this._refreshCheckbox != null) {
            bl = this._refreshCheckbox.isSelected();
        }
        return bl;
    }

    public void refresh() {
        if (this._refresher == null) {
            this._refresher = new Thread(){

                public void run() {
                    StatusRefreshPanel.this.readAndUpdate();
                    StatusRefreshPanel.this._refresher = null;
                }
            };
            this._refresher.start();
        }
    }

    public void invokeHelp() {
        DSUtil.help(this._helpToken, this._model.getFramework().getServerObject().getServerInfo().getAdminURL());
    }

    protected abstract void readAndUpdate();

    protected abstract void initResources();

    protected void showComponent(JComponent jComponent, boolean bl) {
        if (!this._innerPane.isAncestorOf(jComponent)) {
            this._innerPane.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            if (bl) {
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 10;
            } else {
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 11;
            }
            this._innerPane.add((Component)jComponent, gridBagConstraints);
        }
        this._bHelp.setVisible(!bl);
        this.validate();
        this.repaint();
    }

    protected JPanel createRefreshArea() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._refreshButton = UIFactory.makeJButton(this, "refreshpanel", "refreshbutton", this._resource);
        this._refreshCheckbox = UIFactory.makeJCheckBox(this, "refreshpanel", "refreshcheckbox", false, this._resource);
        this._lUpdating = UIFactory.makeJLabel("refreshpanel", "lupdating", this._resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this._refreshButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel.add((Component)this._refreshCheckbox, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._lUpdating, gridBagConstraints);
        this._lUpdating.setVisible(false);
        return jPanel;
    }

    protected JPanel createButtonPanel() {
        this._bHelp = UIFactory.makeJButton(this, "refreshpanel", "bhelp", this._resource);
        JButton[] jButtonArray = new JButton[]{this._bHelp};
        JPanel jPanel = UIFactory.makeJButtonPanel(jButtonArray, true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("Center", jPanel);
        jPanel2.add("North", Box.createVerticalStrut(UIFactory.getDifferentSpace()));
        this._bHelp.setVisible(false);
        return jPanel2;
    }

    protected ConsoleInfo getServerInfo() {
        return this._model.getFramework().getServerObject().getServerInfo();
    }

    protected ConsoleInfo getConsoleInfo() {
        return this._model.getFramework().getServerObject().getConsoleInfo();
    }

    protected void basicLayout(boolean bl) {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.createButtonPanel();
        this.add((Component)jPanel, "South");
        this._innerPane = new JPanel(new GridBagLayout());
        this._innerPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (bl) {
            JScrollPane jScrollPane = new JScrollPane(this._innerPane);
            jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add((Component)jScrollPane, "Center");
        } else {
            this.add((Component)this._innerPane, "Center");
        }
    }
}

