/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.DSStatusPage;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.IStatusPanel;
import com.netscape.admin.dirserv.status.StatusAccessLogPanel;
import com.netscape.admin.dirserv.status.StatusAuditLogPanel;
import com.netscape.admin.dirserv.status.StatusErrorLogPanel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StatusLogTabbedPanel
extends JPanel
implements IStatusPanel,
ChangeListener {
    private JTabbedPane _tabbedPane;
    private boolean[] _needToRefresh = new boolean[]{true, true, true};
    private int _lastSelectedIndex = -1;
    private static ResourceSet _resource = DSStatusPage._resource;

    public StatusLogTabbedPanel(IStatusModel iStatusModel) {
        this.basicLayout();
        StatusAccessLogPanel statusAccessLogPanel = new StatusAccessLogPanel(iStatusModel);
        statusAccessLogPanel.setBorder(new EmptyBorder(UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace()));
        StatusErrorLogPanel statusErrorLogPanel = new StatusErrorLogPanel(iStatusModel);
        statusErrorLogPanel.setBorder(new EmptyBorder(UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace()));
        StatusAuditLogPanel statusAuditLogPanel = new StatusAuditLogPanel(iStatusModel);
        statusAuditLogPanel.setBorder(new EmptyBorder(UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace()));
        this.addTab(statusAccessLogPanel, _resource.getString("logtabbedpanel-access", "title"));
        this.addTab(statusErrorLogPanel, _resource.getString("logtabbedpanel-error", "title"));
        this.addTab(statusAuditLogPanel, _resource.getString("logtabbedpanel-audit", "title"));
        this._tabbedPane.setSelectedIndex(0);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this._tabbedPane) {
            IStatusPanel iStatusPanel;
            if (this._lastSelectedIndex != -1 && (iStatusPanel = (IStatusPanel)((Object)this._tabbedPane.getComponentAt(this._lastSelectedIndex))).isRefreshing()) {
                iStatusPanel.stopRefresher();
            }
            this._lastSelectedIndex = this._tabbedPane.getSelectedIndex();
            iStatusPanel = (IStatusPanel)((Object)this._tabbedPane.getSelectedComponent());
            if (this._needToRefresh[this._lastSelectedIndex]) {
                iStatusPanel.refresh();
                this._needToRefresh[this._lastSelectedIndex] = false;
            }
            if (iStatusPanel.isRefreshing()) {
                iStatusPanel.startRefresher();
            }
        }
    }

    public void startRefresher() {
        IStatusPanel iStatusPanel = (IStatusPanel)((Object)this._tabbedPane.getSelectedComponent());
        iStatusPanel.startRefresher();
    }

    public void stopRefresher() {
        IStatusPanel iStatusPanel = (IStatusPanel)((Object)this._tabbedPane.getSelectedComponent());
        iStatusPanel.stopRefresher();
    }

    public boolean isRefreshing() {
        IStatusPanel iStatusPanel = (IStatusPanel)((Object)this._tabbedPane.getSelectedComponent());
        return iStatusPanel.isRefreshing();
    }

    public void refresh() {
        int n = 0;
        while (n < this._needToRefresh.length) {
            if (n != this._lastSelectedIndex) {
                this._needToRefresh[n] = true;
            } else {
                IStatusPanel iStatusPanel = (IStatusPanel)((Object)this._tabbedPane.getSelectedComponent());
                iStatusPanel.refresh();
                this._needToRefresh[this._lastSelectedIndex] = false;
            }
            ++n;
        }
    }

    private void addTab(Component component, String string) {
        this._tabbedPane.addTab(string, component);
    }

    private void basicLayout() {
        this.setLayout(new GridBagLayout());
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addChangeListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        this.add((Component)this._tabbedPane, gridBagConstraints);
    }
}

