/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.status.DSStatusPage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;

class PendingChangesSearcher
implements Runnable,
ActionListener {
    private LDAPConnection _ldc;
    private String _agreementDn;
    private GenericProgressDialog _dlg;
    private JFrame _frame;
    private LDAPSearchListener _listener;
    private boolean _isCancelled;
    private static ResourceSet _resource = DSStatusPage._resource;

    PendingChangesSearcher() {
    }

    public void setFrame(JFrame jFrame) {
        this._frame = jFrame;
    }

    public void setLDAPConnection(LDAPConnection lDAPConnection) {
        this._ldc = lDAPConnection;
    }

    public void setAgreementDn(String string) {
        this._agreementDn = string;
    }

    public void start() {
        if (this._dlg == null) {
            this._dlg = new GenericProgressDialog(this._frame, false, 0, _resource.getString("pendingchangessearcher", "dlg-title"));
            this._dlg.addActionListener(this);
        }
        this._dlg.setLabelRows(1);
        this._dlg.setLabelColumns(25);
        this._dlg.setTextInLabel(_resource.getString("pendingchangessearcher", "processing-label"));
        Thread thread = new Thread(this);
        thread.start();
        this._dlg.packAndShow();
    }

    public void run() {
        String[] stringArray;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LDAPException lDAPException = null;
        LDAPEntry lDAPEntry = null;
        String[] stringArray2 = new String[]{"ds5replicapendingchangescount"};
        try {
            this._listener = this._ldc.search(this._agreementDn, 0, "objectclass=*", stringArray2, false, this._listener);
            stringArray = null;
            do {
                if ((stringArray = this._listener.getResponse()) != null) {
                    if (!(stringArray instanceof LDAPSearchResult)) continue;
                    lDAPEntry = ((LDAPSearchResult)stringArray).getEntry();
                    continue;
                }
                this._ldc.abandon(this._listener);
            } while (lDAPEntry == null && !this._isCancelled && stringArray != null);
        }
        catch (LDAPException lDAPException2) {
            lDAPException = lDAPException2;
        }
        if (!this._isCancelled) {
            this._dlg.waitForClose();
            if (lDAPEntry == null) {
                if (lDAPException == null) {
                    this._dlg.setLabelColumns(40);
                    this._dlg.setTextInLabel(_resource.getString("pendingchangessearcher", "agreementnotfound-label"));
                } else {
                    stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    this._dlg.setLabelRows(2);
                    this._dlg.setLabelColumns(40);
                    this._dlg.setTextInLabel(_resource.getString("pendingchangessearcher", "agreementnotfound-exception-label", stringArray));
                }
            } else {
                int n = -1;
                try {
                    n = Integer.parseInt(DSUtil.getAttrValue(lDAPEntry, stringArray2[0]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n == -1) {
                    this._dlg.setTextInLabel(_resource.getString("pendingchangessearcher", "pendingchangesnotavailable-label"));
                } else {
                    String[] stringArray3 = new String[]{String.valueOf(n)};
                    this._dlg.setTextInLabel(_resource.getString("pendingchangessearcher", "pendingchangesvalue-label", stringArray3));
                }
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        PendingChangesSearcher.this._dlg.pack();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "Cancel-GenericProgressDialog") {
            this._isCancelled = true;
            try {
                this._ldc.abandon(this._listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._dlg.closeCallBack();
        } else if (actionEvent.getActionCommand() == "Close-GenericProgressDialog") {
            this._dlg.closeCallBack();
        }
    }
}

