/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.roledit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.roledit.RoleCache;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractModalDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class RolePickerDialog
extends AbstractModalDialog
implements SuiConstants,
ListSelectionListener {
    ConsoleInfo _info;
    RoleCache _roleBag;
    JTable _table;
    private static final ResourceSet _resource = DSUtil._resource;
    private static final String _section = "rolePickerDialog";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JLabel;

    public RolePickerDialog(Frame frame, ConsoleInfo consoleInfo) {
        super(frame, _resource.getString(_section, "title"));
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "description"));
        this._info = consoleInfo;
        this._roleBag = new RoleCache();
        this._table = new JTable();
        this._table.setShowGrid(false);
        this._table.setModel(this._roleBag.getTableModel());
        this._table.setAutoResizeMode(4);
        LabelCellRenderer labelCellRenderer = new LabelCellRenderer();
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = RolePickerDialog.class$("java.lang.String")) : class$java$lang$String, labelCellRenderer);
        this._table.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = RolePickerDialog.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, labelCellRenderer);
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.setIntercellSpacing(new Dimension(0, 0));
        this._table.setPreferredScrollableViewportSize(new Dimension(350, 200));
        this.layoutComponents();
    }

    public void load(String string, String string2, Enumeration enumeration) throws LDAPException {
        Vector<DN> vector = new Vector<DN>();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new DN((String)enumeration.nextElement()));
        }
        this._roleBag.clear();
        Debug.println((String)("RolePickerDialog.load: searching from " + string));
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        try {
            Vector vector2 = this.searchRolesVisibleFrom(string, string2);
            if (vector2 != null) {
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    LDAPEntry lDAPEntry = (LDAPEntry)enumeration2.nextElement();
                    String string3 = lDAPEntry.getDN();
                    DN dN = new DN(string3);
                    boolean bl = false;
                    Enumeration enumeration3 = vector.elements();
                    while (enumeration3.hasMoreElements() && !bl) {
                        if (!dN.equals((DN)enumeration3.nextElement())) continue;
                        bl = true;
                    }
                    if (!bl) {
                        this._roleBag.add(lDAPEntry, lDAPConnection);
                        continue;
                    }
                    Debug.println((String)("RolePickerDialog.load: excluding " + string3));
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("RoleEditorDialog.load of" + string + ": " + (Object)((Object)lDAPException)));
            throw lDAPException;
        }
    }

    public void loadWithNestableRoles(String string, Enumeration enumeration) throws LDAPException {
        Vector<DN> vector = new Vector<DN>();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new DN((String)enumeration.nextElement()));
        }
        this._roleBag.clear();
        Debug.println((String)("RolePickerDialog.loadWithNestableRoles: searching for " + string));
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        String string2 = MappingUtils.getTopSuffixForEntry(lDAPConnection, string);
        if (string2 == null) {
            Debug.println((int)0, (String)("RolePickerDialog.loadWithNestableRoles: cannot determine the suffix of " + string));
        } else {
            try {
                String string3 = "(&(objectclass=nsroledefinition)(objectclass=ldapsubentry))";
                String[] stringArray = RoleCache.BASIC_ATTRS;
                LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
                lDAPSearchConstraints.setMaxResults(0);
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 2, string3, stringArray, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    String string4 = lDAPEntry.getDN();
                    DN dN = new DN(string4);
                    boolean bl = false;
                    Enumeration enumeration2 = vector.elements();
                    while (enumeration2.hasMoreElements() && !bl) {
                        if (!dN.equals((DN)enumeration2.nextElement())) continue;
                        bl = true;
                    }
                    if (!bl) {
                        this._roleBag.add(lDAPEntry, lDAPConnection);
                        continue;
                    }
                    Debug.println((String)("RolePickerDialog.loadWithNestableRoles: excluding " + string4));
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((int)0, (String)("RoleEditorDialog.loadWithNestableRoles of" + string + ": " + (Object)((Object)lDAPException)));
                throw lDAPException;
            }
        }
    }

    public Vector getSelectedRoles() {
        Vector<String> vector = null;
        int n = this._table.getModel().getRowCount();
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        int n2 = 0;
        while (n2 < n) {
            if (listSelectionModel.isSelectedIndex(n2)) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(this._roleBag.getRoleDN(n2));
            }
            ++n2;
        }
        return vector;
    }

    void layoutComponents() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JLabel jLabel = new JLabel(_resource.getString(_section, "label"));
        jLabel.setLabelFor(this._table);
        container.add(jLabel);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        container.add(jScrollPane);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.pack();
    }

    Vector searchRolesVisibleFrom(String string, String string2) throws LDAPException {
        Vector<LDAPEntry> vector;
        block5: {
            String string3;
            vector = null;
            if (string != null) {
                string3 = RolePickerDialog.makeParentDn(string);
                vector = this.searchRolesVisibleFrom(string3, string2);
            }
            string3 = this._info.getLDAPConnection();
            String string4 = "(&(objectclass=" + string2 + ")(objectclass=ldapsubentry))";
            String[] stringArray = RoleCache.BASIC_ATTRS;
            try {
                LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)string3.getSearchConstraints().clone();
                lDAPSearchConstraints.setMaxResults(0);
                LDAPSearchResults lDAPSearchResults = string3.search(string, 1, string4, stringArray, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    if (vector == null) {
                        vector = new Vector<LDAPEntry>();
                    }
                    vector.addElement(lDAPEntry);
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block5;
                throw lDAPException;
            }
        }
        return vector;
    }

    public static String makeParentDn(String string) {
        String string2 = null;
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        if (stringArray != null && stringArray.length >= 2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            while (n < stringArray.length) {
                if (stringBuffer.length() >= 1) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n == -1 || n2 - n + 1 > 1 || this._table.getRowCount() <= 0) {
            this._table.setToolTipText(null);
        } else {
            this._table.setToolTipText(this._roleBag.getRoleDN(n));
        }
    }

    protected void helpInvoked() {
        DSUtil.help("configuration-choose-role", this._info.getAdminURL());
    }

    public void allowMultipleSelection(boolean bl) {
        if (bl) {
            this._table.getSelectionModel().setSelectionMode(2);
        } else {
            this._table.getSelectionModel().setSelectionMode(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

