/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.roledit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.roledit.RolePickerDialog;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.IResourceEditorPage;
import com.netscape.management.client.ug.LdapQueryBuilderDialog;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.ug.SearchResultPanel;
import com.netscape.management.client.util.AbstractModalDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPUrl;

public class ResEditorFilteredRole
extends JPanel
implements IResourceEditorPage,
Observer,
ActionListener,
SuiConstants {
    ResourceEditor _parent;
    ResourcePageObservable _observable;
    String _id = _resource.getString("filteredRolePage", "id");
    boolean _isModified = false;
    boolean _isReadOnly = false;
    boolean _isEnabled = true;
    String _oldFilterText;
    JButton _testButton;
    JButton _constructButton;
    JTextField _filterText;
    SearchResultDialog _resultDialog;
    static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "filteredRolePage";
    private static final String NSROLEFILTER_ATTR = "nsRoleFilter";

    public void update(Observable observable, Object object) {
        String string;
        if (!(observable instanceof ResourcePageObservable)) {
            return;
        }
        ResourcePageObservable resourcePageObservable = (ResourcePageObservable)observable;
        if (object instanceof String && (string = (String)object).equalsIgnoreCase(NSROLEFILTER_ATTR)) {
            this._filterText.setText(resourcePageObservable.get(NSROLEFILTER_ATTR, 0));
        }
    }

    public void initialize(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        this._parent = resourceEditor;
        this._observable = resourcePageObservable;
        if (this._filterText == null) {
            this._filterText = new JTextField();
            this._constructButton = UIFactory.makeJButton(this, _section, "constructButton", _resource);
            this._testButton = UIFactory.makeJButton(this, _section, "testButton", _resource);
            this.layoutComponents();
        }
        this._oldFilterText = this._observable.get(NSROLEFILTER_ATTR, 0);
        if (this._observable.isNewUser()) {
            this._filterText.setText("(objectclass=*)");
        } else {
            this._filterText.setText(this._oldFilterText);
        }
    }

    void layoutComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JLabel jLabel = new JLabel(_resource.getString(_section, "label"));
        jLabel.setLabelFor(this._filterText);
        this.add(jLabel);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(this._filterText);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 9, 0, 9);
        gridBagLayout.setConstraints(this._filterText, gridBagConstraints);
        Box box = new Box(0);
        box.add(this._testButton);
        box.add(Box.createHorizontalStrut(12));
        box.add(this._constructButton);
        JButtonFactory.resizeGroup((JButton)this._testButton, (JButton)this._constructButton);
        this.add(box);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagLayout.setConstraints(box, gridBagConstraints);
    }

    public String getID() {
        return this._id;
    }

    public boolean afterSave(ResourcePageObservable resourcePageObservable) throws Exception {
        return true;
    }

    public boolean save(ResourcePageObservable resourcePageObservable) throws Exception {
        if (!this._filterText.getText().equals(this._oldFilterText)) {
            if (this._filterText.getText().trim().length() == 0) {
                resourcePageObservable.delete(NSROLEFILTER_ATTR, this._oldFilterText);
                this._oldFilterText = "";
            } else {
                String string = this._filterText.getText().trim();
                resourcePageObservable.replace(NSROLEFILTER_ATTR, string);
                this._oldFilterText = string;
            }
        }
        return true;
    }

    public void clear() {
        this._filterText.setText(null);
    }

    public void reset() {
        this._filterText.setText(null);
    }

    public void setDefault() {
        this._filterText.setText("(objectclass=*)");
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setModified(boolean bl) {
        this._isModified = bl;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this._isReadOnly = bl;
    }

    public void setEnable(boolean bl) {
        this._isEnabled = bl;
    }

    public boolean isComplete() {
        boolean bl;
        boolean bl2 = bl = this._filterText.getText().trim().length() >= 1;
        if (!bl) {
            JOptionPane.showMessageDialog(null, _resource.getString(_section, "IncompleteText"), _resource.getString(_section, "IncompleteTitle"), 0);
            ModalDialogUtil.sleep();
            bl = false;
        }
        return bl;
    }

    public String getDisplayName() {
        return this._id;
    }

    public void help() {
        DSUtil.help("configuration-role-member-filtered-help", this._observable.getConsoleInfo().getAdminURL());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._parent.setBusyCursor(true);
        if (actionEvent.getSource() == this._testButton) {
            this.actionTest();
        } else if (actionEvent.getSource() == this._constructButton) {
            this.actionConstruct();
        }
        this._parent.setBusyCursor(false);
    }

    void actionTest() {
        ConsoleInfo consoleInfo = this._parent.getConsoleInfo();
        String string = this._observable.isNewUser() ? this._observable.getCreateBaseDN() : RolePickerDialog.makeParentDn(this._observable.getDN());
        String string2 = "ldap:///" + string + "??sub?" + this._filterText.getText().trim();
        try {
            LDAPUrl lDAPUrl = new LDAPUrl(string2);
            LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
            Debug.println((String)("DynamicQueryDlg:" + lDAPUrl.getHost() + " " + lDAPUrl.getPort()));
            if (this._resultDialog == null) {
                this._resultDialog = new SearchResultDialog(this._parent.getFrame(), consoleInfo);
            }
            this._resultDialog.invokeDoSearchLater(lDAPConnection, lDAPUrl);
            this._resultDialog.show();
        }
        catch (MalformedURLException malformedURLException) {
            JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
            JOptionPane.showMessageDialog(jFrame, _resource.getString(_section, "errortext"), _resource.getString(_section, "errortitle"), 0);
            ModalDialogUtil.sleep();
        }
    }

    void actionConstruct() {
        String string = this._observable.isNewUser() ? this._observable.getCreateBaseDN() : RolePickerDialog.makeParentDn(this._observable.getDN());
        ConsoleInfo consoleInfo = (ConsoleInfo)this._parent.getConsoleInfo().clone();
        consoleInfo.setBaseDN(string);
        consoleInfo.setUserBaseDN(string);
        LdapQueryBuilderDialog ldapQueryBuilderDialog = new LdapQueryBuilderDialog(consoleInfo);
        ldapQueryBuilderDialog.setTitle(_resource.getString(_section, "BuilderDialogTitle"));
        ldapQueryBuilderDialog.getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "BuilderDialogTitle-description"));
        ldapQueryBuilderDialog.show();
        if (!ldapQueryBuilderDialog.isCancel()) {
            try {
                LDAPUrl lDAPUrl = new LDAPUrl(ldapQueryBuilderDialog.getQueryString());
                this._filterText.setText(lDAPUrl.getFilter());
            }
            catch (MalformedURLException malformedURLException) {
                Debug.println((String)"ResEditorFilteredRole.actionConstruct: invalid URL !");
            }
        }
    }

    class SearchResultDialog
    extends AbstractModalDialog
    implements ActionListener {
        protected SearchResultPanel _searchResultPanel;

        public SearchResultDialog(Frame frame, ConsoleInfo consoleInfo) {
            super(frame, _resource.getString(ResEditorFilteredRole._section, "SearchResultTitle"), 4);
            this._searchResultPanel = new SearchResultPanel(consoleInfo, (ActionListener)this);
            this.getContentPane().add((Component)this._searchResultPanel);
            this.pack();
        }

        public void invokeDoSearchLater(LDAPConnection lDAPConnection, LDAPUrl lDAPUrl) {
            SwingUtilities.invokeLater(new Runnable(this, lDAPConnection, lDAPUrl){
                private final /* synthetic */ LDAPConnection val$ldc;
                private final /* synthetic */ LDAPUrl val$url;
                private final /* synthetic */ SearchResultDialog this$1;
                {
                    this.this$1 = searchResultDialog;
                    this.val$ldc = lDAPConnection;
                    this.val$url = lDAPUrl;
                }

                public void run() {
                    this.this$1._searchResultPanel.removeAllElements();
                    this.this$1._searchResultPanel.doSearch(this.val$ldc, this.val$url);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Debug.println((String)("SearchResultDialog.actionPerformed: action event" + actionEvent));
        }
    }
}

