/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.management.client.util.Debug;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class MappingUtils {
    private static final String _section = "mappingtree";
    public static final String CONFIG_BASEDN = "cn=plugins, cn=config";
    public static final String CHAINING_CONFIG_BASEDN = "cn=chaining database, cn=plugins, cn=config";
    public static final String LDBM_CONFIG_BASEDN = "cn=ldbm database, cn=plugins, cn=config";
    public static final String CONFIG_MAPPING = "cn=mapping tree, cn=config";
    public static final String ROOT_MAPPING_NODE = "is root suffix";
    public static final String DISABLE = "Disabled";
    public static final String BACKEND = "Backend";
    public static final String REFERRAL = "Referral";
    public static final String ADD_REF = "addReferral";
    public static final String SUFFIX_ATTR = "nsslapd-suffix";
    public static final String BACKEND_ATTR = "nsbackendsuffix";
    private final String DELETE_REF = "deleteReferral";
    public static final String REFERRAL_UPDATE = "Referral on Update";
    public static final int ALL = 0;
    public static final int CHAINING = 1;
    public static final int LDBM = 2;
    private LDAPEntry _entry = null;

    private MappingUtils() {
    }

    public static String[] getMappingNode(LDAPConnection lDAPConnection) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>(1);
        try {
            stringArray = lDAPConnection.search(CONFIG_MAPPING, 1, "objectclass=nsMappingTree", null, false);
            while (stringArray.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)stringArray.nextElement();
                String string = lDAPEntry.getDN();
                vector.addElement(MappingUtils.unQuote(LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true)[0]));
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)("NewMappingNodePanel.getMappingNode() " + (Object)((Object)lDAPException)));
        }
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public static String unQuote(String string) {
        if (string != null) {
            if (string.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                Character c = new Character(string.charAt(0));
                Character c2 = new Character(string.charAt(string.length() - 1));
                Character c3 = new Character('\"');
                if (c.compareTo(c3) == 0) {
                    int n = 1;
                    while (n < string.length() - 1) {
                        stringBuffer.append(string.charAt(n));
                        ++n;
                    }
                } else {
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            return new String(string);
        }
        return null;
    }

    public static String Quote(String string) {
        Character c;
        StringBuffer stringBuffer = new StringBuffer();
        Character c2 = new Character(string.charAt(0));
        if (c2.compareTo(c = new Character('\"')) == 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    public static String[] getBackendList(LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            return null;
        }
        return MappingUtils.getBackendList(lDAPConnection, 0);
    }

    public static String[] getBackendList(LDAPConnection lDAPConnection, int n) {
        String[] stringArray;
        if (lDAPConnection == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>(1);
        String string = "";
        int n2 = 2;
        String string2 = "";
        if (n == 1) {
            string = CHAINING_CONFIG_BASEDN;
            string2 = "objectclass=nsBackendInstance";
        } else if (n == 2) {
            string = LDBM_CONFIG_BASEDN;
            string2 = "objectclass=nsBackendInstance";
        } else if (n == 0) {
            string = "";
            n2 = 0;
            string2 = "objectclass=*";
        }
        try {
            stringArray = new String[]{SUFFIX_ATTR, BACKEND_ATTR};
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, n2, string2, stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                String[] stringArray2;
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                if (n == 0) {
                    stringArray2 = DSUtil.getAttrValues(lDAPEntry, BACKEND_ATTR);
                    if (stringArray2 == null) continue;
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        int n4 = stringArray2[n3].indexOf(58);
                        if (n4 > 0) {
                            String string3 = stringArray2[n3].substring(0, n4);
                            vector.addElement(string3);
                        }
                        ++n3;
                    }
                    continue;
                }
                stringArray2 = lDAPEntry.getDN();
                vector.addElement(LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true)[0]);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)("NewMappingNodePanel.getBackendList() " + (Object)((Object)lDAPException)));
        }
        Debug.println((String)("MappingUtils.getBackendList() " + vector));
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public static String[] getOrderedSuffixList(LDAPConnection lDAPConnection) {
        return MappingUtils.getOrderedSuffixList(lDAPConnection, 0);
    }

    public static String[] getOrderedSuffixList(LDAPConnection lDAPConnection, int n) {
        if (lDAPConnection == null) {
            return null;
        }
        String[] stringArray = MappingUtils.getSuffixList(lDAPConnection, n);
        if (stringArray == null) {
            return null;
        }
        MappingUtils.orderSuffixes(stringArray);
        return stringArray;
    }

    public static void orderSuffixes(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length - 1) {
            DN dN = new DN(stringArray[n]);
            int n2 = n + 1;
            while (n2 < stringArray.length) {
                DN dN2 = new DN(stringArray[n2]);
                if (dN2.isDescendantOf(dN)) {
                    String string = stringArray[n];
                    stringArray[n] = stringArray[n2];
                    stringArray[n2] = string;
                    dN = new DN(stringArray[n]);
                }
                ++n2;
            }
            ++n;
        }
    }

    public static boolean isEntryInSuffixes(String string, String[] stringArray, LDAPConnection lDAPConnection) {
        return MappingUtils.isEntryInSuffixes(string, stringArray, MappingUtils.getOrderedSuffixList(lDAPConnection, 0));
    }

    public static boolean isEntryInSuffixes(String string, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || string == null) {
            return false;
        }
        DN dN = new DN(string);
        DN dN2 = null;
        DN dN3 = null;
        int n = 0;
        while (n < stringArray.length) {
            dN3 = new DN(stringArray[n]);
            if (dN.equals(dN3) || dN.isDescendantOf(dN3)) {
                dN2 = dN3;
                break;
            }
            ++n;
        }
        if (dN2 == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            dN3 = new DN(stringArray2[n2]);
            if (dN.equals(dN3) || dN.isDescendantOf(dN3)) {
                if (!dN3.equals(dN2)) break;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] getSuffixList(LDAPConnection lDAPConnection) {
        return MappingUtils.getSuffixList(lDAPConnection, 0);
    }

    public static String[] getSuffixList(LDAPConnection lDAPConnection, int n) {
        String[] stringArray;
        if (lDAPConnection == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>(1);
        String string = "";
        int n2 = 2;
        String string2 = "";
        if (n == 1) {
            string = CHAINING_CONFIG_BASEDN;
            string2 = "objectclass=nsBackendInstance";
        } else if (n == 2) {
            string = LDBM_CONFIG_BASEDN;
            string2 = "objectclass=nsBackendInstance";
        } else if (n == 0) {
            string = "";
            n2 = 0;
            string2 = "objectclass=*";
        }
        try {
            stringArray = new String[]{SUFFIX_ATTR, BACKEND_ATTR};
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, n2, string2, stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                Object object;
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                if (n == 0) {
                    object = DSUtil.getAttrValues(lDAPEntry, BACKEND_ATTR);
                    if (object == null) continue;
                    int n3 = 0;
                    while (n3 < ((String[])object).length) {
                        int n4 = object[n3].indexOf(58);
                        if (n4 > 0) {
                            String string3 = object[n3].substring(n4 + 1);
                            vector.addElement(MappingUtils.unQuote(string3));
                        }
                        ++n3;
                    }
                    continue;
                }
                object = DSUtil.getAttrValue(lDAPEntry, SUFFIX_ATTR);
                vector.addElement(MappingUtils.unQuote((String)object));
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)("MappingUtils.getSuffixList() " + (Object)((Object)lDAPException)));
        }
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public static String getSuffixForBackend(LDAPConnection lDAPConnection, String string) {
        if (lDAPConnection == null || string == null) {
            return null;
        }
        String[] stringArray = new String[]{BACKEND_ATTR};
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("", 0, "objectclass=*", stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                String[] stringArray2 = DSUtil.getAttrValues(lDAPEntry, BACKEND_ATTR);
                if (stringArray2 == null) continue;
                int n = 0;
                while (n < stringArray2.length) {
                    String string2;
                    int n2 = stringArray2[n].indexOf(58);
                    if (n2 > 0 && (string2 = stringArray2[n].substring(0, n2)).equalsIgnoreCase(string)) {
                        String string3 = stringArray2[n].substring(n2 + 1);
                        return string3;
                    }
                    ++n;
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MappingUtils.getSuffixForBackend " + (Object)((Object)lDAPException)));
        }
        return null;
    }

    public static String[] getSuffixesForBackends(LDAPConnection lDAPConnection, String[] stringArray) {
        if (lDAPConnection == null || stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[]{BACKEND_ATTR};
        Object[] objectArray = null;
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("", 0, "objectclass=*", stringArray2, false);
            Vector<String> vector = new Vector<String>();
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                String[] stringArray3 = DSUtil.getAttrValues(lDAPEntry, BACKEND_ATTR);
                if (stringArray3 == null) continue;
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = 0;
                    while (n2 < stringArray3.length) {
                        String string;
                        int n3 = stringArray3[n2].indexOf(58);
                        if (n3 > 0 && (string = stringArray3[n2].substring(0, n3)).equalsIgnoreCase(stringArray[n])) {
                            String string2 = stringArray3[n2].substring(n3 + 1);
                            vector.addElement(string2);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MappingUtils.getSuffixForBackend " + (Object)((Object)lDAPException)));
        }
        return objectArray;
    }

    public static String[] getBackendsForSuffix(LDAPConnection lDAPConnection, String string) {
        String[] stringArray;
        if (lDAPConnection == null || string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        DN dN = new DN(string);
        String[] stringArray2 = new String[]{BACKEND_ATTR};
        try {
            stringArray = lDAPConnection.search("", 0, "objectclass=*", stringArray2, false);
            while (stringArray.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)stringArray.nextElement();
                String[] stringArray3 = DSUtil.getAttrValues(lDAPEntry, BACKEND_ATTR);
                if (stringArray3 == null) continue;
                int n = 0;
                while (n < stringArray3.length) {
                    String string2;
                    DN dN2;
                    int n2 = stringArray3[n].indexOf(58);
                    if (n2 > 0 && (dN2 = new DN(string2 = stringArray3[n].substring(n2 + 1))).equals(dN)) {
                        String string3 = stringArray3[n].substring(0, n2);
                        vector.addElement(string3);
                    }
                    ++n;
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MappingUtils.getBackendsForSuffix " + (Object)((Object)lDAPException)));
        }
        if (vector.size() <= 0) {
            return null;
        }
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public static String getBackendForSuffix(LDAPConnection lDAPConnection, String string) {
        if (lDAPConnection == null || string == null) {
            return null;
        }
        String[] stringArray = MappingUtils.getBackendsForSuffix(lDAPConnection, string);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public static String getTopSuffixForEntry(LDAPConnection lDAPConnection, String string) {
        if (lDAPConnection == null || string == null) {
            return null;
        }
        DN dN = new DN(string);
        DN dN2 = null;
        DN dN3 = null;
        String[] stringArray = MappingUtils.getOrderedSuffixList(lDAPConnection, 0);
        int n = stringArray.length - 1;
        while (n >= 0) {
            dN3 = new DN(stringArray[n]);
            if (dN.equals(dN3) || dN.isDescendantOf(dN3)) {
                dN2 = dN3;
                return dN2.toString();
            }
            --n;
        }
        return null;
    }

    public static String getTopSuffixForEntry(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return null;
        }
        DN dN = new DN(string);
        DN dN2 = null;
        DN dN3 = null;
        MappingUtils.orderSuffixes(stringArray);
        int n = stringArray.length - 1;
        while (n >= 0) {
            dN3 = new DN(stringArray[n]);
            if (dN.equals(dN3) || dN.isDescendantOf(dN3)) {
                dN2 = dN3;
                return dN2.toString();
            }
            --n;
        }
        return null;
    }

    public static String getSuffixForEntry(LDAPConnection lDAPConnection, String string) {
        if (lDAPConnection == null || string == null) {
            return null;
        }
        DN dN = new DN(string);
        DN dN2 = null;
        DN dN3 = null;
        String[] stringArray = MappingUtils.getOrderedSuffixList(lDAPConnection, 0);
        int n = 0;
        while (n < stringArray.length) {
            dN3 = new DN(stringArray[n]);
            if (dN.equals(dN3) || dN.isDescendantOf(dN3)) {
                dN2 = dN3;
                return dN2.toString();
            }
            ++n;
        }
        return null;
    }

    public static String getBackendForEntry(LDAPConnection lDAPConnection, String string) {
        return MappingUtils.getBackendForSuffix(lDAPConnection, MappingUtils.getSuffixForEntry(lDAPConnection, string));
    }

    public static String[] getBackendsForEntry(LDAPConnection lDAPConnection, String string) {
        return MappingUtils.getBackendsForSuffix(lDAPConnection, MappingUtils.getSuffixForEntry(lDAPConnection, string));
    }

    public static boolean addMappingNode(LDAPConnection lDAPConnection, String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2) {
        LDAPEntry lDAPEntry;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null || string2.trim().length() == 0) {
            return false;
        }
        Character c = new Character(string2.charAt(0));
        Character c2 = new Character(string2.charAt(string2.length() - 1));
        Character c3 = new Character('\"');
        if (c.compareTo(c3) != 0) {
            stringBuffer.append('\"');
        }
        stringBuffer.append(string2);
        if (string3.compareTo(ROOT_MAPPING_NODE) != 0) {
            stringBuffer.append(",");
            stringBuffer.append(string3);
        }
        if (c2.compareTo(c3) != 0) {
            stringBuffer.append('\"');
        }
        String string5 = "cn=" + stringBuffer.toString() + "," + CONFIG_MAPPING;
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        String[] stringArray3 = new String[]{"top", "extensibleObject", "nsMappingTree"};
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray3));
        String[] stringArray4 = new String[]{string4};
        lDAPAttributeSet.add(new LDAPAttribute("nsslapd-state", stringArray4));
        String[] stringArray5 = new String[]{stringBuffer.toString()};
        lDAPAttributeSet.add(new LDAPAttribute("cn", stringArray5));
        if (string3.compareTo(ROOT_MAPPING_NODE) != 0) {
            lDAPEntry = new LDAPEntry[]{MappingUtils.Quote(string3.trim())};
            lDAPAttributeSet.add(new LDAPAttribute("nsslapd-parent-suffix", (String[])lDAPEntry));
        }
        if (stringArray != null) {
            lDAPAttributeSet.add(new LDAPAttribute("nsslapd-backend", stringArray));
        }
        if (stringArray2 != null) {
            lDAPAttributeSet.add(new LDAPAttribute("nsslapd-referral", stringArray2));
        }
        lDAPEntry = new LDAPEntry(string5, lDAPAttributeSet);
        try {
            lDAPConnection.add(lDAPEntry);
        }
        catch (LDAPException lDAPException) {
            String string6 = lDAPException.errorCodeToString();
            String string7 = lDAPException.getLDAPErrorMessage();
            if (string7 != null && string7.length() > 0) {
                string6 = string6 + ". " + string7;
            }
            String[] stringArray6 = new String[]{string6};
            DSUtil.showErrorDialog(null, "error-new-node-title", "error-new-node-msg", stringArray6, string, DSUtil._resource);
            return false;
        }
        return true;
    }

    public static String[] whatsMoreInThisList(String[] stringArray, String[] stringArray2) {
        return MappingUtils.whatsMoreInThisList(stringArray, stringArray2, false);
    }

    public static String[] whatsMoreInThisList(String[] stringArray, String[] stringArray2, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray2;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>(1);
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray2.length) {
            if (!bl) {
                if (!MappingUtils.isStringInStringArray(stringArray2[n], stringArray, bl)) {
                    vector.addElement(stringArray2[n]);
                }
            } else {
                int n2 = 0;
                while (!bl2 && n2 < stringArray.length) {
                    ++n2;
                }
            }
            ++n;
        }
        String[] stringArray3 = new String[vector.size()];
        vector.toArray(stringArray3);
        return stringArray3;
    }

    public static boolean isStringInStringArray(String string, String[] stringArray, boolean bl) {
        boolean bl2 = false;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length && !bl2) {
            bl2 = bl ? string.compareTo(stringArray[n]) == 0 : string.compareToIgnoreCase(stringArray[n]) == 0;
            ++n;
        }
        return bl2;
    }
}

