/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.ReplicaFormatException;
import java.util.Vector;
import netscape.ldap.LDAPEntry;

public class Replica {
    public int role = -1;
    public String id;
    public boolean is4xCompatible;
    public Vector referral = new Vector();
    public Vector bindDn = new Vector();
    public String purgeDelay;
    public boolean overwriteReferrals;
    public boolean masterReferringAfterInit;
    public int delayAfterInit;
    public String suffix;
    public String dn;
    public static final int MASTER = 0;
    public static final int HUB = 1;
    public static final int DEDICATED_CONSUMER = 2;
    public static final int LOG_MASK = 1;
    public static final int OVERWRITE_REFERRAL_MASK = 4;
    public static final String READ_ONLY_TYPE = "2";
    public static final String READ_WRITE_TYPE = "3";
    public static final String NO_ID = "65535";
    public static final int NO_DELAY_AFTER_INIT_AVAILABLE = -1;

    public static synchronized void updateReplica(Replica replica, LDAPEntry lDAPEntry) throws ReplicaFormatException {
        int n;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(DSUtil.getAttrValue(lDAPEntry, "nsDS5Flags"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ReplicaFormatException();
        }
        boolean bl = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaType").equals(READ_ONLY_TYPE);
        boolean bl2 = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaType").equals(READ_WRITE_TYPE);
        if ((n2 & 1) != 0 && !bl) {
            replica.role = 0;
            replica.id = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaID");
        } else if ((n2 & 1) != 0 && bl) {
            replica.role = 1;
        } else if ((n2 & 1) == 0 && bl) {
            replica.role = 2;
        } else {
            throw new ReplicaFormatException();
        }
        replica.overwriteReferrals = (n2 & 4) != 0;
        String string = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaLegacyConsumer");
        replica.is4xCompatible = string.equalsIgnoreCase("on");
        replica.purgeDelay = DSUtil.getAttrValue(lDAPEntry, "nsds5ReplicaPurgeDelay");
        if (replica.purgeDelay.equals("")) {
            replica.purgeDelay = String.valueOf(604800);
        }
        replica.bindDn.clear();
        String[] stringArray = DSUtil.getAttrValues(lDAPEntry, "nsDS5ReplicaBindDN");
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                replica.bindDn.addElement(stringArray[n]);
                ++n;
            }
        }
        replica.referral.clear();
        stringArray = DSUtil.getAttrValues(lDAPEntry, "nsDS5ReplicaReferral");
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                replica.referral.addElement(stringArray[n]);
                ++n;
            }
        }
        if (replica.role == 0) {
            replica.masterReferringAfterInit = false;
            replica.delayAfterInit = -1;
            String string2 = DSUtil.getAttrValue(lDAPEntry, "ds5LastInitTimeStamp");
            String string3 = DSUtil.getAttrValue(lDAPEntry, "ds5BeginReplicaAcceptUpdates");
            String string4 = DSUtil.getAttrValue(lDAPEntry, "ds5ReferralDelayAfterInit");
            try {
                int n3 = Integer.parseInt(string2);
                if (n3 > 0 && !string3.equalsIgnoreCase("start")) {
                    replica.masterReferringAfterInit = true;
                    replica.delayAfterInit = Integer.parseInt(string4);
                    if (replica.delayAfterInit == 0) {
                        replica.delayAfterInit = -1;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        replica.suffix = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaRoot");
        replica.dn = lDAPEntry.getDN();
    }
}

