/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.config.replication.AdvancedReplicaDialog;
import com.netscape.admin.dirserv.config.replication.AgreementCellRenderer;
import com.netscape.admin.dirserv.config.replication.AgreementListModel;
import com.netscape.admin.dirserv.config.replication.CompatibilityHelper;
import com.netscape.admin.dirserv.config.replication.DuplicateAgreementDialog;
import com.netscape.admin.dirserv.config.replication.EditAgreementDialog;
import com.netscape.admin.dirserv.config.replication.NewAgreementDialog;
import com.netscape.admin.dirserv.config.replication.Replica;
import com.netscape.admin.dirserv.config.replication.ReplicaChangeListener;
import com.netscape.admin.dirserv.config.replication.ReplicaFormatException;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.MenuItemCheckBox;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.util.ArrowIcon;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;

public class ConfigReplicationPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private DSFramework _framework;
    private boolean _isReloading;
    private JPanel _innerPane;
    private JPanel _contentPanel;
    private JPanel _generalPanel;
    private JPanel _agreementPanel;
    private JButton _bHelp;
    private JButton _bAdvanced;
    private JButton _bEnable;
    private JButton _bForceMasterToBeUpdatable;
    private JButton _bEditAgreement;
    private JButton _bDeleteAgreement;
    private JButton _bCreateAgreement;
    private JButton _bDuplicateAgreement;
    private JButton _bUpdate;
    private JPopupMenu _updateMenu;
    private MenuItemText _mDisable;
    private MenuItemText _mPromote;
    private MenuItemText _mEnable4xCompatibility;
    private MenuItemText _mDisable4xCompatibility;
    private JButton _bRefreshAgreements;
    private JPopupMenu _refreshMenu;
    private MenuItemText _mRefreshNow;
    private MenuItemCheckBox _mContinuousRefresh;
    private JButton _bAction;
    private JPopupMenu _actionMenu;
    private MenuItemText _mInitialize;
    private MenuItemText _mSuspend;
    private MenuItemText _mResume;
    private MenuItemText _mSendUpdatesNow;
    private MenuItemText _mDisableAgreement;
    private JTextArea _taStatus;
    private JScrollPane _scrollStatus;
    private JTextArea _taDescription;
    private JTextArea _taMasterReferring;
    private JPanel _masterReferringPanel;
    private JList _listAgreement;
    private Suffix _suffix;
    private Replica _replica;
    private ArrayList _listeners;
    private boolean _isInitialized;
    private boolean _doRefresh;
    private Thread _refresher;
    private Icon LEFT_ICON = new ArrowIcon(7);
    private AgreementListModel _modelAgreement;
    private static final ResourceSet _resource = ReplicaWizard._resource;
    private static String ACTION_LABEL = _resource.getString("replicationpanel", "action-label");
    private static String ACTION_MNEMONIC = _resource.getString("replicationpanel", "action-mnemonic");
    private static String ENABLE_AGREEMENT_LABEL = _resource.getString("replicationpanel", "enableagreement-label");
    private static String ENABLE_AGREEMENT_MNEMONIC = _resource.getString("replicationpanel", "enableagreement-mnemonic");
    private final JLabel REFRESH_LABEL = new JLabel(_resource.getString("replicationpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(_resource.getString("replicationpanel-no-rights", "label"), 2, 50);
    private MultilineLabel INCORRECT_FORMAT_LABEL;
    private final JLabel NO_REPLICA_LABEL = new JLabel(_resource.getString("replicationpanel-no-replica", "label"));
    private String HELP_TOKEN = "configuration-replication-noreplica-settings-help";
    private static final String MASTER_HELP_TOKEN = "configuration-replication-master-settings-help";
    private static final String HUB_HELP_TOKEN = "configuration-replication-hub-settings-help";
    private static final String DEDICATED_CONSUMER_HELP_TOKEN = "configuration-replication-dedicatedconsumer-settings-help";
    private static final String NO_REPLICA_HELP_TOKEN = "configuration-replication-noreplica-settings-help";
    private static final String DISABLE = "DISABLE";
    private static final String PROMOTE = "PROMOTE";
    private static final String ENABLE_4X_COMPATIBILITY = "ENABLE_4X_COMPATIBILITY";
    private static final String DISABLE_4X_COMPATIBILITY = "DISABLE_4X_COMPATIBILITY";
    private static final String INITIALIZE = "INITIALIZE";
    private static final String REFRESH_NOW = "REFRESH_NOW";
    private static final String CONTINUOUS_REFRESH = "CONTINUOUS_REFRESH";
    private static final String SUSPEND = "SUSPEND";
    private static final String RESUME = "RESUME";
    private static final String SEND_UPDATES_NOW = "SEND_UPDATES_NOW";
    private static final String DISABLE_AGREEMENT = "DISABLE_AGREEMENT";
    private static final String ENABLE_AGREEMENT = "ENABLE_AGREEMENT";

    public ConfigReplicationPanel(DSFramework dSFramework, Suffix suffix) {
        this._framework = dSFramework;
        this._suffix = suffix;
        String[] stringArray = new String[]{"cn=replica, " + this._suffix.getDn()};
        this.INCORRECT_FORMAT_LABEL = new MultilineLabel(_resource.getString("replicationpanel-incorrect-format", "label", stringArray), 2, 50);
        this.basicLayout();
        this._modelAgreement = new AgreementListModel();
        this._listeners = new ArrayList();
        this.createComponents();
    }

    public void addReplicaChangeListener(ReplicaChangeListener replicaChangeListener) {
        this._listeners.add(replicaChangeListener);
    }

    public void notifyPanelVisible() {
        if (this._replica != null && this._replica.role != 2 && !this._doRefresh && this._mContinuousRefresh.isChecked()) {
            this.startRefresher();
        }
    }

    public void notifyPanelInvisible() {
        this.stopRefresher();
    }

    public void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        ConfigReplicationPanel.this.readDataFromServer();
                        ConfigReplicationPanel.this.updateContentPanel();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigReplicationPanel.access$400(1.access$200(this.this$1), ConfigReplicationPanel.access$300(1.access$200(this.this$1)), false);
                                if (ConfigReplicationPanel.access$500(1.access$200(this.this$1)) != null && ConfigReplicationPanel.access$500((ConfigReplicationPanel)1.access$200(this.this$1)).role != 2 && ConfigReplicationPanel.access$600(1.access$200(this.this$1)).isChecked()) {
                                    if (ConfigReplicationPanel.access$700(1.access$200(this.this$1))) {
                                        ConfigReplicationPanel.access$800(1.access$200(this.this$1));
                                    }
                                } else {
                                    ConfigReplicationPanel.access$900(1.access$200(this.this$1));
                                }
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigReplicationPanel.access$400(1.access$200(this.this$1), (JComponent)ConfigReplicationPanel.access$1000(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (ReplicaFormatException replicaFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigReplicationPanel.access$400(1.access$200(this.this$1), (JComponent)ConfigReplicationPanel.access$1100(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = _resource.getString("replicationpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                ConfigReplicationPanel.access$400(1.access$200(this.this$1), (JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigReplicationPanel.this._isReloading = false;
                }

                static /* synthetic */ ConfigReplicationPanel access$200(1 var0) {
                    return var0.ConfigReplicationPanel.this;
                }
            });
            thread.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bHelp) {
            DSUtil.help(this.HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
        } else if (object == this._bEnable) {
            this.actionEnable();
        } else if (object == this._bForceMasterToBeUpdatable) {
            this.actionForceMasterToBeUpdatable();
        } else if (object == this._bAdvanced) {
            this.actionAdvanced();
        } else if (object == this._bEditAgreement) {
            this.actionEditAgreement();
        } else if (object == this._bDeleteAgreement) {
            this.actionDeleteAgreement();
        } else if (object == this._bCreateAgreement) {
            this.actionCreateAgreement();
        } else if (object == this._bDuplicateAgreement) {
            this.actionDuplicateAgreement();
        } else if (object == this._bRefreshAgreements) {
            this._refreshMenu.show(this._bRefreshAgreements, UIFactory.getComponentSpace() - (int)this._refreshMenu.getPreferredSize().getWidth(), UIFactory.getComponentSpace());
        } else if (object == this._mContinuousRefresh) {
            if (this._mContinuousRefresh.isSelected()) {
                this.startRefresher();
            } else {
                this.stopRefresher();
            }
        } else if (object == this._mRefreshNow) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    ConfigReplicationPanel.this.updateAgreementStatus();
                }
            });
            thread.start();
        } else if (object == this._bUpdate) {
            this._updateMenu.show(this._bUpdate, UIFactory.getComponentSpace() - (int)this._updateMenu.getPreferredSize().getWidth(), UIFactory.getComponentSpace());
        } else if (object == this._bAction) {
            if (this._bAction.getActionCommand() == ENABLE_AGREEMENT) {
                this.actionEnableAgreement();
            } else {
                this._actionMenu.show(this._bAction, UIFactory.getComponentSpace() - (int)this._actionMenu.getPreferredSize().getWidth(), -UIFactory.getComponentSpace() + (int)(this._bAction.getSize().getHeight() - this._actionMenu.getPreferredSize().getHeight()));
            }
        } else if (object == this._mDisable) {
            this.actionDisable();
        } else if (object == this._mPromote) {
            this.actionPromote();
        } else if (object == this._mEnable4xCompatibility) {
            this.actionEnable4xCompatibility();
        } else if (object == this._mDisable4xCompatibility) {
            this.actionDisable4xCompatibility();
        } else if (object == this._mInitialize) {
            this.actionInitialize();
        } else if (object == this._mSuspend) {
            this.actionSuspend();
        } else if (object == this._mDisableAgreement) {
            this.actionDisableAgreement();
        } else if (object == this._mSendUpdatesNow) {
            this.actionSendUpdatesNow();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this._listAgreement) {
            boolean bl = this._listAgreement.isSelectionEmpty() || this._modelAgreement.getAgreementNumber() == 0;
            boolean bl2 = !bl && this._listAgreement.getSelectedIndices().length == 1;
            this._bEditAgreement.setEnabled(bl2);
            this._bDeleteAgreement.setEnabled(!bl);
            this._bDuplicateAgreement.setEnabled(bl2);
            if (bl2) {
                this.updateStatusPanel((ReplicationAgreement)this._listAgreement.getSelectedValue());
            } else {
                this.emptyStatusPanel();
            }
        }
    }

    private void basicLayout() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.createHelpPanel();
        this.add((Component)jPanel, "South");
        this._innerPane = new JPanel(new GridBagLayout());
        this._innerPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this._innerPane);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)jScrollPane, "Center");
    }

    private JPanel createHelpPanel() {
        this._bHelp = UIFactory.makeJButton(this, "replicationpanel", "bhelp", _resource);
        JButton[] jButtonArray = new JButton[]{this._bHelp};
        JPanel jPanel = UIFactory.makeJButtonPanel(jButtonArray, true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("Center", jPanel);
        jPanel2.add("North", Box.createVerticalStrut(UIFactory.getDifferentSpace()));
        return jPanel2;
    }

    private void showComponent(JComponent jComponent, boolean bl) {
        this._innerPane.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        if (bl) {
            gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
        } else {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
        }
        this._bHelp.setVisible(!bl);
        this._innerPane.add((Component)jComponent, gridBagConstraints);
        this.validate();
        this.repaint();
    }

    private void createComponents() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._taDescription = new MultilineLabel(4, 20);
        JScrollPane jScrollPane = new JScrollPane(this._taDescription);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.getViewport().setBackground(this._contentPanel.getBackground());
        this._bForceMasterToBeUpdatable = UIFactory.makeJButton(this, "replicationpanel", "bforcemastertobeupdatable", _resource);
        this._taMasterReferring = new MultilineLabel(_resource.getString("replicationpanel", "masterreferring-msg"), 4, 20);
        JLabel jLabel = new JLabel((Icon)DSUtil.getPackageImage("failed.gif"));
        JScrollPane jScrollPane2 = new JScrollPane(this._taMasterReferring);
        jScrollPane2.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane2.getViewport().setBackground(this._contentPanel.getBackground());
        int n = (int)this._taMasterReferring.getPreferredSize().getHeight() + (int)jScrollPane2.getHorizontalScrollBar().getPreferredSize().getHeight();
        this._masterReferringPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 3;
        this._masterReferringPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        this._masterReferringPanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this._masterReferringPanel.add((Component)this._bForceMasterToBeUpdatable, gridBagConstraints);
        this._bEnable = UIFactory.makeJButton(this, "replicationpanel", "benable", _resource);
        this._bAdvanced = UIFactory.makeJButton(this, "replicationpanel", "badvanced", _resource);
        this._listAgreement = new JList(this._modelAgreement);
        this._listAgreement.addListSelectionListener(this);
        this._listAgreement.setCellRenderer(new AgreementCellRenderer());
        this._listAgreement.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && ConfigReplicationPanel.this._listAgreement.getSelectedValue() != null && ConfigReplicationPanel.this._listAgreement.getSelectedValue() != "NO_SERVER_TO_UPDATE") {
                    ConfigReplicationPanel.this.actionEditAgreement();
                }
            }
        });
        this._bEditAgreement = UIFactory.makeJButton(this, "replicationpanel", "beditagreement", _resource);
        this._bDeleteAgreement = UIFactory.makeJButton(this, "replicationpanel", "bdeleteagreement", _resource);
        this._bCreateAgreement = UIFactory.makeJButton(this, "replicationpanel", "bcreateagreement", _resource);
        this._bDuplicateAgreement = UIFactory.makeJButton(this, "replicationpanel", "bduplicateagreement", _resource);
        this._bRefreshAgreements = UIFactory.makeJButton(this, "replicationpanel", "brefreshagreements", _resource);
        this._bRefreshAgreements.setIcon(this.LEFT_ICON);
        int n2 = Math.max((int)this._bDuplicateAgreement.getPreferredSize().getWidth(), (int)this._bRefreshAgreements.getPreferredSize().getWidth() + this.LEFT_ICON.getIconWidth());
        int n3 = Math.max((int)this._bCreateAgreement.getPreferredSize().getWidth(), (int)this._bDeleteAgreement.getPreferredSize().getWidth());
        n3 = Math.max(n3, (int)this._bEditAgreement.getPreferredSize().getWidth());
        n2 = Math.max(n2, n3);
        n2 = Math.max(n2, (int)this._bAdvanced.getPreferredSize().getWidth());
        this._refreshMenu = new JPopupMenu();
        this._mRefreshNow = new MenuItemText(REFRESH_NOW, _resource.getString("replicationpanel", "mrefreshnow-label"), _resource.getString("replicationpanel", "mrefreshnow-description"), (ActionListener)this);
        this._mContinuousRefresh = new MenuItemCheckBox(CONTINUOUS_REFRESH, _resource.getString("replicationpanel", "mcontinuousrefresh-label"), _resource.getString("replicationpanel", "mcontinuousrefresh-description"), (ActionListener)this, false);
        this._refreshMenu.add((JMenuItem)this._mRefreshNow);
        this._refreshMenu.add((JMenuItem)this._mContinuousRefresh);
        this._generalPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this._bUpdate = UIFactory.makeJButton(this, "replicationpanel", "bupdate", _resource);
        this._bUpdate.setIcon(this.LEFT_ICON);
        this._bUpdate.setPreferredSize(new Dimension(this._bUpdate.getPreferredSize().width + this.LEFT_ICON.getIconWidth(), this._bUpdate.getPreferredSize().height));
        this._updateMenu = new JPopupMenu();
        this._mDisable = new MenuItemText(DISABLE, _resource.getString("replicationpanel", "mdisable"), _resource.getString("replicationpanel", "mdisable-description"), (ActionListener)this);
        this._mPromote = new MenuItemText(PROMOTE, _resource.getString("replicationpanel", "mpromote"), _resource.getString("replicationpanel", "mpromote-description"), (ActionListener)this);
        this._mEnable4xCompatibility = new MenuItemText(ENABLE_4X_COMPATIBILITY, _resource.getString("replicationpanel", "menable4xcompatibility"), _resource.getString("replicationpanel", "menable4xcompatibility-description"), (ActionListener)this);
        this._mDisable4xCompatibility = new MenuItemText(DISABLE_4X_COMPATIBILITY, _resource.getString("replicationpanel", "mdisable4xcompatibility"), _resource.getString("replicationpanel", "mdisable4xcompatibility-description"), (ActionListener)this);
        this._updateMenu.add((JMenuItem)this._mPromote);
        this._updateMenu.add((JMenuItem)this._mEnable4xCompatibility);
        this._updateMenu.add((JMenuItem)this._mDisable4xCompatibility);
        this._updateMenu.add((Component)new MenuItemSeparator());
        this._updateMenu.add((JMenuItem)this._mDisable);
        this._taStatus = new MultilineLabel(4, 20);
        this._scrollStatus = new JScrollPane(this._taStatus);
        this._scrollStatus.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._scrollStatus.getViewport().setBackground(this._contentPanel.getBackground());
        int n4 = (int)this._taStatus.getPreferredSize().getHeight() + (int)this._scrollStatus.getHorizontalScrollBar().getPreferredSize().getHeight();
        this._bAction = new JButton();
        this._bAction.addActionListener(this);
        this._actionMenu = new JPopupMenu();
        this._mInitialize = new MenuItemText(INITIALIZE, _resource.getString("replicationpanel", "minitialize"), _resource.getString("replicationpanel", "minitialize-description"), (ActionListener)this);
        this._mSuspend = new MenuItemText(SUSPEND, _resource.getString("replicationpanel", "msuspend"), _resource.getString("replicationpanel", "msuspend-description"), (ActionListener)this);
        this._mResume = new MenuItemText(RESUME, _resource.getString("replicationpanel", "mresume"), _resource.getString("replicationpanel", "mresume-description"), (ActionListener)this);
        this._mSendUpdatesNow = new MenuItemText(SEND_UPDATES_NOW, _resource.getString("replicationpanel", "msendupdatesnow"), _resource.getString("replicationpanel", "msendupdatesnow-description"), (ActionListener)this);
        this._mDisableAgreement = new MenuItemText(DISABLE_AGREEMENT, _resource.getString("replicationpanel", "mdisableagreement"), _resource.getString("replicationpanel", "mdisableagreement-description"), (ActionListener)this);
        this._actionMenu.add((JMenuItem)this._mInitialize);
        this._actionMenu.add((JMenuItem)this._mSendUpdatesNow);
        this._actionMenu.add((Component)new MenuItemSeparator());
        this._actionMenu.add((JMenuItem)this._mDisableAgreement);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        this._generalPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this._generalPanel.add((Component)this._bUpdate, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 0;
        this._generalPanel.add((Component)this._masterReferringPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = -1;
        this._generalPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        this._generalPanel.add((Component)this._bAdvanced, gridBagConstraints);
        this._agreementPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel2 = UIFactory.makeJLabel("replicationpanel", "lagreement", _resource);
        jLabel2.setLabelFor(this._listAgreement);
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        this._agreementPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        this._agreementPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        JScrollPane jScrollPane3 = new JScrollPane(this._listAgreement);
        jScrollPane3.setBorder(UITools.createLoweredBorder());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this._agreementPanel.add((Component)jScrollPane3, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._bCreateAgreement, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
        jPanel.add((Component)this._bDeleteAgreement, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
        jPanel.add((Component)this._bEditAgreement, gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
        jPanel.add((Component)this._bDuplicateAgreement, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel.add(Box.createHorizontalStrut(n2), gridBagConstraints);
        jPanel.add(Box.createVerticalStrut(2 * UIFactory.getComponentSpace()), gridBagConstraints);
        jPanel.add((Component)this._bRefreshAgreements, gridBagConstraints);
        jScrollPane3.setPreferredSize(new Dimension((int)jScrollPane3.getPreferredSize().getWidth(), (int)jPanel.getPreferredSize().getHeight()));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        this._agreementPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        CompoundBorder compoundBorder = new CompoundBorder(UITools.createLoweredBorder(), new EmptyBorder(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), UIFactory.getDifferentSpace(), UIFactory.getComponentSpace()));
        jPanel2.setBorder(compoundBorder);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this._scrollStatus, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._bAction, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add(Box.createVerticalStrut(n4), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weighty = 0.0;
        this._agreementPanel.add((Component)jPanel2, gridBagConstraints);
    }

    private void updateContentPanel() {
        this._contentPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, 0);
        if (this._replica == null) {
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 1.0;
            this._contentPanel.add((Component)this.NO_REPLICA_LABEL, gridBagConstraints);
            gridBagConstraints.insets.left = UIFactory.getComponentSpace();
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 0;
            this._contentPanel.add((Component)this._bEnable, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        } else {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.right = 0;
            this._contentPanel.add((Component)this._generalPanel, gridBagConstraints);
            this._mEnable4xCompatibility.setEnabled(!this._replica.is4xCompatible);
            this._mDisable4xCompatibility.setEnabled(this._replica.is4xCompatible);
            this._masterReferringPanel.setVisible(this._replica.role == 0 && this._replica.masterReferringAfterInit);
            if (this._replica.role == 0) {
                String[] stringArray = new String[]{this._replica.id};
                if (this._replica.masterReferringAfterInit) {
                    if (this._replica.delayAfterInit == -1) {
                        this._taMasterReferring.setText(_resource.getString("replicationpanel", "referring-master-warning-label"));
                    } else {
                        stringArray[0] = String.valueOf(this._replica.delayAfterInit);
                        this._taMasterReferring.setText(_resource.getString("replicationpanel", "referring-master-with-delay-warning-label", stringArray));
                    }
                }
                if (this._replica.is4xCompatible) {
                    this._taDescription.setText(_resource.getString("replicationpanel", "4xcompatible-master-description-label", stringArray));
                } else {
                    this._taDescription.setText(_resource.getString("replicationpanel", "master-description-label", stringArray));
                }
            } else if (this._replica.role == 1) {
                if (this._replica.is4xCompatible) {
                    this._taDescription.setText(_resource.getString("replicationpanel", "4xcompatible-hub-description-label"));
                } else {
                    this._taDescription.setText(_resource.getString("replicationpanel", "hub-description-label"));
                }
            } else if (this._replica.role == 2) {
                if (this._replica.is4xCompatible) {
                    this._taDescription.setText(_resource.getString("replicationpanel", "4xcompatible-dedicatedconsumer-description-label"));
                } else {
                    this._taDescription.setText(_resource.getString("replicationpanel", "dedicatedconsumer-description-label"));
                }
            } else {
                Thread.dumpStack();
            }
            if (this._replica.role != 2) {
                gridBagConstraints.insets.left = UIFactory.getComponentSpace();
                gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
                gridBagConstraints.weighty = 1.0;
                this._contentPanel.add((Component)this._agreementPanel, gridBagConstraints);
            } else {
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
                this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
            }
            this._bEditAgreement.setEnabled(false);
            this._bDeleteAgreement.setEnabled(false);
            this._bDuplicateAgreement.setEnabled(false);
            this._bAction.setVisible(false);
            this._scrollStatus.setVisible(false);
        }
    }

    private void readDataFromServer() throws LDAPException, ReplicaFormatException {
        LDAPEntry lDAPEntry;
        LDAPConnection lDAPConnection;
        block15: {
            lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            this._modelAgreement.clear();
            lDAPEntry = null;
            try {
                lDAPEntry = lDAPConnection.read("cn=replica, " + this._suffix.getDn());
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block15;
                throw lDAPException;
            }
        }
        if (lDAPEntry != null) {
            if (this._replica == null) {
                this._replica = new Replica();
            }
            Replica.updateReplica(this._replica, lDAPEntry);
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((ReplicaChangeListener)listIterator.next()).replicaChanged(this._replica);
            }
            if (this._replica.role != 2) {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this._replica.dn, 1, "objectclass=nsDS5ReplicationAgreement", (String[])null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
                    ReplicationAgreement replicationAgreement = new ReplicationAgreement();
                    ReplicationAgreement.updateAgreement(lDAPEntry2, replicationAgreement);
                    this._modelAgreement.addElement(replicationAgreement);
                }
                if (this._modelAgreement.getSize() == 0) {
                    this._modelAgreement.addElement("NO_SERVER_TO_UPDATE");
                }
            }
            int n = this._replica.role;
            switch (n) {
                case 0: {
                    this.HELP_TOKEN = MASTER_HELP_TOKEN;
                    break;
                }
                case 1: {
                    this.HELP_TOKEN = HUB_HELP_TOKEN;
                    break;
                }
                case 2: {
                    this.HELP_TOKEN = DEDICATED_CONSUMER_HELP_TOKEN;
                    break;
                }
                default: {
                    Thread.dumpStack();
                    break;
                }
            }
        } else {
            this._replica = null;
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((ReplicaChangeListener)listIterator.next()).replicaChanged(this._replica);
            }
            this.HELP_TOKEN = NO_REPLICA_HELP_TOKEN;
        }
    }

    private synchronized void updateAgreementStatus() {
        try {
            final ListIterator listIterator = ((AbstractList)this.readAgreements()).listIterator();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AgreementListModel agreementListModel = ConfigReplicationPanel.this._modelAgreement;
                    synchronized (agreementListModel) {
                        int[] nArray = ConfigReplicationPanel.this._listAgreement.getSelectedIndices();
                        ConfigReplicationPanel.this._modelAgreement.clear();
                        while (listIterator.hasNext()) {
                            ConfigReplicationPanel.this._modelAgreement.addElement(listIterator.next());
                        }
                        if (ConfigReplicationPanel.this._modelAgreement.getSize() == 0) {
                            ConfigReplicationPanel.this._modelAgreement.addElement("NO_SERVER_TO_UPDATE");
                        }
                        int n = 0;
                        while (n < nArray.length) {
                            if (nArray[n] < ConfigReplicationPanel.this._modelAgreement.getSize()) {
                                ConfigReplicationPanel.this._listAgreement.addSelectionInterval(nArray[n], nArray[n]);
                            }
                            ++n;
                        }
                    }
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigReplicationPanel.this.showComponent((JComponent)ConfigReplicationPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = _resource.getString("replicationpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigReplicationPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    private ArrayList readAgreements() throws LDAPException {
        ArrayList<ReplicationAgreement> arrayList = new ArrayList<ReplicationAgreement>();
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=replica, " + this._suffix.getDn(), 1, "objectclass=nsDS5ReplicationAgreement", (String[])null, false);
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            ReplicationAgreement replicationAgreement = new ReplicationAgreement();
            ReplicationAgreement.updateAgreement(lDAPEntry, replicationAgreement);
            arrayList.add(replicationAgreement);
        }
        return arrayList;
    }

    private String getValue(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        String string2 = (String)lDAPAttribute.getStringValues().nextElement();
        return string2;
    }

    private void actionEnable() {
        ReplicaWizard replicaWizard = new ReplicaWizard(this._framework, this._suffix);
        replicaWizard.pack();
        replicaWizard.show();
        if (!replicaWizard.isCancelled()) {
            this.readAndUpdate();
        }
    }

    public void actionDisable() {
        int n = this._modelAgreement.getAgreementNumber() > 0 ? DSUtil.showConfirmationDialog((Component)((Object)this._framework), "disable-confirmation-withagreements", (String[])null, "replicationpanel", ReplicaWizard._resource) : DSUtil.showConfirmationDialog((Component)((Object)this._framework), "disable-confirmation-withoutagreements", (String[])null, "replicationpanel", ReplicaWizard._resource);
        if (n == 0) {
            final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, ReplicaWizard._resource.getString("replicationpanel", "deleting-title"));
            genericProgressDialog.setTextInLabel(ReplicaWizard._resource.getString("replicationpanel", "deleting-msg"));
            genericProgressDialog.setLabelRows(1);
            genericProgressDialog.setLabelColumns(25);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LDAPConnection lDAPConnection = ConfigReplicationPanel.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    DSUtil.deleteTree(((ConfigReplicationPanel)ConfigReplicationPanel.this)._replica.dn, lDAPConnection);
                    genericProgressDialog.closeCallBack();
                }
            });
            thread.start();
            genericProgressDialog.packAndShow();
            this.readAndUpdate();
        }
    }

    private void actionPromote() {
        ReplicaWizard replicaWizard = new ReplicaWizard(this._framework, this._replica, this._suffix);
        replicaWizard.pack();
        replicaWizard.show();
        if (!replicaWizard.isCancelled()) {
            this.readAndUpdate();
        }
    }

    private void actionEnable4xCompatibility() {
        CompatibilityHelper compatibilityHelper = new CompatibilityHelper(this._framework, this._suffix.getDn());
        if (compatibilityHelper.enableCompatibility()) {
            this.readAndUpdate();
        }
    }

    private void actionDisable4xCompatibility() {
        CompatibilityHelper compatibilityHelper = new CompatibilityHelper(this._framework, this._suffix.getDn());
        if (compatibilityHelper.disableCompatibility()) {
            this.readAndUpdate();
        }
    }

    public void actionForceMasterToBeUpdatable() {
        final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("replicationpanel", "forcemastertobeupdatable-title"), this);
        genericProgressDialog.setTextInLabel(_resource.getString("replicationpanel", "forcemastertobeupdatable-msg"));
        genericProgressDialog.setLabelRows(1);
        genericProgressDialog.setLabelColumns(25);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LDAPConnection lDAPConnection = ConfigReplicationPanel.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("ds5BeginReplicaAcceptUpdates", "start"));
                try {
                    lDAPConnection.modify(((ConfigReplicationPanel)ConfigReplicationPanel.this)._replica.dn, lDAPModification);
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            12.access$1900(this.this$1).closeCallBack();
                            12.access$2000(this.this$1).readAndUpdate();
                        }
                    });
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    SwingUtilities.invokeLater(new Runnable(this, stringArray){
                        private final /* synthetic */ String[] val$arg;
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$arg = stringArray;
                        }

                        public void run() {
                            12.access$1900(this.this$1).closeCallBack();
                            DSUtil.showErrorDialog((Component)((Object)ConfigReplicationPanel.access$1800(12.access$2000(this.this$1))), "error-forcingmastertobeupdatable-title", "error-forcingmastertobeupdatable-msg", this.val$arg, "replicationpanel", ConfigReplicationPanel.access$1200());
                        }
                    });
                }
            }

            static /* synthetic */ GenericProgressDialog access$1900(12 var0) {
                return var0.genericProgressDialog;
            }

            static /* synthetic */ ConfigReplicationPanel access$2000(12 var0) {
                return var0.ConfigReplicationPanel.this;
            }
        });
        thread.start();
        genericProgressDialog.packAndShow();
    }

    private void actionAdvanced() {
        AdvancedReplicaDialog advancedReplicaDialog = new AdvancedReplicaDialog(this._framework, this._replica);
        advancedReplicaDialog.pack();
        advancedReplicaDialog.show();
        if (advancedReplicaDialog.isModified()) {
            this.readAndUpdate();
        }
    }

    private void actionEditAgreement() {
        ReplicationAgreement replicationAgreement = (ReplicationAgreement)this._listAgreement.getSelectedValue();
        EditAgreementDialog editAgreementDialog = new EditAgreementDialog(this._framework, replicationAgreement);
        editAgreementDialog.pack();
        editAgreementDialog.show();
        if (editAgreementDialog.isModified()) {
            this.readAndUpdate();
        }
    }

    private void actionDeleteAgreement() {
        int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirmation-deleteagreements", (String[])null, "replicationpanel", _resource);
        if (n == 0) {
            final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("replicationpanel", "deletingagreement-title"), this);
            genericProgressDialog.setTextInLabel(_resource.getString("replicationpanel", "deletingagreement-msg"));
            genericProgressDialog.setLabelRows(1);
            genericProgressDialog.setLabelColumns(25);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LDAPConnection lDAPConnection = ConfigReplicationPanel.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    int[] nArray = ConfigReplicationPanel.this._listAgreement.getSelectedIndices();
                    boolean[] blArray = new boolean[]{false};
                    boolean bl = false;
                    int n = 0;
                    while (n < nArray.length && !blArray[0]) {
                        ReplicationAgreement replicationAgreement = (ReplicationAgreement)ConfigReplicationPanel.this._modelAgreement.elementAt(nArray[n]);
                        try {
                            lDAPConnection.delete(replicationAgreement.dn);
                            bl = true;
                        }
                        catch (LDAPException lDAPException) {
                            String[] stringArray = new String[]{AgreementCellRenderer.getDisplayText(replicationAgreement), DSUtil.getLDAPErrorMessage(lDAPException)};
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, stringArray, blArray){
                                    private final /* synthetic */ String[] val$args;
                                    private final /* synthetic */ boolean[] val$done;
                                    private final /* synthetic */ 15 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$args = stringArray;
                                        this.val$done = blArray;
                                    }

                                    public void run() {
                                        int n = DSUtil.showConfirmationDialog((Component)((Object)ConfigReplicationPanel.access$1800(15.access$2100(this.this$1))), "error-deletingagreement", this.val$args, "replicationpanel", ConfigReplicationPanel.access$1200());
                                        this.val$done[0] = n != 0;
                                    }
                                });
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        ++n;
                    }
                    if (bl) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 15 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                15.access$2100(this.this$1).readAndUpdate();
                                15.access$2200(this.this$1).closeCallBack();
                            }
                        });
                    }
                }

                static /* synthetic */ ConfigReplicationPanel access$2100(15 var0) {
                    return var0.ConfigReplicationPanel.this;
                }

                static /* synthetic */ GenericProgressDialog access$2200(15 var0) {
                    return var0.genericProgressDialog;
                }
            });
            thread.start();
            genericProgressDialog.packAndShow();
        }
    }

    private void actionCreateAgreement() {
        NewAgreementDialog newAgreementDialog = new NewAgreementDialog(this._framework, this._suffix, this._modelAgreement.agreementArray());
        newAgreementDialog.pack();
        newAgreementDialog.show();
        if (newAgreementDialog.isCreated()) {
            this.readAndUpdate();
        }
    }

    private void actionDuplicateAgreement() {
        int n = this._listAgreement.getSelectedIndex();
        ReplicationAgreement replicationAgreement = (ReplicationAgreement)this._modelAgreement.elementAt(n);
        DuplicateAgreementDialog duplicateAgreementDialog = new DuplicateAgreementDialog(this._framework, replicationAgreement, this._modelAgreement.agreementArray());
        duplicateAgreementDialog.pack();
        duplicateAgreementDialog.show();
        if (duplicateAgreementDialog.somethingDuplicated()) {
            this.readAndUpdate();
        }
    }

    private void actionEnableAgreement() {
        this.changeAttributeOnAgreement("enablingagreement", "ds5AgreementEnable", "on", 2);
    }

    private void actionInitialize() {
        int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "initializeagreement-confirmation", (String[])null, "replicationpanel", ReplicaWizard._resource);
        if (n == 0) {
            this.changeAttributeOnAgreement("initializing", "nsds5BeginReplicaRefresh", "start", 2);
        }
    }

    private void actionDisableAgreement() {
        int n = this._listAgreement.getSelectedIndex();
        ReplicationAgreement replicationAgreement = (ReplicationAgreement)this._modelAgreement.elementAt(n);
        int n2 = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "disableagreement-confirmation", (String[])null, "replicationpanel", ReplicaWizard._resource);
        if (n2 == 0) {
            this.changeAttributeOnAgreement("disablingagreement", "ds5AgreementEnable", "off", 2);
        }
    }

    private void actionSendUpdatesNow() {
        int n = 0;
        ReplicationAgreement replicationAgreement = (ReplicationAgreement)this._listAgreement.getSelectedValue();
        if (!replicationAgreement.schedule.equals("*")) {
            n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "sendupdates-confirmation", (String[])null, "replicationpanel", _resource);
        }
        if (n == 0) {
            this.changeAttributeOnAgreement("sendingupdates", "nsDS5ReplicaUpdateSchedule", "*", 2);
        }
    }

    private void actionSuspend() {
        this.changeAttributeOnAgreement("suspending", "theattribute", "thevalue", 2);
    }

    private void actionResume() {
        this.changeAttributeOnAgreement("resuming", "theattribute", "thevalue*", 2);
    }

    private void updateStatusPanel(ReplicationAgreement replicationAgreement) {
        if (!this._bAction.isVisible()) {
            this._bAction.setVisible(true);
            this._scrollStatus.setVisible(true);
        }
        if (!replicationAgreement.isEnabled) {
            if (this._bAction.getActionCommand() != ENABLE_AGREEMENT) {
                this._bAction.setActionCommand(ENABLE_AGREEMENT);
                this._bAction.setIcon(null);
                this._bAction.setText(ENABLE_AGREEMENT_LABEL);
                if (ENABLE_AGREEMENT_MNEMONIC != null && ENABLE_AGREEMENT_MNEMONIC.length() > 0) {
                    this._bAction.setMnemonic(ENABLE_AGREEMENT_MNEMONIC.charAt(0));
                }
            }
            String string = _resource.getString("replicationpanel", "agreement-disabled-label");
            if (replicationAgreement.isSuspended) {
                string = string + "\n" + _resource.getString("replicationpanel", "initialization-suspended-label");
            }
            this._taStatus.setText(string);
        } else {
            if (this._bAction.getIcon() != this.LEFT_ICON) {
                this._bAction.setActionCommand(null);
                this._bAction.setIcon(this.LEFT_ICON);
                this._bAction.setText(ACTION_LABEL);
                if (ACTION_MNEMONIC != null && ACTION_MNEMONIC.length() > 0) {
                    this._bAction.setMnemonic(ACTION_MNEMONIC.charAt(0));
                }
            }
            if (replicationAgreement.isSuspended) {
                if (this._actionMenu.getComponent(0) != this._mResume) {
                    this._actionMenu.removeAll();
                    this._actionMenu.add((JMenuItem)this._mResume);
                    this._actionMenu.add((Component)new MenuItemSeparator());
                    this._actionMenu.add((JMenuItem)this._mDisableAgreement);
                }
                this._taStatus.setText(_resource.getString("replicationpanel", "initialization-suspended-label"));
            } else if (replicationAgreement.isInitializing) {
                String[] stringArray;
                if (this._actionMenu.getComponent(0) != this._mDisableAgreement) {
                    this._actionMenu.removeAll();
                    this._actionMenu.add((JMenuItem)this._mDisableAgreement);
                }
                String string = _resource.getString("replicationpanel", "initializing-label");
                if (replicationAgreement.lastInitStart != "NO_TIME_AVAILABLE") {
                    stringArray = new String[]{DSUtil.getDateTime(replicationAgreement.lastInitStart).toString()};
                    string = string + "\n" + _resource.getString("replicationpanel", "initializing-date-label", stringArray);
                }
                if (!replicationAgreement.lastInitMessage.equals("")) {
                    stringArray = new String[]{ReplicationAgreement.convertStatusMessage(replicationAgreement.lastInitMessage)};
                    string = string + "\n" + _resource.getString("replicationpanel", "initializing-msg-label", stringArray);
                }
                this._taStatus.setText(string);
            } else {
                if (this._actionMenu.getComponent(0) != this._mInitialize) {
                    this._actionMenu.removeAll();
                    this._actionMenu.add((JMenuItem)this._mInitialize);
                    this._actionMenu.add((JMenuItem)this._mSendUpdatesNow);
                    this._actionMenu.add((Component)new MenuItemSeparator());
                    this._actionMenu.add((JMenuItem)this._mDisableAgreement);
                }
                if (replicationAgreement.lastInitEnd != "NO_TIME_AVAILABLE") {
                    String[] stringArray = new String[]{DSUtil.getDateTime(replicationAgreement.lastInitEnd).toString(), ReplicationAgreement.convertStatusMessage(replicationAgreement.lastUpdateMessage)};
                    this._taStatus.setText(_resource.getString("replicationpanel", "agreement-initialized-label", stringArray));
                } else {
                    String[] stringArray = new String[]{ReplicationAgreement.convertStatusMessage(replicationAgreement.lastUpdateMessage)};
                    this._taStatus.setText(_resource.getString("replicationpanel", "agreement-not-initialized-label", stringArray));
                }
            }
        }
    }

    private void emptyStatusPanel() {
        this._scrollStatus.setVisible(false);
        this._bAction.setVisible(false);
    }

    private void changeAttributeOnAgreement(final String string, final String string2, final String string3, final int n) {
        final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("replicationpanel", string + "-title"));
        int n2 = this._listAgreement.getSelectedIndex();
        final ReplicationAgreement replicationAgreement = (ReplicationAgreement)this._modelAgreement.elementAt(n2);
        String[] stringArray = new String[]{DSUtil.abreviateString(AgreementCellRenderer.getDisplayText(replicationAgreement), 30)};
        genericProgressDialog.setTextInLabel(_resource.getString("replicationpanel", string + "-msg", stringArray));
        genericProgressDialog.setLabelRows(1);
        genericProgressDialog.setLabelColumns(40);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    LDAPConnection lDAPConnection = ConfigReplicationPanel.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    lDAPConnection.modify(replicationAgreement.dn, new LDAPModification(n, new LDAPAttribute(string2, string3)));
                    ConfigReplicationPanel.this.updateAgreementStatus();
                    genericProgressDialog.closeCallBack();
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray = new String[]{DSUtil.abreviateString(AgreementCellRenderer.getDisplayText(replicationAgreement), 30), DSUtil.getLDAPErrorMessage(lDAPException)};
                    SwingUtilities.invokeLater(new Runnable(this, stringArray){
                        private final /* synthetic */ String[] val$args;
                        private final /* synthetic */ 18 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$args = stringArray;
                        }

                        public void run() {
                            18.access$2300(this.this$1).closeCallBack();
                            DSUtil.showErrorDialog((Component)((Object)ConfigReplicationPanel.access$1800(18.access$2400(this.this$1))), "error-" + 18.access$2500(this.this$1) + "-title", "error-" + 18.access$2500(this.this$1) + "-msg", this.val$args, "replicationpanel", ConfigReplicationPanel.access$1200());
                        }
                    });
                }
            }

            static /* synthetic */ GenericProgressDialog access$2300(18 var0) {
                return var0.genericProgressDialog;
            }

            static /* synthetic */ ConfigReplicationPanel access$2400(18 var0) {
                return var0.ConfigReplicationPanel.this;
            }

            static /* synthetic */ String access$2500(18 var0) {
                return var0.string;
            }
        });
        thread.start();
        genericProgressDialog.packAndShow();
    }

    private void startRefresher() {
        this._doRefresh = true;
        if (this._refresher == null) {
            this._refresher = new Thread(){

                public void run() {
                    while (ConfigReplicationPanel.this._doRefresh) {
                        ConfigReplicationPanel.this.updateAgreementStatus();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ConfigReplicationPanel.this._refresher = null;
                }
            };
            this._refresher.start();
        }
    }

    private void stopRefresher() {
        this._doRefresh = false;
    }

    static /* synthetic */ JPanel access$300(ConfigReplicationPanel configReplicationPanel) {
        return configReplicationPanel._contentPanel;
    }

    static /* synthetic */ MenuItemCheckBox access$600(ConfigReplicationPanel configReplicationPanel) {
        return configReplicationPanel._mContinuousRefresh;
    }

    static /* synthetic */ void access$800(ConfigReplicationPanel configReplicationPanel) {
        configReplicationPanel.startRefresher();
    }

    static /* synthetic */ void access$900(ConfigReplicationPanel configReplicationPanel) {
        configReplicationPanel.stopRefresher();
    }

    static /* synthetic */ MultilineLabel access$1100(ConfigReplicationPanel configReplicationPanel) {
        return configReplicationPanel.INCORRECT_FORMAT_LABEL;
    }
}

