/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.ConfigLocalSuffixTabbedPanel;
import com.netscape.admin.dirserv.config.ConfigSuffixNode;
import com.netscape.admin.dirserv.config.ConfigSuffixSettingsPanel;
import com.netscape.admin.dirserv.config.IConfigNode;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.config.replication.CompatibilityHelper;
import com.netscape.admin.dirserv.config.replication.ConfigReplicationPanel;
import com.netscape.admin.dirserv.config.replication.Replica;
import com.netscape.admin.dirserv.config.replication.ReplicaChangeListener;
import com.netscape.admin.dirserv.config.replication.ReplicaFormatException;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class ConfigReplicationNode
extends DefaultMutableTreeNode
implements IConfigNode,
ReplicaChangeListener {
    private DefaultTreeModel _treeModel;
    private String _name;
    private Icon _icon;
    private ConfigReplicationPanel _customPanel;
    private boolean _refreshPanelOnRequest;
    private DSFramework _framework;
    private Suffix _suffix;
    private Replica _replica;
    private static final String ENABLE = "ENABLE";
    private static final String DISABLE = "DISABLE";
    private static final String PROMOTE = "PROMOTE";
    private static final String ENABLE_4X_COMPATIBILITY = "ENABLE_4X_COMPATIBILITY";
    private static final String DISABLE_4X_COMPATIBILITY = "DISABLE_4X_COMPATIBILITY";
    private static final ResourceSet _resource = ReplicaWizard._resource;
    private final IMenuItem[] _objectMenuItems = new IMenuItem[]{new MenuItemText("ENABLE", _resource.getString("replicationpanel", "menable"), _resource.getString("replicationpanel", "menable-description")), new MenuItemText("PROMOTE", _resource.getString("replicationpanel", "mpromote"), _resource.getString("replicationpanel", "mpromote-description")), new MenuItemText("ENABLE_4X_COMPATIBILITY", _resource.getString("replicationpanel", "menable4xcompatibility"), _resource.getString("replicationpanel", "menable4xcompatibility-description")), new MenuItemText("DISABLE_4X_COMPATIBILITY", _resource.getString("replicationpanel", "mdisable4xcompatibility"), _resource.getString("replicationpanel", "mdisable4xcompatibility-description")), new MenuItemSeparator(), new MenuItemText("DISABLE", _resource.getString("replicationpanel", "mdisable"), _resource.getString("replicationpanel", "mdisable-description"))};
    private final IMenuItem[] _contextMenuItems = new IMenuItem[]{new MenuItemText("ENABLE", _resource.getString("replicationpanel", "menable"), _resource.getString("replicationpanel", "menable-description")), new MenuItemText("PROMOTE", _resource.getString("replicationpanel", "mpromote"), _resource.getString("replicationpanel", "mpromote-description")), new MenuItemText("ENABLE_4X_COMPATIBILITY", _resource.getString("replicationpanel", "menable4xcompatibility"), _resource.getString("replicationpanel", "menable4xcompatibility-description")), new MenuItemText("DISABLE_4X_COMPATIBILITY", _resource.getString("replicationpanel", "mdisable4xcompatibility"), _resource.getString("replicationpanel", "mdisable4xcompatibility-description")), new MenuItemSeparator(), new MenuItemText("DISABLE", _resource.getString("replicationpanel", "mdisable"), _resource.getString("replicationpanel", "mdisable-description"))};

    public ConfigReplicationNode(DSFramework dSFramework, Suffix suffix, DefaultTreeModel defaultTreeModel) {
        this._framework = dSFramework;
        this._suffix = suffix;
        this._treeModel = defaultTreeModel;
        this._name = ReplicaWizard._resource.getString("replicationnode-disable", "label");
        this._icon = DSUtil.getPackageImage("ds-rep-dis-get-16.gif");
        this._replica = new Replica();
        int n = 0;
        while (n < this._objectMenuItems.length) {
            if (this._objectMenuItems[n] instanceof MenuItemText) {
                ((MenuItemText)this._objectMenuItems[n]).setVisible(false);
                ((MenuItemText)this._contextMenuItems[n]).setVisible(false);
            } else {
                ((MenuItemSeparator)this._objectMenuItems[n]).setVisible(false);
                ((MenuItemSeparator)this._contextMenuItems[n]).setVisible(false);
            }
            ++n;
        }
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public Component getCustomPanel() {
        if (this._customPanel == null) {
            this._customPanel = this.createCustomPanel();
        } else if (this._refreshPanelOnRequest) {
            this._customPanel.readAndUpdate();
        }
        this._refreshPanelOnRequest = false;
        return this._customPanel;
    }

    public boolean isRefreshNeededOnExpansion() {
        return false;
    }

    public void refreshNode() {
        this._refreshPanelOnRequest = true;
        boolean bl = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        String[] stringArray = new String[]{"nsDS5Flags", "nsDS5ReplicaType", "nsDS5ReplicaLegacyConsumer"};
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read("cn=replica, " + this._suffix.getDn(), stringArray);
            boolean bl2 = bl = lDAPEntry != null;
            if (bl) {
                try {
                    Replica.updateReplica(this._replica, lDAPEntry);
                }
                catch (ReplicaFormatException replicaFormatException) {}
            } else {
                this._replica = null;
            }
            this.updateMenus();
            this.updateNameAndIcon();
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 32) {
                // empty if block
            }
        }
    }

    public void menuAction(String string) {
        CompatibilityHelper compatibilityHelper;
        if (string == ENABLE) {
            ReplicaWizard replicaWizard = new ReplicaWizard(this._framework, this._suffix);
            replicaWizard.pack();
            replicaWizard.show();
            if (!replicaWizard.isCancelled() && this._customPanel != null) {
                this._customPanel.readAndUpdate();
            }
        } else if (string == DISABLE) {
            if (this._customPanel != null) {
                this._customPanel.actionDisable();
            } else {
                int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "disable-confirmation-withoutagreements", (String[])null, "replicationpanel", ReplicaWizard._resource);
                if (n == 0) {
                    final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, ReplicaWizard._resource.getString("replicationpanel", "deleting-title"));
                    genericProgressDialog.setTextInLabel(ReplicaWizard._resource.getString("replicationpanel", "deleting-msg"));
                    genericProgressDialog.setLabelRows(1);
                    genericProgressDialog.setLabelColumns(25);
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            LDAPConnection lDAPConnection = ConfigReplicationNode.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                            DSUtil.deleteTree("cn=replica, " + ConfigReplicationNode.this._suffix.getDn(), lDAPConnection);
                            genericProgressDialog.closeCallBack();
                        }
                    });
                    thread.start();
                    genericProgressDialog.packAndShow();
                }
            }
        } else if (string == PROMOTE) {
            ReplicaWizard replicaWizard = new ReplicaWizard(this._framework, this._replica, this._suffix);
            replicaWizard.pack();
            replicaWizard.show();
            if (!replicaWizard.isCancelled() && this._customPanel != null) {
                this._customPanel.readAndUpdate();
            }
        } else if (string == ENABLE_4X_COMPATIBILITY) {
            CompatibilityHelper compatibilityHelper2 = new CompatibilityHelper(this._framework, this._suffix.getDn());
            if (compatibilityHelper2.enableCompatibility() && this._customPanel != null) {
                this._customPanel.readAndUpdate();
            }
        } else if (string == DISABLE_4X_COMPATIBILITY && (compatibilityHelper = new CompatibilityHelper(this._framework, this._suffix.getDn())).disableCompatibility() && this._customPanel != null) {
            this._customPanel.readAndUpdate();
        }
    }

    public IMenuItem[] getObjectMenuItems() {
        return this._objectMenuItems;
    }

    public IMenuItem[] getContextMenuItems() {
        return this._contextMenuItems;
    }

    public void replicaChanged(Replica replica) {
        this._replica = replica;
        this.updateMenus();
        this.updateNameAndIcon();
    }

    private ConfigReplicationPanel createCustomPanel() {
        ConfigReplicationPanel configReplicationPanel = new ConfigReplicationPanel(this._framework, this._suffix);
        configReplicationPanel.addReplicaChangeListener(this);
        ReplicaChangeListener replicaChangeListener = this.getSuffixSettingsPanel();
        if (replicaChangeListener != null) {
            configReplicationPanel.addReplicaChangeListener(replicaChangeListener);
        }
        configReplicationPanel.readAndUpdate();
        return configReplicationPanel;
    }

    private void updateMenus() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (ConfigReplicationNode.this._replica != null) {
                    ((MenuItemText)ConfigReplicationNode.this._objectMenuItems[0]).setVisible(false);
                    ((MenuItemText)ConfigReplicationNode.this._contextMenuItems[0]).setVisible(false);
                    int n = 1;
                    while (n < ConfigReplicationNode.this._objectMenuItems.length) {
                        if (ConfigReplicationNode.this._objectMenuItems[n] instanceof MenuItemText) {
                            ((MenuItemText)ConfigReplicationNode.this._objectMenuItems[n]).setVisible(true);
                            ((MenuItemText)ConfigReplicationNode.this._contextMenuItems[n]).setVisible(true);
                        } else {
                            ((MenuItemSeparator)ConfigReplicationNode.this._objectMenuItems[n]).setVisible(true);
                            ((MenuItemSeparator)ConfigReplicationNode.this._contextMenuItems[n]).setVisible(true);
                        }
                        ++n;
                    }
                    ((MenuItemText)ConfigReplicationNode.this._objectMenuItems[1]).setEnabled(true);
                    ((MenuItemText)ConfigReplicationNode.this._contextMenuItems[1]).setEnabled(true);
                    ((MenuItemText)ConfigReplicationNode.this._objectMenuItems[2]).setEnabled(!((ConfigReplicationNode)ConfigReplicationNode.this)._replica.is4xCompatible);
                    ((MenuItemText)ConfigReplicationNode.this._contextMenuItems[2]).setEnabled(!((ConfigReplicationNode)ConfigReplicationNode.this)._replica.is4xCompatible);
                    ((MenuItemText)ConfigReplicationNode.this._objectMenuItems[3]).setEnabled(((ConfigReplicationNode)ConfigReplicationNode.this)._replica.is4xCompatible);
                    ((MenuItemText)ConfigReplicationNode.this._contextMenuItems[3]).setEnabled(((ConfigReplicationNode)ConfigReplicationNode.this)._replica.is4xCompatible);
                } else {
                    ((MenuItemText)ConfigReplicationNode.this._objectMenuItems[0]).setVisible(true);
                    ((MenuItemText)ConfigReplicationNode.this._contextMenuItems[0]).setVisible(true);
                    int n = 1;
                    while (n < ConfigReplicationNode.this._objectMenuItems.length) {
                        if (ConfigReplicationNode.this._objectMenuItems[n] instanceof MenuItemText) {
                            ((MenuItemText)ConfigReplicationNode.this._objectMenuItems[n]).setVisible(false);
                            ((MenuItemText)ConfigReplicationNode.this._contextMenuItems[n]).setVisible(false);
                        } else {
                            ((MenuItemSeparator)ConfigReplicationNode.this._objectMenuItems[n]).setVisible(false);
                            ((MenuItemSeparator)ConfigReplicationNode.this._contextMenuItems[n]).setVisible(false);
                        }
                        ++n;
                    }
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private void updateNameAndIcon() {
        Runnable runnable = new Runnable(){

            public void run() {
                boolean bl;
                Icon icon = ConfigReplicationNode.this._icon;
                if (ConfigReplicationNode.this._replica == null) {
                    ConfigReplicationNode.this._name = ReplicaWizard._resource.getString("replicationnode-disable", "label");
                    ConfigReplicationNode.this._icon = (Icon)DSUtil.getPackageImage("ds-rep-dis-get-16.gif");
                } else {
                    ConfigReplicationNode.this._name = ReplicaWizard._resource.getString("replicationnode", "label");
                    if (((ConfigReplicationNode)ConfigReplicationNode.this)._replica.role == 0) {
                        ConfigReplicationNode.this._icon = (Icon)DSUtil.getPackageImage("ds-rep-push-16.gif");
                    } else if (((ConfigReplicationNode)ConfigReplicationNode.this)._replica.role == 2) {
                        ConfigReplicationNode.this._icon = (Icon)DSUtil.getPackageImage("ds-rep-get-16.gif");
                    } else {
                        ConfigReplicationNode.this._icon = (Icon)DSUtil.getPackageImage("ds-rep-hub-16.gif");
                    }
                }
                boolean bl2 = bl = ConfigReplicationNode.this._icon != icon;
                if (bl) {
                    ConfigReplicationNode.this._treeModel.nodeChanged(ConfigReplicationNode.this);
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private ReplicaChangeListener getSuffixSettingsPanel() {
        ConfigSuffixSettingsPanel configSuffixSettingsPanel = null;
        ConfigSuffixNode configSuffixNode = (ConfigSuffixNode)this.getParent();
        Component component = configSuffixNode.getCustomPanel();
        if (component instanceof ConfigLocalSuffixTabbedPanel) {
            configSuffixSettingsPanel = ((ConfigLocalSuffixTabbedPanel)component).getSuffixSettingsPanel();
        }
        return configSuffixSettingsPanel;
    }
}

