/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigPluginNode;
import com.netscape.admin.dirserv.config.ConfigPluginRootPanel;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.IConfigNode;
import com.netscape.admin.dirserv.config.Plugin;
import com.netscape.management.client.IMenuItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class ConfigPluginRootNode
extends DefaultMutableTreeNode
implements IConfigNode {
    private DSFramework _framework;
    private boolean _refreshPanelOnRequest;
    private ConfigPluginRootPanel _customPanel;
    private String _name;
    private Icon _icon;
    private boolean _isRefreshNeededOnExpansion;
    private boolean _isRefreshing;
    private boolean _isLeaf;
    private DefaultTreeModel _treeModel;
    private final IMenuItem[] _objectMenuItems = new IMenuItem[0];
    private final IMenuItem[] _contextMenuItems = new IMenuItem[0];
    private static final String PLUGIN_ROOT_ICON_NAME = "pluginfolder.gif";

    public ConfigPluginRootNode(DSFramework dSFramework, DefaultTreeModel defaultTreeModel) {
        this._framework = dSFramework;
        this._name = DSConfigPage._resource.getString("pluginsrootnode", "label");
        this._icon = DSUtil.getPackageImage(PLUGIN_ROOT_ICON_NAME);
        this._isRefreshNeededOnExpansion = true;
        this._treeModel = defaultTreeModel;
        this.checkChildren();
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public Component getCustomPanel() {
        if (this._customPanel == null) {
            this._customPanel = this.createCustomPanel();
        } else if (this._refreshPanelOnRequest) {
            this._customPanel.readAndUpdate();
        }
        this._refreshPanelOnRequest = false;
        return this._customPanel;
    }

    public boolean isRefreshNeededOnExpansion() {
        return this._isRefreshNeededOnExpansion;
    }

    public void refreshNode() {
        if (!this._isRefreshing) {
            this._refreshPanelOnRequest = true;
            this._isRefreshing = true;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    Object object;
                    LDAPEntry lDAPEntry;
                    ArrayList<ConfigPluginNode> arrayList = new ArrayList<ConfigPluginNode>();
                    int n = 0;
                    try {
                        LDAPConnection lDAPConnection = ConfigPluginRootNode.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=config", 2, "objectclass=nsslapdplugin", null, false);
                        ConfigPluginRootNode.this._isLeaf = true;
                        while (lDAPSearchResults.hasMoreElements()) {
                            lDAPEntry = lDAPSearchResults.next();
                            object = null;
                            Enumeration enumeration = lDAPEntry.getAttribute("cn").getStringValues();
                            if (enumeration.hasMoreElements()) {
                                object = (String)enumeration.nextElement();
                            }
                            ConfigPluginRootNode.this._isLeaf = false;
                            DefaultMutableTreeNode defaultMutableTreeNode = ConfigPluginRootNode.this.getPluginNode((String)object);
                            if (defaultMutableTreeNode != null) continue;
                            Plugin plugin = new Plugin();
                            Plugin.updatePluginFromEntry(plugin, lDAPEntry);
                            arrayList.add(new ConfigPluginNode(ConfigPluginRootNode.this._framework, ConfigPluginRootNode.this._treeModel, plugin));
                            DSUtil.addRequiresRestart(lDAPEntry.getDN(), "nsslapd-pluginenabled");
                            int n2 = arrayList.size();
                            if (n2 % 10 != 0) continue;
                            int n3 = n;
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, n3, n2, arrayList){
                                    private final /* synthetic */ int val$fBeginIndex;
                                    private final /* synthetic */ int val$size;
                                    private final /* synthetic */ ArrayList val$addedChildren;
                                    private final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$fBeginIndex = n;
                                        this.val$size = n2;
                                        this.val$addedChildren = arrayList;
                                    }

                                    public void run() {
                                        int n = this.val$fBeginIndex;
                                        while (n < this.val$size) {
                                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.val$addedChildren.get(n);
                                            ConfigPluginRootNode.access$300(1.access$400(this.this$1)).insertNodeInto(defaultMutableTreeNode, 1.access$400(this.this$1), 1.access$400(this.this$1).getChildCount());
                                            ++n;
                                        }
                                    }
                                });
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            n = n2;
                        }
                    }
                    catch (LDAPException lDAPException) {
                        // empty catch block
                    }
                    int n4 = arrayList.size();
                    int n5 = n;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(this, n5, n4, arrayList){
                            private final /* synthetic */ int val$fBeginIndex;
                            private final /* synthetic */ int val$size;
                            private final /* synthetic */ ArrayList val$addedChildren;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$fBeginIndex = n;
                                this.val$size = n2;
                                this.val$addedChildren = arrayList;
                            }

                            public void run() {
                                int n = this.val$fBeginIndex;
                                while (n < this.val$size) {
                                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.val$addedChildren.get(n);
                                    ConfigPluginRootNode.access$300(1.access$400(this.this$1)).insertNodeInto(defaultMutableTreeNode, 1.access$400(this.this$1), 1.access$400(this.this$1).getChildCount());
                                    ++n;
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    lDAPEntry = ConfigPluginRootNode.this.children();
                    while (lDAPEntry.hasMoreElements()) {
                        object = lDAPEntry.nextElement();
                        if (arrayList.contains(object)) continue;
                        ((IConfigNode)object).refreshNode();
                    }
                    ConfigPluginRootNode.this._isRefreshing = false;
                    ConfigPluginRootNode.this._isRefreshNeededOnExpansion = false;
                }

                static /* synthetic */ ConfigPluginRootNode access$400(1 var0) {
                    return var0.ConfigPluginRootNode.this;
                }
            });
            thread.start();
        }
    }

    public void menuAction(String string) {
    }

    public IMenuItem[] getObjectMenuItems() {
        return this._objectMenuItems;
    }

    public IMenuItem[] getContextMenuItems() {
        return this._contextMenuItems;
    }

    private DefaultMutableTreeNode getPluginNode(String string) {
        Enumeration<TreeNode> enumeration = this.children();
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        while (enumeration.hasMoreElements() && !bl) {
            IConfigNode iConfigNode = (IConfigNode)((Object)enumeration.nextElement());
            if (!iConfigNode.getName().equals(string)) continue;
            bl = true;
            defaultMutableTreeNode = (DefaultMutableTreeNode)((Object)iConfigNode);
        }
        return defaultMutableTreeNode;
    }

    private void checkChildren() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ConfigPluginRootNode.this._isLeaf = true;
                try {
                    LDAPConnection lDAPConnection = ConfigPluginRootNode.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
                    lDAPSearchConstraints.setMaxResults(1);
                    String[] stringArray = new String[]{"dn"};
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=config", 2, "objectclass=nsslapdplugin", stringArray, false, lDAPSearchConstraints);
                    while (lDAPSearchResults.hasMoreElements()) {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        ConfigPluginRootNode.this._isLeaf = false;
                    }
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                if (ConfigPluginRootNode.this._isLeaf) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(this){
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigPluginRootNode.access$300(4.access$700(this.this$1)).nodeChanged(4.access$700(this.this$1));
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }

            static /* synthetic */ ConfigPluginRootNode access$700(4 var0) {
                return var0.ConfigPluginRootNode.this;
            }
        });
        thread.start();
    }

    private ConfigPluginRootPanel createCustomPanel() {
        ConfigPluginRootPanel configPluginRootPanel = new ConfigPluginRootPanel(this._framework);
        configPluginRootPanel.readAndUpdate();
        return configPluginRootPanel;
    }
}

