/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;

public class ConfigPerformanceOtherPanel
extends ConfigBasePanel
implements DocumentListener {
    private boolean _needsRestartServer;
    private boolean _isInitializing;
    private boolean _isCancelled;
    private boolean _isInitializingComponents;
    private JPanel _contentPanel;
    private JLabel _lFileDescriptor;
    private JTextField _tfFileDescriptor;
    private JLabel _lThreadNumber;
    private JTextField _tfThreadNumber;
    private JLabel _lDSMLPoolSize;
    private JTextField _tfDSMLPoolSize;
    private JLabel _lDSMLPoolMaxSize;
    private JTextField _tfDSMLPoolMaxSize;
    private boolean[] _isFileDescriptorValidDirty = new boolean[]{true, false};
    private boolean[] _isThreadNumberValidDirty = new boolean[]{true, false};
    private boolean[] _isDSMLPoolSizeValidDirty = new boolean[]{true, false};
    private boolean[] _isDSMLPoolMaxSizeValidDirty = new boolean[]{true, false};
    private boolean _displayFileDescriptors;
    private int _saveFileDescriptor;
    private int _saveThreadNumber;
    private int _saveDSMLPoolSize;
    private int _saveDSMLPoolMaxSize;
    private String _lastReadAttribute;
    private String _lastReadEntry;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("performanceotherpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("performanceotherpanel-no-rights", "label"), 2, 50);
    private final int MAX_FILE_DESCRIPTOR = 65536;
    private final int MAX_THREADS = 100;
    private final int MAX_DSML_POOL_SIZE = 100;
    private final int MAX_DSML_POOL_MAX_SIZE = 200;
    private final int MIN_FILE_DESCRIPTOR = 1;
    private final int MIN_THREADS = 1;
    private final int MIN_DSML_POOL_SIZE = 0;
    private final int MIN_DSML_POOL_MAX_SIZE = 1;

    public ConfigPerformanceOtherPanel() {
        this.setTitle(ConfigBasePanel._resource.getString("performanceotherpanel", "title"));
        this._helpToken = "configuration-performance-other-help";
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigPerformanceOtherPanel.this.createContentPanel();
                        ConfigPerformanceOtherPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigPerformanceOtherPanel.access$300(1.access$200(this.this$1));
                                ConfigPerformanceOtherPanel.access$400(1.access$200(this.this$1));
                                1.access$200(this.this$1).showComponent(ConfigPerformanceOtherPanel.access$500(1.access$200(this.this$1)), false);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{ConfigPerformanceOtherPanel.access$600(1.access$200(this.this$1)), ConfigPerformanceOtherPanel.access$700(1.access$200(this.this$1))};
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("performanceotherpanel-formatting-error", "label", stringArray), 2, 50), true);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)ConfigPerformanceOtherPanel.access$800(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{ConfigPerformanceOtherPanel.this._lastReadEntry, DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("performanceotherpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigPerformanceOtherPanel.this._isInitialized = true;
                    ConfigPerformanceOtherPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigPerformanceOtherPanel access$200(1 var0) {
                    return var0.ConfigPerformanceOtherPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigPerformanceOtherPanel.this.initComponentsFromServerValues();
                    ConfigPerformanceOtherPanel.this.fireValidDirtyChange();
                    ConfigPerformanceOtherPanel.this.showComponent(ConfigPerformanceOtherPanel.this._contentPanel, false);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ConfigPerformanceOtherPanel.this._lastReadAttribute, ConfigPerformanceOtherPanel.this._lastReadEntry};
                    ConfigPerformanceOtherPanel.this.showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("performanceotherpanel-formatting-error", "label", stringArray), 2, 50), true);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigPerformanceOtherPanel.this.showComponent((JComponent)ConfigPerformanceOtherPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{this._lastReadEntry, DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("performanceotherpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigPerformanceOtherPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        this._needsRestartServer = false;
        boolean bl = false;
        String string = null;
        try {
            LDAPModificationSet lDAPModificationSet;
            LDAPModificationSet lDAPModificationSet2 = new LDAPModificationSet();
            if (this._isFileDescriptorValidDirty[1] && this._displayFileDescriptors) {
                lDAPModificationSet2.add(2, new LDAPAttribute("nsslapd-maxdescriptors", this._tfFileDescriptor.getText()));
            }
            if (this._isThreadNumberValidDirty[1]) {
                lDAPModificationSet2.add(2, new LDAPAttribute("nsslapd-threadnumber", this._tfThreadNumber.getText()));
            }
            if (lDAPModificationSet2.size() > 0 && !this._isCancelled) {
                string = "cn=config";
                lDAPModificationSet = this.getServerInfo().getLDAPConnection();
                lDAPModificationSet.modify(string, lDAPModificationSet2);
                bl = true;
            }
            lDAPModificationSet = new LDAPModificationSet();
            if (this._isDSMLPoolSizeValidDirty[1]) {
                try {
                    lDAPModificationSet.add(2, new LDAPAttribute("ds-hdsml-poolsize", this._tfDSMLPoolSize.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            if (this._isDSMLPoolMaxSizeValidDirty[1]) {
                try {
                    lDAPModificationSet.add(2, new LDAPAttribute("ds-hdsml-poolmaxsize", this._tfDSMLPoolMaxSize.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
                string = "cn=DSMLv2-SOAP-HTTP,cn=frontends,cn=plugins,cn=config";
                LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
                lDAPConnection.modify(string, lDAPModificationSet);
                bl = true;
            }
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
            throw new ConfigPanelException(ConfigBasePanel._resource.getString("performanceotherpanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("performanceotherpanel", "updating-server-error-msg", stringArray));
        }
        this._needsRestartServer = bl;
        if (!this._isCancelled && bl) {
            this.resetCallback();
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean needsRestartServer() {
        return this._needsRestartServer;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._isInitializingComponents) {
            Document document = documentEvent.getDocument();
            if (document == this._tfFileDescriptor.getDocument()) {
                this.fieldUpdated(this._tfFileDescriptor, this._lFileDescriptor, this._isFileDescriptorValidDirty, this._saveFileDescriptor, 1, 65536);
            } else if (document == this._tfThreadNumber.getDocument()) {
                this.checkValueCoherency();
            } else if (document == this._tfDSMLPoolSize.getDocument()) {
                this.checkValueCoherency();
            } else if (document == this._tfDSMLPoolMaxSize.getDocument()) {
                this.checkValueCoherency();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._lFileDescriptor = UIFactory.makeJLabel("performanceotherpanel", "lfiledescriptor", ConfigBasePanel._resource);
        this._tfFileDescriptor = UIFactory.makeJTextField(this, "performanceotherpanel", "lfiledescriptor", null, 7, ConfigBasePanel._resource);
        this._lFileDescriptor.setLabelFor(this._tfFileDescriptor);
        this._lThreadNumber = UIFactory.makeJLabel("performanceotherpanel", "lthreadnumber", ConfigBasePanel._resource);
        this._tfThreadNumber = UIFactory.makeJTextField(this, "performanceotherpanel", "lthreadnumber", null, 7, ConfigBasePanel._resource);
        this._lThreadNumber.setLabelFor(this._tfThreadNumber);
        this._lDSMLPoolSize = UIFactory.makeJLabel("performanceotherpanel", "ldsmlpoolsize", ConfigBasePanel._resource);
        this._tfDSMLPoolSize = UIFactory.makeJTextField(this, "performanceotherpanel", "ldsmlpoolsize", null, 7, ConfigBasePanel._resource);
        this._lDSMLPoolSize.setLabelFor(this._tfDSMLPoolSize);
        this._lDSMLPoolMaxSize = UIFactory.makeJLabel("performanceotherpanel", "ldsmlpoolmaxsize", ConfigBasePanel._resource);
        this._tfDSMLPoolMaxSize = UIFactory.makeJTextField(this, "performanceotherpanel", "ldsmlpoolmaxsize", null, 7, ConfigBasePanel._resource);
        this._lDSMLPoolMaxSize.setLabelFor(this._tfDSMLPoolMaxSize);
        JLabel jLabel = UIFactory.makeJLabel("performanceotherpanel", "lwarning", ConfigBasePanel._resource);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jLabel.setLabelFor(this._tfDSMLPoolMaxSize);
        JComponent[] jComponentArray = new JComponent[]{this._lFileDescriptor, this._tfFileDescriptor};
        this.addLine(this._contentPanel, jComponentArray);
        JComponent[] jComponentArray2 = new JComponent[]{this._lThreadNumber, this._tfThreadNumber};
        this.addLine(this._contentPanel, jComponentArray2);
        JComponent[] jComponentArray3 = new JComponent[]{this._lDSMLPoolSize, this._tfDSMLPoolSize};
        this.addLine(this._contentPanel, jComponentArray3);
        JComponent[] jComponentArray4 = new JComponent[]{this._lDSMLPoolMaxSize, this._tfDSMLPoolMaxSize};
        this.addLine(this._contentPanel, jComponentArray4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException, NumberFormatException {
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        lDAPSearchConstraints.setMaxResults(0);
        String[] stringArray = new String[]{"nsslapd-maxdescriptors", "nsslapd-threadnumber"};
        this._lastReadEntry = "cn=config";
        LDAPEntry lDAPEntry = lDAPConnection.read(this._lastReadEntry, stringArray, lDAPSearchConstraints);
        if (lDAPEntry.getAttribute("nsslapd-maxdescriptors") != null) {
            this._lastReadAttribute = "nsslapd-maxdescriptors";
            this._saveFileDescriptor = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
            this._displayFileDescriptors = true;
        } else {
            this._displayFileDescriptors = false;
        }
        this._lastReadAttribute = "nsslapd-threadnumber";
        this._saveThreadNumber = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        String[] stringArray2 = new String[]{"ds-hdsml-poolsize", "ds-hdsml-poolmaxsize"};
        this._lastReadEntry = "cn=DSMLv2-SOAP-HTTP,cn=frontends,cn=plugins,cn=config";
        LDAPEntry lDAPEntry2 = lDAPConnection.read(this._lastReadEntry, stringArray2, lDAPSearchConstraints);
        this._lastReadAttribute = "ds-hdsml-poolsize";
        this._saveDSMLPoolSize = DSUtil.getAttrValue(lDAPEntry2, this._lastReadAttribute).equals("") ? 0 : Integer.parseInt(this.getValue(lDAPEntry2, this._lastReadAttribute).trim());
        this._lastReadAttribute = "ds-hdsml-poolmaxsize";
        this._saveDSMLPoolMaxSize = DSUtil.getAttrValue(lDAPEntry2, this._lastReadAttribute).equals("") ? 0 : Integer.parseInt(this.getValue(lDAPEntry2, this._lastReadAttribute).trim());
    }

    private void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        if (this._displayFileDescriptors) {
            this._tfFileDescriptor.setText(String.valueOf(this._saveFileDescriptor));
            BlankPanel.setChangeState(this._lFileDescriptor, 1);
        }
        this._tfFileDescriptor.setVisible(this._displayFileDescriptors);
        this._lFileDescriptor.setVisible(this._displayFileDescriptors);
        this._tfThreadNumber.setText(String.valueOf(this._saveThreadNumber));
        BlankPanel.setChangeState(this._lThreadNumber, 1);
        this._tfDSMLPoolSize.setText(String.valueOf(this._saveDSMLPoolSize));
        BlankPanel.setChangeState(this._lDSMLPoolSize, 1);
        this._tfDSMLPoolMaxSize.setText(String.valueOf(this._saveDSMLPoolMaxSize));
        BlankPanel.setChangeState(this._lDSMLPoolMaxSize, 1);
        this._isFileDescriptorValidDirty[1] = false;
        this._isFileDescriptorValidDirty[0] = true;
        this._isThreadNumberValidDirty[1] = false;
        this._isThreadNumberValidDirty[0] = true;
        this._isDSMLPoolSizeValidDirty[1] = false;
        this._isDSMLPoolSizeValidDirty[0] = true;
        this._isDSMLPoolMaxSizeValidDirty[1] = false;
        this._isDSMLPoolMaxSizeValidDirty[0] = true;
        this._isInitializingComponents = false;
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this._isFileDescriptorValidDirty[1] || this._isThreadNumberValidDirty[1] || this._isDSMLPoolSizeValidDirty[1] || this._isDSMLPoolMaxSizeValidDirty[1];
        if (bl2) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        boolean bl4 = bl = this._isFileDescriptorValidDirty[0] && this._isThreadNumberValidDirty[0] && this._isDSMLPoolSizeValidDirty[0] && this._isDSMLPoolMaxSizeValidDirty[0];
        if (bl) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private void addLine(Container container, JComponent[] jComponentArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = jComponentArray.length + 1;
        container.add((Component)jComponentArray[0], gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        int n = 1;
        while (n < jComponentArray.length - 1) {
            --gridBagConstraints.gridwidth;
            container.add((Component)jComponentArray[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        container.add((Component)jComponentArray[jComponentArray.length - 1], gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        container.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    private void fieldUpdated(JTextField jTextField, JLabel jLabel, boolean[] blArray, int n, int n2, int n3) {
        try {
            int n4 = Integer.parseInt(jTextField.getText());
            blArray[1] = n4 != n;
            blArray[0] = n2 <= n4 && n4 <= n3;
        }
        catch (NumberFormatException numberFormatException) {
            blArray[0] = false;
            blArray[1] = true;
        }
        if (!blArray[0]) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        this.fireValidDirtyChange();
    }

    private void checkValueCoherency() {
        this.fieldUpdated(this._tfThreadNumber, this._lThreadNumber, this._isThreadNumberValidDirty, this._saveThreadNumber, 1, 100);
        this.fieldUpdated(this._tfDSMLPoolSize, this._lDSMLPoolSize, this._isDSMLPoolSizeValidDirty, this._saveDSMLPoolSize, 0, 100);
        this.fieldUpdated(this._tfDSMLPoolMaxSize, this._lDSMLPoolMaxSize, this._isDSMLPoolMaxSizeValidDirty, this._saveDSMLPoolMaxSize, 1, 200);
        if (this._isThreadNumberValidDirty[0] && this._isDSMLPoolSizeValidDirty[0] && this._isDSMLPoolMaxSizeValidDirty[0]) {
            try {
                boolean bl;
                boolean bl2 = bl = Integer.parseInt(this._tfThreadNumber.getText()) >= Integer.parseInt(this._tfDSMLPoolMaxSize.getText()) && Integer.parseInt(this._tfDSMLPoolMaxSize.getText()) >= Integer.parseInt(this._tfDSMLPoolSize.getText());
                if (!bl) {
                    this._isThreadNumberValidDirty[0] = false;
                    this._isDSMLPoolSizeValidDirty[0] = false;
                    this._isDSMLPoolMaxSizeValidDirty[0] = false;
                    BlankPanel.setChangeState(this._lThreadNumber, 3);
                    BlankPanel.setChangeState(this._lDSMLPoolSize, 3);
                    BlankPanel.setChangeState(this._lDSMLPoolMaxSize, 3);
                    this.fireValidDirtyChange();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

