/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

public class ConfigPasswordPolicyPanel
extends ConfigBasePanel
implements ActionListener {
    private boolean _isInitializing;
    private boolean _isInitializingComponents;
    private boolean _isCancelled;
    private String _lastReadAttribute;
    private JPanel _contentPanel;
    private JCheckBox _cbPasswordMustChangeOnReset;
    private JCheckBox _cbUserMayChangePassword;
    private JLabel _lAllowChanges;
    private JTextField _tfMinAge;
    private JCheckBox _cbNoMinAge;
    private JCheckBox _cbKeepHistory;
    private JTextField _tfRememberValue;
    private JLabel _lRemember1;
    private JLabel _lRemember2;
    private JRadioButton _rbPasswordNeverExpires;
    private JRadioButton _rbPasswordExpires;
    private JLabel _lExpiresIn;
    private JTextField _tfPasswordExpiresIn;
    private JTextField _tfSendWarning;
    private JLabel _lSendWarning1;
    private JLabel _lSendWarning2;
    private JCheckBox _cbAllowExpireWithoutWarning;
    private JCheckBox _cbCheckSyntax;
    private JLabel _lMinLength;
    private JTextField _tfMinLength;
    private JCheckBox _cbRootDNBypassModsChecks;
    private JLabel _lStorageScheme;
    private JComboBox _comboStorageScheme;
    private boolean _savePasswordMustChangeOnReset;
    private boolean _saveUserMayChangePassword;
    private int _saveMinAge;
    private boolean _saveKeepHistory;
    private int _saveRememberValue;
    private boolean _savePasswordExpires;
    private int _savePasswordExpiresIn;
    private int _saveSendWarning;
    private boolean _saveAllowExpireWithoutWarning;
    private boolean _saveCheckSyntax;
    private boolean _saveRootDNBypassModsChecks;
    private int _saveMinLength;
    private String _saveStorageScheme;
    private Vector _pwdSchemeNames;
    private Vector _pwdSchemeDesc;
    private ArrayList _readPwdSchemeNames;
    private ArrayList _readPwdSchemeDesc;
    private boolean _isPasswordMustChangeOnResetDirty;
    private boolean _isUserMayChangePwdDirty;
    private boolean[] _isMinAgeValidDirty = new boolean[2];
    private boolean _isKeepHistoryDirty;
    private boolean[] _isRememberValueValidDirty = new boolean[2];
    private boolean _isPasswordExpiresDirty;
    private boolean[] _isPasswordExpiresInValidDirty = new boolean[2];
    private boolean[] _isSendWarningValidDirty = new boolean[2];
    private boolean _isAllowExpireWithoutWarningDirty;
    private boolean _isCheckSyntaxDirty;
    private boolean _isRootDNBypassModsChecksDirty;
    private boolean[] _isMinLengthValidDirty = new boolean[2];
    private boolean _isStorageSchemeDirty;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("passwordpolicypanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("passwordpolicypanel-no-rights", "label"), 2, 50);
    private static final int DAY_TO_SEC_FACTOR = 86400;

    public ConfigPasswordPolicyPanel() {
        this.setTitle(ConfigBasePanel._resource.getString("passwordpolicypanel", "title"));
        this._helpToken = "configuration-data-passwordpolicy-help";
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigPasswordPolicyPanel.this._pwdSchemeNames = new Vector();
                        ConfigPasswordPolicyPanel.this._pwdSchemeDesc = new Vector();
                        ConfigPasswordPolicyPanel.this._readPwdSchemeNames = new ArrayList();
                        ConfigPasswordPolicyPanel.this._readPwdSchemeDesc = new ArrayList();
                        ConfigPasswordPolicyPanel.this.createContentPanel();
                        ConfigPasswordPolicyPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigPasswordPolicyPanel.access$700(1.access$600(this.this$1));
                                1.access$600(this.this$1).showComponent(ConfigPasswordPolicyPanel.access$800(1.access$600(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$600(this.this$1).showComponent((JComponent)ConfigPasswordPolicyPanel.access$900(1.access$600(this.this$1)), true);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{ConfigPasswordPolicyPanel.access$1000(1.access$600(this.this$1))};
                                1.access$600(this.this$1).showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("passwordpolicypanel-formatting-error", "label", stringArray), 2, 50), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("passwordpolicypanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$600(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigPasswordPolicyPanel.this._isInitialized = true;
                    ConfigPasswordPolicyPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigPasswordPolicyPanel access$600(1 var0) {
                    return var0.ConfigPasswordPolicyPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigPasswordPolicyPanel.this.initComponentsFromServerValues();
                    ConfigPasswordPolicyPanel.this.fireValidDirtyChange();
                    ConfigPasswordPolicyPanel.this.showComponent(ConfigPasswordPolicyPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigPasswordPolicyPanel.this.showComponent((JComponent)ConfigPasswordPolicyPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ConfigPasswordPolicyPanel.this._lastReadAttribute};
                    ConfigPasswordPolicyPanel.this.showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("passwordpolicypanel-formatting-error", "label", stringArray), 2, 50), true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("passwordpolicypanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigPasswordPolicyPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        int n;
        String string;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isPasswordMustChangeOnResetDirty) {
            string = this._cbPasswordMustChangeOnReset.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("passwordMustChange", string));
        }
        if (this._isUserMayChangePwdDirty) {
            string = this._cbUserMayChangePassword.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("passwordChange", string));
        }
        if (this._isMinAgeValidDirty[1]) {
            if (this._cbNoMinAge.isSelected()) {
                string = "0";
            } else {
                n = 0;
                try {
                    n = Integer.parseInt(this._tfMinAge.getText()) * 86400;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                string = Integer.toString(n);
            }
            lDAPModificationSet.add(2, new LDAPAttribute("passwordMinAge", string));
        }
        if (this._isKeepHistoryDirty) {
            string = this._cbKeepHistory.isSelected() ? (string = this._tfRememberValue.getText()) : "0";
            lDAPModificationSet.add(2, new LDAPAttribute("passwordInHistory", string));
        } else if (this._cbKeepHistory.isSelected() && this._isRememberValueValidDirty[1]) {
            string = this._tfRememberValue.getText();
            lDAPModificationSet.add(2, new LDAPAttribute("passwordInHistory", string));
        }
        if (this._isPasswordExpiresDirty) {
            string = this._rbPasswordExpires.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("passwordExp", string));
        }
        if (this._rbPasswordExpires.isSelected() && this._isPasswordExpiresInValidDirty[1]) {
            n = 0;
            try {
                n = Integer.parseInt(this._tfPasswordExpiresIn.getText()) * 86400;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            string = Integer.toString(n);
            lDAPModificationSet.add(2, new LDAPAttribute("passwordMaxAge", string));
        }
        if (this._rbPasswordExpires.isSelected() && this._isSendWarningValidDirty[1]) {
            n = 0;
            try {
                n = Integer.parseInt(this._tfSendWarning.getText()) * 86400;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            string = Integer.toString(n);
            lDAPModificationSet.add(2, new LDAPAttribute("passwordWarning", string));
        }
        if (this._rbPasswordExpires.isSelected() && this._isAllowExpireWithoutWarningDirty) {
            string = this._cbAllowExpireWithoutWarning.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("passwordExpireWithoutWarning", string));
        }
        if (this._isCheckSyntaxDirty) {
            string = this._cbCheckSyntax.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("passwordCheckSyntax", string));
        }
        if (this._isRootDNBypassModsChecksDirty) {
            string = this._cbRootDNBypassModsChecks.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("passwordRootDNMayByPassModsChecks", string));
        }
        if (this._cbCheckSyntax.isSelected() && this._isMinLengthValidDirty[1]) {
            string = this._tfMinLength.getText();
            lDAPModificationSet.add(2, new LDAPAttribute("passwordMinLength", string));
        }
        if (this._isStorageSchemeDirty) {
            String string2 = (String)this._comboStorageScheme.getSelectedItem();
            int n2 = this._pwdSchemeDesc.indexOf(string2);
            string = (String)this._pwdSchemeNames.elementAt(n2);
            lDAPModificationSet.add(2, new LDAPAttribute("passwordStorageScheme", string));
        }
        if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
            try {
                this.getServerInfo().getLDAPConnection().modify("cn=Password Policy, cn=config", lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("passwordpolicypanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("passwordpolicypanel", "updating-server-error-msg", stringArray));
            }
            this.resetCallback();
        }
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbPasswordMustChangeOnReset) {
            boolean bl = this._isPasswordMustChangeOnResetDirty = this._savePasswordMustChangeOnReset != this._cbPasswordMustChangeOnReset.isSelected();
            if (this._isPasswordMustChangeOnResetDirty) {
                BlankPanel.setChangeState(this._cbPasswordMustChangeOnReset, 2);
            } else {
                BlankPanel.setChangeState(this._cbPasswordMustChangeOnReset, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._cbUserMayChangePassword) {
            boolean bl = this._isUserMayChangePwdDirty = this._saveUserMayChangePassword != this._cbUserMayChangePassword.isSelected();
            if (this._isUserMayChangePwdDirty) {
                BlankPanel.setChangeState(this._cbUserMayChangePassword, 2);
            } else {
                BlankPanel.setChangeState(this._cbUserMayChangePassword, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._cbNoMinAge) {
            if (this._cbNoMinAge.isSelected()) {
                this._isMinAgeValidDirty[0] = true;
                this._isMinAgeValidDirty[1] = 0 != this._saveMinAge;
            } else {
                try {
                    int n = Integer.parseInt(this._tfMinAge.getText());
                    this._isMinAgeValidDirty[0] = n > 0 && n < 24855;
                    this._isMinAgeValidDirty[1] = n != this._saveMinLength;
                }
                catch (Exception exception) {
                    this._isMinAgeValidDirty[0] = false;
                    this._isMinAgeValidDirty[1] = true;
                }
            }
            this._tfMinAge.setEnabled(!this._cbNoMinAge.isSelected());
            if (!this._isMinAgeValidDirty[0]) {
                BlankPanel.setChangeState(this._lAllowChanges, 3);
            } else if (this._isMinAgeValidDirty[1]) {
                BlankPanel.setChangeState(this._lAllowChanges, 2);
            } else {
                BlankPanel.setChangeState(this._lAllowChanges, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._cbKeepHistory) {
            boolean bl = this._isKeepHistoryDirty = this._saveKeepHistory != this._cbKeepHistory.isSelected();
            if (this._isKeepHistoryDirty) {
                BlankPanel.setChangeState(this._cbKeepHistory, 2);
            } else {
                BlankPanel.setChangeState(this._cbKeepHistory, 1);
            }
            this._tfRememberValue.setEnabled(this._cbKeepHistory.isSelected());
            this._lRemember1.setEnabled(this._cbKeepHistory.isSelected());
            this._lRemember2.setEnabled(this._cbKeepHistory.isSelected());
            if (this._tfRememberValue.isEnabled()) {
                this.checkField(this._lRemember1, this._tfRememberValue.getText(), this._saveRememberValue, this._isRememberValueValidDirty, 1, 24);
            } else {
                this.fireValidDirtyChange();
            }
        } else if (object == this._rbPasswordNeverExpires || object == this._rbPasswordExpires) {
            boolean bl = this._isPasswordExpiresDirty = this._savePasswordExpires != this._rbPasswordExpires.isSelected();
            if (this._isPasswordExpiresDirty) {
                BlankPanel.setChangeState(this._rbPasswordExpires, 2);
                BlankPanel.setChangeState(this._rbPasswordNeverExpires, 2);
            } else {
                BlankPanel.setChangeState(this._rbPasswordExpires, 1);
                BlankPanel.setChangeState(this._rbPasswordNeverExpires, 1);
            }
            this._tfPasswordExpiresIn.setEnabled(this._rbPasswordExpires.isSelected());
            this._lExpiresIn.setEnabled(this._rbPasswordExpires.isSelected());
            this._tfSendWarning.setEnabled(this._rbPasswordExpires.isSelected());
            this._lSendWarning1.setEnabled(this._rbPasswordExpires.isSelected());
            this._lSendWarning2.setEnabled(this._rbPasswordExpires.isSelected());
            this._cbAllowExpireWithoutWarning.setEnabled(this._rbPasswordExpires.isSelected());
            this.fireValidDirtyChange();
        } else if (object == this._cbAllowExpireWithoutWarning) {
            boolean bl = this._isAllowExpireWithoutWarningDirty = this._saveAllowExpireWithoutWarning != this._cbAllowExpireWithoutWarning.isSelected();
            if (this._isAllowExpireWithoutWarningDirty) {
                BlankPanel.setChangeState(this._cbAllowExpireWithoutWarning, 2);
            } else {
                BlankPanel.setChangeState(this._cbAllowExpireWithoutWarning, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._cbCheckSyntax) {
            boolean bl = this._isCheckSyntaxDirty = this._saveCheckSyntax != this._cbCheckSyntax.isSelected();
            if (this._isCheckSyntaxDirty) {
                BlankPanel.setChangeState(this._cbCheckSyntax, 2);
            } else {
                BlankPanel.setChangeState(this._cbCheckSyntax, 1);
            }
            this._lMinLength.setEnabled(this._cbCheckSyntax.isSelected());
            this._tfMinLength.setEnabled(this._cbCheckSyntax.isSelected());
            this.fireValidDirtyChange();
        } else if (object == this._cbRootDNBypassModsChecks) {
            boolean bl = this._isRootDNBypassModsChecksDirty = this._saveRootDNBypassModsChecks != this._cbRootDNBypassModsChecks.isSelected();
            if (this._isRootDNBypassModsChecksDirty) {
                BlankPanel.setChangeState(this._cbRootDNBypassModsChecks, 2);
            } else {
                BlankPanel.setChangeState(this._cbRootDNBypassModsChecks, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._comboStorageScheme) {
            Object object2;
            int n = this._pwdSchemeNames.indexOf(this._saveStorageScheme);
            this._isStorageSchemeDirty = n != this._pwdSchemeDesc.indexOf(object2 = this._comboStorageScheme.getSelectedItem());
            BlankPanel.setChangeState(this._lStorageScheme, this._isStorageSchemeDirty ? 2 : 1);
            this.fireValidDirtyChange();
        }
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._cbPasswordMustChangeOnReset = UIFactory.makeJCheckBox(this, "passwordpolicypanel", "cbpasswordmustchangeonreset", false, ConfigBasePanel._resource);
        this._cbUserMayChangePassword = UIFactory.makeJCheckBox(this, "passwordpolicypanel", "cbusermaychangepassword", false, ConfigBasePanel._resource);
        this._lAllowChanges = UIFactory.makeJLabel("passwordpolicypanel", "lallowchanges", ConfigBasePanel._resource);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigPasswordPolicyPanel.this._isInitializingComponents) {
                    ConfigPasswordPolicyPanel.this.checkField(ConfigPasswordPolicyPanel.this._lAllowChanges, ConfigPasswordPolicyPanel.this._tfMinAge.getText(), ConfigPasswordPolicyPanel.this._saveMinAge, ConfigPasswordPolicyPanel.this._isMinAgeValidDirty, 1, 24855);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfMinAge = UIFactory.makeJTextField(documentListener, "passwordpolicypanel", "lallowchanges", null, 5, ConfigBasePanel._resource);
        this._lAllowChanges.setLabelFor(this._tfMinAge);
        this._cbNoMinAge = UIFactory.makeJCheckBox(this, "passwordpolicypanel", "cbnominage", false, ConfigBasePanel._resource);
        this._cbKeepHistory = UIFactory.makeJCheckBox(this, "passwordpolicypanel", "cbkeephistory", false, ConfigBasePanel._resource);
        this._lRemember1 = UIFactory.makeJLabel("passwordpolicypanel", "lremember1", ConfigBasePanel._resource);
        this._lRemember2 = UIFactory.makeJLabel("passwordpolicypanel", "lremember2", ConfigBasePanel._resource);
        DocumentListener documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigPasswordPolicyPanel.this._isInitializingComponents) {
                    ConfigPasswordPolicyPanel.this.checkField(ConfigPasswordPolicyPanel.this._lRemember1, ConfigPasswordPolicyPanel.this._tfRememberValue.getText(), ConfigPasswordPolicyPanel.this._saveRememberValue, ConfigPasswordPolicyPanel.this._isRememberValueValidDirty, 1, 24);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfRememberValue = UIFactory.makeJTextField(documentListener2, "passwordpolicypanel", "lremember1", null, 5, ConfigBasePanel._resource);
        this._lRemember1.setLabelFor(this._tfRememberValue);
        this._lRemember2.setLabelFor(this._tfRememberValue);
        this._rbPasswordNeverExpires = UIFactory.makeJRadioButton(this, "passwordpolicypanel", "rbpasswordneverexpires", false, ConfigBasePanel._resource);
        this._rbPasswordExpires = UIFactory.makeJRadioButton(this, "passwordpolicypanel", "rbpasswordexpires", false, ConfigBasePanel._resource);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbPasswordNeverExpires);
        buttonGroup.add(this._rbPasswordExpires);
        this._lExpiresIn = UIFactory.makeJLabel("passwordpolicypanel", "lexpiresin", ConfigBasePanel._resource);
        DocumentListener documentListener3 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigPasswordPolicyPanel.this._isInitializingComponents) {
                    ConfigPasswordPolicyPanel.this.checkField(ConfigPasswordPolicyPanel.this._lExpiresIn, ConfigPasswordPolicyPanel.this._tfPasswordExpiresIn.getText(), ConfigPasswordPolicyPanel.this._savePasswordExpiresIn, ConfigPasswordPolicyPanel.this._isPasswordExpiresInValidDirty, 1, 24855);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfPasswordExpiresIn = UIFactory.makeJTextField(documentListener3, "passwordpolicypanel", "lexpiresin", null, 5, ConfigBasePanel._resource);
        this._lExpiresIn.setLabelFor(this._tfPasswordExpiresIn);
        this._lSendWarning1 = UIFactory.makeJLabel("passwordpolicypanel", "lsendwarning1", ConfigBasePanel._resource);
        this._lSendWarning2 = UIFactory.makeJLabel("passwordpolicypanel", "lsendwarning2", ConfigBasePanel._resource);
        DocumentListener documentListener4 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigPasswordPolicyPanel.this._isInitializingComponents) {
                    ConfigPasswordPolicyPanel.this.checkField(ConfigPasswordPolicyPanel.this._lSendWarning1, ConfigPasswordPolicyPanel.this._tfSendWarning.getText(), ConfigPasswordPolicyPanel.this._saveSendWarning, ConfigPasswordPolicyPanel.this._isSendWarningValidDirty, 1, 24855);
                    ConfigPasswordPolicyPanel.this.checkSendWarningAndExpiration();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfSendWarning = UIFactory.makeJTextField(documentListener4, "passwordpolicypanel", "lsendwarning1", null, 5, ConfigBasePanel._resource);
        this._lSendWarning1.setLabelFor(this._tfSendWarning);
        this._lSendWarning2.setLabelFor(this._tfSendWarning);
        this._cbAllowExpireWithoutWarning = UIFactory.makeJCheckBox(this, "passwordpolicypanel", "cballowexpirewithoutwarning", false, ConfigBasePanel._resource);
        this._cbCheckSyntax = UIFactory.makeJCheckBox(this, "passwordpolicypanel", "cbchecksyntax", false, ConfigBasePanel._resource);
        this._lMinLength = UIFactory.makeJLabel("passwordpolicypanel", "lminlength", ConfigBasePanel._resource);
        DocumentListener documentListener5 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigPasswordPolicyPanel.this._isInitializingComponents) {
                    ConfigPasswordPolicyPanel.this.checkField(ConfigPasswordPolicyPanel.this._lMinLength, ConfigPasswordPolicyPanel.this._tfMinLength.getText(), ConfigPasswordPolicyPanel.this._saveMinLength, ConfigPasswordPolicyPanel.this._isMinLengthValidDirty, 2, 512);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfMinLength = UIFactory.makeJTextField(documentListener5, "passwordpolicypanel", "lminlength", null, 5, ConfigBasePanel._resource);
        this._lMinLength.setLabelFor(this._tfMinLength);
        this._cbRootDNBypassModsChecks = UIFactory.makeJCheckBox(this, "passwordpolicypanel", "cbrootdnbypassmodschecks", false, ConfigBasePanel._resource);
        this._comboStorageScheme = new JComboBox(this._pwdSchemeDesc);
        this._comboStorageScheme.addActionListener(this);
        this._lStorageScheme = UIFactory.makeJLabel("passwordpolicypanel", "lstoragescheme", ConfigBasePanel._resource);
        if (this._lStorageScheme.getToolTipText() != null) {
            this._comboStorageScheme.setToolTipText(this._lStorageScheme.getToolTipText());
        }
        this._lStorageScheme.setLabelFor(this._comboStorageScheme);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("passwordpolicypanel", "passwordchangepanel-label"));
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        GroupPanel groupPanel2 = new GroupPanel(ConfigBasePanel._resource.getString("passwordpolicypanel", "passwordexpirationpanel-label"));
        this._contentPanel.add((Component)groupPanel2, gridBagConstraints);
        gridBagConstraints.insets.left = 16;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 4;
        this._contentPanel.add((Component)this._cbCheckSyntax, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        --gridBagConstraints.gridwidth;
        this._contentPanel.add((Component)this._lMinLength, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        this._contentPanel.add((Component)this._tfMinLength, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this._contentPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 16;
        this._contentPanel.add((Component)this._cbRootDNBypassModsChecks, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(this._lStorageScheme);
        jPanel.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()));
        jPanel.add(this._comboStorageScheme);
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        this._contentPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        groupPanel.add((Component)this._cbPasswordMustChangeOnReset, gridBagConstraints);
        groupPanel.add((Component)this._cbUserMayChangePassword, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 5;
        groupPanel.add((Component)this._lAllowChanges, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        groupPanel.add((Component)this._tfMinAge, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        groupPanel.add((Component)UIFactory.makeJLabel("passwordpolicypanel", "days", ConfigBasePanel._resource), gridBagConstraints);
        groupPanel.add((Component)this._cbNoMinAge, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this._cbKeepHistory);
        jPanel2.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()));
        jPanel2.add(this._lRemember1);
        jPanel2.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()));
        jPanel2.add(this._tfRememberValue);
        jPanel2.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()));
        jPanel2.add(this._lRemember2);
        groupPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel2.add((Component)this._rbPasswordNeverExpires, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(this._rbPasswordExpires);
        jPanel3.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()));
        jPanel3.add(this._tfPasswordExpiresIn);
        jPanel3.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()));
        jPanel3.add(this._lExpiresIn);
        groupPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        groupPanel2.add((Component)this._lSendWarning1, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        groupPanel2.add((Component)this._tfSendWarning, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        groupPanel2.add((Component)this._lSendWarning2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        groupPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        groupPanel2.add((Component)this._cbAllowExpireWithoutWarning, gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException, NullPointerException, NumberFormatException {
        String[] stringArray = new String[]{"passwordMustChange", "passwordChange", "passwordMinAge", "passwordInHistory", "passwordExp", "passwordMaxAge", "passwordWarning", "passwordExpireWithoutWarning", "passwordCheckSyntax", "passwordMinLength", "passwordRootDNMayByPassModsChecks", "passwordStorageScheme"};
        LDAPEntry lDAPEntry = this.getServerInfo().getLDAPConnection().read("cn=Password Policy, cn=config", stringArray);
        this._savePasswordMustChangeOnReset = this.getValue(lDAPEntry, "passwordMustChange").equalsIgnoreCase("on");
        this._saveUserMayChangePassword = this.getValue(lDAPEntry, "passwordChange").equalsIgnoreCase("on");
        this._lastReadAttribute = "passwordMinAge";
        this._saveMinAge = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim()) / 86400;
        this._lastReadAttribute = "passwordInHistory";
        this._saveRememberValue = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._saveKeepHistory = this._saveRememberValue != 0;
        this._lastReadAttribute = "passwordExp";
        this._savePasswordExpires = this.getValue(lDAPEntry, "passwordExp").equalsIgnoreCase("on");
        this._lastReadAttribute = "passwordMaxAge";
        this._savePasswordExpiresIn = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim()) / 86400;
        this._lastReadAttribute = "passwordWarning";
        this._saveSendWarning = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim()) / 86400;
        this._lastReadAttribute = "passwordExpireWithoutWarning";
        this._saveAllowExpireWithoutWarning = this.getValue(lDAPEntry, "passwordExpireWithoutWarning").equalsIgnoreCase("on");
        this._lastReadAttribute = "passwordCheckSyntax";
        this._saveCheckSyntax = this.getValue(lDAPEntry, "passwordCheckSyntax").equalsIgnoreCase("on");
        this._lastReadAttribute = "passwordMinLength";
        this._saveMinLength = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "passwordRootDNMayByPassModsChecks";
        this._saveRootDNBypassModsChecks = this.getValue(lDAPEntry, "passwordRootDNMayByPassModsChecks").equalsIgnoreCase("on");
        this._saveStorageScheme = this.getValue(lDAPEntry, "passwordStorageScheme").toLowerCase();
        String[] stringArray2 = new String[]{"cn", "nsslapd-plugindescription"};
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=plugins, cn=config", 2, "nsslapd-plugintype=pwdstoragescheme", stringArray2, false);
        this._readPwdSchemeNames.clear();
        this._readPwdSchemeDesc.clear();
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
            String string = this.getValue(lDAPEntry2, "cn");
            if (string.equalsIgnoreCase("ns-mta-md5")) continue;
            this._readPwdSchemeNames.add(string.toLowerCase());
            if (lDAPEntry2.getAttribute("nsslapd-plugindescription") != null) {
                this._readPwdSchemeDesc.add(this.getValue(lDAPEntry2, "nsslapd-plugindescription"));
                continue;
            }
            this._readPwdSchemeDesc.add(string);
        }
    }

    private void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        this._pwdSchemeNames.clear();
        this._pwdSchemeDesc.clear();
        this._pwdSchemeNames.addAll(this._readPwdSchemeNames);
        this._pwdSchemeDesc.addAll(this._readPwdSchemeDesc);
        this._cbPasswordMustChangeOnReset.setSelected(this._savePasswordMustChangeOnReset);
        BlankPanel.setChangeState(this._cbPasswordMustChangeOnReset, 1);
        this._isPasswordMustChangeOnResetDirty = false;
        this._cbUserMayChangePassword.setSelected(this._saveUserMayChangePassword);
        BlankPanel.setChangeState(this._cbUserMayChangePassword, 1);
        this._isUserMayChangePwdDirty = false;
        BlankPanel.setChangeState(this._lAllowChanges, 1);
        this._cbNoMinAge.setSelected(this._saveMinAge <= 0);
        if (this._cbNoMinAge.isSelected()) {
            this._tfMinAge.setText(null);
        } else {
            this._tfMinAge.setText(String.valueOf(this._saveMinAge));
        }
        this._tfMinAge.setEnabled(this._saveMinAge > 0);
        this._isMinAgeValidDirty[0] = true;
        this._isMinAgeValidDirty[1] = false;
        BlankPanel.setChangeState(this._cbKeepHistory, 1);
        this._cbKeepHistory.setSelected(this._saveKeepHistory);
        this._isKeepHistoryDirty = false;
        if (this._saveKeepHistory) {
            this._tfRememberValue.setText(Integer.toString(this._saveRememberValue));
        } else {
            this._tfRememberValue.setText(null);
        }
        BlankPanel.setChangeState(this._lRemember1, 1);
        BlankPanel.setChangeState(this._lRemember2, 1);
        this._tfRememberValue.setEnabled(this._saveKeepHistory);
        this._lRemember1.setEnabled(this._saveKeepHistory);
        this._lRemember2.setEnabled(this._saveKeepHistory);
        this._isRememberValueValidDirty[0] = this._saveKeepHistory;
        this._isRememberValueValidDirty[1] = false;
        this._rbPasswordExpires.setSelected(this._savePasswordExpires);
        this._rbPasswordNeverExpires.setSelected(!this._savePasswordExpires);
        BlankPanel.setChangeState(this._rbPasswordNeverExpires, 1);
        BlankPanel.setChangeState(this._rbPasswordExpires, 1);
        this._isPasswordExpiresDirty = false;
        this._tfPasswordExpiresIn.setText(Integer.toString(this._savePasswordExpiresIn));
        this._isPasswordExpiresInValidDirty[0] = true;
        this._isPasswordExpiresInValidDirty[1] = false;
        BlankPanel.setChangeState(this._lExpiresIn, 1);
        this._tfPasswordExpiresIn.setEnabled(this._savePasswordExpires);
        this._lExpiresIn.setEnabled(this._savePasswordExpires);
        this._tfSendWarning.setText(Integer.toString(this._saveSendWarning));
        this._tfSendWarning.setEnabled(this._savePasswordExpires);
        this._isSendWarningValidDirty[0] = true;
        this._isSendWarningValidDirty[1] = false;
        BlankPanel.setChangeState(this._lSendWarning1, 1);
        BlankPanel.setChangeState(this._lSendWarning2, 1);
        this._tfSendWarning.setEnabled(this._savePasswordExpires);
        this._lSendWarning1.setEnabled(this._savePasswordExpires);
        this._lSendWarning2.setEnabled(this._savePasswordExpires);
        this._isAllowExpireWithoutWarningDirty = false;
        this._cbAllowExpireWithoutWarning.setSelected(this._saveAllowExpireWithoutWarning);
        BlankPanel.setChangeState(this._cbAllowExpireWithoutWarning, 1);
        this._cbAllowExpireWithoutWarning.setEnabled(this._savePasswordExpires);
        this._cbCheckSyntax.setSelected(this._saveCheckSyntax);
        this._isCheckSyntaxDirty = false;
        BlankPanel.setChangeState(this._cbCheckSyntax, 1);
        this._tfMinLength.setText(Integer.toString(this._saveMinLength));
        this._isMinLengthValidDirty[0] = true;
        this._isMinLengthValidDirty[1] = false;
        BlankPanel.setChangeState(this._lMinLength, 1);
        this._tfMinLength.setEnabled(this._saveCheckSyntax);
        this._lMinLength.setEnabled(this._saveCheckSyntax);
        this._cbRootDNBypassModsChecks.setSelected(this._saveRootDNBypassModsChecks);
        this._isRootDNBypassModsChecksDirty = false;
        BlankPanel.setChangeState(this._cbRootDNBypassModsChecks, 1);
        this._comboStorageScheme.setSelectedIndex(this._pwdSchemeNames.indexOf(this._saveStorageScheme));
        this._isStorageSchemeDirty = false;
        BlankPanel.setChangeState(this._lStorageScheme, 1);
        this._isInitializingComponents = false;
    }

    private void checkField(JLabel jLabel, String string, int n, boolean[] blArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = false;
        try {
            int n4 = Integer.parseInt(string);
            bl2 = n4 != n;
            bl = n4 >= n2 && n4 <= n3;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            bl2 = true;
        }
        if (!bl) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (bl2) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        blArray[0] = bl;
        blArray[1] = bl2;
        this.fireValidDirtyChange();
    }

    private void checkSendWarningAndExpiration() {
        if (this._isSendWarningValidDirty[0] && this._isPasswordExpiresInValidDirty[0]) {
            try {
                int n = Integer.parseInt(this._tfSendWarning.getText());
                int n2 = Integer.parseInt(this._tfPasswordExpiresIn.getText());
                boolean bl = this._isSendWarningValidDirty[0] = n2 > n;
                if (!this._isSendWarningValidDirty[0]) {
                    BlankPanel.setChangeState(this._lSendWarning1, 3);
                    this.clearValidFlag();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = !(!this._isMinAgeValidDirty[0] || this._cbKeepHistory.isSelected() && !this._isRememberValueValidDirty[0] || !this._rbPasswordNeverExpires.isSelected() && !this._isPasswordExpiresInValidDirty[0] || !this._rbPasswordNeverExpires.isSelected() && !this._isSendWarningValidDirty[0] || this._cbCheckSyntax.isSelected() && !this._isMinLengthValidDirty[0]);
        boolean bl3 = bl = this._isPasswordMustChangeOnResetDirty || this._isUserMayChangePwdDirty || this._isMinAgeValidDirty[1] || this._isKeepHistoryDirty || this._cbKeepHistory.isSelected() && this._isRememberValueValidDirty[1] || this._isPasswordExpiresDirty || this._rbPasswordExpires.isSelected() && this._isPasswordExpiresInValidDirty[1] || this._rbPasswordExpires.isSelected() && this._isSendWarningValidDirty[1] || this._rbPasswordExpires.isSelected() && this._isAllowExpireWithoutWarningDirty || this._isCheckSyntaxDirty || this._cbCheckSyntax.isSelected() && this._isMinLengthValidDirty[1] || this._isRootDNBypassModsChecksDirty || this._isStorageSchemeDirty;
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }
}

