/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigIndexPanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.ConfigSelectionDialog;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.Index;
import com.netscape.admin.dirserv.config.IndexTableCellRenderer;
import com.netscape.admin.dirserv.config.IndexWarningDialog;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.CheckBoxTableCellRenderer;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;

public class ConfigIndexPanel
extends ConfigBasePanel
implements ActionListener,
ListSelectionListener {
    private Suffix _suffix;
    private Database _database;
    private boolean _isInitializing;
    private boolean _isCancelled;
    private boolean _hasWarningMessage;
    private boolean _dividerSet;
    private JPanel _contentPanel;
    private JButton _bAddIndex;
    private JButton _bDeleteIndex;
    private JTable _tSystemIndexTable;
    private JTable _tEditableIndexTable;
    private JSplitPane _splitPane;
    private JPanel _buttonPanel;
    private Hashtable _htIndexLowerCase;
    private Hashtable _htIndexes;
    private Hashtable _htReadIndexes;
    private List _lOrderedSystemIndexes;
    private List _lReadOrderedSystemIndexes;
    private List _lOrderedEditableIndexes;
    private List _lReadOrderedEditableIndexes;
    private Hashtable _htSave;
    private ArrayList _lModifiedAttributes;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("indexpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("indexpanel-no-rights", "label"), 2, 50);
    private final String[] TABLE_HEADERS = new String[]{ConfigBasePanel._resource.getString("indexpanel", "tableheader0-label"), ConfigBasePanel._resource.getString("indexpanel", "tableheader1-label"), ConfigBasePanel._resource.getString("indexpanel", "tableheader2-label"), ConfigBasePanel._resource.getString("indexpanel", "tableheader3-label"), ConfigBasePanel._resource.getString("indexpanel", "tableheader4-label"), ConfigBasePanel._resource.getString("indexpanel", "tableheader5-label")};
    private final String[] TABLE_HEADERS_TOOLTIPS = new String[]{ConfigBasePanel._resource.getString("indexpanel", "tableheader0-ttip"), ConfigBasePanel._resource.getString("indexpanel", "tableheader1-ttip"), ConfigBasePanel._resource.getString("indexpanel", "tableheader2-ttip"), ConfigBasePanel._resource.getString("indexpanel", "tableheader3-ttip"), ConfigBasePanel._resource.getString("indexpanel", "tableheader4-ttip"), ConfigBasePanel._resource.getString("indexpanel", "tableheader5-ttip")};
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public ConfigIndexPanel(Suffix suffix) {
        this.setTitle(ConfigBasePanel._resource.getString("indexpanel", "title"));
        this._helpToken = "configuration-suffix-indexes-help";
        this._suffix = suffix;
        this._database = (Database)this._suffix.getDatabases().get(0);
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigIndexPanel.this._htIndexes = new Hashtable();
                        ConfigIndexPanel.this._htIndexLowerCase = new Hashtable();
                        ConfigIndexPanel.this._htReadIndexes = new Hashtable();
                        ConfigIndexPanel.this._lOrderedSystemIndexes = new ArrayList();
                        ConfigIndexPanel.this._lReadOrderedSystemIndexes = new ArrayList();
                        ConfigIndexPanel.this._lOrderedEditableIndexes = new ArrayList();
                        ConfigIndexPanel.this._lReadOrderedEditableIndexes = new ArrayList();
                        ConfigIndexPanel.this._htSave = new Hashtable();
                        ConfigIndexPanel.this._lModifiedAttributes = new ArrayList();
                        ConfigIndexPanel.this.createContentPanel();
                        ConfigIndexPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigIndexPanel.access$1200(1.access$1100(this.this$1));
                                1.access$1100(this.this$1).showComponent(ConfigIndexPanel.access$1300(1.access$1100(this.this$1)), false);
                                SwingUtilities.invokeLater(new Runnable(this){
                                    private final /* synthetic */ 2 this$2;
                                    {
                                        this.this$2 = var1_1;
                                    }

                                    public void run() {
                                        ConfigIndexPanel.access$1500(1.access$1100(2.access$1400(this.this$2))).setDividerLocation(0.5);
                                        ConfigIndexPanel.access$1602(1.access$1100(2.access$1400(this.this$2)), true);
                                    }
                                });
                            }

                            static /* synthetic */ 1 access$1400(2 var0) {
                                return var0.this$1;
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$1100(this.this$1).showComponent((JComponent)ConfigIndexPanel.access$1700(1.access$1100(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("indexpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$1100(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigIndexPanel.this._isInitialized = true;
                    ConfigIndexPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigIndexPanel access$1100(1 var0) {
                    return var0.ConfigIndexPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigIndexPanel.this.initComponentsFromServerValues();
                    ConfigIndexPanel.this.fireValidDirtyChange();
                    ConfigIndexPanel.this.showComponent(ConfigIndexPanel.this._contentPanel, false);
                    if (!ConfigIndexPanel.this._dividerSet) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigIndexPanel.access$1500(6.access$2000(this.this$1)).setDividerLocation(0.5);
                                ConfigIndexPanel.access$1602(6.access$2000(this.this$1), true);
                            }
                        });
                    }
                }

                static /* synthetic */ ConfigIndexPanel access$2000(6 var0) {
                    return var0.ConfigIndexPanel.this;
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigIndexPanel.this.showComponent((JComponent)ConfigIndexPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("indexpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigIndexPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        Enumeration enumeration = this._htIndexes.keys();
        this._hasWarningMessage = false;
        this._lModifiedAttributes.clear();
        boolean bl = false;
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        while (enumeration.hasMoreElements() && !this._isCancelled) {
            LDAPAttribute lDAPAttribute;
            Object object;
            String[] stringArray;
            String string = (String)enumeration.nextElement();
            Index index = (Index)this._htIndexes.get(string);
            if (!index.isDirty) continue;
            String string2 = "cn=" + string + ", cn=index, " + this._database.getDn();
            if (index.state == Index.INDEX_TO_DELETE) {
                try {
                    lDAPConnection.delete(string2);
                    bl = true;
                    continue;
                }
                catch (LDAPException lDAPException) {
                    stringArray = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("indexpanel", "deleting-error-title"), ConfigBasePanel._resource.getString("indexpanel", "deleting-error-msg", stringArray));
                }
            }
            if (index.state == Index.INDEX_TO_ADD) {
                object = new LDAPAttributeSet();
                object.add(new LDAPAttribute("objectclass", "nsIndex"));
                object.add(new LDAPAttribute("cn", string));
                object.add(new LDAPAttribute("nsSystemIndex", "false"));
                stringArray = new LDAPAttribute("nsIndexType");
                if (index.isApproximate) {
                    stringArray.addValue("approx");
                }
                if (index.isEquality) {
                    stringArray.addValue("eq");
                }
                if (index.isPresence) {
                    stringArray.addValue("pres");
                }
                if (index.isSubstring) {
                    stringArray.addValue("sub");
                }
                object.add((LDAPAttribute)stringArray);
                if (index.matchingRule.length() > 0) {
                    object.add(new LDAPAttribute("nsMatchingRule", index.matchingRule));
                }
                lDAPAttribute = new LDAPEntry(string2, object);
                try {
                    lDAPConnection.add((LDAPEntry)lDAPAttribute);
                    this._hasWarningMessage = true;
                    this._lModifiedAttributes.add(string);
                    bl = true;
                    continue;
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray2 = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("indexpanel", "adding-error-title"), ConfigBasePanel._resource.getString("indexpanel", "adding-error-msg", stringArray2));
                }
            }
            object = (Index)this._htSave.get(string);
            stringArray = new LDAPModificationSet();
            if (object.isApproximate != index.isApproximate || object.isEquality != index.isEquality || object.isPresence != index.isPresence || object.isSubstring != index.isSubstring) {
                lDAPAttribute = new LDAPAttribute("nsIndexType");
                if (index.isApproximate) {
                    lDAPAttribute.addValue("approx");
                }
                if (index.isEquality) {
                    lDAPAttribute.addValue("eq");
                }
                if (index.isPresence) {
                    lDAPAttribute.addValue("pres");
                }
                if (index.isSubstring) {
                    lDAPAttribute.addValue("sub");
                }
                stringArray.add(2, lDAPAttribute);
            }
            if (!object.matchingRule.equals(index.matchingRule)) {
                stringArray.add(2, new LDAPAttribute("nsMatchingRule", index.matchingRule));
            }
            if (stringArray.size() > 0) {
                try {
                    lDAPConnection.modify(string2, (LDAPModificationSet)stringArray);
                    this._lModifiedAttributes.add(string);
                    this._hasWarningMessage = true;
                    bl = true;
                    continue;
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray3 = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("indexpanel", "modifying-error-title"), ConfigBasePanel._resource.getString("indexpanel", "modifying-error-msg", stringArray3));
                }
            }
            Thread.dumpStack();
        }
        if (!this._isCancelled && bl) {
            this.resetCallback();
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean hasWarningMessage() {
        return this._hasWarningMessage;
    }

    public void displayWarningMessage() {
        String[] stringArray = new String[this._lModifiedAttributes.size()];
        this._lModifiedAttributes.toArray(stringArray);
        IndexWarningDialog indexWarningDialog = new IndexWarningDialog(this._framework, this._suffix, stringArray);
        indexWarningDialog.pack();
        indexWarningDialog.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bAddIndex) {
            this._framework.setBusyCursor(true);
            this.actionAddIndex();
            this._framework.setBusyCursor(false);
        } else if (object == this._bDeleteIndex) {
            this.actionDeleteIndex();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this._bDeleteIndex.setEnabled(this._tEditableIndexTable.getSelectedRowCount() > 0 && this._tEditableIndexTable.getRowCount() > 0);
    }

    private void createContentPanel() {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        this._contentPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = UIFactory.makeJLabel("indexpanel", "ldatabaselocation", ConfigBasePanel._resource);
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        JLabel jLabel2 = new JLabel(this._database.getLocation());
        JLabel jLabel3 = UIFactory.makeJLabel("indexpanel", "ldatabasename", ConfigBasePanel._resource);
        jLabel3.setFont(jLabel3.getFont().deriveFont(0));
        JLabel jLabel4 = new JLabel(this._database.getName());
        this._bAddIndex = UIFactory.makeJButton(this, "indexpanel", "baddindex", ConfigBasePanel._resource);
        this._bDeleteIndex = UIFactory.makeJButton(this, "indexpanel", "bdeleteindex", ConfigBasePanel._resource);
        JLabel jLabel5 = UIFactory.makeJLabel("indexpanel", "lsystemindexes", ConfigBasePanel._resource);
        IndexTableModel indexTableModel = new IndexTableModel(this.TABLE_HEADERS, this._lOrderedSystemIndexes, false);
        this._tSystemIndexTable = new JTable(indexTableModel);
        indexTableModel.setTable(this._tSystemIndexTable);
        jLabel5.setLabelFor(this._tSystemIndexTable);
        this._tSystemIndexTable.setShowGrid(true);
        LabelCellRenderer labelCellRenderer = new LabelCellRenderer();
        this._tSystemIndexTable.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConfigIndexPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean, new CheckBoxTableCellRenderer());
        this._tSystemIndexTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ConfigIndexPanel.class$("java.lang.String")) : class$java$lang$String, labelCellRenderer);
        int n = 0;
        while (n < this.TABLE_HEADERS.length) {
            TableColumn tableColumn = this._tSystemIndexTable.getColumnModel().getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer instanceof JComponent) {
                ((JComponent)((Object)tableCellRenderer)).setToolTipText(this.TABLE_HEADERS_TOOLTIPS[n]);
            }
            ++n;
        }
        this._tSystemIndexTable.setPreferredScrollableViewportSize(new Dimension(10, 10));
        int n2 = 0;
        int n3 = 0;
        Enumeration<TableColumn> enumeration = this._tSystemIndexTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            serializable2 = enumeration.nextElement();
            n3 = (int)((TableColumn)serializable2).getHeaderRenderer().getTableCellRendererComponent(this._tSystemIndexTable, this.TABLE_HEADERS[n2], false, false, 0, n2).getPreferredSize().getWidth();
            ((TableColumn)serializable2).setPreferredWidth(n3);
            ++n2;
        }
        serializable2 = UIFactory.makeJLabel("indexpanel", "leditableindexes", ConfigBasePanel._resource);
        IndexTableModel indexTableModel2 = new IndexTableModel(this.TABLE_HEADERS, this._lOrderedEditableIndexes, true);
        this._tEditableIndexTable = new JTable(indexTableModel2);
        indexTableModel2.setTable(this._tEditableIndexTable);
        ((JLabel)serializable2).setLabelFor(this._tEditableIndexTable);
        this._tEditableIndexTable.getSelectionModel().addListSelectionListener(this);
        this._tEditableIndexTable.setShowGrid(true);
        IndexTableCellRenderer indexTableCellRenderer = new IndexTableCellRenderer(this._htIndexes);
        this._tEditableIndexTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ConfigIndexPanel.class$("java.lang.String")) : class$java$lang$String, indexTableCellRenderer);
        this._tEditableIndexTable.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConfigIndexPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean, indexTableCellRenderer);
        int n4 = 0;
        while (n4 < this.TABLE_HEADERS.length) {
            serializable = this._tEditableIndexTable.getColumnModel().getColumn(n4);
            object = ((TableColumn)serializable).getHeaderRenderer();
            if (object instanceof JComponent) {
                ((JComponent)object).setToolTipText(this.TABLE_HEADERS_TOOLTIPS[n4]);
            }
            ++n4;
        }
        this._tEditableIndexTable.setPreferredScrollableViewportSize(new Dimension(10, 10));
        n2 = 0;
        n3 = 0;
        enumeration = this._tEditableIndexTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            n3 = (int)((TableColumn)serializable).getHeaderRenderer().getTableCellRendererComponent(this._tEditableIndexTable, this.TABLE_HEADERS[n2], false, false, 0, n2).getPreferredSize().getWidth();
            ((TableColumn)serializable).setPreferredWidth(n3);
            ++n2;
        }
        this._bDeleteIndex.setEnabled(this._tEditableIndexTable.getSelectedRowCount() > 0);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        object = new JPanel(new GridBagLayout());
        ((Container)object).add((Component)jLabel5, serializable);
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).insets.bottom = UIFactory.getDifferentSpace();
        JScrollPane jScrollPane = new JScrollPane(this._tSystemIndexTable);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        ((Container)object).add((Component)jScrollPane, serializable);
        JPanel jPanel = new JPanel(new GridBagLayout());
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).insets.bottom = 0;
        ((GridBagConstraints)serializable).insets.top = UIFactory.getDifferentSpace();
        jPanel.add((Component)serializable2, serializable);
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).insets.top = 0;
        JScrollPane jScrollPane2 = new JScrollPane(this._tEditableIndexTable);
        jScrollPane2.setBorder(UITools.createLoweredBorder());
        jPanel.add((Component)jScrollPane2, serializable);
        this._splitPane = new JSplitPane(0, (Component)object, jPanel);
        this._splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, UIFactory.getComponentSpace());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ((GridBagConstraints)serializable).gridwidth = -1;
        jPanel2.add((Component)jLabel3, serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets.right = 0;
        jPanel2.add((Component)jLabel4, serializable);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        ((GridBagConstraints)serializable).insets.right = UIFactory.getComponentSpace();
        ((GridBagConstraints)serializable).gridwidth = -1;
        jPanel3.add((Component)jLabel, serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).insets.right = 0;
        jPanel3.add((Component)jLabel2, serializable);
        ((GridBagConstraints)serializable).insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        ((GridBagConstraints)serializable).fill = 0;
        this._contentPanel.add((Component)jPanel2, serializable);
        ((GridBagConstraints)serializable).insets.top = 0;
        ((GridBagConstraints)serializable).insets.bottom = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)jPanel3, serializable);
        ((GridBagConstraints)serializable).insets.top = UIFactory.getComponentSpace();
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).weighty = 1.0;
        this._contentPanel.add((Component)this._splitPane, serializable);
        ((GridBagConstraints)serializable).insets.top = 0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        JButton[] jButtonArray = new JButton[]{this._bAddIndex, this._bDeleteIndex};
        this._buttonPanel = UIFactory.makeJButtonPanel(jButtonArray);
        this._contentPanel.add((Component)this._buttonPanel, serializable);
    }

    private void readDataFromServer() throws LDAPException {
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        this._htReadIndexes.clear();
        this._lReadOrderedSystemIndexes.clear();
        this._lReadOrderedEditableIndexes.clear();
        this._htSave.clear();
        String[] stringArray = new String[]{"cn", "nsIndexType", "nsSystemIndex", "nsMatchingRule"};
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=index, " + this._database.getDn(), 1, "objectclass=nsIndex", stringArray, false);
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            String string = this.getValue(lDAPEntry, "cn");
            Index index = new Index();
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsIndexType");
            if (lDAPAttribute != null) {
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (string2.equalsIgnoreCase("approx")) {
                        index.isApproximate = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("eq")) {
                        index.isEquality = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("pres")) {
                        index.isPresence = true;
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("sub")) continue;
                    index.isSubstring = true;
                }
            }
            index.matchingRule = DSUtil.getAttrValue(lDAPEntry, "nsMatchingRule");
            index.isSystemIndex = this.getValue(lDAPEntry, "nsSystemIndex").equalsIgnoreCase("true");
            index.state = Index.EXISTING_INDEX;
            index.isDirty = false;
            index.isValid = true;
            this._htReadIndexes.put(string, index);
            this._htSave.put(string, index.clone());
            if (index.isSystemIndex) {
                DSUtil.insertAlphabetically(this._lReadOrderedSystemIndexes, string);
                continue;
            }
            DSUtil.insertAlphabetically(this._lReadOrderedEditableIndexes, string);
        }
    }

    private void initComponentsFromServerValues() {
        this._htIndexes.clear();
        this._htIndexLowerCase.clear();
        Enumeration enumeration = this._htReadIndexes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this._htIndexes.put(string, this._htReadIndexes.get(string));
            this._htIndexLowerCase.put(string.toLowerCase(), string);
        }
        this._lOrderedSystemIndexes.clear();
        this._lOrderedSystemIndexes.addAll(this._lReadOrderedSystemIndexes);
        this._lOrderedEditableIndexes.clear();
        this._lOrderedEditableIndexes.addAll(this._lReadOrderedEditableIndexes);
    }

    private void actionAddIndex() {
        Object object;
        Object[] objectArray;
        Object object2;
        ArrayList arrayList = new ArrayList();
        LDAPSchema lDAPSchema = DSUtil.getSchema(this.getServerInfo());
        Enumeration enumeration = lDAPSchema.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            objectArray = ((String)object2).toLowerCase();
            Object v = this._htIndexLowerCase.get(objectArray);
            if (v == null) {
                DSUtil.insertAlphabetically(arrayList, (String)object2);
                continue;
            }
            object = (Index)this._htIndexes.get(v);
            if (object == null) {
                DSUtil.insertAlphabetically(arrayList, (String)object2);
                continue;
            }
            if (((Index)object).state != Index.INDEX_TO_DELETE) continue;
            DSUtil.insertAlphabetically(arrayList, (String)object2);
        }
        object2 = new ConfigSelectionDialog((JFrame)((Object)this._framework), ConfigBasePanel._resource.getString("indexpanel", "addindex-dlg-title"), arrayList);
        ((ConfigSelectionDialog)object2).packAndShow();
        if (!((ConfigSelectionDialog)object2).isCancelled()) {
            objectArray = ((ConfigSelectionDialog)object2).getSelectedAttributes();
            int n = 0;
            while (n < objectArray.length) {
                object = (String)objectArray[n];
                Index index = (Index)this._htIndexes.get(object);
                if (index != null) {
                    index.state = Index.EXISTING_INDEX;
                    Index index2 = (Index)this._htSave.get(object);
                    index.isDirty = index.isApproximate != index2.isApproximate || index.isEquality != index2.isEquality || index.isPresence != index2.isPresence || index.isSubstring != index2.isSubstring || !index.matchingRule.equals(index2.matchingRule);
                    DSUtil.insertAlphabetically(this._lOrderedEditableIndexes, (String)object);
                } else {
                    index = new Index();
                    index.isEquality = true;
                    index.isPresence = true;
                    index.matchingRule = "";
                    index.isSystemIndex = false;
                    index.isDirty = true;
                    index.isValid = true;
                    index.state = Index.INDEX_TO_ADD;
                    this._htIndexes.put(object, index);
                    this._htIndexLowerCase.put(((String)object).toLowerCase(), object);
                    DSUtil.insertAlphabetically(this._lOrderedEditableIndexes, (String)object);
                }
                ++n;
            }
            this._tEditableIndexTable.revalidate();
            this._tEditableIndexTable.repaint();
            this.fireValidDirtyChange();
        }
    }

    private void actionDeleteIndex() {
        int[] nArray = this._tEditableIndexTable.getSelectedRows();
        int n = nArray.length - 1;
        while (n >= 0) {
            String string = (String)this._lOrderedEditableIndexes.get(nArray[n]);
            this._lOrderedEditableIndexes.remove(nArray[n]);
            Index index = (Index)this._htIndexes.get(string);
            if (index.state == Index.INDEX_TO_ADD) {
                this._htIndexes.remove(string);
                this._htIndexLowerCase.remove(string.toLowerCase());
            } else {
                index.state = Index.INDEX_TO_DELETE;
                index.isDirty = true;
            }
            --n;
        }
        this._tEditableIndexTable.revalidate();
        this._tEditableIndexTable.repaint();
        this.fireValidDirtyChange();
    }

    private void fireValidDirtyChange() {
        Iterator iterator = this._htIndexes.values().iterator();
        boolean bl = false;
        boolean bl2 = true;
        while (iterator.hasNext() && (bl2 || !bl)) {
            Index index = (Index)iterator.next();
            bl = bl || index.isDirty;
            boolean bl3 = bl2 = bl2 && (index.isValid || index.state == Index.INDEX_TO_DELETE);
        }
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    static /* synthetic */ JSplitPane access$1500(ConfigIndexPanel configIndexPanel) {
        return configIndexPanel._splitPane;
    }

    static /* synthetic */ boolean access$1602(ConfigIndexPanel configIndexPanel, boolean bl) {
        configIndexPanel._dividerSet = bl;
        return configIndexPanel._dividerSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class IndexTableModel
    extends AbstractTableModel {
        private String[] _tableHeaders;
        private List _lIndexNames;
        private boolean _isEditable;
        private JTable _table;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$lang$Boolean;

        public IndexTableModel(String[] stringArray, List list, boolean bl) {
            this._tableHeaders = stringArray;
            this._lIndexNames = list;
            this._isEditable = bl;
        }

        public void setTable(JTable jTable) {
            this._table = jTable;
        }

        public int getColumnCount() {
            return this._tableHeaders.length;
        }

        public int getRowCount() {
            return this._lIndexNames.size();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 && this._isEditable;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = this._lIndexNames.get(n);
            } else {
                Index index = (Index)ConfigIndexPanel.this._htIndexes.get(this._lIndexNames.get(n));
                switch (n2) {
                    case 1: {
                        object = index.isApproximate ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 2: {
                        object = index.isEquality ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 3: {
                        object = index.isPresence ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 4: {
                        object = index.isSubstring ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 5: {
                        object = index.matchingRule;
                        break;
                    }
                    default: {
                        Thread.dumpStack();
                    }
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)this._lIndexNames.get(n);
            Index index = (Index)ConfigIndexPanel.this._htIndexes.get(string);
            if (n2 > 0 && n2 < 5) {
                boolean bl = (Boolean)object;
                switch (n2) {
                    case 1: {
                        index.isApproximate = bl;
                        break;
                    }
                    case 2: {
                        index.isEquality = bl;
                        break;
                    }
                    case 3: {
                        index.isPresence = bl;
                        break;
                    }
                    case 4: {
                        index.isSubstring = bl;
                        break;
                    }
                    default: {
                        Thread.dumpStack();
                        break;
                    }
                }
            } else if (n2 == 5) {
                index.matchingRule = (String)object;
            } else {
                Thread.dumpStack();
            }
            boolean bl = index.isValid = index.isApproximate || index.isEquality || index.isPresence || index.isSubstring;
            if (index.state != Index.INDEX_TO_ADD) {
                Index index2 = (Index)ConfigIndexPanel.this._htSave.get(string);
                index.isDirty = index.isApproximate != index2.isApproximate || index.isEquality != index2.isEquality || index.isPresence != index2.isPresence || index.isSubstring != index2.isSubstring || !index.matchingRule.equals(index2.matchingRule);
            }
            this._table.repaint(this._table.getCellRect(n, 0, true));
            ConfigIndexPanel.this.fireValidDirtyChange();
        }

        public String getColumnName(int n) {
            return this._tableHeaders[n];
        }

        public Class getColumnClass(int n) {
            Class clazz = null;
            if (n == 0) {
                clazz = class$java$lang$String == null ? (class$java$lang$String = IndexTableModel.class$("java.lang.String")) : class$java$lang$String;
            } else if (n > 0 && n < 5) {
                clazz = class$java$lang$Boolean == null ? (class$java$lang$Boolean = IndexTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            } else if (n == 5) {
                clazz = class$java$lang$String == null ? (class$java$lang$String = IndexTableModel.class$("java.lang.String")) : class$java$lang$String;
            } else {
                Thread.dumpStack();
            }
            return clazz;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

