/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.replication.PartialReplicationRuleManager;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.util.DN;

public class ConfigGlobalReplicationPanel
extends ConfigBasePanel
implements ActionListener,
DocumentListener {
    private boolean _isInitializing;
    private boolean _isInitializingComponents;
    private boolean _isLocal;
    private String _defaultLocation;
    private JPanel _contentPanel;
    private JLabel _lLocation;
    private JLabel _lMaxRecords;
    private JLabel _lMaxAge;
    private JLabel _l4xDn;
    private JLabel _l4xPwd;
    private JLabel _l4xConfirmPwd;
    private JLabel _lManagerPwd;
    private JLabel _lManagerConfirmPwd;
    private JTextField _tfLocation;
    private JTextField _tfMaxRecords;
    private JTextField _tfMaxAge;
    private JTextField _tf4xDn;
    private JPasswordField _pf4xPwd;
    private JPasswordField _pfConfirm4xPwd;
    private JPasswordField _pfManagerPwd;
    private JPasswordField _pfManagerConfirmPwd;
    private JButton _bBrowse;
    private JCheckBox _cbEnableChangelog;
    private JCheckBox _cbMaxRecordsUnlimited;
    private JCheckBox _cbMaxAgeUnlimited;
    private JCheckBox _cb4xCompatibility;
    private JComboBox _comboMaxAge;
    private JButton _bManageSets;
    private boolean[] _isManagerPwdValidDirty = new boolean[]{true, false};
    private boolean _isEnableChangelogDirty;
    private boolean[] _isLocationValidDirty = new boolean[]{true, false};
    private boolean[] _isMaxRecordsValidDirty = new boolean[]{true, false};
    private boolean[] _isMaxAgeValidDirty = new boolean[]{true, false};
    private boolean _is4xCompatibilityDirty;
    private boolean[] _is4xDnValidDirty = new boolean[]{true, false};
    private boolean[] _is4xPwdValidDirty = new boolean[]{true, false};
    private String _saveManagerPwd;
    private boolean _saveEnableChangelog;
    private String _saveLocation;
    private int _saveMaxRecords;
    private int _saveMaxAge;
    private int _saveMaxAgeUnit;
    private boolean _save4xCompatibility;
    private String _save4xDn;
    private String _save4xPwd;
    private JLabel _lPwdOptional;
    private boolean _hasWarningMessage;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("globalreplicationpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("globalreplicationpanel-no-rights", "label"), 2, 50);
    private int SECONDS = 0;
    private int MINUTES = 1;
    private int HOURS = 2;
    private int DAYS = 3;
    private final Object[] UNIT_LABELS = new Object[]{ConfigBasePanel._resource.getString("globalreplicationpanel", "seconds-unit"), ConfigBasePanel._resource.getString("globalreplicationpanel", "minutes-unit"), ConfigBasePanel._resource.getString("globalreplicationpanel", "hours-unit"), ConfigBasePanel._resource.getString("globalreplicationpanel", "days-unit")};
    private final int[] UNIT_ADAPTER = new int[]{1, 60, 3600, 86400};
    private final char[] UNIT_TAGS = new char[]{'s', 'm', 'h', 'd'};

    public ConfigGlobalReplicationPanel() {
        this.setTitle(ConfigBasePanel._resource.getString("globalreplicationpanel", "title"));
        this._helpToken = "configuration-data-replication-globalsettings-help";
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigGlobalReplicationPanel.this._isLocal = DSUtil.isLocal(ConfigGlobalReplicationPanel.this._framework.getServerObject().getServerInfo().getHost());
                        String string = (String)ConfigGlobalReplicationPanel.this.getServerInfo().get("InstallPath");
                        String string2 = (String)ConfigGlobalReplicationPanel.this.getServerInfo().get("ServerInstance");
                        ConfigGlobalReplicationPanel.this._defaultLocation = string + '/' + string2 + "/changelogdb";
                        ConfigGlobalReplicationPanel.this.createContentPanel();
                        ConfigGlobalReplicationPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigGlobalReplicationPanel.access$500(1.access$400(this.this$1));
                                1.access$400(this.this$1).showComponent(ConfigGlobalReplicationPanel.access$600(1.access$400(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$400(this.this$1).showComponent((JComponent)ConfigGlobalReplicationPanel.access$700(1.access$400(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("globalreplicationpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$400(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigGlobalReplicationPanel.this._isInitialized = true;
                    ConfigGlobalReplicationPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigGlobalReplicationPanel access$400(1 var0) {
                    return var0.ConfigGlobalReplicationPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigGlobalReplicationPanel.this.initComponentsFromServerValues();
                    ConfigGlobalReplicationPanel.this.fireValidDirtyChange();
                    ConfigGlobalReplicationPanel.this.showComponent(ConfigGlobalReplicationPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigGlobalReplicationPanel.this.showComponent((JComponent)ConfigGlobalReplicationPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("globalreplicationpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigGlobalReplicationPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void cancelCallback() {
    }

    public void okCallback() throws ConfigPanelException {
        Object object;
        String string;
        boolean bl = false;
        this._hasWarningMessage = false;
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        if (this._isManagerPwdValidDirty[1]) {
            string = String.valueOf(this._pfManagerPwd.getPassword());
            object = string.equals("") ? new LDAPModification(1, new LDAPAttribute("userPassword")) : new LDAPModification(2, new LDAPAttribute("userPassword", string));
            try {
                lDAPConnection.modify("cn=replication manager, cn=replication, cn=config", (LDAPModification)object);
                bl = true;
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("globalreplicationpanel", "updating-replication-manager-error-title"), ConfigBasePanel._resource.getString("globalreplicationpanel", "updating-replication-manager-error-msg", stringArray));
            }
        }
        if (this._isEnableChangelogDirty) {
            if (this._cbEnableChangelog.isSelected()) {
                string = new LDAPAttributeSet();
                string.add(new LDAPAttribute("objectclass", "extensibleObject"));
                string.add(new LDAPAttribute("cn", "changelog5"));
                string.add(new LDAPAttribute("nsslapd-changelogdir", this._tfLocation.getText()));
                if (!this._tfLocation.getText().equals(this._defaultLocation)) {
                    this._hasWarningMessage = true;
                }
                if (!this._cbMaxRecordsUnlimited.isSelected()) {
                    string.add(new LDAPAttribute("nsslapd-changelogmaxentries", this._tfMaxRecords.getText()));
                }
                if (!this._cbMaxAgeUnlimited.isSelected()) {
                    object = this._tfMaxAge.getText().trim() + this.UNIT_TAGS[this._comboMaxAge.getSelectedIndex()];
                    string.add(new LDAPAttribute("nsslapd-changelogmaxage", (String)object));
                }
                try {
                    lDAPConnection.add(new LDAPEntry("cn=changelog5, cn=config", (LDAPAttributeSet)string));
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("globalreplicationpanel", "enabling-changelog-error-title"), ConfigBasePanel._resource.getString("globalreplicationpanel", "enabling-changelog-error-msg", stringArray));
                }
            } else {
                try {
                    lDAPConnection.delete("cn=changelog5, cn=config");
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    object = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("globalreplicationpanel", "disabling-changelog-error-title"), ConfigBasePanel._resource.getString("globalreplicationpanel", "disabling-changelog-error-msg", object));
                }
            }
        } else {
            string = new LDAPModificationSet();
            if (this._isLocationValidDirty[1]) {
                string.add(2, new LDAPAttribute("nsslapd-changelogdir", this._tfLocation.getText()));
                if (!this._tfLocation.getText().equals(this._defaultLocation)) {
                    this._hasWarningMessage = true;
                }
            }
            if (this._isMaxRecordsValidDirty[1]) {
                if (!this._cbMaxRecordsUnlimited.isSelected()) {
                    string.add(2, new LDAPAttribute("nsslapd-changelogmaxentries", this._tfMaxRecords.getText()));
                } else {
                    string.add(2, new LDAPAttribute("nsslapd-changelogmaxentries", "0"));
                }
            }
            if (this._isMaxAgeValidDirty[1]) {
                if (!this._cbMaxAgeUnlimited.isSelected()) {
                    object = this._tfMaxAge.getText().trim() + this.UNIT_TAGS[this._comboMaxAge.getSelectedIndex()];
                    string.add(2, new LDAPAttribute("nsslapd-changelogmaxage", (String)object));
                } else {
                    string.add(2, new LDAPAttribute("nsslapd-changelogmaxage", "0"));
                }
            }
            if (string.size() > 0) {
                try {
                    lDAPConnection.modify("cn=changelog5, cn=config", (LDAPModificationSet)string);
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("globalreplicationpanel", "modifying-changelog-error-title"), ConfigBasePanel._resource.getString("globalreplicationpanel", "modifying-changelog-error-msg", stringArray));
                }
            }
        }
        if (this._is4xCompatibilityDirty) {
            if (this._cb4xCompatibility.isSelected()) {
                string = new LDAPAttributeSet();
                string.add(new LDAPAttribute("objectclass", "extensibleObject"));
                string.add(new LDAPAttribute("nsslapd-legacy-updatedn", this._tf4xDn.getText()));
                if (this._pf4xPwd.getPassword().length > 0) {
                    string.add(new LDAPAttribute("nsslapd-legacy-updatepw", String.valueOf(this._pf4xPwd.getPassword())));
                }
                try {
                    lDAPConnection.add(new LDAPEntry("cn=legacy consumer,cn=replication,cn=config", (LDAPAttributeSet)string));
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("globalreplicationpanel", "enabling-legacy-error-title"), ConfigBasePanel._resource.getString("globalreplicationpanel", "enabling-legacy-error-msg", stringArray));
                }
            } else {
                try {
                    lDAPConnection.delete("cn=legacy consumer,cn=replication, cn=config");
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    object = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("globalreplicationpanel", "disabling-legacy-error-title"), ConfigBasePanel._resource.getString("globalreplicationpanel", "disabling-legacy-error-msg", object));
                }
            }
        } else {
            string = new LDAPModificationSet();
            if (this._is4xDnValidDirty[1]) {
                string.add(2, new LDAPAttribute("nsslapd-legacy-updatedn", this._tf4xDn.getText()));
            }
            if (this._is4xPwdValidDirty[1]) {
                string.add(2, new LDAPAttribute("nsslapd-legacy-updatepw", String.valueOf(this._pf4xPwd.getPassword())));
            }
            if (string.size() > 0) {
                try {
                    lDAPConnection.modify("cn=legacy consumer,cn=replication, cn=config", (LDAPModificationSet)string);
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("globalreplicationpanel", "modifying-legacy-error-title"), ConfigBasePanel._resource.getString("globalreplicationpanel", "modifying-legacy-error-msg", stringArray));
                }
            }
        }
        if (bl) {
            this.resetCallback();
        }
    }

    public boolean hasWarningMessage() {
        return this._hasWarningMessage;
    }

    public void displayWarningMessage() {
        DSUtil.showInformationDialog(this, "warning-changeloglocation", null, "globalreplicationpanel", ConfigBasePanel._resource);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbEnableChangelog) {
            boolean bl = this._cbEnableChangelog.isSelected();
            this._lLocation.setEnabled(bl);
            this._tfLocation.setEnabled(bl);
            this._bBrowse.setEnabled(bl && this._isLocal);
            this._lMaxRecords.setEnabled(bl);
            this._tfMaxRecords.setEnabled(bl && !this._cbMaxRecordsUnlimited.isSelected());
            this._lMaxAge.setEnabled(bl);
            this._tfMaxAge.setEnabled(bl && !this._cbMaxAgeUnlimited.isSelected());
            this._cbMaxRecordsUnlimited.setEnabled(bl);
            this._cbMaxAgeUnlimited.setEnabled(bl);
            this._comboMaxAge.setEnabled(bl && !this._cbMaxAgeUnlimited.isSelected());
            this._isEnableChangelogDirty = this._saveEnableChangelog != this._cbEnableChangelog.isSelected();
            this.updateColoring(this._cbEnableChangelog, true, this._isEnableChangelogDirty);
            this.fireValidDirtyChange();
        } else if (object == this._bBrowse) {
            String string;
            String string2 = this._tfLocation.getText().trim();
            if (string2.length() == 0) {
                if (DSFileDialog.getDefaultDirectory() == null) {
                    DSFileDialog.setDefaultDirectory(this._defaultLocation);
                }
            } else {
                DSFileDialog.setDefaultDirectory(string2);
            }
            if ((string = DSFileDialog.browseDirectories(true, this._bBrowse)) != null) {
                this._tfLocation.setText(string);
            }
        } else if (object == this._cbMaxRecordsUnlimited) {
            if (this._cbMaxRecordsUnlimited.isSelected()) {
                this._isMaxRecordsValidDirty[0] = true;
                this._isMaxRecordsValidDirty[1] = 0 != this._saveMaxRecords;
            } else {
                try {
                    int n = Integer.parseInt(this._tfMaxRecords.getText());
                    this._isMaxRecordsValidDirty[0] = n > 0;
                    this._isMaxRecordsValidDirty[1] = n != this._saveMaxRecords;
                }
                catch (NumberFormatException numberFormatException) {
                    this._isMaxRecordsValidDirty[0] = false;
                    this._isMaxRecordsValidDirty[1] = true;
                }
            }
            this._tfMaxRecords.setEnabled(!this._cbMaxRecordsUnlimited.isSelected());
            this.updateColoring(this._lMaxRecords, this._isMaxRecordsValidDirty[0], this._isMaxRecordsValidDirty[1]);
            this.fireValidDirtyChange();
        } else if (object == this._cbMaxAgeUnlimited) {
            if (this._cbMaxAgeUnlimited.isSelected()) {
                this._isMaxAgeValidDirty[0] = true;
                this._isMaxAgeValidDirty[1] = 0 != this._saveMaxAge;
            } else {
                try {
                    int n = this._comboMaxAge.getSelectedIndex();
                    int n2 = Integer.parseInt(this._tfMaxAge.getText());
                    this._isMaxAgeValidDirty[0] = n2 > 0;
                    this._isMaxAgeValidDirty[1] = n2 != this._saveMaxAge || n != this._saveMaxAgeUnit;
                }
                catch (NumberFormatException numberFormatException) {
                    this._isMaxAgeValidDirty[0] = false;
                    this._isMaxAgeValidDirty[1] = true;
                }
            }
            this._tfMaxAge.setEnabled(!this._cbMaxAgeUnlimited.isSelected());
            this._comboMaxAge.setEnabled(!this._cbMaxAgeUnlimited.isSelected());
            this.updateColoring(this._lMaxAge, this._isMaxAgeValidDirty[0], this._isMaxAgeValidDirty[1]);
            this.fireValidDirtyChange();
        } else if (object == this._comboMaxAge && !this._isInitializingComponents) {
            try {
                int n = this._comboMaxAge.getSelectedIndex();
                int n3 = Integer.parseInt(this._tfMaxAge.getText());
                this._isMaxAgeValidDirty[0] = n3 > 0;
                this._isMaxAgeValidDirty[1] = n3 != this._saveMaxAge || n != this._saveMaxAgeUnit;
            }
            catch (NumberFormatException numberFormatException) {
                this._isMaxAgeValidDirty[0] = false;
                this._isMaxAgeValidDirty[1] = true;
            }
            this.updateColoring(this._lMaxAge, this._isMaxAgeValidDirty[0], this._isMaxAgeValidDirty[1]);
            this.fireValidDirtyChange();
        } else if (object == this._cb4xCompatibility) {
            boolean bl = this._cb4xCompatibility.isSelected();
            this._l4xDn.setEnabled(bl);
            this._tf4xDn.setEnabled(bl);
            this._l4xPwd.setEnabled(bl);
            this._pf4xPwd.setEnabled(bl);
            this._l4xConfirmPwd.setEnabled(bl);
            this._pfConfirm4xPwd.setEnabled(bl);
            this._lPwdOptional.setEnabled(bl);
            this._pf4xPwd.setBackground(this._tf4xDn.getBackground());
            this._pfConfirm4xPwd.setBackground(this._tf4xDn.getBackground());
            this._is4xCompatibilityDirty = this._save4xCompatibility != this._cb4xCompatibility.isSelected();
            this.updateColoring(this._cb4xCompatibility, true, this._is4xCompatibilityDirty);
            this.fireValidDirtyChange();
        } else if (object == this._bManageSets) {
            PartialReplicationRuleManager partialReplicationRuleManager = new PartialReplicationRuleManager(this._framework);
            partialReplicationRuleManager.pack();
            partialReplicationRuleManager.show();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._isInitializingComponents) {
            Document document = documentEvent.getDocument();
            if (document == this._pfManagerPwd.getDocument() || document == this._pfManagerConfirmPwd.getDocument()) {
                String string = String.valueOf(this._pfManagerPwd.getPassword());
                String string2 = String.valueOf(this._pfManagerConfirmPwd.getPassword());
                this._isManagerPwdValidDirty[0] = string.equals(string2);
                this._isManagerPwdValidDirty[1] = !this._saveManagerPwd.equals(string);
                this.updateColoring(this._lManagerPwd, this._isManagerPwdValidDirty[0], this._isManagerPwdValidDirty[1]);
                this.updateColoring(this._lManagerConfirmPwd, this._isManagerPwdValidDirty[0], this._isManagerPwdValidDirty[1]);
                this.fireValidDirtyChange();
            } else if (document == this._tfLocation.getDocument()) {
                String string = this._tfLocation.getText();
                boolean bl = this._isLocationValidDirty[0] = !string.equals("");
                if (this._isLocal && this._isLocationValidDirty[0]) {
                    File file = new File(this._tfLocation.getText());
                    this._isLocationValidDirty[0] = file.isAbsolute();
                }
                this._isLocationValidDirty[1] = !this._saveLocation.equals(string);
                this.updateColoring(this._lLocation, this._isLocationValidDirty[0], this._isLocationValidDirty[1]);
                this.fireValidDirtyChange();
            } else if (document == this._tfMaxRecords.getDocument()) {
                try {
                    int n = Integer.parseInt(this._tfMaxRecords.getText());
                    this._isMaxRecordsValidDirty[0] = n > 0;
                    this._isMaxRecordsValidDirty[1] = n != this._saveMaxRecords;
                }
                catch (NumberFormatException numberFormatException) {
                    this._isMaxRecordsValidDirty[0] = false;
                    this._isMaxRecordsValidDirty[1] = true;
                }
                this.updateColoring(this._lMaxRecords, this._isMaxRecordsValidDirty[0], this._isMaxRecordsValidDirty[1]);
                this.fireValidDirtyChange();
            } else if (document == this._tfMaxAge.getDocument()) {
                try {
                    int n = this._comboMaxAge.getSelectedIndex();
                    int n2 = Integer.parseInt(this._tfMaxAge.getText());
                    this._isMaxAgeValidDirty[0] = n2 > 0;
                    this._isMaxAgeValidDirty[1] = n2 != this._saveMaxAge || n != this._saveMaxAgeUnit;
                }
                catch (NumberFormatException numberFormatException) {
                    this._isMaxAgeValidDirty[0] = false;
                    this._isMaxAgeValidDirty[1] = true;
                }
                this.updateColoring(this._lMaxAge, this._isMaxAgeValidDirty[0], this._isMaxAgeValidDirty[1]);
                this.fireValidDirtyChange();
            } else if (document == this._tf4xDn.getDocument()) {
                String string = this._tf4xDn.getText();
                this._is4xDnValidDirty[0] = DN.isDN((String)string) && string.trim().length() > 0;
                this._is4xDnValidDirty[1] = !string.equals(this._save4xDn);
                this.updateColoring(this._l4xDn, this._is4xDnValidDirty[0], this._is4xDnValidDirty[1]);
                this.fireValidDirtyChange();
            } else if (document == this._pf4xPwd.getDocument() || document == this._pfConfirm4xPwd.getDocument()) {
                String string = String.valueOf(this._pf4xPwd.getPassword());
                String string3 = String.valueOf(this._pfConfirm4xPwd.getPassword());
                this._is4xPwdValidDirty[0] = string.equals(string3);
                this._is4xPwdValidDirty[1] = !this._save4xPwd.equals(string);
                this.updateColoring(this._l4xPwd, this._is4xPwdValidDirty[0], this._is4xPwdValidDirty[1]);
                this.updateColoring(this._l4xConfirmPwd, this._is4xPwdValidDirty[0], this._is4xPwdValidDirty[1]);
                this.fireValidDirtyChange();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    private void readDataFromServer() throws LDAPException, NullPointerException {
        Object object;
        String[] stringArray;
        block20: {
            LDAPEntry lDAPEntry;
            String[] stringArray2;
            LDAPConnection lDAPConnection;
            block19: {
                lDAPConnection = this.getServerInfo().getLDAPConnection();
                String[] stringArray3 = new String[]{"userpassword"};
                LDAPEntry lDAPEntry2 = lDAPConnection.read("cn=replication manager, cn=replication, cn=config", stringArray3);
                this._saveManagerPwd = DSUtil.getAttrValue(lDAPEntry2, stringArray3[0]);
                stringArray2 = new String[]{"nsslapd-changelogdir", "nsslapd-changelogmaxentries", "nsslapd-changelogmaxage"};
                lDAPEntry = null;
                try {
                    lDAPEntry = lDAPConnection.read("cn=changelog5, cn=config", stringArray2);
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 32) break block19;
                    throw lDAPException;
                }
            }
            boolean bl = this._saveEnableChangelog = lDAPEntry != null;
            if (this._saveEnableChangelog) {
                this._saveLocation = DSUtil.getAttrValue(lDAPEntry, stringArray2[0]);
                stringArray = DSUtil.getAttrValue(lDAPEntry, stringArray2[1]).trim();
                if (stringArray.equals("")) {
                    this._saveMaxRecords = 0;
                } else {
                    try {
                        this._saveMaxRecords = Integer.parseInt((String)stringArray);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this._saveMaxRecords = 0;
                    }
                }
                object = DSUtil.getAttrValue(lDAPEntry, stringArray2[2]).trim();
                if (((String)object).equals("")) {
                    this._saveMaxAgeUnit = this.DAYS;
                    this._saveMaxAge = 0;
                } else {
                    this._saveMaxAgeUnit = this.DAYS;
                    char c = ((String)object).charAt(((String)object).length() - 1);
                    boolean bl2 = false;
                    int n = 0;
                    while (n < this.UNIT_TAGS.length && !bl2) {
                        if (c == this.UNIT_TAGS[n]) {
                            this._saveMaxAgeUnit = n;
                            bl2 = true;
                        }
                        ++n;
                    }
                    if (bl2) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    try {
                        this._saveMaxAge = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this._saveMaxAge = 0;
                    }
                }
            } else {
                this._saveLocation = "";
                this._saveMaxRecords = 0;
                this._saveMaxAge = 0;
            }
            stringArray = new String[]{"nsslapd-legacy-updatedn", "nsslapd-legacy-updatepw"};
            object = null;
            try {
                object = lDAPConnection.read("cn=legacy consumer,cn=replication,cn=config", stringArray);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block20;
                throw lDAPException;
            }
        }
        boolean bl = this._save4xCompatibility = object != null;
        if (this._save4xCompatibility) {
            this._save4xDn = DSUtil.getAttrValue((LDAPEntry)object, stringArray[0]);
            this._save4xPwd = DSUtil.getAttrValue((LDAPEntry)object, stringArray[1]);
        } else {
            this._save4xDn = "";
            this._save4xPwd = "";
        }
    }

    private void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        BlankPanel.setChangeState(this._lManagerPwd, 1);
        BlankPanel.setChangeState(this._lManagerConfirmPwd, 1);
        ((JTextComponent)this._pfManagerPwd).setText(this._saveManagerPwd);
        ((JTextComponent)this._pfManagerConfirmPwd).setText(this._saveManagerPwd);
        this._isManagerPwdValidDirty[0] = true;
        this._isManagerPwdValidDirty[1] = false;
        BlankPanel.setChangeState(this._cbEnableChangelog, 1);
        this._cbEnableChangelog.setSelected(this._saveEnableChangelog);
        this._isEnableChangelogDirty = false;
        BlankPanel.setChangeState(this._lLocation, 1);
        this._isLocationValidDirty[0] = true;
        this._isLocationValidDirty[1] = false;
        if (this._saveEnableChangelog) {
            this._tfLocation.setText(this._saveLocation);
        } else {
            this._tfLocation.setText(this._defaultLocation);
        }
        this._lLocation.setEnabled(this._saveEnableChangelog);
        this._tfLocation.setEnabled(this._saveEnableChangelog);
        this._bBrowse.setEnabled(this._saveEnableChangelog && this._isLocal);
        BlankPanel.setChangeState(this._lMaxRecords, 1);
        this._isMaxRecordsValidDirty[0] = true;
        this._isMaxRecordsValidDirty[1] = false;
        if (this._saveMaxRecords != 0) {
            this._tfMaxRecords.setText(String.valueOf(this._saveMaxRecords));
            this._cbMaxRecordsUnlimited.setSelected(false);
        } else {
            this._tfMaxRecords.setText("");
            this._cbMaxRecordsUnlimited.setSelected(true);
        }
        this._lMaxRecords.setEnabled(this._saveEnableChangelog);
        this._tfMaxRecords.setEnabled(this._saveEnableChangelog && !this._cbMaxRecordsUnlimited.isSelected());
        this._cbMaxRecordsUnlimited.setEnabled(this._saveEnableChangelog);
        BlankPanel.setChangeState(this._lMaxAge, 1);
        this._isMaxAgeValidDirty[0] = true;
        this._isMaxAgeValidDirty[1] = false;
        if (this._saveMaxAge != 0) {
            this._tfMaxAge.setText(String.valueOf(this._saveMaxAge));
            this._cbMaxAgeUnlimited.setSelected(false);
        } else {
            this._tfMaxAge.setText("");
            this._cbMaxAgeUnlimited.setSelected(true);
        }
        this._comboMaxAge.setSelectedIndex(this._saveMaxAgeUnit);
        this._lMaxAge.setEnabled(this._saveEnableChangelog);
        this._tfMaxAge.setEnabled(this._saveEnableChangelog && !this._cbMaxAgeUnlimited.isSelected());
        this._comboMaxAge.setEnabled(this._saveEnableChangelog && !this._cbMaxAgeUnlimited.isSelected());
        this._cbMaxAgeUnlimited.setEnabled(this._saveEnableChangelog);
        BlankPanel.setChangeState(this._cb4xCompatibility, 1);
        this._cb4xCompatibility.setSelected(this._save4xCompatibility);
        this._is4xCompatibilityDirty = false;
        if (DN.isDN((String)this._save4xDn) && this._save4xDn.trim().length() > 0) {
            BlankPanel.setChangeState(this._l4xDn, 1);
            this._is4xDnValidDirty[0] = true;
        } else {
            BlankPanel.setChangeState(this._l4xDn, 3);
            this._is4xDnValidDirty[0] = false;
        }
        this._is4xDnValidDirty[1] = false;
        this._l4xDn.setEnabled(this._save4xCompatibility);
        this._tf4xDn.setEnabled(this._save4xCompatibility);
        this._tf4xDn.setText(this._save4xDn);
        BlankPanel.setChangeState(this._l4xPwd, 1);
        BlankPanel.setChangeState(this._l4xConfirmPwd, 1);
        this._is4xPwdValidDirty[0] = true;
        this._is4xPwdValidDirty[1] = false;
        this._l4xPwd.setEnabled(this._save4xCompatibility);
        this._pf4xPwd.setEnabled(this._save4xCompatibility);
        ((JTextComponent)this._pf4xPwd).setText(this._save4xPwd);
        this._l4xConfirmPwd.setEnabled(this._save4xCompatibility);
        this._pfConfirm4xPwd.setEnabled(this._save4xCompatibility);
        ((JTextComponent)this._pfConfirm4xPwd).setText(this._save4xPwd);
        this._lPwdOptional.setEnabled(this._save4xCompatibility);
        this._pf4xPwd.setBackground(this._tf4xDn.getBackground());
        this._pfConfirm4xPwd.setBackground(this._tf4xDn.getBackground());
        this._isInitializingComponents = false;
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._cbEnableChangelog = UIFactory.makeJCheckBox(this, "globalreplicationpanel", "cbenablechangelog", false, ConfigBasePanel._resource);
        this._cbEnableChangelog.setMargin(new Insets(0, 0, 0, 0));
        this._lLocation = UIFactory.makeJLabel("globalreplicationpanel", "llocation", ConfigBasePanel._resource);
        this._tfLocation = UIFactory.makeJTextField(this, "globalreplicationpanel", "llocation", null, 20, ConfigBasePanel._resource);
        this._lLocation.setLabelFor(this._tfLocation);
        this._bBrowse = UIFactory.makeJButton(this, "globalreplicationpanel", "bbrowse", ConfigBasePanel._resource);
        this._lMaxRecords = UIFactory.makeJLabel("globalreplicationpanel", "lmaxrecords", ConfigBasePanel._resource);
        this._tfMaxRecords = UIFactory.makeJTextField(this, "globalreplicationpanel", "lmaxrecords", null, 5, ConfigBasePanel._resource);
        this._lMaxRecords.setLabelFor(this._tfMaxRecords);
        this._cbMaxRecordsUnlimited = UIFactory.makeJCheckBox(this, "globalreplicationpanel", "cbmaxrecordsunlimited", false, ConfigBasePanel._resource);
        this._lMaxAge = UIFactory.makeJLabel("globalreplicationpanel", "lmaxage", ConfigBasePanel._resource);
        this._tfMaxAge = UIFactory.makeJTextField(this, "globalreplicationpanel", "lmaxage", null, 5, ConfigBasePanel._resource);
        this._lMaxAge.setLabelFor(this._tfMaxAge);
        this._comboMaxAge = new JComboBox<Object>(this.UNIT_LABELS);
        this._comboMaxAge.setToolTipText(ConfigBasePanel._resource.getString("globalreplicationpanel", "lmaxage-ttip"));
        this._comboMaxAge.addActionListener(this);
        this._cbMaxAgeUnlimited = UIFactory.makeJCheckBox(this, "globalreplicationpanel", "cbmaxageunlimited", false, ConfigBasePanel._resource);
        JPanel jPanel = new JPanel(new GridBagLayout());
        ConfigBasePanel.addComponentBorder(jPanel, this._cbEnableChangelog);
        this._cb4xCompatibility = UIFactory.makeJCheckBox(this, "globalreplicationpanel", "cb4xcompatibility", false, ConfigBasePanel._resource);
        this._cb4xCompatibility.setMargin(new Insets(0, 0, 0, 0));
        this._l4xDn = UIFactory.makeJLabel("globalreplicationpanel", "l4xdn", ConfigBasePanel._resource);
        this._tf4xDn = UIFactory.makeJTextField(this, "globalreplicationpanel", "l4xdn", null, 20, ConfigBasePanel._resource);
        this._l4xDn.setLabelFor(this._tf4xDn);
        this._l4xPwd = UIFactory.makeJLabel("globalreplicationpanel", "l4xpwd", ConfigBasePanel._resource);
        this._pf4xPwd = UIFactory.makeJPasswordField(this, "globalreplicationpanel", "l4xdn", null, 20, ConfigBasePanel._resource);
        this._l4xPwd.setLabelFor(this._pf4xPwd);
        this._l4xConfirmPwd = UIFactory.makeJLabel("globalreplicationpanel", "l4xconfirmpwd", ConfigBasePanel._resource);
        this._pfConfirm4xPwd = UIFactory.makeJPasswordField(this, "globalreplicationpanel", "l4xconfirmpwd", null, 20, ConfigBasePanel._resource);
        this._l4xConfirmPwd.setLabelFor(this._pfConfirm4xPwd);
        this._lPwdOptional = UIFactory.makeJLabel("globalreplicationpanel", "lpwdoptional", ConfigBasePanel._resource);
        this._lPwdOptional.setFont(this._lPwdOptional.getFont().deriveFont(2));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ConfigBasePanel.addComponentBorder(jPanel2, this._cb4xCompatibility);
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("globalreplicationpanel", "managerpanel-title"));
        this._lManagerPwd = UIFactory.makeJLabel("globalreplicationpanel", "lmanagerpwd", ConfigBasePanel._resource);
        this._pfManagerPwd = UIFactory.makeJPasswordField(this, "globalreplicationpanel", "lmanagerpwd", null, 20, ConfigBasePanel._resource);
        this._lManagerPwd.setLabelFor(this._pfManagerPwd);
        this._lManagerConfirmPwd = UIFactory.makeJLabel("globalreplicationpanel", "lmanagerconfirmpwd", ConfigBasePanel._resource);
        this._pfManagerConfirmPwd = UIFactory.makeJPasswordField(this, "globalreplicationpanel", "lmanagerconfirmpwd", null, 20, ConfigBasePanel._resource);
        this._lManagerConfirmPwd.setLabelFor(this._pfManagerConfirmPwd);
        this._bManageSets = UIFactory.makeJButton(this, "globalreplicationpanel", "bmanagesets", ConfigBasePanel._resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace() - 4, 0, UIFactory.getComponentSpace() - 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._lLocation, gridBagConstraints);
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        jPanel3.add((Component)this._tfLocation, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        jPanel3.add((Component)this._bBrowse, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 13;
        jPanel4.add((Component)this._lMaxRecords, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel4.add((Component)this._tfMaxRecords, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel4.add((Component)this._cbMaxRecordsUnlimited, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel4.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel4.add((Component)this._lMaxAge, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this._tfMaxAge, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel4.add((Component)this._comboMaxAge, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel4.add((Component)this._cbMaxAgeUnlimited, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace() - 4, UIFactory.getComponentSpace(), 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._l4xDn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace() - 4;
        jPanel2.add((Component)this._tf4xDn, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace() - 4;
        jPanel2.add((Component)this._l4xPwd, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace() - 4;
        jPanel2.add((Component)this._pf4xPwd, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace() - 4;
        jPanel2.add((Component)this._l4xConfirmPwd, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace() - 4;
        jPanel2.add((Component)this._pfConfirm4xPwd, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this._lPwdOptional, gridBagConstraints);
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        groupPanel.add((Component)this._lManagerPwd, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel.add((Component)this._pfManagerPwd, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        groupPanel.add((Component)this._lManagerConfirmPwd, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel.add((Component)this._pfManagerConfirmPwd, gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.insets.top -= 4;
        gridBagConstraints.insets.left += 2;
        gridBagConstraints.insets.right += 2;
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.top += 2;
        this._contentPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)this._bManageSets, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void updateColoring(JComponent jComponent, boolean bl, boolean bl2) {
        if (!bl) {
            BlankPanel.setChangeState(jComponent, 3);
        } else if (bl2) {
            BlankPanel.setChangeState(jComponent, 2);
        } else {
            BlankPanel.setChangeState(jComponent, 1);
        }
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = this._isManagerPwdValidDirty[0] && (!this._cbEnableChangelog.isSelected() || this._isLocationValidDirty[0] && this._isMaxRecordsValidDirty[0] && this._isMaxAgeValidDirty[0]) && (!this._cb4xCompatibility.isSelected() || this._is4xDnValidDirty[0] && this._is4xPwdValidDirty[0]);
        boolean bl3 = bl = this._isManagerPwdValidDirty[1] || this._isEnableChangelogDirty || this._cbEnableChangelog.isSelected() && (this._isLocationValidDirty[1] || this._isMaxRecordsValidDirty[1] || this._isMaxAgeValidDirty[1]) || this._is4xCompatibilityDirty || this._cb4xCompatibility.isSelected() && (this._is4xDnValidDirty[1] || this._is4xPwdValidDirty[1]);
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }
}

