/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigDataTabbedPanel;
import com.netscape.admin.dirserv.config.ConfigSuffixNode;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.IConfigNode;
import com.netscape.admin.dirserv.config.NewChainedSuffixDialog;
import com.netscape.admin.dirserv.config.NewSuffixDialog;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.util.DN;

public class ConfigDataNode
extends DefaultMutableTreeNode
implements IConfigNode {
    DSFramework _framework;
    private String _name;
    private Icon _icon;
    private ConfigDataTabbedPanel _customPanel;
    private JTree _tree;
    private DefaultTreeModel _treeModel;
    private boolean _refreshPanelOnRequest;
    private boolean _isLeaf;
    private boolean _isRefreshNeededOnExpansion;
    private static final ResourceSet _resource = DSConfigPage._resource;
    private static final String NEW_SUFFIX = "NEW SUFFIX";
    private static final String NEW_CHAINED_SUFFIX = "NEW CHAINED SUFFIX";
    private static final DN LDBM_PLUGIN_DN = new DN("cn=ldbm database,cn=plugins,cn=config");
    private final IMenuItem[] _objectMenuItems = new IMenuItem[]{new MenuItemText("NEW SUFFIX", _resource.getString("menu", "newrootsuffix"), _resource.getString("menu", "newsuffix-description")), new MenuItemText("NEW CHAINED SUFFIX", _resource.getString("menu", "newrootchainedsuffix"), _resource.getString("menu", "newchainedsuffix-description"))};
    private final IMenuItem[] _contextMenuItems = new IMenuItem[]{new MenuItemText("NEW SUFFIX", _resource.getString("menu", "newrootsuffix"), _resource.getString("menu", "newsuffix-description")), new MenuItemText("NEW CHAINED SUFFIX", _resource.getString("menu", "newrootchainedsuffix"), _resource.getString("menu", "newchainedsuffix-description"))};
    private static final String DATA_ICON_NAME = "dbcontainer.gif";

    public ConfigDataNode(DSFramework dSFramework, JTree jTree) {
        this._name = _resource.getString("datanode", "label");
        this._icon = DSUtil.getPackageImage(DATA_ICON_NAME);
        this._framework = dSFramework;
        this._tree = jTree;
        this._treeModel = (DefaultTreeModel)jTree.getModel();
        this._isRefreshNeededOnExpansion = true;
        this._isLeaf = this._framework.getServerObject().getDatabaseConfig().getSuffixes().size() == 0;
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public Component getCustomPanel() {
        if (this._customPanel == null) {
            this._customPanel = this.createCustomPanel();
        } else if (this._refreshPanelOnRequest) {
            this._customPanel.refreshPanel();
        }
        this._refreshPanelOnRequest = false;
        return this._customPanel;
    }

    public boolean isRefreshNeededOnExpansion() {
        return this._isRefreshNeededOnExpansion;
    }

    public void refreshNode() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object2;
        if (this._customPanel != null) {
            this._refreshPanelOnRequest = true;
        }
        ArrayList<ConfigSuffixNode> arrayList = new ArrayList<ConfigSuffixNode>();
        DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
        ListIterator listIterator = ((AbstractList)databaseConfig.getSuffixes()).listIterator();
        this._isLeaf = !listIterator.hasNext();
        while (listIterator.hasNext()) {
            object2 = (Suffix)listIterator.next();
            if (((Suffix)object2).getParentSuffix() != null || (defaultMutableTreeNode = this.getSuffixNode((String)(object = ((Suffix)object2).getName()))) != null) continue;
            ConfigSuffixNode configSuffixNode = new ConfigSuffixNode(this._framework, (Suffix)object2, this._tree);
            arrayList.add(configSuffixNode);
        }
        object2 = ((AbstractList)arrayList).listIterator();
        while (object2.hasNext()) {
            this._treeModel.insertNodeInto((DefaultMutableTreeNode)object2.next(), this, this.getChildCount());
        }
        object = this.children();
        while (object.hasMoreElements()) {
            defaultMutableTreeNode = object.nextElement();
            if (arrayList.contains(defaultMutableTreeNode)) continue;
            ((IConfigNode)((Object)defaultMutableTreeNode)).refreshNode();
        }
        this._isRefreshNeededOnExpansion = false;
    }

    public void menuAction(String string) {
        if (string == NEW_SUFFIX) {
            this.actionCreateNewSuffix();
        } else if (string == NEW_CHAINED_SUFFIX) {
            this.actionCreateNewChainedSuffix();
        }
    }

    public IMenuItem[] getObjectMenuItems() {
        return this._objectMenuItems;
    }

    public IMenuItem[] getContextMenuItems() {
        return this._contextMenuItems;
    }

    private ConfigDataTabbedPanel createCustomPanel() {
        return new ConfigDataTabbedPanel(this._framework);
    }

    private void actionCreateNewSuffix() {
        NewSuffixDialog newSuffixDialog = new NewSuffixDialog(this._framework);
        newSuffixDialog.pack();
        newSuffixDialog.show();
        Suffix suffix = newSuffixDialog.getSuffix();
        if (suffix != null) {
            this._isLeaf = false;
            DefaultMutableTreeNode defaultMutableTreeNode = this.getSuffixNode(suffix.getName());
            if (defaultMutableTreeNode != null) {
                TreePath treePath = new TreePath(this._treeModel.getPathToRoot(defaultMutableTreeNode));
                this._tree.setSelectionPath(treePath);
            }
        }
    }

    private void actionCreateNewChainedSuffix() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        NewChainedSuffixDialog newChainedSuffixDialog = new NewChainedSuffixDialog(this._framework);
        newChainedSuffixDialog.pack();
        newChainedSuffixDialog.show();
        Suffix suffix = newChainedSuffixDialog.getSuffix();
        if (suffix != null && (defaultMutableTreeNode = this.getSuffixNode(suffix.getName())) != null) {
            this._isLeaf = false;
            TreePath treePath = new TreePath(this._treeModel.getPathToRoot(defaultMutableTreeNode));
            this._tree.setSelectionPath(treePath);
        }
    }

    private DefaultMutableTreeNode getSuffixNode(String string) {
        Enumeration<TreeNode> enumeration = this.children();
        boolean bl = false;
        DN dN = new DN(string);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        while (enumeration.hasMoreElements() && !bl) {
            IConfigNode iConfigNode = (IConfigNode)((Object)enumeration.nextElement());
            DN dN2 = new DN(iConfigNode.getName());
            if (!dN2.equals(dN)) continue;
            bl = true;
            defaultMutableTreeNode = (DefaultMutableTreeNode)((Object)iConfigNode);
        }
        return defaultMutableTreeNode;
    }
}

