/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;

public class ConfigCachePanel
extends ConfigBasePanel
implements DocumentListener {
    private boolean _isInitializing;
    private boolean _isCancelled;
    private boolean _isInitializingComponents;
    private boolean _needsRestartServer;
    private ArrayList _suffixNames;
    private ArrayList _readSuffixNames;
    private ArrayList _localSuffixNames;
    private ArrayList _readLocalSuffixNames;
    private ArrayList _databaseDns;
    private ArrayList _chainedSuffixNames;
    private ArrayList _readChainedSuffixNames;
    private ArrayList _nonSupportedSuffixNames;
    private ArrayList _readNonSupportedSuffixNames;
    private Hashtable _htSuffixDirtyValid;
    private ArrayList _suffixCacheSize;
    private ArrayList _readSuffixCacheSize;
    private ArrayList _suffixNumberEntries;
    private ArrayList _readSuffixNumberEntries;
    private ArrayList _saveSuffixCacheSize;
    private ArrayList _readSaveSuffixCacheSize;
    private ArrayList _saveSuffixNumberEntries;
    private ArrayList _readSaveSuffixNumberEntries;
    private JPanel _contentPanel;
    private JLabel _lDbCacheSize;
    private JTextField _tfDbCacheSize;
    private JLabel _lImportCacheSize;
    private JTextField _tfImportCacheSize;
    private JTable _tEntryCache;
    private JLabel _lTotalCacheSize;
    private boolean[] _isDbCacheSizeValidDirty = new boolean[]{true, false};
    private boolean[] _isImportCacheSizeValidDirty = new boolean[]{true, false};
    private float _saveDbCacheSize;
    private float _saveImportCacheSize;
    private String _lastReadAttribute;
    private String _lastReadEntry;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("cachepanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("cachepanel-no-rights", "label"), 2, 50);
    private final String INCORRECT_CACHE_SIZE = ConfigBasePanel._resource.getString("cachepanel", "ltotalcachesize-incorrect-label");
    private final String[] TABLE_HEADERS = new String[]{ConfigBasePanel._resource.getString("cachepanel", "tentrycache-suffixheader"), ConfigBasePanel._resource.getString("cachepanel", "tentrycache-suffixcachesizeheader"), ConfigBasePanel._resource.getString("cachepanel", "tentrycache-suffixnbentriesheader")};
    static /* synthetic */ Class class$java$lang$String;

    public ConfigCachePanel() {
        this.setTitle(ConfigBasePanel._resource.getString("cachepanel", "title"));
        this._helpToken = "configuration-performance-cache-help";
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigCachePanel.this._suffixNames = new ArrayList();
                        ConfigCachePanel.this._localSuffixNames = new ArrayList();
                        ConfigCachePanel.this._databaseDns = new ArrayList();
                        ConfigCachePanel.this._chainedSuffixNames = new ArrayList();
                        ConfigCachePanel.this._nonSupportedSuffixNames = new ArrayList();
                        ConfigCachePanel.this._htSuffixDirtyValid = new Hashtable();
                        ConfigCachePanel.this._suffixCacheSize = new ArrayList();
                        ConfigCachePanel.this._suffixNumberEntries = new ArrayList();
                        ConfigCachePanel.this._saveSuffixCacheSize = new ArrayList();
                        ConfigCachePanel.this._saveSuffixNumberEntries = new ArrayList();
                        ConfigCachePanel.this._readSuffixNames = new ArrayList();
                        ConfigCachePanel.this._readLocalSuffixNames = new ArrayList();
                        ConfigCachePanel.this._readChainedSuffixNames = new ArrayList();
                        ConfigCachePanel.this._readNonSupportedSuffixNames = new ArrayList();
                        ConfigCachePanel.this._readSuffixCacheSize = new ArrayList();
                        ConfigCachePanel.this._readSuffixNumberEntries = new ArrayList();
                        ConfigCachePanel.this._readSaveSuffixCacheSize = new ArrayList();
                        ConfigCachePanel.this._readSaveSuffixNumberEntries = new ArrayList();
                        ConfigCachePanel.this.createContentPanel();
                        ConfigCachePanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigCachePanel.access$2100(1.access$2000(this.this$1));
                                ConfigCachePanel.access$2200(1.access$2000(this.this$1));
                                1.access$2000(this.this$1).showComponent(ConfigCachePanel.access$2300(1.access$2000(this.this$1)), false);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{ConfigCachePanel.access$2400(1.access$2000(this.this$1)), ConfigCachePanel.access$2500(1.access$2000(this.this$1))};
                                1.access$2000(this.this$1).showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("cachepanel-formatting-error", "label", stringArray), 2, 50), true);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$2000(this.this$1).showComponent((JComponent)ConfigCachePanel.access$2600(1.access$2000(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{ConfigCachePanel.this._lastReadEntry, DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("cachepanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$2000(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigCachePanel.this._isInitialized = true;
                    ConfigCachePanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigCachePanel access$2000(1 var0) {
                    return var0.ConfigCachePanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigCachePanel.this.initComponentsFromServerValues();
                    ConfigCachePanel.this.fireValidDirtyChange();
                    ConfigCachePanel.this.showComponent(ConfigCachePanel.this._contentPanel, false);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ConfigCachePanel.this._lastReadAttribute, ConfigCachePanel.this._lastReadEntry};
                    ConfigCachePanel.this.showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("cachepanel-formatting-error", "label", stringArray), 2, 50), true);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigCachePanel.this.showComponent((JComponent)ConfigCachePanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{this._lastReadEntry, DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("cachepanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigCachePanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        boolean bl = false;
        boolean bl2 = false;
        this._needsRestartServer = false;
        String string = null;
        try {
            long l;
            float f;
            Object object;
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            if (this._isDbCacheSizeValidDirty[1]) {
                object = null;
                try {
                    f = Float.parseFloat(this._tfDbCacheSize.getText());
                    l = (long)(f * 1024.0f * 1024.0f);
                    object = String.valueOf(l);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                if (object != null) {
                    lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-dbcachesize", object));
                    bl2 = true;
                }
            }
            if (this._isImportCacheSizeValidDirty[1]) {
                object = null;
                try {
                    f = Float.parseFloat(this._tfImportCacheSize.getText());
                    l = (long)(f * 1024.0f * 1024.0f);
                    object = String.valueOf(l);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                if (object != null) {
                    lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-import-cachesize", (String)object));
                }
            }
            if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
                string = "cn=config,cn=ldbm database,cn=plugins,cn=config";
                object = this.getServerInfo().getLDAPConnection();
                object.modify(string, lDAPModificationSet);
                this._needsRestartServer = bl2;
                bl = true;
            }
            int n = 0;
            while (n < this._localSuffixNames.size()) {
                String string2;
                boolean[] blArray = (boolean[])this._htSuffixDirtyValid.get(this._localSuffixNames.get(n));
                LDAPModificationSet lDAPModificationSet2 = new LDAPModificationSet();
                if (blArray[1]) {
                    string2 = null;
                    try {
                        float f2 = Float.parseFloat((String)this._suffixCacheSize.get(n));
                        long l2 = (long)(f2 * 1024.0f * 1024.0f);
                        string2 = String.valueOf(l2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                    }
                    if (string2 != null) {
                        lDAPModificationSet2.add(2, new LDAPAttribute("nsslapd-cachememsize", string2));
                    }
                }
                if (blArray[3]) {
                    string2 = (String)this._suffixNumberEntries.get(n);
                    lDAPModificationSet2.add(2, new LDAPAttribute("nsslapd-cachesize", string2));
                }
                if (lDAPModificationSet2.size() > 0 && !this._isCancelled) {
                    string = (String)this._databaseDns.get(n);
                    string2 = this.getServerInfo().getLDAPConnection();
                    string2.modify(string, lDAPModificationSet2);
                    bl = true;
                }
                ++n;
            }
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
            throw new ConfigPanelException(ConfigBasePanel._resource.getString("cachepanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("cachepanel", "updating-server-error-msg", stringArray));
        }
        if (!this._isCancelled && bl) {
            this.resetCallback();
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean needsRestartServer() {
        return this._needsRestartServer;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._isInitializingComponents) {
            if (documentEvent.getDocument() == this._tfDbCacheSize.getDocument()) {
                this.checkField(this._tfDbCacheSize, this._saveDbCacheSize, this._isDbCacheSizeValidDirty, this._lDbCacheSize);
            } else if (documentEvent.getDocument() == this._tfImportCacheSize.getDocument()) {
                this.checkField(this._tfImportCacheSize, this._saveImportCacheSize, this._isImportCacheSizeValidDirty, this._lImportCacheSize);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void basicLayout() {
        this.setLayout(new BorderLayout(0, 0));
        this._innerPanel = new JPanel(new GridBagLayout());
        this._innerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this._innerPanel, "Center");
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._lDbCacheSize = UIFactory.makeJLabel("cachepanel", "ldbcachesize", ConfigBasePanel._resource);
        this._tfDbCacheSize = UIFactory.makeJTextField(this, "cachepanel", "ldbcachesize", String.valueOf(this._saveDbCacheSize), 8, ConfigBasePanel._resource);
        this._lDbCacheSize.setLabelFor(this._tfDbCacheSize);
        this._lImportCacheSize = UIFactory.makeJLabel("cachepanel", "limportcachesize", ConfigBasePanel._resource);
        this._tfImportCacheSize = UIFactory.makeJTextField(this, "cachepanel", "limportcachesize", String.valueOf(this._saveImportCacheSize), 8, ConfigBasePanel._resource);
        this._lImportCacheSize.setLabelFor(this._tfImportCacheSize);
        JLabel jLabel = new JLabel(DSConfigPage._resource.getString("cachepanel", "tentrycache-label"));
        EntryCacheTableModel entryCacheTableModel = new EntryCacheTableModel();
        this._tEntryCache = new JTable(entryCacheTableModel);
        jLabel.setLabelFor(this._tEntryCache);
        this._tEntryCache.setColumnSelectionAllowed(false);
        this._tEntryCache.getTableHeader().setReorderingAllowed(false);
        this._tEntryCache.setSelectionMode(0);
        EntryCacheTableCellRenderer entryCacheTableCellRenderer = new EntryCacheTableCellRenderer();
        this._tEntryCache.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ConfigCachePanel.class$("java.lang.String")) : class$java$lang$String, entryCacheTableCellRenderer);
        this._tEntryCache.setShowGrid(true);
        this._lTotalCacheSize = UIFactory.makeJLabel("cachepanel", "ltotalcachesize", ConfigBasePanel._resource);
        this._lTotalCacheSize.setLabelFor(this._contentPanel);
        JLabel jLabel2 = UIFactory.makeJLabel("cachepanel", "lunlimitedinformation", ConfigBasePanel._resource);
        jLabel2.setFont(jLabel2.getFont().deriveFont(2));
        jLabel2.setLabelFor(this._tEntryCache);
        JLabel jLabel3 = UIFactory.makeJLabel("cachepanel", "ldbcachesize-unit", ConfigBasePanel._resource);
        jLabel3.setLabelFor(this._tfDbCacheSize);
        JComponent[] jComponentArray = new JComponent[]{this._lDbCacheSize, this._tfDbCacheSize, jLabel3};
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.addLine(jPanel, jComponentArray);
        jLabel3 = UIFactory.makeJLabel("cachepanel", "limportcachesize-unit", ConfigBasePanel._resource);
        jLabel3.setLabelFor(this._tfImportCacheSize);
        JComponent[] jComponentArray2 = new JComponent[]{this._lImportCacheSize, this._tfImportCacheSize, jLabel3};
        this.addLine(jPanel, jComponentArray2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 0;
        this._contentPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.insets.top = 0;
        JScrollPane jScrollPane = new JScrollPane(this._tEntryCache, 20, 30);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this._contentPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.weighty = 0.0;
        this._contentPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel4 = UIFactory.makeJLabel("cachepanel", "llabelcache", ConfigBasePanel._resource);
        jLabel4.setFont(jLabel4.getFont().deriveFont(0));
        JComponent[] jComponentArray3 = new JComponent[]{jLabel4, this._lTotalCacheSize};
        this.addLine(jPanel, jComponentArray3);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 0;
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException, NumberFormatException {
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        lDAPSearchConstraints.setMaxResults(0);
        String[] stringArray = new String[]{"nsslapd-dbcachesize", "nsslapd-import-cachesize"};
        this._lastReadEntry = "cn=config,cn=ldbm database,cn=plugins,cn=config";
        LDAPEntry lDAPEntry = lDAPConnection.read(this._lastReadEntry, stringArray, lDAPSearchConstraints);
        this._lastReadAttribute = "nsslapd-dbcachesize";
        this._saveDbCacheSize = (float)Long.parseLong(this.getValue(lDAPEntry, this._lastReadAttribute)) / 1048576.0f;
        this._lastReadAttribute = "nsslapd-import-cachesize";
        this._saveImportCacheSize = (float)Long.parseLong(this.getValue(lDAPEntry, this._lastReadAttribute)) / 1048576.0f;
        this._readSuffixNames.clear();
        this._readLocalSuffixNames.clear();
        this._databaseDns.clear();
        this._readChainedSuffixNames.clear();
        this._readNonSupportedSuffixNames.clear();
        this._readSuffixCacheSize.clear();
        this._readSuffixNumberEntries.clear();
        this._readSaveSuffixCacheSize.clear();
        this._readSaveSuffixNumberEntries.clear();
        DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
        Vector vector = databaseConfig.getSuffixes();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            Vector vector2 = suffix.getDatabases();
            if (vector2 != null && vector2.size() == 1) {
                Database database = (Database)vector2.elementAt(0);
                if (database.getType() == 0) {
                    String[] stringArray2 = new String[]{"nsslapd-cachememsize", "nsslapd-cachesize"};
                    this._lastReadEntry = "cn=" + database.getName() + ",cn=ldbm database,cn=plugins,cn=config";
                    LDAPEntry lDAPEntry2 = lDAPConnection.read(this._lastReadEntry, stringArray2, lDAPSearchConstraints);
                    this._lastReadAttribute = "nsslapd-cachememsize";
                    long l = Long.parseLong(this.getValue(lDAPEntry2, this._lastReadAttribute).trim());
                    this._lastReadAttribute = "nsslapd-cachesize";
                    int n = Integer.parseInt(this.getValue(lDAPEntry2, this._lastReadAttribute).trim());
                    this._readLocalSuffixNames.add(suffix.getName());
                    this._databaseDns.add(this._lastReadEntry);
                    float f = Long.parseLong(this.getValue(lDAPEntry2, "nsslapd-cachememsize"));
                    float f2 = f / 1048576.0f;
                    this._readSuffixCacheSize.add(String.valueOf(f2));
                    this._readSuffixNumberEntries.add(this.getValue(lDAPEntry2, "nsslapd-cachesize"));
                    this._readSaveSuffixCacheSize.add(new Float(f2));
                    this._readSaveSuffixNumberEntries.add(new Integer(n));
                } else if (database.getType() == 1) {
                    this._readChainedSuffixNames.add(suffix.getName());
                } else {
                    this._readNonSupportedSuffixNames.add(suffix.getName());
                }
            } else {
                this._readNonSupportedSuffixNames.add(suffix.getName());
            }
            this._readSuffixNames.add(suffix.getName());
        }
    }

    private void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        this._suffixNames.clear();
        this._suffixNames.addAll(this._readSuffixNames);
        this._localSuffixNames.clear();
        this._localSuffixNames.addAll(this._readLocalSuffixNames);
        this._chainedSuffixNames.clear();
        this._chainedSuffixNames.addAll(this._readChainedSuffixNames);
        this._nonSupportedSuffixNames.clear();
        this._nonSupportedSuffixNames.addAll(this._readNonSupportedSuffixNames);
        this._suffixCacheSize.clear();
        this._suffixCacheSize.addAll(this._readSuffixCacheSize);
        this._suffixNumberEntries.clear();
        this._suffixNumberEntries.addAll(this._readSuffixNumberEntries);
        this._saveSuffixCacheSize.clear();
        this._saveSuffixCacheSize.addAll(this._readSaveSuffixCacheSize);
        this._saveSuffixNumberEntries.clear();
        this._saveSuffixNumberEntries.addAll(this._readSaveSuffixNumberEntries);
        this._tfDbCacheSize.setText(String.valueOf(this._saveDbCacheSize));
        BlankPanel.setChangeState(this._lDbCacheSize, 1);
        this._tfImportCacheSize.setText(String.valueOf(this._saveImportCacheSize));
        BlankPanel.setChangeState(this._lImportCacheSize, 1);
        this.updateTotalCacheLabel();
        this._isDbCacheSizeValidDirty[1] = false;
        this._isDbCacheSizeValidDirty[0] = true;
        this._isImportCacheSizeValidDirty[1] = false;
        this._isImportCacheSizeValidDirty[0] = true;
        this._htSuffixDirtyValid.clear();
        Iterator iterator = ((AbstractList)this._localSuffixNames).iterator();
        while (iterator.hasNext()) {
            boolean[] blArray = new boolean[]{true, false, true, false};
            this._htSuffixDirtyValid.put(iterator.next(), blArray);
        }
        this._isInitializingComponents = false;
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2;
        Iterator iterator = this._htSuffixDirtyValid.values().iterator();
        boolean bl3 = false;
        boolean bl4 = true;
        while (iterator.hasNext() && (!bl3 || bl4)) {
            boolean[] blArray = (boolean[])iterator.next();
            bl4 = bl4 && blArray[0] && blArray[2];
            boolean bl5 = bl3 = bl3 || blArray[1] || blArray[3];
        }
        boolean bl6 = bl2 = this._isDbCacheSizeValidDirty[1] || this._isImportCacheSizeValidDirty[1] || bl3;
        if (bl2) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        boolean bl7 = bl = this._isDbCacheSizeValidDirty[0] && this._isImportCacheSizeValidDirty[0] && bl4;
        if (bl) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private void addLine(Container container, JComponent[] jComponentArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = jComponentArray.length + 1;
        container.add((Component)jComponentArray[0], gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        int n = 1;
        while (n < jComponentArray.length - 1) {
            --gridBagConstraints.gridwidth;
            gridBagConstraints.weightx = 0.1;
            container.add((Component)jComponentArray[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        container.add((Component)jComponentArray[jComponentArray.length - 1], gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 0;
        container.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    private void updateTotalCacheLabel() {
        Object object;
        float f = 0.0f;
        try {
            f += Float.parseFloat(this._tfDbCacheSize.getText());
            f += Float.parseFloat(this._tfImportCacheSize.getText());
            object = ((AbstractList)this._suffixCacheSize).iterator();
            while (object.hasNext()) {
                f += Float.parseFloat((String)object.next());
            }
        }
        catch (NumberFormatException numberFormatException) {
            f = -1.0f;
        }
        if (f >= 0.0f) {
            object = new String[]{String.valueOf(f)};
            String string = ConfigBasePanel._resource.getString("cachepanel", "ltotalcachesize-label", (String[])object);
            this._lTotalCacheSize.setText(string);
        } else {
            this._lTotalCacheSize.setText(this.INCORRECT_CACHE_SIZE);
        }
    }

    private void checkField(JTextField jTextField, float f, boolean[] blArray, JLabel jLabel) {
        try {
            float f2 = Float.parseFloat(jTextField.getText());
            blArray[1] = f2 != f;
            blArray[0] = (double)f2 >= 0.1;
        }
        catch (NumberFormatException numberFormatException) {
            blArray[0] = false;
            blArray[1] = true;
        }
        if (!blArray[0]) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        this.fireValidDirtyChange();
        this.updateTotalCacheLabel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EntryCacheTableCellRenderer
    implements TableCellRenderer {
        private JLabel NON_APPLICABLE_CHAINED_LABEL = UIFactory.makeJLabel("cachepanel", "notapplicable-chained", 0, ConfigBasePanel._resource);
        final Icon LOCAL_SUFFIX_ICON = DSUtil.getPackageImage("plugin.gif");
        final Icon CHAINED_SUFFIX_ICON = DSUtil.getPackageImage("chobj.gif");
        final Icon NON_SUPPORTED_SUFFIX_ICON = DSUtil.getPackageImage("nonsupportedsuffix.gif");
        private JLabel NOT_SUPPORTED_DISTRIBUTED_LABEL = UIFactory.makeJLabel("cachepanel", "notsupported-distributed", 0, ConfigBasePanel._resource);
        private LabelCellRenderer _lRenderer = new LabelCellRenderer();

        public EntryCacheTableCellRenderer() {
            this.NON_APPLICABLE_CHAINED_LABEL.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.NOT_SUPPORTED_DISTRIBUTED_LABEL.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = null;
            n2 = jTable.convertColumnIndexToModel(n2);
            Object object2 = jTable.getModel().getValueAt(n, 0);
            if (ConfigCachePanel.this._localSuffixNames.contains(object2)) {
                if (n2 == 0) {
                    boolean[] blArray;
                    jComponent = (JLabel)this._lRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (((JLabel)jComponent).getIcon() != this.LOCAL_SUFFIX_ICON) {
                        ((JLabel)jComponent).setIcon(this.LOCAL_SUFFIX_ICON);
                    }
                    if (!(blArray = (boolean[])ConfigCachePanel.this._htSuffixDirtyValid.get(object))[0] || !blArray[2]) {
                        BlankPanel.setChangeState(jComponent, 3);
                    } else if (blArray[1] || blArray[3]) {
                        BlankPanel.setChangeState(jComponent, 2);
                    } else {
                        BlankPanel.setChangeState(jComponent, 1);
                    }
                } else if (n2 == 1 || n2 == 2) {
                    jComponent = (JComponent)this._lRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (((JLabel)jComponent).getIcon() != null) {
                        ((JLabel)jComponent).setIcon(null);
                    }
                    BlankPanel.setChangeState(jComponent, 1);
                } else {
                    Thread.dumpStack();
                }
            } else if (ConfigCachePanel.this._chainedSuffixNames.contains(object2)) {
                if (n2 == 0) {
                    jComponent = (JLabel)this._lRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (((JLabel)jComponent).getIcon() != this.CHAINED_SUFFIX_ICON) {
                        ((JLabel)jComponent).setIcon(this.CHAINED_SUFFIX_ICON);
                    }
                    BlankPanel.setChangeState(jComponent, 1);
                } else if (n2 == 1 || n2 == 2) {
                    jComponent = this.NON_APPLICABLE_CHAINED_LABEL;
                } else {
                    Thread.dumpStack();
                }
            } else if (ConfigCachePanel.this._nonSupportedSuffixNames.contains(object2)) {
                if (n2 == 0) {
                    jComponent = (JLabel)this._lRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (((JLabel)jComponent).getIcon() != this.NON_SUPPORTED_SUFFIX_ICON) {
                        ((JLabel)jComponent).setIcon(this.NON_SUPPORTED_SUFFIX_ICON);
                    }
                    BlankPanel.setChangeState(jComponent, 1);
                } else if (n2 == 1 || n2 == 2) {
                    jComponent = this.NOT_SUPPORTED_DISTRIBUTED_LABEL;
                } else {
                    Thread.dumpStack();
                }
            } else {
                Thread.dumpStack();
            }
            return jComponent;
        }
    }

    class EntryCacheTableModel
    extends AbstractTableModel {
        static /* synthetic */ Class class$java$lang$String;

        EntryCacheTableModel() {
        }

        public int getColumnCount() {
            return ConfigCachePanel.this.TABLE_HEADERS.length;
        }

        public int getRowCount() {
            return ConfigCachePanel.this._suffixNames.size();
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl;
            if (n2 == 0) {
                bl = false;
            } else {
                String string = (String)ConfigCachePanel.this._suffixNames.get(n);
                int n3 = ConfigCachePanel.this._localSuffixNames.indexOf(string);
                bl = n3 >= 0;
            }
            return bl;
        }

        public Object getValueAt(int n, int n2) {
            Object var3_3 = null;
            if (n2 == 0) {
                var3_3 = ConfigCachePanel.this._suffixNames.get(n);
            } else {
                String string = (String)ConfigCachePanel.this._suffixNames.get(n);
                int n3 = ConfigCachePanel.this._localSuffixNames.indexOf(string);
                if (n3 >= 0) {
                    if (n2 == 1) {
                        var3_3 = ConfigCachePanel.this._suffixCacheSize.get(n3);
                    } else if (n2 == 2) {
                        var3_3 = ConfigCachePanel.this._suffixNumberEntries.get(n3);
                    } else {
                        Thread.dumpStack();
                    }
                }
            }
            return var3_3;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)ConfigCachePanel.this._suffixNames.get(n);
            int n3 = ConfigCachePanel.this._localSuffixNames.indexOf(string);
            if (n2 == 1) {
                boolean[] blArray = (boolean[])ConfigCachePanel.this._htSuffixDirtyValid.get(string);
                try {
                    float f = Float.parseFloat((String)object);
                    blArray[0] = (double)f >= 0.1;
                    Float f2 = (Float)ConfigCachePanel.this._saveSuffixCacheSize.get(n3);
                    blArray[1] = f2.floatValue() != f;
                }
                catch (NumberFormatException numberFormatException) {
                    blArray[0] = false;
                    blArray[1] = true;
                }
                ConfigCachePanel.this._suffixCacheSize.set(n3, object);
                ConfigCachePanel.this.updateTotalCacheLabel();
                ConfigCachePanel.this._tEntryCache.repaint(ConfigCachePanel.this._tEntryCache.getCellRect(n, 0, true));
                ConfigCachePanel.this.fireValidDirtyChange();
            } else if (n2 == 2) {
                boolean[] blArray = (boolean[])ConfigCachePanel.this._htSuffixDirtyValid.get(string);
                try {
                    int n4 = Integer.parseInt((String)object);
                    blArray[2] = n4 >= 0 || n4 == -1;
                    Integer n5 = (Integer)ConfigCachePanel.this._saveSuffixNumberEntries.get(n3);
                    blArray[3] = n5 != n4;
                }
                catch (NumberFormatException numberFormatException) {
                    blArray[2] = false;
                    blArray[3] = true;
                }
                ConfigCachePanel.this._suffixNumberEntries.set(n3, object);
                ConfigCachePanel.this._tEntryCache.repaint(ConfigCachePanel.this._tEntryCache.getCellRect(n, 0, true));
                ConfigCachePanel.this.fireValidDirtyChange();
            }
            ConfigCachePanel.this._tEntryCache.repaint(ConfigCachePanel.this._tEntryCache.getCellRect(n, 0, true));
            ConfigCachePanel.this.fireValidDirtyChange();
        }

        public String getColumnName(int n) {
            return ConfigCachePanel.this.TABLE_HEADERS[n];
        }

        public Class getColumnClass(int n) {
            Class clazz = null;
            if (n >= 0 && n < 3) {
                clazz = class$java$lang$String == null ? (class$java$lang$String = EntryCacheTableModel.class$("java.lang.String")) : class$java$lang$String;
            } else {
                Thread.dumpStack();
            }
            return clazz;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

