/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.AttributeEncryptionConfirmationDialog;
import com.netscape.admin.dirserv.config.AttributeEncryptionWarningDialog;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.ConfigSelectionDialog;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.Encryption;
import com.netscape.admin.dirserv.config.ISSLConfigListener;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.UITools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;

public class ConfigAttributeEncryptionPanel
extends ConfigBasePanel
implements ActionListener,
ListSelectionListener,
ISSLConfigListener {
    private String _databaseDn;
    private Suffix _suffix;
    private boolean _isInitializing;
    private boolean _isCancelled;
    private boolean _somethingModified;
    private boolean _isSSLEnabled;
    private JPanel _contentPanel;
    private JTable _tAttributes;
    private JLabel _lEncryptedAttributes;
    private JButton _bAddAttribute;
    private JButton _bDeleteAttribute;
    private String _exportFileName;
    private DefaultCellEditor _editor;
    private Hashtable _htSaveAttributes;
    private Hashtable _htAttributes;
    private Hashtable _htReadAttributes;
    private List _lOrderedAttributeNames;
    private List _lReadOrderedAttributeNames;
    private List _lAttributes;
    private final String[] SCHEME_NAMES = new String[]{"CKM_DES_CBC", "CKM_DES3_CBC", "CKM_RC4", "CKM_RC2_CBC"};
    private final String[] SCHEME_DESCRIPTIONS = new String[]{"DES", "Triple DES", "RC4", "RC2"};
    private Vector _pwdSchemeNames = new Vector(this.SCHEME_NAMES.length);
    private Vector _pwdSchemeDesc = new Vector(this.SCHEME_DESCRIPTIONS.length);
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("attributeencryptionpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("attributeencryptionpanel-no-rights", "label"), 2, 50);
    private final String[] TABLE_HEADERS = new String[]{ConfigBasePanel._resource.getString("attributeencryptionpanel", "tableheader0-label"), ConfigBasePanel._resource.getString("attributeencryptionpanel", "tableheader1-label")};
    private JPanel SSL_DISABLED;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$netscape$admin$dirserv$config$Encryption;

    public ConfigAttributeEncryptionPanel(Suffix suffix) {
        this.setTitle(ConfigBasePanel._resource.getString("attributeencryptionpanel", "title"));
        this._helpToken = "configuration-suffix-attributeencryption-help";
        this._suffix = suffix;
        this._databaseDn = ((Database)this._suffix.getDatabases().get(0)).getDn();
        int n = 0;
        while (n < this.SCHEME_NAMES.length) {
            this._pwdSchemeNames.addElement(this.SCHEME_NAMES[n].toLowerCase());
            this._pwdSchemeDesc.addElement(this.SCHEME_DESCRIPTIONS[n]);
            ++n;
        }
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigAttributeEncryptionPanel.this._htSaveAttributes = new Hashtable();
                        ConfigAttributeEncryptionPanel.this._htAttributes = new Hashtable();
                        ConfigAttributeEncryptionPanel.this._htReadAttributes = new Hashtable();
                        ConfigAttributeEncryptionPanel.this._lOrderedAttributeNames = new ArrayList();
                        ConfigAttributeEncryptionPanel.this._lReadOrderedAttributeNames = new ArrayList();
                        ConfigAttributeEncryptionPanel.this.createContentPanel();
                        ConfigAttributeEncryptionPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigAttributeEncryptionPanel.access$800(1.access$700(this.this$1));
                                1.access$700(this.this$1).showComponent(ConfigAttributeEncryptionPanel.access$900(1.access$700(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$700(this.this$1).showComponent((JComponent)ConfigAttributeEncryptionPanel.access$1000(1.access$700(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("attributeencryptionpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$700(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigAttributeEncryptionPanel.this._isInitialized = true;
                    ConfigAttributeEncryptionPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigAttributeEncryptionPanel access$700(1 var0) {
                    return var0.ConfigAttributeEncryptionPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigAttributeEncryptionPanel.this.initComponentsFromServerValues();
                    ConfigAttributeEncryptionPanel.this._editor.stopCellEditing();
                    ConfigAttributeEncryptionPanel.this.fireValidDirtyChange();
                    ConfigAttributeEncryptionPanel.this.showComponent(ConfigAttributeEncryptionPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigAttributeEncryptionPanel.this.showComponent((JComponent)ConfigAttributeEncryptionPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("attributeencryptionpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigAttributeEncryptionPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        Enumeration enumeration = this._htAttributes.keys();
        this._somethingModified = false;
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        while (enumeration.hasMoreElements() && !this._isCancelled) {
            String[] stringArray;
            String string = (String)enumeration.nextElement();
            Encryption encryption = (Encryption)this._htAttributes.get(string);
            if (!encryption.isDirty) continue;
            String string2 = "cn=" + string + ", cn=encrypted attributes, " + this._databaseDn;
            if (encryption.state == Encryption.ATTRIBUTE_TO_DELETE) {
                try {
                    lDAPConnection.modify(string2, new LDAPModification(2, new LDAPAttribute("dsEncryptionAlgorithm", "cleartext")));
                    this._somethingModified = true;
                    continue;
                }
                catch (LDAPException lDAPException) {
                    stringArray = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("attributeencryptionpanel", "deleting-error-title"), ConfigBasePanel._resource.getString("attributeencryptionpanel", "deleting-error-msg", stringArray));
                }
            }
            if (encryption.state == Encryption.ATTRIBUTE_TO_ADD) {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", "dsAttributeEncryption"));
                lDAPAttributeSet.add(new LDAPAttribute("cn", string));
                lDAPAttributeSet.add(new LDAPAttribute("dsEncryptionAlgorithm", encryption.type));
                stringArray = new LDAPEntry(string2, lDAPAttributeSet);
                try {
                    lDAPConnection.add((LDAPEntry)stringArray);
                    this._somethingModified = true;
                    continue;
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray2 = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
                    throw new ConfigPanelException(ConfigBasePanel._resource.getString("attributeencryptionpanel", "adding-error-title"), ConfigBasePanel._resource.getString("attributeencryptionpanel", "adding-error-msg", stringArray2));
                }
            }
            try {
                lDAPConnection.modify(string2, new LDAPModification(2, new LDAPAttribute("dsEncryptionAlgorithm", encryption.type)));
                this._somethingModified = true;
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("attributeencryptionpanel", "modifying-error-title"), ConfigBasePanel._resource.getString("attributeencryptionpanel", "modifying-error-msg", stringArray));
            }
        }
        if (!this._isCancelled && this._somethingModified) {
            this.resetCallback();
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean needsConfirmation() {
        Iterator iterator = this._htAttributes.values().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            Encryption encryption = (Encryption)iterator.next();
            boolean bl2 = bl = bl || encryption.isDirty;
        }
        return bl;
    }

    public boolean askForConfirmation() {
        AttributeEncryptionConfirmationDialog attributeEncryptionConfirmationDialog = new AttributeEncryptionConfirmationDialog(this._framework, this._suffix);
        attributeEncryptionConfirmationDialog.pack();
        attributeEncryptionConfirmationDialog.show();
        this._exportFileName = attributeEncryptionConfirmationDialog.getFileName();
        return attributeEncryptionConfirmationDialog.userConfirmation();
    }

    public boolean hasWarningMessage() {
        return this._somethingModified;
    }

    public void displayWarningMessage() {
        AttributeEncryptionWarningDialog attributeEncryptionWarningDialog = new AttributeEncryptionWarningDialog(this._framework, this._suffix, this._exportFileName);
        attributeEncryptionWarningDialog.pack();
        attributeEncryptionWarningDialog.show();
    }

    public void notifySSLEnabled() {
        this._isSSLEnabled = true;
        if (this._isInitialized) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigAttributeEncryptionPanel.this.SSL_DISABLED.setVisible(false);
                    ConfigAttributeEncryptionPanel.this.checkPanelEnabling();
                    ConfigAttributeEncryptionPanel.this.fireValidDirtyChange();
                }
            });
        }
    }

    public void notifySSLDisabled() {
        this._isSSLEnabled = false;
        if (this._isInitialized) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigAttributeEncryptionPanel.this.SSL_DISABLED.setVisible(true);
                    ConfigAttributeEncryptionPanel.this.checkPanelEnabling();
                    ConfigAttributeEncryptionPanel.this.fireValidDirtyChange();
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bAddAttribute) {
            this._framework.setBusyCursor(true);
            this.actionAddAttribute();
            this._framework.setBusyCursor(false);
        } else if (object == this._bDeleteAttribute) {
            this.actionDeleteAttribute();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkDeleteButton();
    }

    protected void basicLayout() {
        this.setLayout(new BorderLayout(0, 0));
        this._innerPanel = new JPanel(new GridBagLayout());
        this._innerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this._innerPanel, "Center");
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this.SSL_DISABLED = new JPanel(new GridBagLayout());
        this._bAddAttribute = UIFactory.makeJButton(this, "attributeencryptionpanel", "baddattribute", ConfigBasePanel._resource);
        this._bDeleteAttribute = UIFactory.makeJButton(this, "attributeencryptionpanel", "bdeleteattribute", ConfigBasePanel._resource);
        this._lEncryptedAttributes = UIFactory.makeJLabel("attributeencryptionpanel", "lencryptedattributes", ConfigBasePanel._resource);
        EncryptedAttributeTableModel encryptedAttributeTableModel = new EncryptedAttributeTableModel();
        this._tAttributes = new JTable(encryptedAttributeTableModel){
            static /* synthetic */ Class class$com$netscape$admin$dirserv$config$Encryption;

            protected void processKeyEvent(KeyEvent keyEvent) {
                super.processKeyEvent(keyEvent);
                if (keyEvent.getKeyCode() == 32 && keyEvent.getID() == 401 && this.getColumnClass(this.getSelectedColumn()) == (class$com$netscape$admin$dirserv$config$Encryption == null ? (class$com$netscape$admin$dirserv$config$Encryption = 10.class$("com.netscape.admin.dirserv.config.Encryption")) : class$com$netscape$admin$dirserv$config$Encryption)) {
                    JComboBox jComboBox = (JComboBox)ConfigAttributeEncryptionPanel.this._editor.getComponent();
                    if (!jComboBox.isPopupVisible()) {
                        jComboBox.requestFocus();
                        jComboBox.setPopupVisible(true);
                    } else {
                        jComboBox.hidePopup();
                    }
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        encryptedAttributeTableModel.setTable(this._tAttributes);
        this._tAttributes.setShowGrid(true);
        this._tAttributes.getSelectionModel().addListSelectionListener(this);
        this._lEncryptedAttributes.setLabelFor(this._tAttributes);
        this._editor = new DefaultCellEditor(new JComboBox(this._pwdSchemeDesc));
        AttributeEncryptionRenderer attributeEncryptionRenderer = new AttributeEncryptionRenderer();
        this._tAttributes.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ConfigAttributeEncryptionPanel.class$("java.lang.String")) : class$java$lang$String, attributeEncryptionRenderer);
        this._tAttributes.setDefaultRenderer(class$com$netscape$admin$dirserv$config$Encryption == null ? (class$com$netscape$admin$dirserv$config$Encryption = ConfigAttributeEncryptionPanel.class$("com.netscape.admin.dirserv.config.Encryption")) : class$com$netscape$admin$dirserv$config$Encryption, attributeEncryptionRenderer);
        this._tAttributes.setDefaultEditor(class$com$netscape$admin$dirserv$config$Encryption == null ? (class$com$netscape$admin$dirserv$config$Encryption = ConfigAttributeEncryptionPanel.class$("com.netscape.admin.dirserv.config.Encryption")) : class$com$netscape$admin$dirserv$config$Encryption, this._editor);
        this._tAttributes.setRowHeight((int)this._editor.getComponent().getPreferredSize().getHeight());
        this.checkDeleteButton();
        JLabel jLabel = new JLabel((Icon)DSUtil.getPackageImage("failed.gif"));
        jLabel.setText(ConfigBasePanel._resource.getString("attributeencryptionpanel-ssl-disabled", "label"));
        jLabel.setLabelFor(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        this.SSL_DISABLED.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.SSL_DISABLED.add(Box.createHorizontalGlue(), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._bAddAttribute, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        jPanel.add((Component)this._bDeleteAttribute, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this._contentPanel.add((Component)this.SSL_DISABLED, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.99;
        gridBagConstraints.gridwidth = -1;
        this._contentPanel.add((Component)this._lEncryptedAttributes, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        this._contentPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.99;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        JScrollPane jScrollPane = new JScrollPane(this._tAttributes);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        this._contentPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException {
        String string;
        String[] stringArray;
        String[] stringArray2;
        if (this._lAttributes == null) {
            this._lAttributes = new ArrayList(300);
        } else {
            this._lAttributes.clear();
        }
        LDAPSchema lDAPSchema = DSUtil.getSchema(this.getServerInfo());
        Enumeration enumeration = lDAPSchema.getAttributeNames();
        String[] stringArray3 = DSSchemaHelper.getOperationalAttributes(lDAPSchema);
        while (enumeration.hasMoreElements()) {
            boolean bl = true;
            stringArray2 = (String[])enumeration.nextElement();
            int n = 0;
            while (n < stringArray3.length && bl) {
                bl = !stringArray3[n].equalsIgnoreCase((String)stringArray2);
                ++n;
            }
            if (!bl) continue;
            DSUtil.insertAlphabetically(this._lAttributes, (String)stringArray2);
        }
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        this._htReadAttributes.clear();
        this._lReadOrderedAttributeNames.clear();
        this._htSaveAttributes.clear();
        stringArray2 = new String[]{"cn", "dsEncryptionAlgorithm"};
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=encrypted attributes, " + this._databaseDn, 1, "objectclass=dsAttributeEncryption", stringArray2, false);
        while (lDAPSearchResults.hasMoreElements()) {
            stringArray = lDAPSearchResults.next();
            string = this.getValue((LDAPEntry)stringArray, "cn").toLowerCase();
            Encryption encryption = new Encryption();
            encryption.type = this.getValue((LDAPEntry)stringArray, "dsEncryptionAlgorithm").toLowerCase();
            encryption.isDirty = false;
            encryption.state = Encryption.EXISTING_ATTRIBUTE;
            this._htReadAttributes.put(string, encryption);
            this._htSaveAttributes.put(string, encryption.clone());
            if (encryption.type.equals("cleartext")) continue;
            DSUtil.insertAlphabetically(this._lReadOrderedAttributeNames, string);
        }
        stringArray = new String[]{"nsslapd-security"};
        string = lDAPConnection.read("cn=config", stringArray);
        this._isSSLEnabled = DSUtil.getAttrValue((LDAPEntry)string, "nsslapd-security").equalsIgnoreCase("on");
    }

    private void initComponentsFromServerValues() {
        this._htAttributes.clear();
        Enumeration enumeration = this._htReadAttributes.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this._htAttributes.put(k, this._htReadAttributes.get(k));
        }
        this._lOrderedAttributeNames.clear();
        this._lOrderedAttributeNames.addAll(this._lReadOrderedAttributeNames);
        this.SSL_DISABLED.setVisible(!this._isSSLEnabled);
        this.checkPanelEnabling();
    }

    private void actionAddAttribute() {
        Object[] objectArray;
        Object object;
        this._editor.stopCellEditing();
        Iterator iterator = this._lAttributes.iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>(this._lAttributes.size());
        while (iterator.hasNext()) {
            object = iterator.next();
            objectArray = (Object[])this._htAttributes.get(object);
            if (objectArray == null) {
                arrayList.add(object);
                continue;
            }
            if (objectArray.state == Encryption.ATTRIBUTE_TO_DELETE) {
                arrayList.add(object);
                continue;
            }
            if (!objectArray.type.equals("cleartext")) continue;
            arrayList.add(object);
        }
        object = new ConfigSelectionDialog((JFrame)((Object)this._framework), ConfigBasePanel._resource.getString("attributeencryptionpanel", "addattribute-dlg-title"), arrayList);
        ((ConfigSelectionDialog)object).packAndShow();
        if (!((ConfigSelectionDialog)object).isCancelled()) {
            objectArray = ((ConfigSelectionDialog)object).getSelectedAttributes();
            int n = 0;
            while (n < objectArray.length) {
                String string = ((String)objectArray[n]).toLowerCase();
                Encryption encryption = (Encryption)this._htAttributes.get(string);
                if (encryption != null) {
                    encryption.state = Encryption.EXISTING_ATTRIBUTE;
                    if (encryption.type.equals("cleartext")) {
                        encryption.type = (String)this._pwdSchemeNames.elementAt(0);
                    }
                    Encryption encryption2 = (Encryption)this._htSaveAttributes.get(string);
                    encryption.isDirty = !encryption.type.equals(encryption2.type);
                    DSUtil.insertAlphabetically(this._lOrderedAttributeNames, string);
                } else {
                    encryption = new Encryption();
                    encryption.state = Encryption.ATTRIBUTE_TO_ADD;
                    encryption.type = (String)this._pwdSchemeNames.elementAt(0);
                    encryption.isDirty = true;
                    this._htAttributes.put(string, encryption);
                    DSUtil.insertAlphabetically(this._lOrderedAttributeNames, string);
                }
                ++n;
            }
            this._tAttributes.revalidate();
            this._tAttributes.repaint();
            this.checkDeleteButton();
            this.fireValidDirtyChange();
        }
    }

    private void actionDeleteAttribute() {
        this._editor.stopCellEditing();
        int[] nArray = this._tAttributes.getSelectedRows();
        int n = nArray.length - 1;
        while (n >= 0) {
            String string = (String)this._lOrderedAttributeNames.get(nArray[n]);
            this._lOrderedAttributeNames.remove(nArray[n]);
            Encryption encryption = (Encryption)this._htAttributes.get(string);
            if (encryption.state == Encryption.ATTRIBUTE_TO_ADD) {
                this._htAttributes.remove(string);
            } else {
                encryption.state = Encryption.ATTRIBUTE_TO_DELETE;
                encryption.isDirty = true;
            }
            --n;
        }
        this._tAttributes.revalidate();
        this._tAttributes.repaint();
        this.checkDeleteButton();
        this.fireValidDirtyChange();
    }

    private void fireValidDirtyChange() {
        boolean bl = false;
        if (this._isSSLEnabled) {
            Iterator iterator = this._htAttributes.values().iterator();
            while (iterator.hasNext() && !bl) {
                Encryption encryption = (Encryption)iterator.next();
                boolean bl2 = bl = bl || encryption.isDirty;
            }
        }
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
    }

    private void checkDeleteButton() {
        int n = this._tAttributes.getSelectedRow();
        if (n >= 0 && n < this._tAttributes.getRowCount()) {
            this._bDeleteAttribute.setEnabled(true);
        } else {
            this._bDeleteAttribute.setEnabled(false);
        }
    }

    private void checkPanelEnabling() {
        this._tAttributes.setEnabled(this._isSSLEnabled);
        this._lEncryptedAttributes.setEnabled(this._isSSLEnabled);
        this._bAddAttribute.setEnabled(this._isSSLEnabled);
        if (!this._isSSLEnabled) {
            this._bDeleteAttribute.setEnabled(false);
        } else {
            this.checkDeleteButton();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AttributeEncryptionRenderer
    implements TableCellRenderer {
        private LabelCellRenderer _lRenderer = new LabelCellRenderer();
        JComboBox _combo = new JComboBox(ConfigAttributeEncryptionPanel.access$1700(ConfigAttributeEncryptionPanel.this));

        AttributeEncryptionRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = null;
            if (n2 == 0) {
                jComponent = (JComponent)this._lRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                Encryption encryption = (Encryption)ConfigAttributeEncryptionPanel.this._htAttributes.get(object);
                if (encryption.isDirty) {
                    BlankPanel.setChangeState(jComponent, 2);
                } else {
                    BlankPanel.setChangeState(jComponent, 1);
                }
            } else if (n2 == 1) {
                int n3 = ConfigAttributeEncryptionPanel.this._pwdSchemeNames.indexOf(object);
                this._combo.setSelectedIndex(n3);
                jComponent = this._combo;
                if (bl) {
                    this._combo.setOpaque(true);
                    if (!bl2) {
                        this._combo.setForeground(jTable.getSelectionForeground());
                        this._combo.setBackground(jTable.getSelectionBackground());
                    } else {
                        this._combo.setForeground(jTable.getForeground());
                        this._combo.setBackground(jTable.getBackground());
                    }
                } else {
                    this._combo.setOpaque(false);
                    this._combo.setForeground(jTable.getForeground());
                    this._combo.setBackground(jTable.getBackground());
                }
            } else {
                Thread.dumpStack();
            }
            return jComponent;
        }
    }

    class EncryptedAttributeTableModel
    extends AbstractTableModel {
        private JTable _table;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$com$netscape$admin$dirserv$config$Encryption;

        public void setTable(JTable jTable) {
            this._table = jTable;
        }

        public int getColumnCount() {
            return ConfigAttributeEncryptionPanel.this.TABLE_HEADERS.length;
        }

        public int getRowCount() {
            return ConfigAttributeEncryptionPanel.this._lOrderedAttributeNames.size();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n2 == 0) {
                string = (String)ConfigAttributeEncryptionPanel.this._lOrderedAttributeNames.get(n);
            } else if (n2 == 1) {
                Encryption encryption = (Encryption)ConfigAttributeEncryptionPanel.this._htAttributes.get(ConfigAttributeEncryptionPanel.this._lOrderedAttributeNames.get(n));
                string = encryption.type;
            } else {
                Thread.dumpStack();
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                Encryption encryption = (Encryption)ConfigAttributeEncryptionPanel.this._htAttributes.get(ConfigAttributeEncryptionPanel.this._lOrderedAttributeNames.get(n));
                int n3 = ConfigAttributeEncryptionPanel.this._pwdSchemeDesc.indexOf(object);
                encryption.type = (String)ConfigAttributeEncryptionPanel.this._pwdSchemeNames.elementAt(n3);
                if (encryption.state != Encryption.ATTRIBUTE_TO_ADD) {
                    Encryption encryption2 = (Encryption)ConfigAttributeEncryptionPanel.this._htSaveAttributes.get(ConfigAttributeEncryptionPanel.this._lOrderedAttributeNames.get(n));
                    encryption.isDirty = !encryption.type.equals(encryption2.type);
                }
                this._table.repaint(this._table.getCellRect(n, 0, true));
                this.fireTableRowsUpdated(n, n);
                ConfigAttributeEncryptionPanel.this.fireValidDirtyChange();
            } else {
                Thread.dumpStack();
            }
        }

        public String getColumnName(int n) {
            return ConfigAttributeEncryptionPanel.this.TABLE_HEADERS[n];
        }

        public Class getColumnClass(int n) {
            Class clazz = null;
            if (n == 0) {
                clazz = class$java$lang$String == null ? (class$java$lang$String = EncryptedAttributeTableModel.class$("java.lang.String")) : class$java$lang$String;
            } else if (n == 1) {
                clazz = class$com$netscape$admin$dirserv$config$Encryption == null ? (class$com$netscape$admin$dirserv$config$Encryption = EncryptedAttributeTableModel.class$("com.netscape.admin.dirserv.config.Encryption")) : class$com$netscape$admin$dirserv$config$Encryption;
            } else {
                Thread.dumpStack();
            }
            return clazz;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

