/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSyntaxSchema;

public class ConfigAttributeDialog
extends AbstractDialog
implements ActionListener,
ItemListener,
DocumentListener {
    private String _helpToken;
    private DSFramework _framework;
    private JLabel _lAttributeAliases;
    private JLabel _lAttributeOID;
    private JLabel _lAttributeName;
    private JLabel _lAttributeDesc;
    private JLabel _lAttributeSyntax;
    private JTextField _tfAttributeName;
    private JTextField _tfAttributeAliases;
    private JTextField _tfAttributeOID;
    private JTextField _tfAttributeDesc;
    private JCheckBox _ckbAttributeIsMulti;
    private JComboBox _cmbAttributeSyntax;
    private LDAPAttributeSchema _las = null;
    private boolean _create = false;
    private Hashtable _htSyntaxStrings = null;
    static final String _validsyntax = "abcdefghijklmnopqrstuvwxyz0123456789-_";
    static final ResourceSet _resource = DSConfigPage._resource;

    ConfigAttributeDialog(DSFramework dSFramework) {
        this(dSFramework, null);
        ((Dialog)((Object)this)).setTitle(_resource.getString("schemaattributesdialog", "new-title"));
    }

    ConfigAttributeDialog(DSFramework dSFramework, LDAPAttributeSchema lDAPAttributeSchema) {
        super((Frame)((Object)dSFramework), "", true, 11);
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString("schemaattributesdialog", "description"));
        ((Dialog)((Object)this)).setTitle(_resource.getString("schemaattributesdialog", "edit-title"));
        this._framework = dSFramework;
        this._las = lDAPAttributeSchema;
        this._create = this._las == null;
        this._helpToken = "configuration-schema-attr-create-dbox-help";
        this.setComponent(this.createNewAttributeArea());
        this.checkOkay();
    }

    public String getAttributeName() {
        String string = null;
        if (this._las != null) {
            string = this._las.getName();
        }
        return string;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkOkay();
    }

    public JComponent getDefaultFocusComponent() {
        return this._tfAttributeName;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._ckbAttributeIsMulti)) {
            this.checkOkay();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this._cmbAttributeSyntax)) {
            this.checkOkay();
        }
    }

    protected void okInvoked() {
        Object object;
        Object object2;
        String string = this._tfAttributeName.getText();
        String[] stringArray = DSSchemaHelper.stringToArray(this._tfAttributeAliases.getText().trim());
        boolean bl = false;
        if (this._create && this.getSchema().getAttribute(string) != null) {
            DSUtil.showErrorDialog((Component)((Object)this), "exists", string, "schemaattributesdialog", _resource);
            bl = true;
        }
        if (!bl && stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length && !bl) {
                int n2;
                if (this.getSchema().getAttribute(stringArray[n]) != null && !stringArray[n].equalsIgnoreCase(string) && (n2 = DSUtil.showConfirmationDialog((Component)((Object)this), "exists-alias-attribute", stringArray[n], "schemaattributesdialog", _resource)) != 0) {
                    bl = true;
                }
                ++n;
            }
        }
        if (!bl) {
            Enumeration enumeration = this.getSchema().getAttributes();
            while (enumeration.hasMoreElements() && !bl) {
                LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)enumeration.nextElement();
                String[] stringArray2 = lDAPAttributeSchema.getAliases();
                if (stringArray2 == null) continue;
                int n = 0;
                while (n < stringArray2.length && !bl) {
                    if (stringArray2[n].equalsIgnoreCase(string)) {
                        int n3;
                        object2 = lDAPAttributeSchema.getName();
                        if (!((String)object2).equalsIgnoreCase(string) && (n3 = DSUtil.showConfirmationDialog((Component)((Object)this), "exists-attribute-alias", (String[])(object = new String[]{object2, stringArray2[n]}), "schemaattributesdialog", _resource)) != 0) {
                            bl = true;
                        }
                    } else if (stringArray != null && stringArray.length > 0) {
                        int n4 = 0;
                        while (n4 < stringArray.length && !bl) {
                            String[] stringArray3;
                            int n5;
                            if (stringArray2[n].equalsIgnoreCase(stringArray[n4]) && !((String)(object = lDAPAttributeSchema.getName())).equalsIgnoreCase(string) && (n5 = DSUtil.showConfirmationDialog((Component)((Object)this), "exists-alias-alias", stringArray3 = new String[]{object, stringArray2[n]}, "schemaattributesdialog", _resource)) != 0) {
                                bl = true;
                            }
                            ++n4;
                        }
                    }
                    ++n;
                }
            }
        }
        if (!bl) {
            String string2;
            String string3 = this._tfAttributeOID.getText();
            if (string3 == null || string3.length() == 0) {
                string3 = string + "-oid";
            }
            if ((string2 = this._tfAttributeDesc.getText()) == null) {
                string2 = "User defined attribute";
            }
            boolean bl2 = this._ckbAttributeIsMulti.isSelected();
            String string4 = (String)this._cmbAttributeSyntax.getSelectedItem();
            object2 = this._htSyntaxStrings.keys();
            object = null;
            while (object2.hasMoreElements()) {
                object = (String[])object2.nextElement();
                if (string4.equals(this._htSyntaxStrings.get(object))) break;
            }
            String string5 = null;
            LDAPAttributeSchema lDAPAttributeSchema = new LDAPAttributeSchema(string, string3, string2, (String)object, !bl2, string5, stringArray);
            lDAPAttributeSchema.setQualifier("X-ORIGIN", "user defined");
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = true;
            Object var16_26 = null;
            while (!bl3) {
                try {
                    if (!this._create && !bl4) {
                        try {
                            this._las.remove(this._framework.getServerObject().getServerInfo().getLDAPConnection());
                            bl4 = true;
                        }
                        catch (LDAPException lDAPException) {
                            // empty catch block
                        }
                    }
                    lDAPAttributeSchema.add(this._framework.getServerObject().getServerInfo().getLDAPConnection());
                    this._las = lDAPAttributeSchema;
                    bl3 = true;
                    bl5 = true;
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() != 50) {
                        this.restoreAttr(this._las);
                    }
                    if (lDAPException.getLDAPResultCode() == 50) {
                        DSUtil.showPermissionDialog((Component)((Object)this._framework), this._framework.getServerObject().getServerInfo().getLDAPConnection());
                        bl3 = true;
                        bl5 = false;
                        continue;
                    }
                    if (lDAPException.getLDAPResultCode() == 20 || lDAPException.getLDAPResultCode() == 68) {
                        bl3 = true;
                        bl5 = false;
                        bl6 = false;
                        DSUtil.showErrorDialog((Component)((Object)this._framework), "oidexists", lDAPAttributeSchema.getID(), "schemaattributesdialog", _resource);
                        return;
                    }
                    if (lDAPException.getLDAPResultCode() == 1) {
                        bl3 = true;
                        bl5 = false;
                        bl6 = false;
                        String string6 = lDAPException.getLDAPErrorMessage();
                        if (string6 != null && string6.indexOf("must begin and end with a digit") > 0) {
                            DSUtil.showErrorDialog((Component)((Object)this._framework), "invalid-oid-digit", lDAPAttributeSchema.getID(), "schemaattributesdialog", _resource);
                            continue;
                        }
                        if (string6 != null && string6.indexOf("contains an invalid character") > 0) {
                            bl6 = false;
                            DSUtil.showErrorDialog((Component)((Object)this._framework), "invalid-oid-char", lDAPAttributeSchema.getID(), "schemaattributesdialog", _resource);
                            continue;
                        }
                        bl6 = false;
                        DSUtil.showErrorDialog((Component)((Object)this._framework), "failed-add", DSUtil.getLDAPErrorMessage(lDAPException), "schemaattributesdialog", _resource);
                        continue;
                    }
                    bl3 = true;
                    bl5 = false;
                    bl6 = false;
                    DSUtil.showErrorDialog((Component)((Object)this._framework), "failed-add", DSUtil.getLDAPErrorMessage(lDAPException), "schemaattributesdialog", _resource);
                }
            }
            if (bl5) {
                super.okInvoked();
            } else if (bl6) {
                super.okInvoked();
            }
        }
    }

    protected void cancelInvoked() {
        this._las = null;
        super.cancelInvoked();
    }

    protected void helpInvoked() {
        DSUtil.help(this._helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private void checkOkay() {
        Object object;
        String string;
        boolean bl = true;
        boolean bl2 = false;
        String string2 = this._tfAttributeName.getText();
        if (string2 != null && string2.length() > 0 && this.isValidSchemaSyntax(string2)) {
            bl2 = true;
        }
        bl = bl && bl2;
        boolean bl3 = true;
        if (bl && (string = (string = this._tfAttributeAliases.getText()) == null ? "" : string.trim()).length() > 0 && string2 != null) {
            object = DSSchemaHelper.stringToArray(string);
            int n = 0;
            while (n < ((Object)object).length && bl3) {
                if (((String)object[n]).equalsIgnoreCase(string2)) {
                    bl3 = false;
                }
                ++n;
            }
        }
        bl = bl && bl3;
        boolean bl4 = true;
        if (bl) {
            object = this._tfAttributeOID.getText().trim();
            if (object == null) {
                object = "";
            }
            if (string2 != null && ((String)object).length() > 0 && !((String)object).equalsIgnoreCase(string2 + "-oid")) {
                String string3 = ((String)object).substring(0, 1);
                String string4 = ((String)object).substring(((String)object).length() - 1, ((String)object).length());
                try {
                    int n = Integer.valueOf(string3);
                    int n2 = Integer.valueOf(string4);
                    if (0 > n || n > 9 || 0 > n2 || n2 > 9) {
                        bl4 = false;
                    }
                    if (bl4) {
                        int n3 = 1;
                        while (n3 < ((String)object).length() - 1) {
                            int n4;
                            String string5 = ((String)object).substring(n3, n3 + 1);
                            if (!(string5.equals(".") || 0 <= (n4 = Integer.valueOf(string5).intValue()) && n4 <= 9)) {
                                bl4 = false;
                            }
                            ++n3;
                        }
                    }
                }
                catch (Exception exception) {
                    bl4 = false;
                }
            }
        }
        bl = bl && bl4;
        this.setOKButtonEnabled(bl);
    }

    private boolean isValidSchemaSyntax(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string, 0);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (_validsyntax.indexOf(Character.toLowerCase(c)) == -1) {
                return false;
            }
            c = stringCharacterIterator.next();
        }
        return true;
    }

    protected JPanel createNewAttributeArea() {
        Object object;
        Object object2;
        this._lAttributeName = UIFactory.makeJLabel("schemaattributesdialog", "newname", _resource);
        this._tfAttributeName = UIFactory.makeJTextField(this, "schemaattributesdialog", "newname", null, 20, _resource);
        this._lAttributeName.setLabelFor(this._tfAttributeName);
        this._lAttributeAliases = UIFactory.makeJLabel("schemaattributesdialog", "newaliases", _resource);
        this._tfAttributeAliases = UIFactory.makeJTextField(this, "schemaattributesdialog", "newaliases", null, 20, _resource);
        this._lAttributeAliases.setLabelFor(this._tfAttributeAliases);
        this._lAttributeOID = UIFactory.makeJLabel("schemaattributesdialog", "newoid", _resource);
        this._tfAttributeOID = UIFactory.makeJTextField(this, "schemaattributesdialog", "newoid", null, 20, _resource);
        this._lAttributeOID.setLabelFor(this._tfAttributeOID);
        this._lAttributeDesc = UIFactory.makeJLabel("schemaattributesdialog", "newdesc", _resource);
        this._tfAttributeDesc = UIFactory.makeJTextField(this, "schemaattributesdialog", "newdesc", null, 20, _resource);
        this._lAttributeDesc.setLabelFor(this._tfAttributeDesc);
        this._ckbAttributeIsMulti = UIFactory.makeJCheckBox(this, "schemaattributesdialog", "newmulti", false, _resource);
        this._ckbAttributeIsMulti.setSelected(true);
        this._ckbAttributeIsMulti.addActionListener(this);
        this._lAttributeSyntax = UIFactory.makeJLabel("schemaattributesdialog", "newsyntax", _resource);
        this._cmbAttributeSyntax = UIFactory.makeJComboBox(this, "schemaattributesdialog", "newsyntax", null, _resource);
        this._lAttributeSyntax.setLabelFor(this._cmbAttributeSyntax);
        this._cmbAttributeSyntax = UIFactory.makeJComboBox(this, null);
        UIFactory.setToolTip("schemaattributesdialog", "newsyntax", this._cmbAttributeSyntax, _resource);
        this._htSyntaxStrings = new Hashtable();
        LDAPSchema lDAPSchema = this.getSchema();
        Enumeration enumeration = lDAPSchema.getSyntaxes();
        while (enumeration.hasMoreElements()) {
            object2 = (LDAPSyntaxSchema)enumeration.nextElement();
            if (object2 == null) continue;
            object = object2.getDescription();
            this._htSyntaxStrings.put(object2.getID(), object);
            this._cmbAttributeSyntax.addItem(object);
        }
        object2 = new JPanel(new GridBagLayout());
        ((JComponent)object2).setBorder(new EmptyBorder(0, 0, 0, 0));
        object = new GridBagConstraints();
        int n = UIFactory.getDifferentSpace();
        Insets insets = new Insets(0, 0, n, 0);
        Insets insets2 = new Insets(0, 0, n, 0);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 12;
        ((GridBagConstraints)object).gridwidth = -1;
        ((GridBagConstraints)object).insets = insets;
        ((GridBagConstraints)object).weightx = 0.0;
        ((Container)object2).add((Component)this._lAttributeName, object);
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).insets = insets2;
        ((Container)object2).add((Component)this._tfAttributeName, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 12;
        ((GridBagConstraints)object).gridwidth = -1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).insets = insets;
        ((Container)object2).add((Component)this._lAttributeOID, object);
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).insets = insets2;
        ((Container)object2).add((Component)this._tfAttributeOID, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 12;
        ((GridBagConstraints)object).gridwidth = -1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).insets = insets;
        ((Container)object2).add((Component)this._lAttributeAliases, object);
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).insets = insets2;
        ((Container)object2).add((Component)this._tfAttributeAliases, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 12;
        ((GridBagConstraints)object).gridwidth = -1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).insets = insets;
        ((Container)object2).add((Component)this._lAttributeDesc, object);
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).insets = insets2;
        ((Container)object2).add((Component)this._tfAttributeDesc, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 12;
        ((GridBagConstraints)object).gridwidth = -1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).insets = insets;
        ((Container)object2).add((Component)this._lAttributeSyntax, object);
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).insets = insets2;
        ((Container)object2).add((Component)this._cmbAttributeSyntax, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).anchor = 12;
        ((GridBagConstraints)object).gridwidth = -1;
        ((Container)object2).add(Box.createGlue(), object);
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).insets = insets;
        ((GridBagConstraints)object).insets.bottom = 0;
        ((Container)object2).add((Component)this._ckbAttributeIsMulti, object);
        if (this._las != null) {
            this._tfAttributeName.setText(this._las.getName());
            this._tfAttributeOID.setText(this._las.getID());
            this._tfAttributeAliases.setText(DSSchemaHelper.arrayToString(this._las.getAliases()));
            this._tfAttributeDesc.setText(this._las.getDescription());
            String string = (String)this._htSyntaxStrings.get(this._las.getSyntaxString());
            if (string != null) {
                this._cmbAttributeSyntax.setSelectedItem(string);
            }
            this._ckbAttributeIsMulti.setSelected(!this._las.isSingleValued());
        } else {
            this._tfAttributeName.setText(_resource.getString("schemaattributesdialog", "newname-default"));
        }
        this.setFocusComponent(this._tfAttributeName);
        return object2;
    }

    private boolean attributeExists(String string) {
        LDAPAttributeSchema lDAPAttributeSchema = null;
        LDAPSchema lDAPSchema = this.getSchema();
        if (lDAPSchema != null) {
            LDAPSchema lDAPSchema2 = lDAPSchema;
            synchronized (lDAPSchema2) {
                lDAPAttributeSchema = lDAPSchema.getAttribute(string);
            }
        }
        return lDAPAttributeSchema != null;
    }

    private void restoreAttr(LDAPAttributeSchema lDAPAttributeSchema) {
        if (lDAPAttributeSchema == null) {
            return;
        }
        try {
            lDAPAttributeSchema.add(this._framework.getServerObject().getServerInfo().getLDAPConnection());
        }
        catch (LDAPException lDAPException) {
            DSUtil.showErrorDialog((Component)((Object)this._framework), "failed-add", lDAPException.toString(), "schemaattributesdialog", _resource);
        }
    }

    private LDAPSchema getSchema() {
        return DSUtil.getSchema(this._framework.getServerObject().getServerInfo());
    }
}

