/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class VLVCache {
    private Hashtable _htVlvIndex = new Hashtable();
    public static Integer HAS_INDEX = new Integer(1);
    public static Integer HAS_NOT_INDEX = new Integer(2);
    public static Integer CANNOT_HAVE_INDEX = new Integer(3);
    private static DN CONFIG_DN = new DN("cn=config");
    private static DN SCHEMA_DN = new DN("cn=schema");
    private static DN MONITOR_DN = new DN("cn=monitor");
    private static DN ROOT_DN = new DN("");

    public void reload(LDAPConnection lDAPConnection) throws LDAPException {
        LDAPAttribute lDAPAttribute;
        this._htVlvIndex.clear();
        String[] stringArray = new String[]{"vlvsearch"};
        LDAPEntry lDAPEntry = lDAPConnection.read("", stringArray);
        if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("vlvsearch")) != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                String[] stringArray2;
                LDAPEntry lDAPEntry2;
                block4: {
                    String string = (String)enumeration.nextElement();
                    if (!string.startsWith("cn=MCC")) continue;
                    lDAPEntry2 = null;
                    try {
                        stringArray2 = new String[]{"vlvBase"};
                        lDAPEntry2 = lDAPConnection.read(string, stringArray2);
                    }
                    catch (LDAPException lDAPException) {
                        if (lDAPException.getLDAPResultCode() == 32) break block4;
                        throw lDAPException;
                    }
                }
                if (lDAPEntry2 == null || (stringArray2 = lDAPEntry2.getAttribute("vlvBase")) == null) continue;
                String string = (String)stringArray2.getStringValues().nextElement();
                this._htVlvIndex.put(string, HAS_INDEX);
            }
        }
    }

    public Integer getVlvState(String string) {
        Integer n = (Integer)this._htVlvIndex.get(string);
        if (n == null) {
            if (this.canHaveIndex(string)) {
                n = HAS_NOT_INDEX;
                this._htVlvIndex.put(string, HAS_NOT_INDEX);
            } else {
                n = CANNOT_HAVE_INDEX;
                this._htVlvIndex.put(string, CANNOT_HAVE_INDEX);
            }
        }
        return n;
    }

    public void vlvIndexCreated(String string) {
        this._htVlvIndex.put(string, HAS_INDEX);
    }

    public void vlvIndexDeleted(String string) {
        this._htVlvIndex.put(string, HAS_NOT_INDEX);
    }

    private boolean canHaveIndex(String string) {
        DN dN = new DN(string);
        boolean bl = !dN.equals(CONFIG_DN) && !dN.isDescendantOf(CONFIG_DN) && !dN.equals(SCHEMA_DN) && !dN.equals(MONITOR_DN) && !dN.isDescendantOf(MONITOR_DN) && !dN.equals(ROOT_DN);
        return bl;
    }
}

