/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.account.AccountInactivation;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class Activator
implements ActionListener,
Runnable {
    boolean _taskCancelled = false;
    DSFramework _framework;
    GenericProgressDialog _dlg;
    String _dn;
    LDAPConnection _ldc;

    public Activator(DSFramework dSFramework, String string, LDAPConnection lDAPConnection) {
        this._framework = dSFramework;
        this._dn = string;
        this._ldc = lDAPConnection;
    }

    public void execute() {
        this.createActivateProgressDialog();
        Thread thread = new Thread(this);
        thread.start();
        this._dlg.packAndShow();
    }

    protected void createActivateProgressDialog() {
        String string = DSUtil._resource.getString("accountinactivation-activate", "title");
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 7, string, null, null);
        this._dlg.setTextInTextAreaLabel(DSUtil._resource.getString("accountinactivation-activate", "rejected-objects"));
        this._dlg.setTextAreaRows(5);
        this._dlg.setTextAreaColumns(30);
        this._dlg.setLabelColumns(50);
        this._dlg.setLocationRelativeTo((Component)((Object)this._framework));
        this._dlg.pack();
        this._taskCancelled = false;
        this._dlg.addActionListener(this);
        this._dlg.enableButtons(true);
    }

    public void run() {
        block14: {
            String[] stringArray = new String[]{"nsrole", "nsroledn", "objectclass", "nsAccountLock"};
            try {
                LDAPEntry lDAPEntry = this._ldc.read(this._dn, stringArray);
                if (lDAPEntry == null) break block14;
                DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
                AccountInactivation accountInactivation = new AccountInactivation(lDAPEntry, databaseConfig);
                int n = accountInactivation.activate(this._ldc);
                String string = DSUtil.abreviateString(lDAPEntry.getDN(), 45);
                String[] stringArray2 = new String[]{string};
                this._dlg.setTextInLabel(DSUtil._resource.getString("accountinactivation-activate", "entry", stringArray2));
                switch (n) {
                    case 4: {
                        this._dlg.appendTextToTextArea(DSUtil._resource.getString("accountinactivation-activate", "inactivatedthroughunknownmechanics", string) + "\n");
                        break;
                    }
                    case 1: {
                        this._dlg.appendTextToTextArea(DSUtil._resource.getString("accountinactivation-activate", "unknown-error", string) + "\n");
                        break;
                    }
                    case 2: {
                        Vector vector = null;
                        try {
                            vector = accountInactivation.getLockingRoles(this._ldc);
                        }
                        catch (LDAPException lDAPException) {
                            // empty catch block
                        }
                        if (vector != null) {
                            String string2 = "";
                            int n2 = 0;
                            while (n2 < vector.size()) {
                                string2 = string2 + "'" + DSUtil.abreviateString((String)vector.elementAt(n2), 45) + "'" + "\n";
                                ++n2;
                            }
                            String[] stringArray3 = new String[]{string, string2};
                            this._dlg.appendTextToTextArea(DSUtil._resource.getString("accountinactivation-activate", "cannotactivate", stringArray3) + "\n");
                            break;
                        }
                        this._dlg.appendTextToTextArea(DSUtil._resource.getString("accountinactivation-activate", "cannotactivate-lockingrolesnotfound", string) + "\n");
                        break;
                    }
                    case 7: {
                        this._dlg.appendTextToTextArea(DSUtil._resource.getString("accountinactivation-activate", "rootorconfigentry", string) + "\n");
                        break;
                    }
                }
            }
            catch (LDAPException lDAPException) {
                String string = DSUtil.abreviateString(this._dn, 45);
                String string3 = DSUtil.getLDAPErrorMessage(lDAPException);
                String[] stringArray4 = new String[]{this._dn, string3};
                this._dlg.appendTextToTextArea(DSUtil._resource.getString("accountinactivation-activate", "errorreadingentry", stringArray4) + "\n");
            }
        }
        if (this._taskCancelled) {
            this._dlg.closeCallBack();
        } else {
            this._dlg.setTextInLabel(DSUtil._resource.getString("accountinactivation-activate", "finished"));
            this._dlg.waitForClose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._taskCancelled = true;
            this._dlg.disableCancelButton();
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            this._dlg.closeCallBack();
        }
    }
}

