/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.attredit;

import com.netscape.admin.dirserv.attredit.AttributeEditorFactory;
import com.netscape.admin.dirserv.attredit.IAttributeEditor;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import netscape.ldap.LDAPSchema;

public class AttributeEditor
extends JPanel
implements IAttributeEditor,
MouseListener,
FocusListener {
    protected Container _parent = null;
    private JPanel _list;
    protected Vector _values = new Vector();
    protected LDAPSchema _schema = null;
    private Rectangle _labelBounds = null;
    private JLabel _label;
    private String _labelText = null;
    private String _name = null;
    private Color _labelColor = UIManager.getColor("text");
    private Font _labelFont = null;
    private boolean _singleValued = false;
    private boolean _initialized = false;
    private boolean _dirty = false;
    protected JPopupMenu _contextMenu = null;
    protected Vector _fields = new Vector();
    private boolean _isSelected = false;
    protected Component _focusField = null;
    private GridBagConstraints _c = null;
    protected JComponent _blankField = null;
    protected Border _textBorder = null;
    protected Color _textBackground = Color.white;
    protected Color _textColor = UIManager.getColor("textText");
    protected Font _textFont = null;
    private Rectangle _defaultBounds = null;
    protected boolean _isReadOnly;

    public AttributeEditor() {
        this.addMouseListener(this);
        this.addFocusListener(this);
    }

    private void setLabelRect(Rectangle rectangle) {
        this.createLabel();
        this._labelBounds = rectangle;
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        this._label.setPreferredSize(dimension);
        this._label.setMinimumSize(dimension);
        this._label.addMouseListener(this);
    }

    public void setParent(Container container) {
        this._parent = container;
    }

    protected void createLabel(String string) {
        if (this._label == null) {
            this._label = UIFactory.makeJLabel(string);
            if (this._labelFont != null) {
                this._label.setFont(this._labelFont);
            }
            this._label.setHorizontalAlignment(4);
        } else {
            this._label.setText(string);
        }
    }

    protected void createLabel() {
        String string = this.getLabelText() != null ? this.getLabelText() : "";
        this.createLabel(string);
    }

    public void init() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLayout(new GridBagLayout());
        JComponent jComponent = this.makeField();
        this._textBorder = jComponent.getBorder();
        this.addComponent(this._label, 0, 0, 1, 1, 3, 11, 0.0, 1.0);
        this._list = new JPanel();
        this._list.setLayout(new ListLayout());
        this.addComponent(this._list, 1, 0, 0, 1, 2, 17, 1.0, 0.0);
    }

    public void init(String string, String string2, Rectangle rectangle, boolean bl, boolean bl2) {
        this.setName(string);
        this._singleValued = bl;
        this._isReadOnly = bl2;
        this.setLabelText(string2);
        this.setLabelRect(rectangle);
        this.setLabelToolTip(string);
        this.init();
    }

    public boolean isFocusTraversable() {
        return this._fields.size() < 1;
    }

    public int getValueCount() {
        return this._values.size();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public void setDirty() {
        this.setDirty(true);
    }

    public boolean isBinary() {
        return true;
    }

    public boolean isSingleValued() {
        return this._singleValued;
    }

    public void setLabelColor(Color color) {
        this._labelColor = color;
    }

    public void setLabelFont(Font font) {
        this._labelFont = font;
    }

    public void setLabelText(String string) {
        this._labelText = string;
        this.createLabel(string);
    }

    public void setLabelToolTip(String string) {
        this._label.setToolTipText(string);
    }

    public void addValue(Object object) {
        this._values.addElement(object);
        JComponent jComponent = this.fetchField(object);
        if (this._label != null) {
            this._label.setLabelFor(jComponent);
        }
        this.addField(jComponent);
        this._list.add(jComponent);
        jComponent.requestFocus();
        Dimension dimension = new Dimension(this._labelBounds.width, this._labelBounds.height);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        this.invalidate();
        this.validate();
        this.setDirty();
    }

    public void addValue() {
        this.addValue(this.getDefaultValue());
    }

    public Vector getValues() {
        return this._values;
    }

    public Object getValue(int n) {
        if (this._values.size() > n) {
            return this._values.elementAt(n);
        }
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public void deleteValue(int n) {
        Debug.println((String)("AttributeEditor.deleteValue: index " + n));
        Vector vector = this.getValues();
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < vector.size()) {
            if (n2 != n) {
                vector2.addElement(vector.elementAt(n2));
            }
            ++n2;
        }
        int n3 = vector2.size();
        this.deleteValues();
        this.init();
        int n4 = 0;
        while (n4 < n3) {
            try {
                this.addValue(vector2.elementAt(n4));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n4;
        }
        if (n3 > 0) {
            ((Component)this._fields.elementAt(0)).requestFocus();
        } else {
            this.requestFocus();
        }
        this.setDirty();
    }

    public void deleteValue(Object object) {
        Debug.println((String)("AttributeEditor.deleteValue: " + object.getClass().getName()));
        if (object == null) {
            return;
        }
        int n = this._fields.indexOf(object);
        if (n >= 0) {
            this.deleteValue(n);
        } else {
            Debug.println((String)("No recollection of " + object + ", <" + ((JTextField)object).getText() + ">"));
        }
    }

    public void deleteValues() {
        this.removeAll();
        this._fields.removeAllElements();
        this._values.removeAllElements();
        this.setDirty();
    }

    public void replaceValue(Object object, int n) {
        this._values.setElementAt(object, n);
    }

    public void setAllowedValues(Vector vector) {
    }

    public int getFieldIndex(Object object) {
        int n = this._fields.indexOf(object);
        return n;
    }

    public void setSchema(LDAPSchema lDAPSchema) {
        this._schema = lDAPSchema;
    }

    public void addField(Component component) {
        this._label.setLabelFor(component);
        this._fields.addElement(component);
        this._focusField = component;
    }

    public String getLabelText() {
        return this._labelText;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setContextMenu(JPopupMenu jPopupMenu) {
    }

    protected Window getOwnerWindow() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private boolean isFocusInHierarchy() {
        Window window = this.getOwnerWindow();
        Component component = window.getFocusOwner();
        return this.equals(component) || this.isAncestorOf(component);
    }

    public void setSelected(boolean bl) {
        this._isSelected = bl;
        if (this._isSelected && !this.isFocusInHierarchy()) {
            this.requestFocus();
        }
        this.repaint();
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        Debug.println((String)("AttributeEditor.focusGained: focus on " + component));
        if (AttributeEditorFactory.isEditor(component.getClass().getName())) {
            if (this._fields.size() > 0) {
                Debug.println((String)("AttributeEditor.focusGained: requesting focus to " + this._fields.elementAt(0)));
                ((Component)this._fields.elementAt(0)).requestFocus();
            }
        } else if (!(component instanceof JLabel)) {
            this._focusField = component;
            Debug.println((String)("AttributeEditor.focusGained: new focus is on " + this._focusField));
        }
        Container container = this.getParent();
        while (container != null && !(container instanceof FocusListener)) {
            container = container.getParent();
        }
        if (container != null) {
            Debug.println((String)("AttributeEditor.focusGained: dispatching to " + container));
            ((FocusListener)((Object)container)).focusGained(focusEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.repaint();
        }
    }

    public Component getFocusField() {
        return this._focusField;
    }

    public boolean isDeletable() {
        return !this._isReadOnly;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    protected JComponent fetchField(Object object) {
        return null;
    }

    protected JComponent makeField() {
        return null;
    }

    public void paintComponent(Graphics graphics) {
        if (!this._isSelected) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            super.paintComponent(graphics);
        } else {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            super.paintComponent(graphics);
        }
    }

    public JComponent getLastFocusableComponent() {
        return this;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Debug.println((String)("AttributeEditor.mouseClicked " + mouseEvent + ", parent = " + this.getParent()));
        this.focusGained(new FocusEvent(this, 1004));
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void registerEditors() {
    }

    void addComponent(JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7) {
        if (this._c == null) {
            this.setLayout(new GridBagLayout());
            this._c = new GridBagConstraints();
            this._c.insets = new Insets(1, 6, 1, 6);
        }
        this._c.gridx = n;
        this._c.gridy = n2;
        this._c.gridwidth = n3;
        this._c.gridheight = n4;
        this._c.fill = n5;
        this._c.anchor = n6;
        this._c.weightx = d;
        this._c.weighty = d2;
        if (n7 == -1) {
            this.add((Component)jComponent, this._c);
        } else {
            this.add(jComponent, this._c, n7);
        }
    }

    void addComponent(JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2) {
        this.addComponent(jComponent, n, n2, n3, n4, n5, n6, d, d2, -1);
    }

    protected Container getEditorParent() {
        return this._parent;
    }

    class ListLayout
    implements LayoutManager2 {
        ListLayout() {
        }

        public void layoutContainer(Container container) {
            int n = 0;
            int n2 = 0;
            while (n2 < container.getComponentCount()) {
                Component component = container.getComponent(n2);
                if (component.isVisible()) {
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(0, n, container.getBounds().width, dimension.height);
                    n += dimension.height;
                }
                ++n2;
            }
        }

        public Dimension getDimensions(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < container.getComponentCount()) {
                Component component = container.getComponent(n3);
                if (component.isVisible()) {
                    Dimension dimension = component.getPreferredSize();
                    n2 += dimension.height;
                    n = Math.max(n, dimension.width);
                }
                ++n3;
            }
            return new Dimension(n, n2);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.getDimensions(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.getDimensions(container);
        }

        public Dimension maximumLayoutSize(Container container) {
            return this.getDimensions(container);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void invalidateLayout(Container container) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }
    }
}

