/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.account;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.util.AbstractModalDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class InactivatingRoleDialog
extends AbstractModalDialog
implements SuiConstants,
ListSelectionListener {
    Vector _roleList;
    RoleTableModel _tableModel = new RoleTableModel();
    LDAPConnection _ldc;
    Hashtable _cnTable = new Hashtable();
    Hashtable _descriptionTable = new Hashtable();
    Table _table = new Table((TableModel)this._tableModel);
    JLabel _dnLabel;
    private static final ResourceSet _resource = DSUtil._resource;
    private static final String _section = "inactivatingRoleDialog";
    private static final String CN_ATTR = "cn";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String OBJECTCLASS_ATTR = "objectclass";
    private static final String[] BASIC_ATTRS = new String[]{"cn", "description", "objectclass"};
    private static final String NO_DN = "";

    public InactivatingRoleDialog(Frame frame) {
        super(frame, _resource.getString(_section, "title"), 4);
        this._table.setAutoResizeMode(5);
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.setPreferredScrollableViewportSize(new Dimension(350, 200));
        this._dnLabel = new JLabel(_resource.getString(_section, "dn-prefix"));
        this.layoutComponents();
    }

    public void setRoleList(Vector vector, LDAPConnection lDAPConnection) {
        this._roleList = vector;
        this._ldc = lDAPConnection;
        this._cnTable.clear();
        this._descriptionTable.clear();
        Enumeration enumeration = this._roleList.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.loadRole(string);
        }
    }

    void layoutComponents() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JLabel jLabel = new JLabel(_resource.getString(_section, "label"));
        gridBagConstraints.weighty = 0.0;
        container.add((Component)jLabel, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane((Component)this._table);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this._dnLabel, gridBagConstraints);
        this.pack();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        String string = n == -1 || n2 - n + 1 > 1 ? NO_DN : (String)this._roleList.elementAt(n);
        this._dnLabel.setText(_resource.getString(_section, "dn-prefix") + string);
    }

    void loadRole(String string) {
        String string2 = NO_DN;
        String string3 = NO_DN;
        try {
            LDAPEntry lDAPEntry = DSUtil.readEntry(this._ldc, string, BASIC_ATTRS, null);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(CN_ATTR);
            string2 = lDAPAttribute == null ? NO_DN : lDAPAttribute.getStringValueArray()[0];
            lDAPAttribute = lDAPEntry.getAttribute(DESCRIPTION_ATTR);
            string3 = lDAPAttribute == null ? NO_DN : lDAPAttribute.getStringValueArray()[0];
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("InactivatingRoleDialog.loadRole: failed to read " + string));
            string2 = string;
            string3 = NO_DN;
        }
        this._cnTable.put(string, string2);
        this._descriptionTable.put(string, string3);
    }

    class RoleTableModel
    extends AbstractTableModel {
        RoleTableModel() {
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return _resource.getString(InactivatingRoleDialog._section, "header-name");
            }
            return _resource.getString(InactivatingRoleDialog._section, "header-description");
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return InactivatingRoleDialog.this._roleList == null ? 0 : InactivatingRoleDialog.this._roleList.size();
        }

        public Object getValueAt(int n, int n2) {
            String string = (String)InactivatingRoleDialog.this._roleList.elementAt(n);
            String string2 = null;
            string2 = n2 == 0 ? (String)InactivatingRoleDialog.this._cnTable.get(string) : (String)InactivatingRoleDialog.this._descriptionTable.get(string);
            if (string2 == null) {
                string2 = "...";
            }
            return string2;
        }

        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }

        public void fireTableRowsDeleted(int n, int n2) {
            super.fireTableRowsDeleted(n, n2);
        }

        public void fireTableRowsInserted(int n, int n2) {
            super.fireTableRowsInserted(n, n2);
        }
    }
}

