/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IMenuItemCategory;
import com.netscape.management.client.MenuItemCheckBox;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public abstract class MenuController {
    protected JPopupMenu _contextMenu;
    protected ActionListener _listener;
    protected IFramework _framework;
    protected Vector _shortcutRegisterers = new Vector(2);
    protected Hashtable _shortCutTable;

    public MenuController(JPopupMenu jPopupMenu, IFramework iFramework, ActionListener actionListener) {
        this._framework = iFramework;
        this._listener = actionListener;
        this._contextMenu = jPopupMenu;
        this.createShortCutKeys();
    }

    public void addShortCutRegisterer(JComponent jComponent) {
        this._shortcutRegisterers.addElement(jComponent);
    }

    public void populateMenuItems() {
        String[] stringArray = this.getMenuCategoryIDs();
        int n = 0;
        while (n < stringArray.length) {
            this.populateMenuCategory(stringArray[n]);
            ++n;
        }
    }

    public void unpopulateMenuItems() {
        String[] stringArray = this.getMenuCategoryIDs();
        int n = stringArray.length - 1;
        while (n >= 0) {
            this.unpopulateMenuCategory(stringArray[n]);
            --n;
        }
    }

    protected void addShortCuts(IMenuItem[] iMenuItemArray) {
        int n = 0;
        while (n < iMenuItemArray.length) {
            KeyStroke keyStroke;
            MenuItemText menuItemText;
            String string;
            if (iMenuItemArray[n] instanceof MenuItemText && (string = (menuItemText = (MenuItemText)iMenuItemArray[n]).getID()) != null && (keyStroke = (KeyStroke)this._shortCutTable.get(string)) != null) {
                menuItemText.setAccelerator(keyStroke);
                Enumeration enumeration = this._shortcutRegisterers.elements();
                while (enumeration.hasMoreElements()) {
                    JComponent jComponent = (JComponent)enumeration.nextElement();
                    jComponent.registerKeyboardAction(this._listener, menuItemText.getID(), menuItemText.getAccelerator(), 1);
                }
            }
            ++n;
        }
    }

    protected void setActionCommand(IMenuItem[] iMenuItemArray) {
        int n = 0;
        while (n < iMenuItemArray.length) {
            if (iMenuItemArray[n] instanceof MenuItemText) {
                ((MenuItemText)iMenuItemArray[n]).setActionCommand(iMenuItemArray[n].getID());
            } else if (iMenuItemArray[n] instanceof MenuItemCheckBox) {
                ((MenuItemCheckBox)iMenuItemArray[n]).setActionCommand(iMenuItemArray[n].getID());
            }
            ++n;
        }
    }

    protected void populateMenuCategory(String string) {
        IMenuItem[] iMenuItemArray = this.getMenuItems(string);
        if (iMenuItemArray != null) {
            if (string == "CONTEXT") {
                Debug.println((String)("MenuController.populateMenuCategory() adding " + string + " to context menu"));
                int n = 0;
                while (n < iMenuItemArray.length) {
                    this._contextMenu.add(iMenuItemArray[n].getComponent());
                    ++n;
                }
            } else {
                JMenu jMenu = this.getMenu(this._contextMenu, string);
                if (jMenu != null) {
                    Debug.println((String)("MenuController.populateMenuCategory() adding " + string + " to some menu"));
                    int n = 0;
                    while (n < iMenuItemArray.length) {
                        jMenu.add(iMenuItemArray[n].getComponent());
                        ++n;
                    }
                } else if (this._framework != null) {
                    Debug.println((String)("MenuController.populateMenuCategory() adding " + string + " to Framework"));
                    int n = 0;
                    while (n < iMenuItemArray.length) {
                        this._framework.addMenuItem(string, iMenuItemArray[n]);
                        ++n;
                    }
                }
            }
        } else {
            Debug.println((String)("MenuController.populateMenuCategory() " + string + " has no menu items"));
        }
    }

    protected void unpopulateMenuCategory(String string) {
        IMenuItem[] iMenuItemArray = this.getMenuItems(string);
        if (iMenuItemArray != null) {
            if (string == "CONTEXT") {
                Debug.println((String)("MenuController.unpopulateMenuCategory() removing " + string + " from context"));
                int n = 0;
                while (n < iMenuItemArray.length) {
                    this._contextMenu.remove(iMenuItemArray[n].getComponent());
                    ++n;
                }
            } else {
                JMenu jMenu = this.getMenu(this._contextMenu, string);
                if (jMenu != null) {
                    Debug.println((String)("MenuController.unpopulateMenuCategory() removing " + string + " from menu"));
                    int n = 0;
                    while (n < iMenuItemArray.length) {
                        this.removeMenuItem(jMenu, iMenuItemArray[n]);
                        ++n;
                    }
                } else if (this._framework != null) {
                    Debug.println((String)("MenuController.unpopulateMenuCategory() removing " + string + " from framework"));
                    int n = 0;
                    while (n < iMenuItemArray.length) {
                        this._framework.removeMenuItem(iMenuItemArray[n]);
                        ++n;
                    }
                }
            }
        } else {
            Debug.println((String)("MenuController.unpopulateMenuCategory() " + string + " has no menu items"));
        }
    }

    protected JMenu getMenu(JPopupMenu jPopupMenu, String string) {
        JMenu jMenu = null;
        int n = 0;
        while (n < jPopupMenu.getComponentCount()) {
            JMenu jMenu2;
            Component component = jPopupMenu.getComponent(n);
            if (component instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)component).getID())) {
                jMenu = (JMenu)((IMenuItemCategory)component).getComponent();
                break;
            }
            if (component instanceof JMenu && (jMenu2 = this.getMenu((JMenu)component, string)) != null) {
                jMenu = jMenu2;
                break;
            }
            ++n;
        }
        return jMenu;
    }

    protected JMenu getMenu(JMenu jMenu, String string) {
        JMenu jMenu2 = null;
        int n = 0;
        while (n < jMenu.getMenuComponentCount()) {
            JMenu jMenu3;
            Component component = jMenu.getMenuComponent(n);
            if (component instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)component).getID())) {
                jMenu2 = (JMenu)((IMenuItemCategory)component).getComponent();
                break;
            }
            if (component instanceof JMenu && (jMenu3 = this.getMenu((JMenu)component, string)) != null) {
                jMenu2 = jMenu3;
                break;
            }
            ++n;
        }
        return jMenu2;
    }

    protected JMenu getMenu(JMenuBar jMenuBar, String string) {
        JMenu jMenu = null;
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu2;
            JMenu jMenu3 = jMenuBar.getMenu(n);
            if (jMenu3 instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)jMenu3).getID())) {
                jMenu = (JMenu)((IMenuItemCategory)jMenu3).getComponent();
                break;
            }
            if (jMenu3 instanceof JMenu && (jMenu2 = this.getMenu(jMenu3, string)) != null) {
                jMenu = jMenu2;
                break;
            }
            ++n;
        }
        return jMenu;
    }

    protected boolean removeMenuItem(JMenu jMenu, IMenuItem iMenuItem) {
        boolean bl = false;
        int n = 0;
        while (n < jMenu.getMenuComponentCount()) {
            Component component = jMenu.getMenuComponent(n);
            if (component instanceof IMenuItem && component == iMenuItem) {
                jMenu.remove(n);
                bl = true;
                break;
            }
            if (component instanceof JMenu && this.removeMenuItem((JMenu)component, iMenuItem)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    protected void setEnabledMenuItem(IMenuItem[] iMenuItemArray, String string, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < iMenuItemArray.length && !bl2) {
            if (iMenuItemArray[n].getID().equals(string)) {
                bl2 = true;
                if (iMenuItemArray[n] instanceof JMenuItem) {
                    ((JMenuItem)iMenuItemArray[n]).setEnabled(bl);
                }
            }
            ++n;
        }
    }

    protected void setEnabledMenuItem(IMenuItem[] iMenuItemArray, boolean bl) {
        int n = 0;
        while (n < iMenuItemArray.length) {
            if (iMenuItemArray[n] instanceof JMenuItem) {
                ((JMenuItem)iMenuItemArray[n]).setEnabled(bl);
            }
            ++n;
        }
    }

    protected void setCheckedMenuItem(IMenuItem[] iMenuItemArray, String string, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < iMenuItemArray.length && !bl2) {
            Debug.println((String)("ContentMenuController.setCheckedMenuItem() ID " + iMenuItemArray[n].getID()));
            if (iMenuItemArray[n].getID().equals(string)) {
                bl2 = true;
                if (iMenuItemArray[n] instanceof MenuItemCheckBox) {
                    ((MenuItemCheckBox)iMenuItemArray[n]).setChecked(bl);
                }
            }
            ++n;
        }
    }

    protected abstract String[] getMenuCategoryIDs();

    protected abstract IMenuItem[] getMenuItems(String var1);

    protected abstract void createShortCutKeys();
}

