/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.StateBox;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class GenericProgressDialog
extends JDialog {
    protected int _options;
    protected int _currentStep;
    protected int _stepNumber;
    protected JPanel _panel;
    protected JPanel _stepsPanel;
    protected JButton _bCancel;
    protected JButton _bShowLogs;
    protected JTextArea _textArea;
    protected JLabel _textAreaLabel;
    protected JTextArea _label;
    protected Vector _sboxVector;
    protected ActionListener _listener;
    protected JFrame _parent;
    protected Component _comp;
    private int _bufferMode;
    private boolean _bufferOverflow;
    public static final int CIRCULAR_BUFFER = 0;
    public static final int LIMIT_BUFFER = 1;
    public static final int ONLY_CANCEL_BUTTON_OPTION = 0;
    public static final int DEFAULT_OPTION = 0;
    public static final int NO_BUTTON_OPTION = 1;
    public static final int ONLY_LOG_BUTTON_OPTION = 2;
    public static final int CANCEL_AND_LOG_BUTTON_OPTION = 3;
    public static final int TEXT_FIELD_OPTION = 4;
    public static final int ONLY_CLOSE_BUTTON_OPTION = 5;
    public static final int CLOSE_AND_LOG_BUTTON_OPTION = 6;
    public static final int TEXT_FIELD_AND_CANCEL_BUTTON_OPTION = 7;
    final int ROWS = 15;
    final int TEXT_AREA_MAX_SIZE = 40000;
    public static final String CANCEL = "Cancel-GenericProgressDialog";
    public static final String CLOSE = "Close-GenericProgressDialog";
    public static final String SHOW_LOGS = "Show_Logs-GenericProgressDialog";

    public GenericProgressDialog(JFrame jFrame) {
        this(jFrame, true);
    }

    public GenericProgressDialog(JFrame jFrame, boolean bl) {
        this(jFrame, bl, 0);
    }

    public GenericProgressDialog(JFrame jFrame, int n) {
        this(jFrame, true, n);
    }

    public GenericProgressDialog(JFrame jFrame, boolean bl, int n) {
        this(jFrame, bl, n, null);
    }

    public GenericProgressDialog(JFrame jFrame, boolean bl, int n, String string) {
        this(jFrame, bl, n, string, null);
    }

    public GenericProgressDialog(JFrame jFrame, boolean bl, int n, String string, Component component) {
        this(jFrame, bl, n, string, component, null);
    }

    public GenericProgressDialog(JFrame jFrame, boolean bl, int n, String string, Component component, ActionListener actionListener) {
        super((Frame)jFrame, bl);
        this._options = n;
        if (string != null) {
            this.setTitle(string);
        }
        this.getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString("genericprogressdialog", "description"));
        this._parent = jFrame;
        this._comp = component;
        this._bufferMode = 0;
        this._listener = actionListener;
        this._panel = new JPanel();
        this._panel.setBorder(new EmptyBorder(9, 6, 9, 9));
        this._panel.setLayout(new GridBagLayout());
        this._stepsPanel = new JPanel();
        this._stepsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._label = new MultilineLabel(2, 50);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, UIFactory.getComponentSpace(), 0);
        this._panel.add((Component)this._label, gridBagConstraints);
        ((MultilineLabel)this._label).setLabelFor((Component)this._panel);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        this._panel.add((Component)this._stepsPanel, gridBagConstraints);
        if (this._options == 4 || this._options == 7) {
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            this._panel.add((Component)new JSeparator(), gridBagConstraints);
            this._textAreaLabel = new JLabel("");
            gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 0, 0, 0);
            this._panel.add((Component)this._textAreaLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this._panel.add((Component)this.createFieldsPanel(), gridBagConstraints);
        } else {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this._panel.add(Box.createVerticalGlue(), gridBagConstraints);
        }
        if (this._options != 1) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 0, 0, 0);
            this._panel.add((Component)this.createButtonPanel(), gridBagConstraints);
        }
        this.setContentPane(this._panel);
        this._stepNumber = 0;
        this._currentStep = 0;
    }

    public void setTextAreaBufferMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Not supported buffer mode");
        }
        this._bufferMode = n;
    }

    public int getTextAreaBufferMode() {
        return this._bufferMode;
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        this._bCancel = UIFactory.makeJButton((Object)this, "general", "Stop");
        this._bCancel.setVisible(false);
        if (this._listener != null) {
            this._bCancel.addActionListener(this._listener);
        }
        if (this._options != 1) {
            Vector<JButton> vector = new Vector<JButton>();
            if (this._options == 5 || this._options == 6) {
                this._bCancel.setActionCommand(CLOSE);
                this._bCancel.setEnabled(false);
                this._bCancel.setVisible(true);
                this._bCancel.setText(DSUtil._resource.getString("general", "Close-label"));
                String string = DSUtil._resource.getString("general", "Close-mnemonic");
                if (string != null && string.length() > 0) {
                    this._bCancel.setMnemonic(string.charAt(0));
                }
            } else if (this._options != 2) {
                this._bCancel.setActionCommand(CANCEL);
                this._bCancel.setOpaque(true);
                this._bCancel.setVisible(true);
            }
            vector.addElement(this._bCancel);
            if (this._options != 0 && this._options != 7 && this._options != 5) {
                this._bShowLogs = UIFactory.makeJButton((Object)this, "general", "ShowLogs");
                this._bShowLogs.setActionCommand(SHOW_LOGS);
                this._bShowLogs.setOpaque(true);
                this._bShowLogs.setVisible(true);
                if (this._listener != null) {
                    this._bShowLogs.addActionListener(this._listener);
                }
                vector.addElement(this._bShowLogs);
            }
            JButton[] jButtonArray = new JButton[vector.size()];
            vector.toArray(jButtonArray);
            return UIFactory.makeJButtonPanel(jButtonArray);
        }
        return jPanel;
    }

    protected JScrollPane createFieldsPanel() {
        this._textArea = new JTextArea();
        this._textArea.setRows(15);
        this._textArea.setBackground(this.getContentPane().getBackground());
        this._textArea.setAutoscrolls(false);
        this._textArea.setEditable(false);
        this._textAreaLabel.setLabelFor(this._textArea);
        JScrollPane jScrollPane = new JScrollPane(this._textArea);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        return jScrollPane;
    }

    public void addStep(String string) {
        StateBox stateBox = new StateBox();
        if (this._sboxVector == null) {
            this._sboxVector = new Vector();
        }
        this._sboxVector.addElement(stateBox);
        if (this._sboxVector.size() == 1) {
            stateBox.setState(1);
        } else {
            stateBox.setState(0);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(this._sboxVector.size() == 0 ? UIFactory.getComponentSpace() : 0, 0, UIFactory.getComponentSpace(), 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        this._stepsPanel.add((Component)stateBox, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        JLabel jLabel = UIFactory.makeJLabel(string);
        this._stepsPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setLabelFor(stateBox);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._stepsPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        ++this._stepNumber;
    }

    public void closeCallBack() {
        Disposer disposer = new Disposer();
        if (SwingUtilities.isEventDispatchThread()) {
            disposer.run();
        } else {
            SwingUtilities.invokeLater(disposer);
        }
    }

    public void nextStepCompleted() {
        StateBoxUpdater stateBoxUpdater = new StateBoxUpdater();
        if (SwingUtilities.isEventDispatchThread()) {
            stateBoxUpdater.run();
        } else {
            SwingUtilities.invokeLater(stateBoxUpdater);
        }
    }

    public void stepCompleted(int n) {
        StateBoxUpdater stateBoxUpdater = new StateBoxUpdater(n);
        if (SwingUtilities.isEventDispatchThread()) {
            stateBoxUpdater.run();
        } else {
            SwingUtilities.invokeLater(stateBoxUpdater);
        }
    }

    public void appendTextToTextArea(String string) {
        TextFieldAppender textFieldAppender = new TextFieldAppender(string);
        if (SwingUtilities.isEventDispatchThread()) {
            textFieldAppender.run();
        } else {
            SwingUtilities.invokeLater(textFieldAppender);
        }
    }

    public void setTextInTextArea(String string) {
        TextFieldUpdater textFieldUpdater = new TextFieldUpdater(string);
        if (SwingUtilities.isEventDispatchThread()) {
            textFieldUpdater.run();
        } else {
            SwingUtilities.invokeLater(textFieldUpdater);
        }
    }

    public void setTextInLabel(String string) {
        LabelUpdater labelUpdater = new LabelUpdater(string);
        if (SwingUtilities.isEventDispatchThread()) {
            labelUpdater.run();
        } else {
            SwingUtilities.invokeLater(labelUpdater);
        }
    }

    public void waitForClose() {
        WaitAndCloser waitAndCloser = new WaitAndCloser();
        if (SwingUtilities.isEventDispatchThread()) {
            waitAndCloser.run();
        } else {
            SwingUtilities.invokeLater(waitAndCloser);
        }
    }

    public void disableCancelButton() {
        ButtonDisabler buttonDisabler = new ButtonDisabler(this._bCancel, false);
        if (SwingUtilities.isEventDispatchThread()) {
            buttonDisabler.run();
        } else {
            SwingUtilities.invokeLater(buttonDisabler);
        }
    }

    public void disableLogButton() {
        ButtonDisabler buttonDisabler = new ButtonDisabler(this._bShowLogs, false);
        if (SwingUtilities.isEventDispatchThread()) {
            buttonDisabler.run();
        } else {
            SwingUtilities.invokeLater(buttonDisabler);
        }
    }

    public void enableButtons(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            ButtonDisabler buttonDisabler = new ButtonDisabler(this._bShowLogs, false);
            buttonDisabler.run();
            buttonDisabler = new ButtonDisabler(this._bCancel, false);
            buttonDisabler.run();
        } else {
            SwingUtilities.invokeLater(new ButtonDisabler(this._bShowLogs, bl));
            SwingUtilities.invokeLater(new ButtonDisabler(this._bCancel, bl));
        }
    }

    public void reset() {
        this._currentStep = 0;
        Resetter resetter = new Resetter();
        if (SwingUtilities.isEventDispatchThread()) {
            resetter.run();
        } else {
            SwingUtilities.invokeLater(resetter);
        }
    }

    public int getCurrentStepNumber() {
        return this._currentStep;
    }

    public int getStepNumber() {
        return this._stepNumber;
    }

    public void packAndShow() {
        this.pack();
        if (this._comp != null) {
            ModalDialogUtil.setDialogLocation((Component)this, (Component)this._comp);
        } else {
            ModalDialogUtil.setDialogLocation((Component)this, (Component)this._parent);
        }
        this.show();
    }

    public void setLabelRows(int n) {
        this._label.setRows(n);
    }

    public void setLabelColumns(int n) {
        this._label.setColumns(n);
    }

    public void setTextAreaRows(int n) {
        this._textArea.setRows(n);
    }

    public void setTextAreaColumns(int n) {
        this._textArea.setColumns(n);
    }

    public void setTextInTextAreaLabel(String string) {
        if (this._textAreaLabel != null && string != null) {
            this._textAreaLabel.setText(string);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this._listener = actionListener;
        if (this._listener != null) {
            if (this._bCancel != null) {
                this._bCancel.addActionListener(this._listener);
            }
            if (this._bShowLogs != null) {
                this._bShowLogs.addActionListener(this._listener);
            }
        }
    }

    class ButtonDisabler
    implements Runnable {
        JButton _button;
        boolean _state;

        ButtonDisabler(JButton jButton, boolean bl) {
            this._button = jButton;
            this._state = bl;
        }

        public void run() {
            if (this._button != null) {
                this._button.setEnabled(this._state);
            }
        }
    }

    class WaitAndCloser
    implements Runnable {
        WaitAndCloser() {
        }

        public void run() {
            if (GenericProgressDialog.this._bCancel != null) {
                if (!GenericProgressDialog.this._bCancel.isEnabled()) {
                    GenericProgressDialog.this._bCancel.setEnabled(true);
                }
                if (!GenericProgressDialog.this._bCancel.isVisible()) {
                    GenericProgressDialog.this._bCancel.setVisible(true);
                    GenericProgressDialog.this.invalidate();
                    GenericProgressDialog.this.validate();
                }
                GenericProgressDialog.this._bCancel.setText(DSUtil._resource.getString("general", "Close-label"));
                JButtonFactory.resize((JButton)GenericProgressDialog.this._bCancel);
                GenericProgressDialog.this._bCancel.setActionCommand(GenericProgressDialog.CLOSE);
                if (GenericProgressDialog.this._listener != null) {
                    GenericProgressDialog.this._bCancel.addActionListener(GenericProgressDialog.this._listener);
                }
                GenericProgressDialog.this._bCancel.grabFocus();
            }
        }
    }

    class LabelUpdater
    implements Runnable {
        String _text;

        LabelUpdater(String string) {
            this._text = string;
        }

        public void run() {
            if (GenericProgressDialog.this._label != null) {
                GenericProgressDialog.this._label.setText(this._text);
            }
        }
    }

    class TextFieldUpdater
    implements Runnable {
        String _text;

        TextFieldUpdater(String string) {
            this._text = string;
        }

        public void run() {
            if (GenericProgressDialog.this._textArea != null) {
                int n = this._text.length();
                if (n > 40000) {
                    if (GenericProgressDialog.this._bufferMode == 0) {
                        GenericProgressDialog.this._textArea.setText(this._text.substring(n - 40000));
                    } else if (GenericProgressDialog.this._bufferMode == 1 && !GenericProgressDialog.this._bufferOverflow) {
                        GenericProgressDialog.this._bufferOverflow = true;
                        GenericProgressDialog.this._textArea.append(this._text.substring(0, 40000));
                        GenericProgressDialog.this._textArea.append("\n\n" + DSUtil._resource.getString("general", "bufferoverflow-label"));
                    }
                } else {
                    GenericProgressDialog.this._textArea.setText(this._text);
                }
            }
        }
    }

    class TextFieldAppender
    implements Runnable {
        String _text;

        TextFieldAppender(String string) {
            this._text = string;
        }

        public void run() {
            if (GenericProgressDialog.this._textArea != null) {
                int n;
                int n2 = GenericProgressDialog.this._textArea.getText().length();
                if (n2 + (n = this._text.length()) > 40000) {
                    if (GenericProgressDialog.this._bufferMode == 0) {
                        if (n > 40000) {
                            GenericProgressDialog.this._textArea.setText(this._text.substring(n - 40000));
                        } else if (n2 / 5 < n) {
                            GenericProgressDialog.this._textArea.replaceRange("", 0, n);
                            GenericProgressDialog.this._textArea.append(this._text);
                        } else {
                            GenericProgressDialog.this._textArea.replaceRange("", 0, n2 / 5);
                            GenericProgressDialog.this._textArea.append(this._text);
                        }
                    } else if (GenericProgressDialog.this._bufferMode == 1 && !GenericProgressDialog.this._bufferOverflow) {
                        GenericProgressDialog.this._bufferOverflow = true;
                        GenericProgressDialog.this._textArea.append(this._text.substring(0, 40000 - n2));
                        GenericProgressDialog.this._textArea.append("\n\n" + DSUtil._resource.getString("general", "bufferoverflow-label"));
                    }
                } else {
                    GenericProgressDialog.this._textArea.append(this._text);
                }
            }
        }
    }

    class Resetter
    implements Runnable {
        Resetter() {
        }

        public void run() {
            int n = 0;
            while (n < GenericProgressDialog.this._stepNumber) {
                StateBox stateBox = (StateBox)GenericProgressDialog.this._sboxVector.elementAt(n);
                if (n == 0) {
                    stateBox.setState(1);
                } else {
                    stateBox.setState(0);
                }
                ++n;
            }
        }
    }

    class StateBoxUpdater
    implements Runnable {
        boolean _state;
        int _number = -1;

        StateBoxUpdater() {
        }

        StateBoxUpdater(int n) {
            this._number = n;
        }

        public void run() {
            if (this._number >= 0) {
                GenericProgressDialog.this._currentStep = this._number;
            }
            if (GenericProgressDialog.this._currentStep < GenericProgressDialog.this._stepNumber) {
                StateBox stateBox = (StateBox)GenericProgressDialog.this._sboxVector.elementAt(GenericProgressDialog.this._currentStep);
                stateBox.setState(2);
                ++GenericProgressDialog.this._currentStep;
                if (GenericProgressDialog.this._currentStep < GenericProgressDialog.this._stepNumber && (stateBox = (StateBox)GenericProgressDialog.this._sboxVector.elementAt(GenericProgressDialog.this._currentStep)).getState() == 0) {
                    stateBox.setState(1);
                }
            } else {
                Debug.println((String)"StateBoxUpdater.run(): ERROR given index is out of bounds");
            }
        }
    }

    class Disposer
    implements Runnable {
        Disposer() {
        }

        public void run() {
            ((Component)GenericProgressDialog.this).setVisible(false);
            GenericProgressDialog.this.dispose();
        }
    }
}

