/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.ITaskObject;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.TaskModel;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.ace.ACIManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.security.CertMigrateWizard;
import com.netscape.management.client.security.CertificateDialog;
import com.netscape.management.client.security.PKCSConfigDialog;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.MutableTreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class DSTaskModel
extends TaskModel
implements IMenuInfo {
    private boolean _refreshUponSelect = false;
    public static String MENU_OPEN = "OPEN";
    public static String MENU_ACL = "ACL";
    public static String MENU_SECURITY = "SECURITY";
    public static String MENU_KEYCERT_MANAGEMENT = "CERT_MANAGEMENT";
    public static String MENU_PKCS11 = "PKCS_MANAGEMENT";
    public static String MENU_KEYCERT_IMPORT = "CERT_IMPORT";
    private static final String PREFERENCES_TASK_TAB = "TaskTab";
    private static final String PREFERENCES_TASK_LIST = "TaskList";
    static ResourceSet _resource = DSUtil._resource;
    protected Hashtable _taskList;
    protected ITaskObject _selection;
    private IPage _viewInstance = null;
    private ConsoleInfo _info;
    private ConsoleInfo _serverInfo;
    private Vector _authListeners = null;
    private JFrame _frame;
    private String[] _categoryID = null;
    private IMenuItem[] _menuFile = null;
    private IMenuItem[] _menuContext = null;
    private IMenuItem[] _menuSecurity = null;
    private IMenuItem[] _menuEdit = null;

    public DSTaskModel(Vector vector, ConsoleInfo consoleInfo, ConsoleInfo consoleInfo2) {
        this._serverInfo = consoleInfo2;
        this._info = consoleInfo;
        if (vector != null) {
            this._authListeners = vector;
        }
        this.init();
    }

    public void reset(Vector vector, ConsoleInfo consoleInfo, ConsoleInfo consoleInfo2) {
        this._serverInfo = consoleInfo2;
        this._info = consoleInfo;
        if (vector != null) {
            this._authListeners = vector;
        }
        this.init();
    }

    private void init() {
        TaskObject taskObject = new TaskObject("root", this._info);
        taskObject.setAllowsChildren(true);
        this._taskList = new Hashtable();
        String string = this._serverInfo.getCurrentDN();
        if (string != null) {
            String string2 = this.findTaskOrder(string);
            Hashtable hashtable = new Hashtable();
            Debug.println((String)("DSTaskModel.init: Searching for tasks under " + string));
            this.findTasks(taskObject, string, hashtable);
            string = "cn=Tasks," + new DN(this._serverInfo.getCurrentDN()).getParent().toString();
            Debug.println((String)("DSTaskModel.init: Searching for tasks under " + string));
            this.findTasks(taskObject, string, hashtable);
            Debug.println((int)9, (String)"DSTaskModel.init: Finished searching for tasks");
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    TaskObject taskObject2 = (TaskObject)hashtable.get(stringTokenizer.nextToken());
                    if (taskObject2 == null) continue;
                    taskObject.add((MutableTreeNode)taskObject2);
                }
            } else {
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    taskObject.add((MutableTreeNode)((TaskObject)enumeration.nextElement()));
                }
            }
        } else {
            Debug.println((String)"DSTaskModel.init: no currentDN");
        }
        this.setRoot((ITaskObject)taskObject);
    }

    private void findTasks(TaskObject taskObject, String string, Hashtable hashtable) {
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        if (lDAPConnection == null) {
            return;
        }
        try {
            String[] stringArray = new String[]{"nsclassname", "nsexecref", "cn"};
            Debug.println((int)9, (String)("DSTaskModel.findTasks: searching for tasks under DN=" + string + " on directory server " + DSUtil.format(lDAPConnection)));
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 2, "(objectclass=nstask)", stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                String string2;
                Object var7_8 = null;
                String string3 = null;
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[2]);
                if (lDAPAttribute != null) {
                    string2 = lDAPAttribute.getStringValueArray()[0];
                    this._taskList.put(string2, string2);
                }
                if ((string2 = lDAPEntry.getAttribute(stringArray[0])) != null) {
                    string3 = LDAPUtil.flatting((Enumeration)string2.getStringValues());
                }
                Debug.println((int)9, (String)("DSTaskModel.findTasks: Found task " + lDAPEntry.getDN() + " class name=" + string3));
                if (string3 == null) continue;
                try {
                    String[] stringArray2;
                    Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)this._info, (String)string3);
                    Debug.println((int)9, (String)("DSTaskModel.findTasks: loaded  class =" + clazz));
                    TaskObject taskObject2 = (TaskObject)clazz.newInstance();
                    Debug.println((int)9, (String)("DSTaskModel.findTasks: new  task =" + taskObject2));
                    ConsoleInfo consoleInfo = (ConsoleInfo)this._serverInfo.clone();
                    consoleInfo.setCurrentDN(lDAPEntry.getDN());
                    consoleInfo.put("AuthChangeListeners", this._authListeners);
                    string2 = lDAPEntry.getAttribute(stringArray[1]);
                    if (string2 != null) {
                        stringArray2 = LDAPUtil.flatting((Enumeration)string2.getStringValues());
                        consoleInfo.put("execref", stringArray2);
                    }
                    consoleInfo.put("dstaskmodel", this);
                    consoleInfo.put("consoleinfo", this._info);
                    taskObject2.setConsoleInfo(consoleInfo);
                    stringArray2 = LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true);
                    hashtable.put(stringArray2[0], taskObject2);
                    Debug.println((int)9, (String)("DSTaskModel.findTasks: finish task " + taskObject2));
                }
                catch (Exception exception) {
                    Debug.println((String)("DSTaskModel.findTasks: could not load class: " + string3 + ", " + exception));
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSTaskModel.findTasks: " + lDAPException.toString()));
        }
    }

    private String findTaskOrder(String string) {
        LDAPConnection lDAPConnection;
        String string2 = null;
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0");
        Preferences preferences = preferenceManager.getPreferences(PREFERENCES_TASK_TAB);
        if (preferences != null) {
            string2 = preferences.getString(PREFERENCES_TASK_LIST);
            if (string2 != null && string2.trim().length() > 0) {
                return string2;
            }
            string2 = null;
        }
        if ((lDAPConnection = this._info.getLDAPConnection()) == null) {
            return null;
        }
        try {
            LDAPAttribute lDAPAttribute;
            String string3 = "cn=task summary, cn=Operation, cn=Tasks," + string;
            String[] stringArray = new String[]{"description"};
            LDAPEntry lDAPEntry = lDAPConnection.read(string3, stringArray);
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(stringArray[0])) != null) {
                string2 = (String)lDAPAttribute.getStringValues().nextElement();
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSTaskModel.findTaskOrder: no list of tasks, " + (Object)((Object)lDAPException)));
        }
        return string2;
    }

    public void pageSelected(IFramework iFramework, IPage iPage) {
        if (this.getRefreshUponSelect()) {
            this.init();
            this.setRefreshUponSelect(false);
        }
    }

    public void setSelectedPage(IPage iPage) {
        if (iPage != null) {
            this._viewInstance = iPage;
        }
    }

    public IPage getSelectedPage() {
        return this._viewInstance;
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"FILE", "EDIT", "CONTEXT", MENU_SECURITY};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("FILE")) {
            if (this._menuFile == null) {
                this._menuFile = new IMenuItem[]{new MenuItemCategory(MENU_SECURITY, _resource.getString("menu", "Security")), new MenuItemSeparator(), new MenuItemText(MENU_OPEN, _resource.getString("menu", "open"), _resource.getString("menu", "open-description"))};
            }
            return this._menuFile;
        }
        if (string.equals(MENU_SECURITY)) {
            if (this._menuSecurity == null) {
                this._menuSecurity = new IMenuItem[]{new MenuItemText(MENU_KEYCERT_MANAGEMENT, _resource.getString("menu", "SecurityCertManagement"), _resource.getString("menu", "SecurityCertManagement-description")), new MenuItemText(MENU_PKCS11, _resource.getString("menu", "SecurityPKCS11"), _resource.getString("menu", "SecurityPKCS11-description")), new MenuItemText(MENU_KEYCERT_IMPORT, _resource.getString("menu", "SecurityCertImport"), _resource.getString("menu", "SecurityCertImport-description"))};
            }
            return this._menuSecurity;
        }
        if (string.equals("EDIT")) {
            if (this._menuEdit == null) {
                this._menuEdit = new IMenuItem[]{new MenuItemText(MENU_ACL, _resource.getString("menu", "editacls"), _resource.getString("menu", "editacls-description"), false)};
            }
            return this._menuEdit;
        }
        if (string.equals("CONTEXT")) {
            if (this._menuContext == null) {
                this._menuContext = new IMenuItem[]{new MenuItemText(MENU_ACL, _resource.getString("menu", "editacls"), _resource.getString("menu", "editacls-description"))};
            }
            return this._menuContext;
        }
        return null;
    }

    public void actionObjectSelected(IPage iPage, ITaskObject iTaskObject, ITaskObject iTaskObject2) {
        super.actionObjectSelected(iPage, iTaskObject, iTaskObject2);
        this.setSelectedPage(iPage);
        this._selection = iTaskObject;
        if (iTaskObject == null) {
            this.fireDisableMenuItem(iPage, MENU_ACL);
        } else {
            this.fireEnableMenuItem(iPage, MENU_ACL);
        }
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        this.setSelectedPage(iPage);
        if (iMenuItem.getID().equals(MENU_OPEN)) {
            this.actionObjectRun(iPage, this._selection);
        } else if (iMenuItem.getID().equals(MENU_ACL)) {
            if (this._selection == null) {
                return;
            }
            String string = this._selection.getConsoleInfo().getCurrentDN();
            ACIManager aCIManager = new ACIManager(this.getFrame(), string, string);
            aCIManager.show();
        } else if (iMenuItem.getID().equals(MENU_KEYCERT_MANAGEMENT)) {
            CertificateDialog certificateDialog = new CertificateDialog((Frame)this.getFrame(), this._info, (String)this._serverInfo.get("SIE"));
            certificateDialog.showModal();
        } else if (iMenuItem.getID().equals(MENU_PKCS11)) {
            PKCSConfigDialog pKCSConfigDialog = new PKCSConfigDialog((Component)this.getFrame(), this._info, (String)this._serverInfo.get("SIE"));
            pKCSConfigDialog.setVisible(true);
        } else if (iMenuItem.getID().equals(MENU_KEYCERT_IMPORT)) {
            this.actionMenuImport(iPage);
        }
    }

    public void actionMenuImport(IPage iPage) {
        boolean bl;
        DSFramework dSFramework = (DSFramework)iPage.getFramework();
        DSAdmin dSAdmin = dSFramework.getServerObject();
        try {
            bl = dSAdmin.getSecurityState() == DSAdmin.SECURITY_ENABLE;
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)"DSTaskModel.actionMenuImport: failed to read directory");
            Debug.println((int)0, (String)"DSTaskModel.actionMenuImport: SSL is considered as off");
            bl = false;
        }
        if (bl) {
            DSUtil.showInformationDialog((Component)this.getFrame(), "impossible-when-ssl-enabled", "", "dirtask");
        } else {
            CertMigrateWizard certMigrateWizard = new CertMigrateWizard((Component)this.getFrame(), this._info, (String)this._serverInfo.get("SIE"));
            certMigrateWizard.setVisible(true);
            dSAdmin.fireDSAdminEvent(1);
        }
    }

    public void actionViewClosing(IPage iPage) throws CloseVetoException {
    }

    public void setWaitCursor(boolean bl) {
        this.fireChangeFeedbackCursor(null, bl ? 3 : 0);
        if (bl) {
            this.fireChangeStatusItemState(this.getSelectedPage(), "StatusItemProgress", StatusItemProgress.STATE_BUSY);
        } else {
            this.fireChangeStatusItemState(this.getSelectedPage(), "StatusItemProgress", new Integer(0));
        }
    }

    public void setRefreshUponSelect(boolean bl) {
        this._refreshUponSelect = bl;
    }

    public boolean getRefreshUponSelect() {
        return this._refreshUponSelect;
    }

    public void setFrame(JFrame jFrame) {
        this._frame = jFrame;
    }

    public JFrame getFrame() {
        if (this._frame == null) {
            Debug.println((int)0, (String)"DSTaskModel.getFrame: returning null frame !");
        }
        return this._frame;
    }

    public boolean isTaskAvailable(String string) {
        return this._taskList.get(string) != null;
    }
}

