/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.ConfirmationAddUnderReferralDialog;
import com.netscape.admin.dirserv.CutCopyLimitationDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSSearchPanel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DisplayedChildrenLimitExceededDialog;
import com.netscape.admin.dirserv.Helper;
import com.netscape.admin.dirserv.IAuthenticationChangeListener;
import com.netscape.admin.dirserv.IStartStopListener;
import com.netscape.admin.dirserv.RemoteNodeInformationDialog;
import com.netscape.admin.dirserv.ShowSortInfoDialog;
import com.netscape.admin.dirserv.SortedChildrenLimitExceededDialog;
import com.netscape.admin.dirserv.account.AccountInactivation;
import com.netscape.admin.dirserv.browser.Activator;
import com.netscape.admin.dirserv.browser.AttributeController;
import com.netscape.admin.dirserv.browser.BasicNode;
import com.netscape.admin.dirserv.browser.BrowserController;
import com.netscape.admin.dirserv.browser.BrowserEvent;
import com.netscape.admin.dirserv.browser.BrowserEventListener;
import com.netscape.admin.dirserv.browser.ChildrenController;
import com.netscape.admin.dirserv.browser.Clipboard;
import com.netscape.admin.dirserv.browser.ContentMenuController;
import com.netscape.admin.dirserv.browser.Copier;
import com.netscape.admin.dirserv.browser.CutDeleter;
import com.netscape.admin.dirserv.browser.DSSearchDialog;
import com.netscape.admin.dirserv.browser.DisplayAttributeDialog;
import com.netscape.admin.dirserv.browser.EntryEditor;
import com.netscape.admin.dirserv.browser.IBrowserNodeInfo;
import com.netscape.admin.dirserv.browser.IContentPageInfo;
import com.netscape.admin.dirserv.browser.IconPool;
import com.netscape.admin.dirserv.browser.Inactivator;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.browser.Paster;
import com.netscape.admin.dirserv.browser.ReferralAuthenticationDialog;
import com.netscape.admin.dirserv.browser.VLVCache;
import com.netscape.admin.dirserv.browser.VLVIndexHelper;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.IDatabaseConfigListener;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.effectiverights.EffectiveRightsInputDialog;
import com.netscape.admin.dirserv.panel.NonResolvedReferralDialog;
import com.netscape.admin.dirserv.ppoledit.PasswordPolicyEditorDialog;
import com.netscape.admin.dirserv.ppoledit.PasswordPolicyEditorDialogForRoles;
import com.netscape.admin.dirserv.roledit.RoleEditorDialog;
import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.ace.ACIManager;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.ug.IResourcePickerPlugin;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;

public class DSContentPage
extends JPanel
implements IPage,
SuiConstants,
IAuthenticationChangeListener,
IStartStopListener,
BrowserEventListener,
TreeSelectionListener,
TreeWillExpandListener,
ListSelectionListener,
ActionListener,
MouseListener,
IContentPageInfo,
IDatabaseConfigListener {
    DSFramework _framework;
    DatabaseConfig _databaseConfig;
    EntryEditor _entryEditor;
    LDAPConnectionPool _connectionPool;
    IconPool _iconPool;
    BrowserController _controller;
    ContentMenuController _menuController;
    protected JTree _tree;
    protected JScrollPane _treePanel;
    protected JList _list;
    protected JScrollPane _childrenPanel;
    protected Component _lastSelectedComponent;
    private IBrowserNodeInfo _inspectedNode;
    Color _listDefaultColor;
    Color _listDisabledColor;
    ChildrenController _childrenController;
    JPanel _attributePanel;
    AttributeController _attributeController;
    protected JPopupMenu _contextMenu;
    JLabel _selectedDnLabel;
    JLabel _statusLabel;
    JSplitPane _splitPanel;
    JPanel _displayedPanel;
    boolean _showRemoteInformationDialog;
    boolean _showDisplayedChildrenLimitExceededDialog;
    boolean _showSortedChildrenLimitExceededDialog;
    boolean _showCutCopyLimitationDialog;
    boolean _showSortInfoDialog;
    boolean _showAddUnderReferralDialog;
    static ResourceSet _resource = DSUtil._resource;
    static final String NO_SELECTED_DN = "  ";
    public static final String[] CONTAINER_OBJECTCLASSES = new String[]{"organization", "organizationalUnit", "netscapeServer", "netscapeResource", "domain"};
    static final String SEARCH_OID = "2.16.840.1.113730.3.4.14";
    static final String SHOW_REMOTE_INFORMATION_DIALOG = "SHOW_REMOTE_INFORMATION_DIALOG";
    static final String SHOW_DISPLAYED_CHILDREN_LIMIT_EXCEEDED = "SHOW_DISPLAYED_CHILDREN_LIMIT_EXCEEDED";
    static final String SHOW_SORTED_CHILDREN_LIMIT_EXCEEDED = "SHOW_SORTED_CHILDREN_LIMIT_EXCEEDED";
    static final String SHOW_CUT_COPY_LIMITATION = "SHOW_CUT_COPY_LIMITATION";
    static final String SHOW_ADD_UNDER_REFERRAL_DIALOG = "SHOW_ADD_UNDER_REFERRAL_DIALOG";
    static final String SHOW_SORT_INFO_DIALOG = "SHOW_SORT_INFO_DIALOG";
    public static final String SORT_PREFERENCES = "SORT_PREFERENCES";
    public static final String FOLLOW_REFERRALS_PREFERENCES = "FOLLOW_REFERRALS_PREFERENCES";
    public static final String DISPLAY_PREFERENCES = "DISPLAY_PREFERENCES";
    public static final String DISPLAY_ATTRIBUTE = "DISPLAY_ATTRIBUTE";
    public static final String SHOW_ATTRIBUTE_NAME = "SHOW_ATTRIBUTE_NAME";
    static final String LAYOUT_PREFERENCES = "LAYOUT_PREFERENCES";
    static final int NO_VLV_SORTED_LIMIT = 300;
    static final int DISPLAYED_CHILDREN_LIMIT = 5000;
    private static final String[] NON_ACTIVABLE_OBJECTCLASSES = new String[]{"groupofuniquenames", "passwordpolicy", "cossuperdefinition", "cospointerdefinition", "cosindirectdefinition", "cosclassicdefinition", "organizationalunit"};
    Preferences _preferences = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0").getPreferences("DS_MISCELLANEOUS");
    public static LDAPControl _manageDSAITControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
    private VLVCache _vlvCache;
    private Hashtable _activationCache = new Hashtable();
    private String _layout = "NODE_LEAF_LAYOUT";
    private int _display;
    private String _displayAttribute;
    private boolean _showAttributeName;
    private boolean _isInitialized = false;
    private boolean _isPageSelected = false;
    private boolean _refreshUponSelect = false;
    private boolean _recreateNewRootEntryMenusUponSelect = false;
    private boolean _ignoreAuthenticationEvent = false;
    private boolean _ignoreDatabaseConfigEvents = false;
    private boolean _ignoreSelectionEvent = false;
    private Clipboard _clipboard = new Clipboard();
    private Vector _authListeners = new Vector();
    private String[] _allAttrs = null;

    public void actionViewClosing(IFramework iFramework) throws CloseVetoException {
        Debug.println((String)"DSContentPage.actionViewClosing");
        if (this._controller != null) {
            this._controller.shutDown();
        }
        if (this._attributeController != null) {
            this._attributeController.shutDown();
        }
        if (this._childrenController != null) {
            this._childrenController.shutDown();
        }
    }

    public Object clone() {
        throw new IllegalStateException("DSContentPage.clone() should not be called");
    }

    public IFramework getFramework() {
        return this._framework;
    }

    public String getPageTitle() {
        return DSUtil._resource.getString("browser", "tab-title");
    }

    public void initialize(IFramework iFramework) {
        Debug.println((String)"DSContentPage.initialize");
        this._framework = (DSFramework)iFramework;
        this._framework.getServerObject().addStartStopListener(this);
        this._showRemoteInformationDialog = this._preferences.getBoolean(SHOW_REMOTE_INFORMATION_DIALOG, true);
        this._showDisplayedChildrenLimitExceededDialog = this._preferences.getBoolean(SHOW_DISPLAYED_CHILDREN_LIMIT_EXCEEDED, true);
        this._showSortedChildrenLimitExceededDialog = this._preferences.getBoolean(SHOW_SORTED_CHILDREN_LIMIT_EXCEEDED, true);
        this._showCutCopyLimitationDialog = this._preferences.getBoolean(SHOW_CUT_COPY_LIMITATION, true);
        this._showAddUnderReferralDialog = this._preferences.getBoolean(SHOW_ADD_UNDER_REFERRAL_DIALOG, true);
        this._showSortInfoDialog = this._preferences.getBoolean(SHOW_SORT_INFO_DIALOG, true);
        boolean bl = this._preferences.getBoolean(SORT_PREFERENCES, false);
        boolean bl2 = this._preferences.getBoolean(FOLLOW_REFERRALS_PREFERENCES, true);
        this._display = this._preferences.getInt(DISPLAY_PREFERENCES, 1);
        this._layout = this._preferences.getString(LAYOUT_PREFERENCES, "NODE_LEAF_LAYOUT");
        this._displayAttribute = this._preferences.getString(DISPLAY_ATTRIBUTE, "rdn attribute");
        this._showAttributeName = this._preferences.getBoolean(SHOW_ATTRIBUTE_NAME, false);
        this._tree = new JTree();
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeSelectionListener(this);
        this._tree.addTreeWillExpandListener(this);
        this._tree.addMouseListener(this);
        this._list = new JList(new DefaultListModel());
        this._list.setSelectionMode(2);
        this._list.addListSelectionListener(this);
        this._list.addMouseListener(this);
        this._listDefaultColor = this._list.getBackground();
        this._listDisabledColor = ((Component)((Object)this._framework)).getBackground();
        this._selectedDnLabel = new JLabel(NO_SELECTED_DN);
        this._selectedDnLabel.setLabelFor(this._tree);
        this._statusLabel = new JLabel("");
        this._statusLabel.setLabelFor(this._tree);
        ConsoleInfo consoleInfo = this._framework.getServerObject().getServerInfo();
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        this._connectionPool = this._framework.getServerObject().getConnectionPool();
        this._iconPool = this._framework.getServerObject().getIconPool();
        this.layoutComponents();
        this._controller = new BrowserController(this._tree, this._connectionPool, this._iconPool);
        this._controller.addBrowserEventListener(this);
        this._controller.setLDAPConnection(lDAPConnection);
        this._controller.setShowContainerOnly(false);
        this._controller.setContainerClasses(CONTAINER_OBJECTCLASSES);
        this._controller.setMaxChildren(5000);
        this._childrenController = new ChildrenController(this._list, this._connectionPool, this._iconPool);
        this._childrenController.setLDAPConnection(lDAPConnection);
        this._childrenController.addBrowserEventListener(this);
        this._childrenController.setContainerClasses(CONTAINER_OBJECTCLASSES);
        this._childrenController.setMaxChildren(5000);
        this._attributeController = new AttributeController(this._connectionPool, this._attributePanel);
        this._databaseConfig = this._framework.getServerObject().getDatabaseConfig();
        this._databaseConfig.addChangeListener(this);
        this._vlvCache = this._framework.getServerObject().getVLVCache();
        this._controller.setNumSubordinateHacker(this._databaseConfig.getNumSubordinateHacker());
        this._contextMenu = new JPopupMenu();
        this._menuController = new ContentMenuController(this, this._contextMenu, (IFramework)this._framework, this._databaseConfig, this);
        this._menuController.addShortCutRegisterer(this._tree);
        this._menuController.addShortCutRegisterer(this._list);
        this._entryEditor = new EntryEditor(this.getSchema(), (JFrame)((Object)this._framework), this._databaseConfig);
        this._entryEditor.setConnectionPool(this._connectionPool);
        ListIterator listIterator = ((AbstractList)this.getRootSuffixesWithEntry()).listIterator();
        while (listIterator.hasNext()) {
            this._controller.addSuffix((String)listIterator.next(), null);
        }
        this._controller.addSuffix("cn=schema", null);
        this._controller.addSuffix("cn=monitor", null);
        this._controller.addSuffix("cn=config", null);
        this._childrenController.setSorted(bl);
        this._controller.setShowContainerOnly(this._layout.equals("NODE_LEAF_LAYOUT"));
        this._controller.setSorted(bl);
        this._controller.setFollowReferrals(bl2);
        this._childrenController.setFollowReferrals(bl2);
        this._controller.setDisplayFlags(this._display);
        this._controller.setDisplayAttribute(this._displayAttribute);
        this._controller.showAttributeName(this._showAttributeName);
        this._childrenController.setDisplayFlags(this._display);
        this._childrenController.setDisplayAttribute(this._displayAttribute);
        this._childrenController.showAttributeName(this._showAttributeName);
        this._tree.clearSelection();
        this.getAccessibleContext().setAccessibleName(this.getPageTitle());
        this.getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString("browser", "tab-description"));
        this._isInitialized = true;
    }

    void layoutComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._treePanel = new JScrollPane();
        this._treePanel.getViewport().add(this._tree);
        this._treePanel.setBorder(new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow")));
        this._treePanel.setPreferredSize(new Dimension(200, 200));
        this._treePanel.setMinimumSize(new Dimension(1, 1));
        this._childrenPanel = new JScrollPane(this._list);
        this._childrenPanel.setBorder(new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow")));
        this._childrenPanel.setPreferredSize(new Dimension(200, 200));
        this._childrenPanel.setMinimumSize(new Dimension(1, 1));
        this._attributePanel = new JPanel(new GridBagLayout());
        this._splitPanel = new JSplitPane(1);
        this._splitPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._splitPanel.setLeftComponent(this._treePanel);
        if (this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._splitPanel.setRightComponent(this._childrenPanel);
        } else if (this._layout.equals("ATTRIBUTE_LAYOUT")) {
            this._splitPanel.setRightComponent(this._attributePanel);
        }
        this._splitPanel.setDividerLocation((int)this._treePanel.getPreferredSize().getWidth() - 6);
        this._displayedPanel = new JPanel(new BorderLayout());
        this._displayedPanel.setBorder(new EmptyBorder(6, 6, 0, 6));
        this.add((Component)this._displayedPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this._selectedDnLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this._statusLabel, gridBagConstraints);
        if (this._layout.equals("ONLY_TREE_LAYOUT")) {
            this._displayedPanel.add(this._treePanel);
        } else {
            this._displayedPanel.add(this._splitPanel);
        }
    }

    public void pageSelected(IFramework iFramework) {
        Debug.println((String)"DSContentPage.pageSelected ");
        this._isPageSelected = true;
        if (this._refreshUponSelect) {
            this.refreshPage();
            this._refreshUponSelect = false;
            this._recreateNewRootEntryMenusUponSelect = false;
        } else {
            if (this._recreateNewRootEntryMenusUponSelect) {
                this._menuController.recreateNewRootEntryMenus();
                this._recreateNewRootEntryMenusUponSelect = false;
            }
            this._entryEditor.setSchema(this.getSchema());
        }
        this._menuController.populateMenuItems();
        if (this.getSelectedNodeInfo() == null) {
            this._menuController.noObjectSelected();
        }
    }

    public void pageUnselected(IFramework iFramework) {
        Debug.println((String)"DSContentPage.pageUnselected");
        this._isPageSelected = false;
        this._menuController.unpopulateMenuItems();
        this._controller.stopRefresh();
    }

    public boolean isRootSelected() {
        boolean bl = false;
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            bl = iBrowserNodeInfo.isRootNode();
        }
        return bl;
    }

    public boolean isSelectedNodeRemote() {
        boolean bl = false;
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            bl = iBrowserNodeInfo.isRemote();
        }
        return bl;
    }

    public boolean hasSelectedNodeCustomEditor() {
        String[] stringArray;
        boolean bl = false;
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && (stringArray = iBrowserNodeInfo.getObjectClassValues()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                ++n;
            }
            bl = DSSchemaHelper.isStandardObjectClass(arrayList, this.getSchema());
        }
        return bl;
    }

    public boolean hasCustomEditor(LDAPEntry lDAPEntry) {
        String[] stringArray;
        boolean bl = false;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValueArray()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                ++n;
            }
            bl = DSSchemaHelper.isStandardObjectClass(arrayList, this.getSchema());
        }
        return bl;
    }

    public boolean isClipboardEmpty() {
        return this._clipboard.isEmpty();
    }

    public boolean isSelectionMultiple() {
        boolean bl = false;
        if (this._layout.equals("NODE_LEAF_LAYOUT") && this._lastSelectedComponent == this._list) {
            int[] nArray = this._list.getSelectedIndices();
            bl = nArray != null && nArray.length > 1;
        }
        return bl;
    }

    public Integer getSelectionVlvState() {
        String string;
        Integer n = VLVCache.CANNOT_HAVE_INDEX;
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && (string = Helper.getNodeInfoDN(iBrowserNodeInfo)) != null) {
            n = this.getVlvState(string);
        }
        return n;
    }

    public Integer getVlvState(String string) {
        return this._vlvCache.getVlvState(string);
    }

    public Integer getSelectionActivationState() {
        String string;
        Integer n = new Integer(10);
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && (string = Helper.getNodeInfoDN(iBrowserNodeInfo)) != null) {
            n = this.getActivationState(string, iBrowserNodeInfo);
        }
        return n;
    }

    public Integer getActivationState(String string) {
        Integer n = new Integer(10);
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            n = this.getActivationState(string, iBrowserNodeInfo);
        }
        return n;
    }

    private Integer getActivationState(String string, IBrowserNodeInfo iBrowserNodeInfo) {
        Integer n = (Integer)this._activationCache.get(string);
        if (n == null) {
            n = new Integer(10);
            if (this.ocCanBeActivated(iBrowserNodeInfo.getObjectClassValues())) {
                try {
                    LDAPEntry lDAPEntry;
                    String[] stringArray = new String[]{"nsrole", "nsroledn", "objectclass", "nsAccountLock"};
                    LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    if (lDAPConnection != null && (lDAPEntry = (lDAPConnection = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo)).read(string, stringArray)) != null) {
                        AccountInactivation accountInactivation = new AccountInactivation(lDAPEntry, this._databaseConfig);
                        n = new Integer(accountInactivation.operationAllowed(lDAPConnection));
                    }
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
            }
            this._activationCache.put(string, n);
        }
        return n;
    }

    private boolean ocCanBeActivated(String[] stringArray) {
        boolean bl = true;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length && bl) {
                int n2 = 0;
                while (n2 < NON_ACTIVABLE_OBJECTCLASSES.length && bl) {
                    bl = !stringArray[n].equalsIgnoreCase(NON_ACTIVABLE_OBJECTCLASSES[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        return bl;
    }

    public String getPanelLayout() {
        return this._layout;
    }

    public int getDisplay() {
        return this._display;
    }

    public boolean isSorted() {
        return this._controller.isSorted();
    }

    public boolean getFollowReferrals() {
        return this._controller.getFollowReferrals();
    }

    public EntryEditor getEntryEditor() {
        return this._entryEditor;
    }

    public void notifyActivationModified(String string) {
        this._activationCache.remove(string);
    }

    public void authenticationChanged(String string, String string2, String string3, String string4) {
        if (this._isInitialized && !this._ignoreAuthenticationEvent) {
            Debug.println((String)("DSContentPage.authenticationChanged(): new bind DN = " + string2 + " old bind DN = " + string));
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            this._controller.setLDAPConnection(lDAPConnection);
            this._childrenController.setLDAPConnection(lDAPConnection);
            if (!this._isPageSelected) {
                this._refreshUponSelect = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSContentPage.this.refreshPage();
                    }
                });
            }
        }
    }

    public boolean getNewAuthentication() {
        this._ignoreAuthenticationEvent = true;
        boolean bl = false;
        DSUtil.DeferAuthListeners deferAuthListeners = null;
        String string = (String)this._framework.getServerObject().getServerInfo().get("rootdn");
        deferAuthListeners = DSUtil.reauthenticateDefer(this._framework.getServerObject().getServerInfo().getLDAPConnection(), (JFrame)((Object)this._framework), this._authListeners, string, null);
        boolean bl2 = bl = deferAuthListeners != null;
        if (bl) {
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            this._controller.setLDAPConnection(lDAPConnection);
            this._childrenController.setLDAPConnection(lDAPConnection);
            this.actionRefreshTree();
        }
        if (bl) {
            deferAuthListeners.notifyListeners();
        }
        this._ignoreAuthenticationEvent = false;
        return bl;
    }

    public void setAuthenticationChangeListener(Vector vector) {
        this._authListeners = vector;
    }

    public void serverStarted() {
        if (this._isInitialized) {
            if (!this._isPageSelected) {
                this._refreshUponSelect = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSContentPage.this.refreshPage();
                    }
                });
            }
        }
    }

    public void serverStopped() {
        this.serverStarted();
    }

    public void serverRestarted() {
        this.serverStarted();
    }

    public void databaseConfigChanged() {
        if (!this._ignoreDatabaseConfigEvents) {
            if (!this._isPageSelected) {
                this._refreshUponSelect = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSContentPage.this.refreshPage();
                    }
                });
            }
        }
    }

    public void suffixAdded(Suffix suffix) {
        if (!this._ignoreDatabaseConfigEvents && suffix.getParentSuffix() == null) {
            if (!this._isPageSelected) {
                this._recreateNewRootEntryMenusUponSelect = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSContentPage.this._menuController.recreateNewRootEntryMenus();
                    }
                });
            }
        }
    }

    public void suffixDeleted(final Suffix suffix) {
        if (!this._ignoreDatabaseConfigEvents && suffix.getParentSuffix() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (DSContentPage.this._controller.hasSuffix(suffix.getName())) {
                        DSContentPage.this._controller.removeSuffix(suffix.getName());
                    } else {
                        DSContentPage.this._menuController.recreateNewRootEntryMenus();
                    }
                }
            });
        }
    }

    public void parentChanged(final Suffix suffix, final Suffix suffix2, final Suffix suffix3) {
        if (!this._ignoreDatabaseConfigEvents) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (suffix2 == null || suffix3 == null) {
                        if (!suffix.hasRootEntry()) {
                            DSContentPage.this._menuController.recreateNewRootEntryMenus();
                        } else if (suffix3 == null) {
                            if (!DSContentPage.this._controller.hasSuffix(suffix.getName())) {
                                DSContentPage.this._controller.addSuffix(suffix.getName(), null);
                            }
                        } else if (suffix2 == null && DSContentPage.this._controller.hasSuffix(suffix.getName())) {
                            DSContentPage.this._controller.removeSuffix(suffix.getName());
                        }
                    }
                }
            });
        }
    }

    public void rootEntryAdded(final Suffix suffix) {
        if (!this._ignoreDatabaseConfigEvents && suffix.getParentSuffix() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!DSContentPage.this._controller.hasSuffix(suffix.getName())) {
                        DSContentPage.this._controller.addSuffix(suffix.getName(), null);
                    }
                    DSContentPage.this._menuController.recreateNewRootEntryMenus();
                }
            });
        }
    }

    public void rootEntryDeleted(final Suffix suffix) {
        if (!this._ignoreDatabaseConfigEvents && suffix.getParentSuffix() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (DSContentPage.this._controller.hasSuffix(suffix.getName())) {
                        DSContentPage.this._controller.removeSuffix(suffix.getName());
                    }
                    DSContentPage.this._menuController.recreateNewRootEntryMenus();
                }
            });
        }
    }

    public void databaseAdded(Database database) {
    }

    public void databaseDeleted(Database database) {
        final Suffix suffix = database.getSuffix();
        if (!this._ignoreDatabaseConfigEvents && suffix != null && suffix.getDatabases().size() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (DSContentPage.this._controller.hasSuffix(suffix.getName())) {
                        DSContentPage.this._controller.removeSuffix(suffix.getName());
                    }
                }
            });
        }
    }

    public void processBrowserEvent(BrowserEvent browserEvent) {
        switch (browserEvent.getID()) {
            case 1: {
                this._statusLabel.setText(_resource.getString("browser", "updating-label"));
                break;
            }
            case 2: {
                this._statusLabel.setText("");
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this._ignoreSelectionEvent) {
            this._ignoreSelectionEvent = true;
            this._list.clearSelection();
            this._ignoreSelectionEvent = false;
            this._lastSelectedComponent = this._tree;
            IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
            if (iBrowserNodeInfo == null) {
                this._menuController.noObjectSelected();
                this._selectedDnLabel.setText(NO_SELECTED_DN);
                if (this._inspectedNode != iBrowserNodeInfo) {
                    if (this._layout.equals("NODE_LEAF_LAYOUT")) {
                        this._childrenController.setBaseNodeInfo(null);
                        this._list.setBackground(this._listDefaultColor);
                    } else if (this._layout.equals("ATTRIBUTE_LAYOUT")) {
                        this._attributeController.clearAttributePanel();
                    }
                    BasicNode basicNode = this._inspectedNode.getNode();
                    ((DefaultTreeModel)this._tree.getModel()).nodeChanged(basicNode);
                    this._inspectedNode = null;
                    this._controller.setInspectedNode(null);
                }
            } else {
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                if (string == null || string.equals("")) {
                    this._selectedDnLabel.setText(NO_SELECTED_DN);
                } else {
                    this._selectedDnLabel.setText(DSContentPage.findDisplayNameFromNode(iBrowserNodeInfo));
                }
                this._menuController.updateMenuState();
                if (!iBrowserNodeInfo.representsSameNode(this._inspectedNode)) {
                    if (this._layout.equals("NODE_LEAF_LAYOUT")) {
                        boolean bl = this.checkChildrenForNode(iBrowserNodeInfo);
                        if (bl) {
                            this._childrenController.setBaseNodeInfo(iBrowserNodeInfo);
                            this._list.setBackground(this._listDefaultColor);
                        } else {
                            this._childrenController.setBaseNodeInfo(null);
                            this._list.setBackground(this._listDisabledColor);
                        }
                    } else if (this._layout.equals("ATTRIBUTE_LAYOUT")) {
                        this._attributeController.updateAttributePanel(iBrowserNodeInfo);
                    }
                    if (this._inspectedNode != null) {
                        BasicNode basicNode = this._inspectedNode.getNode();
                        ((DefaultTreeModel)this._tree.getModel()).nodeChanged(basicNode);
                    }
                    this._inspectedNode = iBrowserNodeInfo;
                    this._controller.setInspectedNode(this._inspectedNode);
                    ((DefaultTreeModel)this._tree.getModel()).nodeChanged(this._inspectedNode.getNode());
                }
            }
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath != null && treePath.getPathCount() <= 1) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        boolean bl;
        IBrowserNodeInfo iBrowserNodeInfo;
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath != null && (iBrowserNodeInfo = this._controller.getNodeInfoFromPath(treePath)) != null && !(bl = this.checkChildrenForNode(iBrowserNodeInfo))) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this._ignoreSelectionEvent) {
            this._ignoreSelectionEvent = true;
            this._tree.clearSelection();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSContentPage.this._ignoreSelectionEvent = false;
                    DSContentPage.this._lastSelectedComponent = DSContentPage.this._list;
                    IBrowserNodeInfo iBrowserNodeInfo = DSContentPage.this.getSelectedNodeInfo();
                    if (iBrowserNodeInfo == null) {
                        DSContentPage.this._menuController.noObjectSelected();
                        DSContentPage.this._selectedDnLabel.setText(DSContentPage.NO_SELECTED_DN);
                    } else {
                        String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                        if (string == null || string.equals("")) {
                            DSContentPage.this._selectedDnLabel.setText(DSContentPage.NO_SELECTED_DN);
                        } else {
                            DSContentPage.this._selectedDnLabel.setText(DSContentPage.findDisplayNameFromNode(iBrowserNodeInfo));
                        }
                        DSContentPage.this._menuController.updateMenuState();
                    }
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setBusyCursor(true);
        String string = actionEvent.getActionCommand();
        Debug.println((String)("DSContentPage.actionPerformed(): " + string));
        if (string == "open") {
            this.actionEdit();
        } else if (string == "advanced open") {
            this.actionAdvancedEdit();
        } else if (string == "authenticate") {
            this.actionAuthenticate();
        } else if (string == "REFERRAL_AUTHENTICATION") {
            this.actionReferralAuthentication();
        } else if (string == "copy") {
            this.actionCopy();
        } else if (string == "paste") {
            this.actionPaste();
        } else if (string == "cut") {
            this.actionCut();
        } else if (string == "delete") {
            this.actionDelete();
        } else if (string == "copydn") {
            this.actionCopyDN();
        } else if (string == "copyldapurl") {
            this.actionCopyLDAPURL();
        } else if (string == "newuser") {
            this.actionNewUser();
        } else if (string == "newgroup") {
            this.actionNewGroup();
        } else if (string == "newou") {
            this.actionNewOrganizationalUnit();
        } else if (string == "newrole") {
            this.actionNewRole();
        } else if (string == "newpasswordpolicy") {
            this.actionNewPasswordPolicy();
        } else if (string == "newcos") {
            this.actionNewCos();
        } else if (string == "newreferral") {
            this.actionNewReferral();
        } else if (string == "newobject") {
            this.actionNewObject();
        } else if (string == "acl") {
            this.actionACL();
        } else if (string == "effective rights") {
            this.actionEffectiveRights();
        } else if (string == "roles") {
            this.actionRoles();
        } else if (string == "password policies") {
            this.actionSetPasswordPolicy();
        } else if (string == "search") {
            this.actionSearch();
        } else if (string == "createVLVIndex") {
            this.actionCreateVLVIndex();
        } else if (string == "deleteVLVIndex") {
            this.actionDeleteVLVIndex();
        } else if (string == "FOLLOW_REFERRALS") {
            this.actionFollowReferrals();
        } else if (string == "REFRESHTREE") {
            this.actionRefreshTree();
        } else if (string == "activate") {
            this.actionActivate();
        } else if (string == "inactivate") {
            this.actionInactivate();
        } else if (string == "DISPLAY_ACCOUNT_INACTIVATION") {
            this.actionDisplayAccountInactivation();
        } else if (string == "DISPLAY_ACI_COUNT") {
            this.actionDisplayACICount();
        } else if (string == "DISPLAY_ROLE_COUNT") {
            this.actionDisplayRoleCount();
        } else if (string == "NODE_LEAF_LAYOUT") {
            this.actionNodeLeafLayout();
        } else if (string == "ONLY_TREE_LAYOUT") {
            this.actionOnlyTreeLayout();
        } else if (string == "ATTRIBUTE_LAYOUT") {
            this.actionAttributeLayout();
        } else if (string == "SORT") {
            this.actionSetSorted();
        } else if (string == DISPLAY_ATTRIBUTE) {
            this.actionDisplayAttribute();
        } else {
            Enumeration enumeration = this._databaseConfig.getSuffixes().elements();
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                Suffix suffix = (Suffix)enumeration.nextElement();
                if (!suffix.hasRootEntry()) {
                    vector.addElement(suffix.getName());
                }
                Vector vector3 = suffix.getDatabases();
                Enumeration enumeration2 = vector3.elements();
                while (enumeration2.hasMoreElements()) {
                    String string2 = ((Database)enumeration2.nextElement()).getName();
                    vector2.addElement(string2);
                }
            }
            if (vector.indexOf(string) >= 0) {
                this.actionCreateRootEntry(string);
            }
        }
        this.setBusyCursor(false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n;
            int n2;
            if (this._lastSelectedComponent == this._tree) {
                TreePath treePath;
                TreePath treePath2;
                if (this._inspectedNode != null && (treePath2 = this._inspectedNode.getTreePath()) != null && (treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.equals(treePath2)) {
                    this.setBusyCursor(true);
                    this.actionEdit();
                    this.setBusyCursor(false);
                }
            } else if (this._lastSelectedComponent == this._list && (n2 = this._list.getSelectedIndex()) >= 0 && (n = this._list.locationToIndex(mouseEvent.getPoint())) == n2) {
                this.setBusyCursor(true);
                this.actionEdit();
                this.setBusyCursor(false);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._contextMenu != null && !this._contextMenu.isVisible() && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._contextMenu != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void popupContextMenu(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this._tree) {
            TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                if (!this._tree.isPathSelected(treePath)) {
                    this._tree.setSelectionPath(treePath);
                }
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Point point = this._tree.getLocationOnScreen();
                int n = (int)dimension.getWidth();
                int n2 = this._contextMenu.getWidth();
                int n3 = mouseEvent.getX();
                int n4 = (int)point.getX();
                int n5 = (int)dimension.getHeight();
                int n6 = this._contextMenu.getHeight();
                int n7 = mouseEvent.getY();
                int n8 = (int)point.getY();
                if (n4 + n3 + n2 > n) {
                    n3 -= n2;
                }
                if (n8 + n7 + n6 > n5) {
                    n7 -= n6;
                }
                this._contextMenu.show(component, n3, n7);
            }
        } else if (mouseEvent.getComponent() == this._list) {
            boolean bl;
            int n = this._list.locationToIndex(mouseEvent.getPoint());
            boolean bl2 = bl = n != -1;
            if (bl) {
                if (!this._list.isSelectedIndex(n)) {
                    this._list.setSelectedIndex(n);
                }
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Point point = this._list.getLocationOnScreen();
                int n9 = (int)dimension.getWidth();
                int n10 = this._contextMenu.getWidth();
                int n11 = mouseEvent.getX();
                int n12 = (int)point.getX();
                int n13 = (int)dimension.getHeight();
                int n14 = this._contextMenu.getHeight();
                int n15 = mouseEvent.getY();
                int n16 = (int)point.getY();
                if (n12 + n11 + n10 > n9) {
                    n11 -= n10;
                }
                if (n16 + n15 + n14 > n13) {
                    n15 -= n14;
                }
                this._contextMenu.show(component, n11, n15);
            }
        }
    }

    private void refreshSuffixes() {
        Vector vector = this.getRootSuffixesWithEntry();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.get(n);
            if (!this._controller.hasSuffix(string)) {
                this._controller.addSuffix(string, null);
            }
            ++n;
        }
        if (!this._controller.hasSuffix("cn=schema")) {
            this._controller.addSuffix("cn=schema", null);
        }
        if (!this._controller.hasSuffix("cn=monitor")) {
            this._controller.addSuffix("cn=monitor", null);
        }
        if (!this._controller.hasSuffix("cn=config")) {
            this._controller.addSuffix("cn=config", null);
        }
    }

    private boolean checkChildrenForNode(IBrowserNodeInfo iBrowserNodeInfo) {
        boolean bl = true;
        int n = iBrowserNodeInfo.getNumSubOrdinates();
        if (this._controller.isSorted() && this._showSortedChildrenLimitExceededDialog && n > 300) {
            Object object;
            boolean bl2 = true;
            String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
            if (string != null) {
                object = this._vlvCache.getVlvState(string);
                boolean bl3 = bl2 = object == VLVCache.HAS_NOT_INDEX;
            }
            if (bl2) {
                object = new SortedChildrenLimitExceededDialog((JFrame)((Object)this._framework), iBrowserNodeInfo);
                ((SortedChildrenLimitExceededDialog)((Object)object)).packAndShow();
                this._showSortedChildrenLimitExceededDialog = ((SortedChildrenLimitExceededDialog)((Object)object)).continueShowingDialog();
                if (!this._showSortedChildrenLimitExceededDialog) {
                    this._preferences.set(SHOW_SORTED_CHILDREN_LIMIT_EXCEEDED, this._showSortedChildrenLimitExceededDialog);
                }
            }
        }
        if (this._showDisplayedChildrenLimitExceededDialog && bl && n > 5000) {
            DisplayedChildrenLimitExceededDialog displayedChildrenLimitExceededDialog = new DisplayedChildrenLimitExceededDialog((JFrame)((Object)this._framework), iBrowserNodeInfo);
            displayedChildrenLimitExceededDialog.packAndShow();
            this._showDisplayedChildrenLimitExceededDialog = displayedChildrenLimitExceededDialog.continueShowingDialog();
            if (!this._showDisplayedChildrenLimitExceededDialog) {
                this._preferences.set(SHOW_DISPLAYED_CHILDREN_LIMIT_EXCEEDED, this._showDisplayedChildrenLimitExceededDialog);
            }
        }
        return bl;
    }

    public static String findDisplayNameFromNode(IBrowserNodeInfo iBrowserNodeInfo) {
        String string = null;
        LDAPUrl lDAPUrl = iBrowserNodeInfo.getURL();
        string = iBrowserNodeInfo.isRemote() ? lDAPUrl.getDN() + "   ( " + lDAPUrl.getHost() + ":" + lDAPUrl.getPort() + " )" : lDAPUrl.getDN();
        return string;
    }

    private boolean continueOperation(IBrowserNodeInfo iBrowserNodeInfo) {
        Object object;
        boolean bl = true;
        int n = iBrowserNodeInfo.getErrorType();
        if (n == 0 && iBrowserNodeInfo.isRemote() && this._showRemoteInformationDialog) {
            object = new RemoteNodeInformationDialog((JFrame)((Object)this._framework), iBrowserNodeInfo);
            ((RemoteNodeInformationDialog)((Object)object)).packAndShow();
            this._showRemoteInformationDialog = ((RemoteNodeInformationDialog)((Object)object)).continueShowingDialog();
            if (!this._showRemoteInformationDialog) {
                this._preferences.set(SHOW_REMOTE_INFORMATION_DIALOG, this._showRemoteInformationDialog);
            }
            boolean bl2 = bl = !((RemoteNodeInformationDialog)((Object)object)).isCancelled();
        }
        if (n == 2) {
            object = (String)iBrowserNodeInfo.getErrorArg();
            Exception exception = iBrowserNodeInfo.getErrorException();
            NonResolvedReferralDialog nonResolvedReferralDialog = new NonResolvedReferralDialog((JFrame)((Object)this._framework), iBrowserNodeInfo.getURL(), (String)object, exception);
            nonResolvedReferralDialog.packAndShow();
            bl = !nonResolvedReferralDialog.isCancel();
        }
        return bl;
    }

    private boolean confirmationAddUnderReferral(IBrowserNodeInfo iBrowserNodeInfo) {
        boolean bl = true;
        if (this._showAddUnderReferralDialog && iBrowserNodeInfo.getReferral() != null && iBrowserNodeInfo.getReferral().length > 0) {
            ConfirmationAddUnderReferralDialog confirmationAddUnderReferralDialog = new ConfirmationAddUnderReferralDialog((JFrame)((Object)this._framework));
            confirmationAddUnderReferralDialog.packAndShow();
            this._showAddUnderReferralDialog = confirmationAddUnderReferralDialog.continueShowingDialog();
            if (!this._showAddUnderReferralDialog) {
                this._preferences.set(SHOW_ADD_UNDER_REFERRAL_DIALOG, this._showAddUnderReferralDialog);
            }
            bl = !confirmationAddUnderReferralDialog.isCancelled();
        }
        return bl;
    }

    private void actionFollowReferrals() {
        this._controller.setFollowReferrals(!this._controller.getFollowReferrals());
        this._childrenController.setFollowReferrals(this._controller.getFollowReferrals());
        this._tree.clearSelection();
        this._tree.setSelectionRow(0);
        this._attributeController.reset();
        this._activationCache.clear();
        this._preferences.set(FOLLOW_REFERRALS_PREFERENCES, this._controller.getFollowReferrals());
    }

    private void actionRefreshTree() {
        String[] stringArray;
        this.setSchema(null);
        this._ignoreDatabaseConfigEvents = true;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        try {
            this._databaseConfig.reload(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "reading-databaseconfig-error-title", "reading-databaseconfig-error-msg", stringArray, "browser");
        }
        try {
            this._vlvCache.reload(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "reading-vlvcache-error-title", "reading-vlvcache-error-msg", stringArray, "browser");
        }
        this.refreshPage();
        this._ignoreDatabaseConfigEvents = false;
    }

    private void refreshPage() {
        this.refreshSuffixes();
        this._allAttrs = null;
        this._attributeController.reset();
        this._activationCache.clear();
        this._entryEditor.setSchema(this.getSchema());
        this._menuController.recreateNewRootEntryMenus();
        this._controller.startRefresh();
        this._tree.clearSelection();
        this._tree.setSelectionRow(0);
    }

    private void actionSearch() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            try {
                lDAPConnection2 = this.getConnectionForNode(iBrowserNodeInfo);
                lDAPConnection = this.makeConnectionToEdit(lDAPConnection2, iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                ConsoleInfo consoleInfo = (ConsoleInfo)this._framework.getServerObject().getServerInfo().clone();
                consoleInfo.setUserBaseDN(Helper.getNodeInfoDN(iBrowserNodeInfo));
                consoleInfo.setUserLDAPConnection(lDAPConnection);
                consoleInfo.setLDAPConnection(lDAPConnection);
                consoleInfo.setUserHost(lDAPConnection.getHost());
                consoleInfo.setUserPort(lDAPConnection.getPort());
                DSSearchDialog dSSearchDialog = new DSSearchDialog(consoleInfo, this, this._framework);
                dSSearchDialog.appendSearchInterface((IResourcePickerPlugin)new DSSearchPanel());
                dSSearchDialog.show();
                if (dSSearchDialog.getModifiedEntries().size() > 0) {
                    if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                        this._controller.startRefresh(iBrowserNodeInfo);
                        this._tree.clearSelection();
                        this._tree.setSelectionPath(iBrowserNodeInfo.getTreePath());
                    } else if (this._list == this._lastSelectedComponent) {
                        this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                        if (this._inspectedNode != null) {
                            this._controller.notifyChildEntryChanged(this._inspectedNode, Helper.getNodeInfoDN(iBrowserNodeInfo));
                        }
                    }
                }
                if (lDAPConnection2 != null) {
                    this._connectionPool.releaseConnection(lDAPConnection2);
                }
            }
        }
    }

    private void actionDisplayACICount() {
        this._display = (this._display & 1) == 0 ? (this._display |= 1) : (this._display &= 0xFFFFFFFE);
        this._controller.setDisplayFlags(this._display);
        this._childrenController.setDisplayFlags(this._display);
        if (this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._childrenController.startRefresh();
        }
        this._preferences.set(DISPLAY_PREFERENCES, this._display);
    }

    private void actionDisplayRoleCount() {
        this._display = (this._display & 2) == 0 ? (this._display |= 2) : (this._display &= 0xFFFFFFFD);
        this._controller.setDisplayFlags(this._display);
        this._childrenController.setDisplayFlags(this._display);
        if (this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._childrenController.startRefresh();
        }
        this._preferences.set(DISPLAY_PREFERENCES, this._display);
    }

    private void actionDisplayAccountInactivation() {
        this._display = (this._display & 4) == 0 ? (this._display |= 4) : (this._display &= 0xFFFFFFFB);
        this._controller.setDisplayFlags(this._display);
        this._childrenController.setDisplayFlags(this._display);
        if (this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._childrenController.startRefresh();
        }
        this._preferences.set(DISPLAY_PREFERENCES, this._display);
    }

    private void actionOnlyTreeLayout() {
        if (!this._layout.equals("ONLY_TREE_LAYOUT")) {
            this._displayedPanel.remove(this._splitPanel);
            this._displayedPanel.add(this._treePanel);
            this._layout = "ONLY_TREE_LAYOUT";
            if (this._controller.isShowContainerOnly()) {
                this._controller.setShowContainerOnly(false);
            }
            this._tree.clearSelection();
            this.validate();
            this.repaint();
            this._preferences.set(LAYOUT_PREFERENCES, this._layout);
        }
    }

    private void actionNodeLeafLayout() {
        if (!this._layout.equals("NODE_LEAF_LAYOUT")) {
            if (this._layout.equals("ONLY_TREE_LAYOUT")) {
                this._splitPanel.setRightComponent(this._childrenPanel);
                this._displayedPanel.remove(this._treePanel);
                this._splitPanel.setLeftComponent(this._treePanel);
                this._displayedPanel.add(this._splitPanel);
            } else if (this._layout.equals("ATTRIBUTE_LAYOUT")) {
                int n = this._splitPanel.getDividerLocation();
                this._splitPanel.setRightComponent(this._childrenPanel);
                this._splitPanel.setDividerLocation(n);
            }
            this._layout = "NODE_LEAF_LAYOUT";
            if (!this._controller.isShowContainerOnly()) {
                this._controller.setShowContainerOnly(true);
            }
            this._tree.clearSelection();
            IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
            this._childrenController.setBaseNodeInfo(iBrowserNodeInfo);
            this._list.setBackground(this._listDefaultColor);
            this.validate();
            this.repaint();
            this._preferences.set(LAYOUT_PREFERENCES, this._layout);
        }
    }

    private void actionAttributeLayout() {
        if (!this._layout.equals("ATTRIBUTE_LAYOUT")) {
            if (this._layout.equals("ONLY_TREE_LAYOUT")) {
                this._splitPanel.setRightComponent(this._attributePanel);
                this._displayedPanel.remove(this._treePanel);
                this._splitPanel.setLeftComponent(this._treePanel);
                this._displayedPanel.add(this._splitPanel);
            } else if (this._layout.equals("NODE_LEAF_LAYOUT")) {
                int n = this._splitPanel.getDividerLocation();
                this._splitPanel.setRightComponent(this._attributePanel);
                this._splitPanel.setDividerLocation(n);
            }
            this._layout = "ATTRIBUTE_LAYOUT";
            if (this._controller.isShowContainerOnly()) {
                this._controller.setShowContainerOnly(false);
            }
            this._tree.clearSelection();
            IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
            if (iBrowserNodeInfo == null) {
                this._attributeController.clearAttributePanel();
            } else {
                this._attributeController.updateAttributePanel(iBrowserNodeInfo);
            }
            this.validate();
            this.repaint();
            this._preferences.set(LAYOUT_PREFERENCES, this._layout);
        }
    }

    private void actionSetSorted() {
        if (this._showSortInfoDialog) {
            ShowSortInfoDialog showSortInfoDialog = new ShowSortInfoDialog((JFrame)((Object)this._framework));
            showSortInfoDialog.packAndShow();
            this._showSortInfoDialog = showSortInfoDialog.continueShowingDialog();
            if (!this._showSortInfoDialog) {
                this._preferences.set(SHOW_SORT_INFO_DIALOG, this._showSortInfoDialog);
            }
        }
        this._controller.setSorted(!this._controller.isSorted());
        this._childrenController.setSorted(this._controller.isSorted());
        this._preferences.set(SORT_PREFERENCES, this._controller.isSorted());
        this._tree.clearSelection();
    }

    private void actionDisplayAttribute() {
        LDAPSchema lDAPSchema = this.getSchema();
        DisplayAttributeDialog displayAttributeDialog = new DisplayAttributeDialog((JFrame)((Object)this._framework), this.getSchema(), this._displayAttribute, this._showAttributeName);
        displayAttributeDialog.pack();
        displayAttributeDialog.show();
        if (!displayAttributeDialog.isCancelled()) {
            String string = displayAttributeDialog.getDisplayAttribute();
            boolean bl = displayAttributeDialog.showAttributeName();
            if (!string.equals(this._displayAttribute) || bl != this._showAttributeName) {
                this._displayAttribute = string;
                this._showAttributeName = bl;
                this._controller.setDisplayAttribute(this._displayAttribute);
                this._controller.showAttributeName(this._showAttributeName);
                this._childrenController.setDisplayAttribute(this._displayAttribute);
                this._childrenController.showAttributeName(this._showAttributeName);
                if (this._layout.equals("NODE_LEAF_LAYOUT")) {
                    this._childrenController.startRefresh();
                }
                this._preferences.set(DISPLAY_ATTRIBUTE, this._displayAttribute);
                this._preferences.set(SHOW_ATTRIBUTE_NAME, this._showAttributeName);
            }
        }
    }

    private void actionCopy() {
        IBrowserNodeInfo[] iBrowserNodeInfoArray = this.getSelectedNodes();
        if (iBrowserNodeInfoArray != null) {
            Object object;
            LDAPConnection[] lDAPConnectionArray = new LDAPConnection[iBrowserNodeInfoArray.length];
            LDAPConnection[] lDAPConnectionArray2 = new LDAPConnection[iBrowserNodeInfoArray.length];
            boolean bl = false;
            int n = 0;
            while (n < lDAPConnectionArray.length && !bl) {
                if (this.continueOperation(iBrowserNodeInfoArray[n])) {
                    try {
                        lDAPConnectionArray2[n] = this.getConnectionForNode(iBrowserNodeInfoArray[n]);
                        lDAPConnectionArray[n] = this.makeConnectionToEdit(lDAPConnectionArray2[n], iBrowserNodeInfoArray[n]);
                        object = lDAPConnectionArray[n].getSearchConstraints();
                        object.setMaxResults(0);
                        lDAPConnectionArray[n].setSearchConstraints((LDAPSearchConstraints)object);
                    }
                    catch (LDAPException lDAPException) {
                        this.displayConnectionError(lDAPException, iBrowserNodeInfoArray[n]);
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                if (this._showCutCopyLimitationDialog) {
                    object = new CutCopyLimitationDialog((JFrame)((Object)this._framework));
                    ((CutCopyLimitationDialog)((Object)object)).packAndShow();
                    this._showCutCopyLimitationDialog = ((CutCopyLimitationDialog)((Object)object)).continueShowingDialog();
                    if (!this._showCutCopyLimitationDialog) {
                        this._preferences.set(SHOW_CUT_COPY_LIMITATION, this._showCutCopyLimitationDialog);
                    }
                }
                object = new String[iBrowserNodeInfoArray.length];
                int n2 = 0;
                while (n2 < iBrowserNodeInfoArray.length) {
                    object[n2] = Helper.getNodeInfoDN(iBrowserNodeInfoArray[n2]);
                    ++n2;
                }
                Copier copier = new Copier(lDAPConnectionArray, (String[])object, (JFrame)((Object)this._framework), this._clipboard);
                copier.execute();
                this._menuController.updateMenuState();
            }
            int n3 = 0;
            while (n3 < lDAPConnectionArray2.length) {
                if (lDAPConnectionArray2[n3] != null) {
                    this._connectionPool.releaseConnection(lDAPConnectionArray2[n3]);
                }
                ++n3;
            }
        }
    }

    private void actionCopyDN() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    private void actionCopyLDAPURL() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            StringSelection stringSelection = new StringSelection(iBrowserNodeInfo.getURL().toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    private void actionPaste() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                Paster paster = new Paster(lDAPConnection, string, (JFrame)((Object)this._framework), this._clipboard);
                paster.execute();
                Vector vector = paster.getPastedRootEntries();
                if (vector != null) {
                    if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            LDAPEntry lDAPEntry = (LDAPEntry)enumeration.nextElement();
                            String string2 = lDAPEntry.getDN();
                            if (!this._layout.equals("NODE_LEAF_LAYOUT")) {
                                this._controller.notifyEntryAdded(iBrowserNodeInfo, string2);
                                continue;
                            }
                            boolean bl = this.isContainerObject(lDAPEntry);
                            if (!bl) {
                                try {
                                    bl = Helper.entryHasChildren(string2, lDAPConnection);
                                }
                                catch (LDAPException lDAPException) {
                                    // empty catch block
                                }
                            }
                            if (bl) {
                                this._controller.notifyEntryAdded(iBrowserNodeInfo, string2);
                            }
                            this._childrenController.notifyEntryAdded(string2);
                        }
                    } else if (this._list == this._lastSelectedComponent) {
                        this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                        if (this._inspectedNode != null) {
                            this._controller.notifyChildEntryChanged(this._inspectedNode, string);
                        }
                    }
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionCut() {
        IBrowserNodeInfo[] iBrowserNodeInfoArray = this.getSelectedNodes();
        if (iBrowserNodeInfoArray != null) {
            Object object;
            LDAPConnection[] lDAPConnectionArray = new LDAPConnection[iBrowserNodeInfoArray.length];
            LDAPConnection[] lDAPConnectionArray2 = new LDAPConnection[iBrowserNodeInfoArray.length];
            boolean bl = false;
            int n = 0;
            while (n < lDAPConnectionArray.length && !bl) {
                if (this.continueOperation(iBrowserNodeInfoArray[n])) {
                    try {
                        lDAPConnectionArray2[n] = this.getConnectionForNode(iBrowserNodeInfoArray[n]);
                        lDAPConnectionArray[n] = this.makeConnectionToEdit(lDAPConnectionArray2[n], iBrowserNodeInfoArray[n]);
                        object = lDAPConnectionArray[n].getSearchConstraints();
                        object.setMaxResults(0);
                        lDAPConnectionArray[n].setSearchConstraints((LDAPSearchConstraints)object);
                    }
                    catch (LDAPException lDAPException) {
                        this.displayConnectionError(lDAPException, iBrowserNodeInfoArray[n]);
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                TreePath treePath;
                boolean bl2;
                if (this._showCutCopyLimitationDialog) {
                    object = new CutCopyLimitationDialog((JFrame)((Object)this._framework));
                    ((CutCopyLimitationDialog)((Object)object)).packAndShow();
                    this._showCutCopyLimitationDialog = ((CutCopyLimitationDialog)((Object)object)).continueShowingDialog();
                    if (!this._showCutCopyLimitationDialog) {
                        this._preferences.set(SHOW_CUT_COPY_LIMITATION, this._showCutCopyLimitationDialog);
                    }
                }
                object = new String[iBrowserNodeInfoArray.length];
                int n2 = 0;
                while (n2 < iBrowserNodeInfoArray.length) {
                    object[n2] = Helper.getNodeInfoDN(iBrowserNodeInfoArray[n2]);
                    ++n2;
                }
                CutDeleter cutDeleter = new CutDeleter(lDAPConnectionArray, (String[])object, (JFrame)((Object)this._framework), this._clipboard, true);
                cutDeleter.execute();
                this._menuController.updateMenuState();
                boolean bl3 = !this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent;
                boolean bl4 = bl2 = !bl3 && this._list == this._lastSelectedComponent;
                if (bl3) {
                    if (cutDeleter.getDeletedSubtrees().contains(object[0])) {
                        treePath = this._inspectedNode.getTreePath().getParentPath();
                        this._tree.setSelectionPath(treePath);
                    }
                } else if (bl2 && cutDeleter.getDeletedSubtrees().size() == ((Object)object).length) {
                    treePath = this._inspectedNode.getTreePath();
                    this._tree.setSelectionPath(treePath);
                }
                int n3 = 0;
                while (n3 < ((Object)object).length) {
                    if (cutDeleter.getDeletedSubtrees().contains(object[n3])) {
                        if (bl3) {
                            this._controller.notifyEntryDeleted(iBrowserNodeInfoArray[n3]);
                        } else if (bl2) {
                            this._childrenController.notifyEntryDeleted(iBrowserNodeInfoArray[n3]);
                            if (this._inspectedNode != null) {
                                this._controller.notifyChildEntryDeleted(this._inspectedNode, (String)object[n3]);
                            }
                        }
                        this.checkObjectDeleted((String)object[n3]);
                    } else if (bl3) {
                        this._controller.startRefresh(iBrowserNodeInfoArray[n3]);
                    } else if (bl2) {
                        this._childrenController.notifyEntryChanged(iBrowserNodeInfoArray[n3]);
                        if (this._inspectedNode != null) {
                            this._controller.notifyChildEntryChanged(this._inspectedNode, (String)object[n3]);
                        }
                    }
                    ++n3;
                }
            }
            int n4 = 0;
            while (n4 < lDAPConnectionArray2.length) {
                if (lDAPConnectionArray2[n4] != null) {
                    this._connectionPool.releaseConnection(lDAPConnectionArray2[n4]);
                }
                ++n4;
            }
        }
    }

    private void actionDelete() {
        IBrowserNodeInfo[] iBrowserNodeInfoArray = this.getSelectedNodes();
        if (iBrowserNodeInfoArray != null) {
            LDAPSearchConstraints lDAPSearchConstraints;
            LDAPConnection[] lDAPConnectionArray = new LDAPConnection[iBrowserNodeInfoArray.length];
            LDAPConnection[] lDAPConnectionArray2 = new LDAPConnection[iBrowserNodeInfoArray.length];
            boolean bl = false;
            int n = 0;
            while (n < lDAPConnectionArray.length && !bl) {
                if (this.continueOperation(iBrowserNodeInfoArray[n])) {
                    try {
                        lDAPConnectionArray2[n] = this.getConnectionForNode(iBrowserNodeInfoArray[n]);
                        lDAPConnectionArray[n] = this.makeConnectionToEdit(lDAPConnectionArray2[n], iBrowserNodeInfoArray[n]);
                        lDAPSearchConstraints = lDAPConnectionArray[n].getSearchConstraints();
                        lDAPSearchConstraints.setMaxResults(0);
                        lDAPConnectionArray[n].setSearchConstraints(lDAPSearchConstraints);
                    }
                    catch (LDAPException lDAPException) {
                        this.displayConnectionError(lDAPException, iBrowserNodeInfoArray[n]);
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                TreePath treePath;
                boolean bl2;
                lDAPSearchConstraints = new String[iBrowserNodeInfoArray.length];
                int n2 = 0;
                while (n2 < iBrowserNodeInfoArray.length) {
                    lDAPSearchConstraints[n2] = Helper.getNodeInfoDN(iBrowserNodeInfoArray[n2]);
                    ++n2;
                }
                CutDeleter cutDeleter = new CutDeleter(lDAPConnectionArray, (String[])lDAPSearchConstraints, (JFrame)((Object)this._framework), this._clipboard, false);
                cutDeleter.execute();
                boolean bl3 = !this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent;
                boolean bl4 = bl2 = !bl3 && this._list == this._lastSelectedComponent;
                if (bl3) {
                    if (cutDeleter.getDeletedSubtrees().contains(lDAPSearchConstraints[0])) {
                        treePath = this._inspectedNode.getTreePath().getParentPath();
                        this._tree.setSelectionPath(treePath);
                    }
                } else if (bl2 && cutDeleter.getDeletedSubtrees().size() == ((LDAPSearchConstraints)lDAPSearchConstraints).length) {
                    treePath = this._inspectedNode.getTreePath();
                    this._tree.setSelectionPath(treePath);
                }
                int n3 = 0;
                while (n3 < ((LDAPSearchConstraints)lDAPSearchConstraints).length) {
                    if (cutDeleter.getDeletedSubtrees().contains(lDAPSearchConstraints[n3])) {
                        if (bl3) {
                            this._controller.notifyEntryDeleted(iBrowserNodeInfoArray[n3]);
                        } else if (bl2) {
                            this._childrenController.notifyEntryDeleted(iBrowserNodeInfoArray[n3]);
                            if (this._inspectedNode != null) {
                                this._controller.notifyChildEntryDeleted(this._inspectedNode, (String)lDAPSearchConstraints[n3]);
                            }
                        }
                        this.checkObjectDeleted((String)lDAPSearchConstraints[n3]);
                    } else if (bl3) {
                        this._controller.startRefresh(iBrowserNodeInfoArray[n3]);
                    } else if (bl2) {
                        this._childrenController.notifyEntryChanged(iBrowserNodeInfoArray[n3]);
                        if (this._inspectedNode != null) {
                            this._controller.notifyChildEntryChanged(this._inspectedNode, (String)lDAPSearchConstraints[n3]);
                        }
                    }
                    ++n3;
                }
            }
            int n4 = 0;
            while (n4 < lDAPConnectionArray2.length) {
                if (lDAPConnectionArray2[n4] != null) {
                    this._connectionPool.releaseConnection(lDAPConnectionArray2[n4]);
                }
                ++n4;
            }
        }
    }

    private boolean checkObjectDeleted(String string) {
        boolean bl = false;
        DN dN = new DN(string);
        Enumeration enumeration = this._databaseConfig.getSuffixes().elements();
        while (enumeration.hasMoreElements() && !bl) {
            DN dN2;
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (suffix.getParentSuffix() != null || !suffix.hasRootEntry() || !dN.equals(dN2 = new DN(suffix.getName()))) continue;
            bl = true;
            this._databaseConfig.notifyRootEntryDeleted(suffix);
        }
        if (bl) {
            this._menuController.recreateNewRootEntryMenus();
        }
        return bl;
    }

    private void actionACL() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            try {
                lDAPConnection2 = this.getConnectionForNode(iBrowserNodeInfo);
                lDAPConnection = this.makeConnectionToEdit(lDAPConnection2, iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                DN dN;
                LDAPConnection lDAPConnection3 = Console.getConsoleInfo().getUserLDAPConnection();
                String string2 = "";
                if (lDAPConnection3.getHost().equals(lDAPConnection.getHost()) && lDAPConnection3.getPort() == lDAPConnection.getPort()) {
                    Debug.println((String)"ContentModel.actionACL: ACI and users are on the same directory");
                    string2 = Console.getConsoleInfo().getUserBaseDN();
                } else {
                    Debug.println((String)"ContentModel.actionACL: ACI and users are on different directories");
                    dN = new DN(string);
                    boolean bl = false;
                    Enumeration enumeration = this._databaseConfig.getSuffixes().elements();
                    while (enumeration.hasMoreElements() && !bl) {
                        DN dN2;
                        Suffix suffix = (Suffix)enumeration.nextElement();
                        if (suffix.getParentSuffix() != null || !dN.equals(dN2 = new DN(suffix.getName())) && !dN.isDescendantOf(dN2)) continue;
                        bl = true;
                        string2 = suffix.getName();
                    }
                }
                Debug.println((String)("ContentModel.actionACL: users will be search from " + string2));
                dN = new ACIManager((JFrame)((Object)this._framework), string, lDAPConnection, string, lDAPConnection, string2);
                dN.show();
                this.updateAfterModify(iBrowserNodeInfo, string);
            }
            if (lDAPConnection2 != null) {
                this._connectionPool.releaseConnection(lDAPConnection2);
            }
        }
    }

    private void actionEffectiveRights() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection2 != null) {
                EffectiveRightsInputDialog effectiveRightsInputDialog = new EffectiveRightsInputDialog(this._framework, lDAPConnection2, Helper.getNodeInfoDN(iBrowserNodeInfo));
                effectiveRightsInputDialog.pack();
                effectiveRightsInputDialog.show();
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionRoles() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            if (!iBrowserNodeInfo.isRemote()) {
                LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
                LDAPConnection lDAPConnection2 = null;
                try {
                    if (lDAPConnection == null) {
                        throw new LDAPException("failed to connect to server", 91);
                    }
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
                if (lDAPConnection2 != null) {
                    String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                    ConsoleInfo consoleInfo = new ConsoleInfo(lDAPConnection2.getHost(), lDAPConnection2.getPort(), lDAPConnection2.getAuthenticationDN() == null ? "" : lDAPConnection2.getAuthenticationDN(), lDAPConnection2.getAuthenticationDN() == null ? "" : lDAPConnection2.getAuthenticationPassword(), string);
                    consoleInfo.setCurrentDN(string);
                    consoleInfo.setUserGroupDN(string);
                    consoleInfo.setLDAPConnection(lDAPConnection2);
                    RoleEditorDialog roleEditorDialog = new RoleEditorDialog((JFrame)((Object)this._framework), consoleInfo);
                    roleEditorDialog.show();
                    this.updateAfterModify(iBrowserNodeInfo, string);
                }
            } else {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
            }
        }
    }

    private void actionSetPasswordPolicy() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            if (!iBrowserNodeInfo.isRemote()) {
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                LDAPConnection lDAPConnection = null;
                try {
                    lDAPConnection = this.makeNoReferralConnection(this._framework.getServerObject().getServerInfo().getLDAPConnection());
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
                if (lDAPConnection != null) {
                    PasswordPolicyEditorDialog passwordPolicyEditorDialog;
                    ConsoleInfo consoleInfo = new ConsoleInfo(lDAPConnection.getHost(), lDAPConnection.getPort(), lDAPConnection.getAuthenticationDN() == null ? "" : lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationDN() == null ? "" : lDAPConnection.getAuthenticationPassword(), string);
                    consoleInfo.setCurrentDN(string);
                    consoleInfo.setUserGroupDN(string);
                    consoleInfo.setLDAPConnection(lDAPConnection);
                    String[] stringArray = iBrowserNodeInfo.getObjectClassValues();
                    boolean bl = false;
                    int n = 0;
                    while (n < stringArray.length) {
                        String string2 = stringArray[n];
                        if (string2.toLowerCase().equals("nsroledefinition")) {
                            passwordPolicyEditorDialog = new PasswordPolicyEditorDialogForRoles(this._framework, consoleInfo);
                            bl = true;
                        }
                        ++n;
                    }
                    if (!bl) {
                        passwordPolicyEditorDialog = new PasswordPolicyEditorDialog(this._framework, consoleInfo);
                    }
                    this.updateAfterModify(iBrowserNodeInfo, string);
                }
            } else {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
            }
        }
    }

    private void actionCreateVLVIndex() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            if (!iBrowserNodeInfo.isRemote()) {
                VLVIndexHelper vLVIndexHelper = new VLVIndexHelper();
                vLVIndexHelper.setFramework(this._framework);
                if (vLVIndexHelper.createIndex(Helper.getNodeInfoDN(iBrowserNodeInfo))) {
                    this._vlvCache.vlvIndexCreated(Helper.getNodeInfoDN(iBrowserNodeInfo));
                    this._menuController.updateMenuState();
                }
            } else {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
            }
        }
    }

    private void actionDeleteVLVIndex() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            if (!iBrowserNodeInfo.isRemote()) {
                VLVIndexHelper vLVIndexHelper = new VLVIndexHelper();
                vLVIndexHelper.setFramework(this._framework);
                if (vLVIndexHelper.deleteIndex(Helper.getNodeInfoDN(iBrowserNodeInfo))) {
                    this._vlvCache.vlvIndexDeleted(Helper.getNodeInfoDN(iBrowserNodeInfo));
                    this._menuController.updateMenuState();
                }
            } else {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
            }
        }
    }

    private void actionInactivate() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            if (!iBrowserNodeInfo.isRemote()) {
                LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
                LDAPConnection lDAPConnection2 = null;
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                try {
                    if (lDAPConnection == null) {
                        throw new LDAPException("failed to connect to server", 91);
                    }
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    LDAPException lDAPException2 = lDAPException;
                    this.displayConnectionError(lDAPException2, iBrowserNodeInfo);
                }
                if (lDAPConnection2 != null) {
                    Inactivator inactivator = new Inactivator(this._framework, string, lDAPConnection2);
                    inactivator.execute();
                    this.updateViewAfterInactivation(iBrowserNodeInfo, inactivator.getLockingInfrastructureDNs());
                    this._activationCache.remove(Helper.getNodeInfoDN(iBrowserNodeInfo));
                    this._menuController.updateMenuState();
                }
            } else {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
            }
        }
    }

    private void updateViewAfterInactivation(IBrowserNodeInfo iBrowserNodeInfo, Vector vector) {
        String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
        if (vector != null && vector.size() > 0) {
            String string2;
            TreePath treePath;
            TreePath treePath2 = this._inspectedNode.getTreePath();
            while (treePath2.getPathCount() > 2) {
                treePath2 = treePath2.getParentPath();
            }
            IBrowserNodeInfo iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath2);
            boolean bl = false;
            if (this._layout.equals("NODE_LEAF_LAYOUT") && (treePath = this._inspectedNode.getTreePath()).getPathCount() == 2) {
                bl = true;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < vector.size()) {
                String string3 = (String)vector.elementAt(n);
                if (this._controller.isShowContainerOnly()) {
                    if (string3.indexOf("cn=nsAccountInactivationTmp") == 0) {
                        this._controller.notifyEntryAdded(iBrowserNodeInfo2, string3);
                        bl2 = true;
                    } else if (string3.indexOf("cn=\"cn=nsDisabledRole") == 0) {
                        bl3 = true;
                    }
                    if (bl && string3.indexOf("cn=\"cn=nsDisabledRole") < 0) {
                        this._childrenController.notifyEntryAdded(string3);
                    }
                } else if (string3.indexOf("cn=\"cn=nsDisabledRole") < 0) {
                    this._controller.notifyEntryAdded(iBrowserNodeInfo2, string3);
                }
                ++n;
            }
            if (this._controller.isShowContainerOnly() && bl3 && !bl2 && (string2 = Helper.getNodeInfoDN(iBrowserNodeInfo2)) != null) {
                this._controller.notifyEntryAdded(iBrowserNodeInfo2, "cn=nsAccountInactivationTmp, " + string2);
            }
        }
        this.updateAfterModify(iBrowserNodeInfo, string);
    }

    private void actionActivate() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            if (!iBrowserNodeInfo.isRemote()) {
                LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
                LDAPConnection lDAPConnection2 = null;
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                try {
                    if (lDAPConnection == null) {
                        throw new LDAPException("failed to connect to server", 91);
                    }
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    LDAPException lDAPException2 = lDAPException;
                    this.displayConnectionError(lDAPException2, iBrowserNodeInfo);
                }
                if (lDAPConnection2 != null) {
                    Activator activator = new Activator(this._framework, string, lDAPConnection2);
                    activator.execute();
                    this.updateAfterModify(iBrowserNodeInfo, string);
                    this._activationCache.remove(Helper.getNodeInfoDN(iBrowserNodeInfo));
                    this._menuController.updateMenuState();
                }
            } else {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
            }
        }
    }

    private void actionEdit() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection2 != null) {
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.editObject(string, lDAPConnection2, false);
                if (bl) {
                    String string2 = this._entryEditor.getEditedObjectDn();
                    this.updateAfterModify(iBrowserNodeInfo, string2);
                }
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionAdvancedEdit() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection2 != null) {
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.editObject(string, lDAPConnection2, true);
                if (bl) {
                    String string2 = this._entryEditor.getEditedObjectDn();
                    this.updateAfterModify(iBrowserNodeInfo, string2);
                }
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewUser() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            String string;
            boolean bl;
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            boolean bl2 = this.confirmationAddUnderReferral(iBrowserNodeInfo);
            if (bl2) {
                try {
                    lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
            }
            if (lDAPConnection2 != null && (bl = this._entryEditor.createUser(string = Helper.getNodeInfoDN(iBrowserNodeInfo), lDAPConnection2))) {
                LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                this.checkObjectAdded(lDAPEntry.getDN());
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewGroup() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            boolean bl = this.confirmationAddUnderReferral(iBrowserNodeInfo);
            if (bl) {
                try {
                    lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
            }
            if (lDAPConnection2 != null) {
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl2 = this._entryEditor.createGroup(string, lDAPConnection2);
                if (bl2) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN());
                }
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewPasswordPolicy() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            boolean bl = this.confirmationAddUnderReferral(iBrowserNodeInfo);
            if (bl) {
                try {
                    lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
            }
            if (lDAPConnection2 != null) {
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl2 = this._entryEditor.createPasswordPolicy(string, lDAPConnection2);
                if (bl2) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN());
                }
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewRole() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            boolean bl = this.confirmationAddUnderReferral(iBrowserNodeInfo);
            if (bl) {
                try {
                    lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
            }
            if (lDAPConnection2 != null) {
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl2 = this._entryEditor.createRole(string, lDAPConnection2);
                if (bl2) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN());
                }
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewCos() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            String string;
            boolean bl;
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            boolean bl2 = this.confirmationAddUnderReferral(iBrowserNodeInfo);
            if (bl2) {
                try {
                    lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
            }
            if (lDAPConnection2 != null && (bl = this._entryEditor.createCos(string = Helper.getNodeInfoDN(iBrowserNodeInfo), lDAPConnection2))) {
                LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                this.checkObjectAdded(lDAPEntry.getDN());
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewOrganizationalUnit() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            String string;
            boolean bl;
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            boolean bl2 = this.confirmationAddUnderReferral(iBrowserNodeInfo);
            if (bl2) {
                try {
                    lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
            }
            if (lDAPConnection2 != null && (bl = this._entryEditor.createOrganizationalUnit(string = Helper.getNodeInfoDN(iBrowserNodeInfo), lDAPConnection2))) {
                LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                this.checkObjectAdded(lDAPEntry.getDN());
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewReferral() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            String string;
            boolean bl;
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            boolean bl2 = this.confirmationAddUnderReferral(iBrowserNodeInfo);
            if (bl2) {
                try {
                    lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
            }
            if (lDAPConnection2 != null && (bl = this._entryEditor.createReferral(string = Helper.getNodeInfoDN(iBrowserNodeInfo), lDAPConnection2))) {
                LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                this.checkObjectAdded(lDAPEntry.getDN());
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionCreateRootEntry(String string) {
        block4: {
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            try {
                if (lDAPConnection != null) {
                    boolean bl = this._entryEditor.createRootObject(string, lDAPConnection);
                    if (bl) {
                        this.checkObjectAdded(string);
                    }
                    break block4;
                }
                throw new LDAPException("failed to connect to server", 91);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{"", DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "getting-connection-error-title", "getting-connection-error-msg", stringArray, "browser");
            }
        }
    }

    private void actionNewObject() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            LDAPConnection lDAPConnection2 = null;
            boolean bl = this.confirmationAddUnderReferral(iBrowserNodeInfo);
            if (bl) {
                try {
                    lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
                    lDAPConnection2 = this.makeConnectionToEdit(lDAPConnection, iBrowserNodeInfo);
                }
                catch (LDAPException lDAPException) {
                    this.displayConnectionError(lDAPException, iBrowserNodeInfo);
                }
            }
            if (lDAPConnection2 != null) {
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl2 = this._entryEditor.createObject(string, lDAPConnection2);
                if (bl2) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN());
                }
            }
            if (lDAPConnection != null) {
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void updateAfterModify(IBrowserNodeInfo iBrowserNodeInfo, String string) {
        String string2 = Helper.getNodeInfoDN(iBrowserNodeInfo);
        DN dN = new DN(string2);
        DN dN2 = new DN(string);
        this._attributeController.remove(iBrowserNodeInfo.getURL());
        this._activationCache.remove(string2);
        this._menuController.updateMenuState();
        if (!dN.equals(dN2)) {
            this.checkObjectAdded(string);
            if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                TreePath treePath = this._controller.notifyEntryDeleted(iBrowserNodeInfo);
                IBrowserNodeInfo iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath);
                TreePath treePath2 = this._controller.notifyEntryAdded(iBrowserNodeInfo2, string);
                this._tree.setSelectionPath(treePath2);
            } else if (this._list == this._lastSelectedComponent) {
                this._childrenController.notifyEntryDeleted(iBrowserNodeInfo);
                int n = this._childrenController.notifyEntryAdded(string);
                this._list.setSelectedIndex(n);
                if (this._inspectedNode != null) {
                    this._controller.notifyChildEntryDeleted(this._inspectedNode, string2);
                    this._controller.notifyChildEntryAdded(this._inspectedNode, string);
                }
            }
        } else if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
            this._controller.notifyEntryChanged(iBrowserNodeInfo);
            if (this._layout.equals("ATTRIBUTE_LAYOUT")) {
                this._attributeController.updateAttributePanel(iBrowserNodeInfo);
            }
        } else if (this._list == this._lastSelectedComponent) {
            this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
            if (this._inspectedNode != null) {
                this._controller.notifyChildEntryChanged(this._inspectedNode, string);
            }
        }
    }

    private boolean checkObjectAdded(String string) {
        boolean bl = false;
        DN dN = new DN(string);
        Enumeration enumeration = this._databaseConfig.getSuffixes().elements();
        while (enumeration.hasMoreElements() && !bl) {
            DN dN2;
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (suffix.getParentSuffix() != null || suffix.hasRootEntry() || !dN.equals(dN2 = new DN(suffix.getName()))) continue;
            bl = true;
            this._databaseConfig.notifyRootEntryAdded(suffix);
        }
        if (bl) {
            this._menuController.recreateNewRootEntryMenus();
        }
        return bl;
    }

    private void updateViewAfterAdd(LDAPEntry lDAPEntry, IBrowserNodeInfo iBrowserNodeInfo) {
        String string = lDAPEntry.getDN();
        if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
            if (this._layout.equals("NODE_LEAF_LAYOUT")) {
                this._childrenController.notifyEntryAdded(string);
                if (this.isContainerObject(lDAPEntry)) {
                    this._controller.notifyEntryAdded(iBrowserNodeInfo, string);
                }
            } else {
                this._controller.notifyEntryAdded(iBrowserNodeInfo, string);
            }
        } else if (this._list == this._lastSelectedComponent) {
            this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
            if (this._inspectedNode != null) {
                this._controller.notifyChildEntryAdded(this._inspectedNode, string);
            }
        }
    }

    private boolean isContainerObject(LDAPEntry lDAPEntry) {
        boolean bl = false;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements() && !bl) {
                String string = (String)enumeration.nextElement();
                int n = 0;
                while (n < CONTAINER_OBJECTCLASSES.length && !bl) {
                    if (string.equalsIgnoreCase(CONTAINER_OBJECTCLASSES[n])) {
                        bl = true;
                    } else if (this.getFollowReferrals() && string.equalsIgnoreCase("referral")) {
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    private void actionAuthenticate() {
        boolean bl = this.getNewAuthentication();
    }

    private void actionReferralAuthentication() {
        ReferralAuthenticationDialog referralAuthenticationDialog = new ReferralAuthenticationDialog((JFrame)((Object)this._framework), this._connectionPool);
        referralAuthenticationDialog.pack();
        referralAuthenticationDialog.show();
    }

    public LDAPSchema getSchema() {
        return DSUtil.getSchema(this._framework.getServerObject().getServerInfo());
    }

    public void setSchema(LDAPSchema lDAPSchema) {
        DSUtil.setSchema(this._framework.getServerObject().getServerInfo(), lDAPSchema);
    }

    protected LDAPConnection getConnectionForNode(IBrowserNodeInfo iBrowserNodeInfo) throws LDAPException {
        LDAPConnection lDAPConnection = this._connectionPool.getConnection(iBrowserNodeInfo.getURL());
        return lDAPConnection;
    }

    protected LDAPConnection makeConnectionToEdit(LDAPConnection lDAPConnection, IBrowserNodeInfo iBrowserNodeInfo) throws LDAPException {
        LDAPConnection lDAPConnection2;
        if (iBrowserNodeInfo.getReferral() != null) {
            lDAPConnection2 = this.makeNoReferralConnection(lDAPConnection);
        } else {
            lDAPConnection2 = (LDAPConnection)lDAPConnection.clone();
            if (lDAPConnection2 != null) {
                LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
            } else {
                throw new LDAPException("failed to connect to server", 91);
            }
        }
        return lDAPConnection2;
    }

    protected LDAPConnection makeNoReferralConnection(LDAPConnection lDAPConnection) throws LDAPException {
        LDAPConnection lDAPConnection2 = (LDAPConnection)lDAPConnection.clone();
        if (lDAPConnection2 == null) {
            throw new LDAPException("failed to connect to server", 91);
        }
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        lDAPSearchConstraints.setServerControls(_manageDSAITControl);
        lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
        return lDAPConnection2;
    }

    protected IBrowserNodeInfo getSelectedNodeInfo() {
        IBrowserNodeInfo iBrowserNodeInfo = null;
        IBrowserNodeInfo[] iBrowserNodeInfoArray = this.getSelectedNodes();
        if (iBrowserNodeInfoArray != null) {
            iBrowserNodeInfo = iBrowserNodeInfoArray[0];
        }
        return iBrowserNodeInfo;
    }

    protected IBrowserNodeInfo[] getSelectedNodes() {
        int[] nArray;
        IBrowserNodeInfo[] iBrowserNodeInfoArray = null;
        if (this._lastSelectedComponent == this._tree || !this._layout.equals("NODE_LEAF_LAYOUT")) {
            TreePath treePath = this._tree.getSelectionPath();
            if (treePath != null) {
                iBrowserNodeInfoArray = new IBrowserNodeInfo[]{this._controller.getNodeInfoFromPath(treePath)};
            }
        } else if (this._lastSelectedComponent == this._list && (nArray = this._list.getSelectedIndices()) != null && nArray.length > 0) {
            iBrowserNodeInfoArray = new IBrowserNodeInfo[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                iBrowserNodeInfoArray[n] = this._childrenController.getNodeInfoFromIndex(nArray[n]);
                ++n;
            }
        }
        return iBrowserNodeInfoArray;
    }

    private void setBusyCursor(boolean bl) {
        int n = bl ? 3 : 0;
        Cursor cursor = Cursor.getPredefinedCursor(n);
        this.setCursor(this, cursor);
    }

    private void setCursor(Container container, Cursor cursor) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof Container) {
                    this.setCursor((Container)componentArray[n], cursor);
                }
                ++n;
            }
        }
        container.setCursor(cursor);
    }

    private void displayConnectionError(LDAPException lDAPException, IBrowserNodeInfo iBrowserNodeInfo) {
        String[] stringArray = new String[]{DSContentPage.findDisplayNameFromNode(iBrowserNodeInfo), DSUtil.getLDAPErrorMessage(lDAPException)};
        DSUtil.showErrorDialog((Component)((Object)this._framework), "getting-connection-error-title", "getting-connection-error-msg", stringArray, "browser");
    }

    private Vector getRootSuffixesWithEntry() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._databaseConfig.getSuffixes().elements();
        while (enumeration.hasMoreElements()) {
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (suffix.getParentSuffix() != null || !suffix.hasRootEntry()) continue;
            vector.addElement(suffix.getName());
        }
        return vector;
    }
}

