/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.AdminConfigData;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleBytePasswordField;
import com.netscape.management.client.util.SingleByteTextField;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class UGDirectoryConfigPanel
extends PluginConfigPanel
implements SuiConstants {
    IConfigDataModel _configData;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nLdapURL = _resource.getString("ldapds", "LdapURL");
    static String _i18nUseGlobal;
    static String _i18nOverrideGlobal;
    static String _i18nBindDN;
    static String _i18nBindPW;
    static String _i18nEnterBindDN;
    static String _i18nEnterBindPW;
    static String _i18nHost;
    static String _i18nHostUsage;
    static String _i18nPort;
    static String _i18nUseSSL;
    static String _i18nBaseDN;
    static String _i18nUGGroupbox;
    static String _i18nEnterLdapHost;
    static String _i18nEnterBaseDN;
    static String _i18nPortRange;
    static String _i18nWarnCert;
    Help _help;
    JLabel _lblGlobalLdapURL;
    JLabel _lblGlobalLdapURLValue;
    JLabel _lblBindDN;
    JLabel _lblBindPW1;
    JRadioButton _rbUseGlobal;
    JRadioButton _rbOverrideGlobal;
    JTextField _txtBindDN;
    SingleBytePasswordField _txtBindPW1;
    JLabel _lblHost;
    JLabel _lblHostUsage;
    JLabel _lblBaseDN;
    JTextField _txtBaseDN;
    SingleByteTextField _txtHost;
    JCheckBox _cbSSL;
    ItemListener _rbListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = true;
            if (itemEvent.getSource() == UGDirectoryConfigPanel.this._rbUseGlobal && UGDirectoryConfigPanel.this._rbUseGlobal.isSelected()) {
                bl = false;
            }
            UGDirectoryConfigPanel.this._lblHost.setEnabled(bl);
            UGDirectoryConfigPanel.this._lblHost.repaint();
            UGDirectoryConfigPanel.this._lblHostUsage.setEnabled(bl);
            UGDirectoryConfigPanel.this._lblHostUsage.repaint();
            UGDirectoryConfigPanel.this._lblBaseDN.setEnabled(bl);
            UGDirectoryConfigPanel.this._lblBaseDN.repaint();
            UGDirectoryConfigPanel.this._lblBindDN.setEnabled(bl);
            UGDirectoryConfigPanel.this._lblBindDN.repaint();
            UGDirectoryConfigPanel.this._lblBindPW1.setEnabled(bl);
            UGDirectoryConfigPanel.this._lblBindPW1.repaint();
            UGDirectoryConfigPanel.this._txtHost.setEnabled(bl);
            UGDirectoryConfigPanel.this._txtBaseDN.setEnabled(bl);
            UGDirectoryConfigPanel.this._txtBindDN.setEnabled(bl);
            UGDirectoryConfigPanel.this._txtBindPW1.setEnabled(bl);
            UGDirectoryConfigPanel.this._cbSSL.setEnabled(bl);
            Color color = bl ? Color.white : UIManager.getColor("Label.background");
            UGDirectoryConfigPanel.this._txtHost.setBackground(color);
            UGDirectoryConfigPanel.this._txtBaseDN.setBackground(color);
            UGDirectoryConfigPanel.this._txtBindDN.setBackground(color);
            UGDirectoryConfigPanel.this._txtBindPW1.setBackground(color);
        }
    };
    ActionListener _cbSSLListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (UGDirectoryConfigPanel.this._cbSSL.isSelected()) {
                // empty if block
            }
        }
    };

    public UGDirectoryConfigPanel(String string, IConfigDataModel iConfigDataModel) {
        super(string);
        this._configData = iConfigDataModel;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("ugLdapHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel iConfigDataModel) {
        this._configData = iConfigDataModel;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws RemoteRequestException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        this._rbUseGlobal.addItemListener(this._rbListener);
        this._rbOverrideGlobal.addItemListener(this._rbListener);
        this._cbSSL.addActionListener(this._cbSSLListener);
        this.setPanelContent(this._configData);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ConfigPanelException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor((JTextComponent)this._txtHost);
        editMonitor.monitor(this._cbSSL);
        editMonitor.monitor(this._txtBindDN);
        editMonitor.monitor((JTextComponent)this._txtBindPW1);
        editMonitor.monitor(this._rbUseGlobal);
        editMonitor.monitor(this._rbOverrideGlobal);
    }

    public void setPanelContent(IConfigDataModel iConfigDataModel) {
        boolean bl;
        String string = iConfigDataModel.getAttribute("ugdsconfig.inforef");
        Debug.println((String)("inforef=" + string));
        this.setGlobalLdapURL(iConfigDataModel.getAttribute("ugdsconfig.globaldirurl"));
        boolean bl2 = bl = string != null && string.length() > 0;
        if (bl) {
            this._rbUseGlobal.setSelected(true);
            this.setLdapHost("");
            this._cbSSL.setEnabled(false);
            this.setBaseDN("");
            this.setBindDN("");
            this.setBindPW1("");
        } else {
            this._rbOverrideGlobal.setSelected(true);
            this.setLdapURL(iConfigDataModel.getAttribute("ugdsconfig.dirurl"));
            this.setBindDN(iConfigDataModel.getAttribute("ugdsconfig.binddn"));
            this.setBindPW1(iConfigDataModel.getAttribute("ugdsconfig.bindpw"));
        }
    }

    public void setLdapHost(String string) {
        this._txtHost.setText(string != null ? string : "");
    }

    public void setBaseDN(String string) {
        if (string == null) {
            this._txtBaseDN.setText("");
        } else if (string.startsWith("/")) {
            this._txtBaseDN.setText(string.substring(1));
        } else {
            this._txtBaseDN.setText(string);
        }
    }

    public void setLdapURL(String string) {
        String string2;
        if (string.startsWith("ldaps://")) {
            this._cbSSL.setSelected(true);
            string2 = string.substring(8);
        } else if (string.startsWith("ldap://")) {
            this._cbSSL.setSelected(false);
            string2 = string.substring(7);
        } else {
            Debug.println((String)("ERROR: Bad Ldap url " + string));
            return;
        }
        Debug.println((String)("parse=" + string2));
        int n = string2.indexOf(47, 8);
        this.setLdapHost(string2.substring(0, n));
        this.setBaseDN(string2.substring(n + 1));
    }

    private String getLdapURL() throws ValidationException {
        String string = this._txtHost.getText().trim();
        String string2 = this._txtBaseDN.getText().trim();
        if (string.length() == 0) {
            throw new ValidationException("", _i18nEnterLdapHost);
        }
        if (string2.length() == 0) {
            throw new ValidationException("", _i18nEnterBaseDN);
        }
        String string3 = this._txtHost.getText().trim() + "/" + this._txtBaseDN.getText().trim();
        if (this._cbSSL.isSelected()) {
            return "ldaps://" + string3;
        }
        return "ldap://" + string3;
    }

    public void setGlobalLdapURL(String string) {
        this._lblGlobalLdapURLValue.setText(string != null ? string : "");
        this._lblGlobalLdapURLValue.repaint();
    }

    void setBindDN(String string) {
        this._txtBindDN.setText(string == null ? "" : string);
    }

    void setBindPW1(String string) {
        this._txtBindPW1.setText(string == null ? "" : string);
    }

    public void getPanelContent(IConfigDataModel iConfigDataModel) throws ConfigPanelException {
        if (this._rbOverrideGlobal.isSelected()) {
            String string = this.getLdapURL();
            String string2 = this._txtBindDN.getText().trim();
            String string3 = this._txtBindPW1.getText().trim();
            boolean bl = !iConfigDataModel.getAttribute("ugdsconfig.dirurl").equals("");
            bl = bl || !string.equals(iConfigDataModel.getAttribute("ugdsconfig.dirurl"));
            bl = bl || !string2.equals(iConfigDataModel.getAttribute("ugdsconfig.binddn"));
            boolean bl2 = bl = bl || !string3.equals(iConfigDataModel.getAttribute("ugdsconfig.bindpw"));
            if (!bl) {
                return;
            }
            if (string2.length() == 0 && string3.length() != 0) {
                throw new ValidationException("", _i18nEnterBindDN);
            }
            this.connectAndValidate();
            iConfigDataModel.setAttribute("ugdsconfig.dirurl", string);
            iConfigDataModel.setAttribute("ugdsconfig.binddn", string2);
            iConfigDataModel.setAttribute("ugdsconfig.bindpw", string3);
            iConfigDataModel.setAttribute("ugdsconfig.inforef", "");
        } else {
            iConfigDataModel.setAttribute("ugdsconfig.inforef", "default");
        }
        if (iConfigDataModel instanceof AdminConfigData) {
            ((AdminConfigData)iConfigDataModel).setDialogParent(this);
        }
    }

    private void connectAndValidate() throws ConfigPanelException {
        ConsoleInfo consoleInfo;
        String string;
        String string2 = this._txtHost.getText().trim();
        String string3 = this._txtBaseDN.getText().trim();
        String string4 = this._txtBindPW1.getText().trim();
        String string5 = this._txtBindDN.getText().trim();
        boolean bl = this._cbSSL.isSelected();
        int n = -1;
        if (string2.indexOf(" ") != -1 && (string = (String)(consoleInfo = ((AdminConfigData)this._configData).getConsoleInfo()).get("SIE_VERSION")).equals("4.0")) {
            String string6 = _resource.getString("ldapds", "FailoverSupport");
            throw new ValidationException("", string6);
        }
        try {
            LDAPUtil.validateLDAPParams((String)string2, (int)n, (boolean)bl, (String)string5, (String)string4, (String)string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ValidationException("", illegalArgumentException.getMessage());
        }
    }

    protected JComponent makeConfigPanel() {
        JPanel jPanel = new JPanel();
        GBC gBC = new GBC();
        int n = 0;
        int n2 = 20;
        jPanel.setBorder(BaseConfigPanel.createGroupBorder(_i18nUGGroupbox));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, n, 3, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this.createInfoMessage(), gBC);
        this._rbUseGlobal = new JRadioButton(_i18nUseGlobal, false);
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, ++n, 3, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._rbUseGlobal, gBC);
        this._lblGlobalLdapURL = new JLabel(_i18nLdapURL);
        gBC.setInsets(0, n2, 0, 0);
        gBC.setGrid(0, ++n, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblGlobalLdapURL, gBC);
        this._lblGlobalLdapURLValue = new JLabel(".");
        gBC.setInsets(0, 9, 0, 0);
        gBC.setGrid(1, n, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._lblGlobalLdapURLValue, gBC);
        this._rbOverrideGlobal = new JRadioButton(_i18nOverrideGlobal, false);
        gBC.setInsets(9, 0, 0, 0);
        gBC.setGrid(0, ++n, 3, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._rbOverrideGlobal, gBC);
        this._lblHost = new JLabel(_i18nHost);
        gBC.setInsets(0, n2, 0, 0);
        gBC.setGrid(0, ++n, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblHost, gBC);
        this._txtHost = new SingleByteTextField(16);
        gBC.setInsets(0, 9, 0, 0);
        gBC.setGrid(1, n, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtHost, gBC);
        this._lblHost.setLabelFor((Component)this._txtHost);
        this._lblHostUsage = new JLabel(_i18nHostUsage);
        gBC.setInsets(0, n2, 0, 0);
        gBC.setGrid(0, ++n, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblHostUsage, gBC);
        this._cbSSL = new JCheckBox(_i18nUseSSL, false);
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, ++n, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._cbSSL, gBC);
        this._lblBaseDN = new JLabel(_i18nBaseDN);
        this._lblBaseDN.setFont(BaseConfigPanel.getLabelFont());
        gBC.setInsets(6, 0, 0, 0);
        gBC.setGrid(0, ++n, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblBaseDN, gBC);
        this._txtBaseDN = new JTextField(16);
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, n, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtBaseDN, gBC);
        this._lblBaseDN.setLabelFor(this._txtBaseDN);
        this._lblBindDN = new JLabel(_i18nBindDN);
        gBC.setInsets(6, n2, 0, 0);
        gBC.setGrid(0, ++n, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblBindDN, gBC);
        this._txtBindDN = new JTextField(16);
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, n, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtBindDN, gBC);
        this._lblBindDN.setLabelFor(this._txtBindDN);
        this._lblBindPW1 = new JLabel(_i18nBindPW);
        gBC.setInsets(6, n2, 0, 0);
        gBC.setGrid(0, ++n, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblBindPW1, gBC);
        this._txtBindPW1 = new SingleBytePasswordField(16);
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, n, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtBindPW1, gBC);
        this._lblBindPW1.setLabelFor((Component)this._txtBindPW1);
        ++n;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbUseGlobal);
        buttonGroup.add(this._rbOverrideGlobal);
        return jPanel;
    }

    private JPanel createInfoMessage() {
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        int n = 0;
        JLabel jLabel = new JLabel();
        gBC.setInsets(0, 6, 0, 0);
        gBC.setGrid(1, n, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        MultilineLabel multilineLabel = new MultilineLabel(_i18nWarnCert, 1, 36);
        jPanel.add((Component)multilineLabel, gBC);
        multilineLabel.setFont(jLabel.getFont());
        ++n;
        return jPanel;
    }

    static {
        _i18nBindDN = _resource.getString("ldapds", "BindDN");
        _i18nBindPW = _resource.getString("ldapds", "BindPW");
        _i18nUseGlobal = _resource.getString("ldapds", "UseGlobal");
        _i18nOverrideGlobal = _resource.getString("ldapds", "OverrideGlobal");
        _i18nEnterBindDN = _resource.getString("ldapds", "EnterBindDN");
        _i18nEnterBindPW = _resource.getString("ldapds", "EnterBindPW");
        _i18nHost = _resource.getString("ldapds", "UGHost");
        _i18nHostUsage = _resource.getString("ldapds", "UGHostUsage");
        _i18nPort = _resource.getString("ldapds", "Port");
        _i18nUseSSL = _resource.getString("ldapds", "UseSSL");
        _i18nBaseDN = _resource.getString("ldapds", "BaseDN");
        _i18nUGGroupbox = _resource.getString("ldapds", "UGGroupbox");
        _i18nEnterLdapHost = _resource.getString("ldapds", "EnterHostPortList");
        _i18nEnterBaseDN = _resource.getString("ldapds", "EnterBaseDN");
        _i18nPortRange = _resource.getString("common", "PortRange");
        _i18nWarnCert = _resource.getString("ldapds", "WarnCert");
    }
}

