/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.logging;

import com.netscape.management.admserv.AdminServer;
import com.netscape.management.client.comm.AbstractCommClient;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.logging.ILogViewerModel;
import com.netscape.management.client.logging.LogLengthCommClient;
import com.netscape.management.client.logging.LogViewerModel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.table.DefaultTableModel;

public class ErrorLogViewerModel
extends LogViewerModel {
    ConsoleInfo _consoleInfo;
    String _url;
    String _username;
    String _password;
    int _logLength = 0;
    private boolean _isInitialized = false;
    private boolean _logLengthAvailable = false;
    private boolean _logLengthCalculating = false;
    StringBuffer _logLengthStringBuffer = null;
    public static ResourceSet _resource = AdminServer._resource;

    public ErrorLogViewerModel(ConsoleInfo consoleInfo, String string) {
        this._consoleInfo = consoleInfo;
        this._url = this._consoleInfo.getAdminURL() + string;
        this._username = this._consoleInfo.getAuthenticationDN();
        this._password = this._consoleInfo.getAuthenticationPassword();
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "lineno"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "date"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "time"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "severity"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "details"));
        this._isInitialized = true;
    }

    public void populateRows(int n, int n2) {
        Debug.println((int)6, (String)("ErrorLogViewer: populateRows " + n + " to " + (n + n2)));
        try {
            URL uRL = new URL(this._url + "?op=read" + "&start=" + n + "&stop=" + (n + n2) + "&" + URLEncoder.encode("name=../../../../admin-serv/logs/error"));
            HttpManager httpManager = new HttpManager();
            ErrorLogDataClient errorLogDataClient = new ErrorLogDataClient(this._username, this._password);
            httpManager.get(uRL, (CommClient)errorLogDataClient, (Object)this, 3);
        }
        catch (Exception exception) {
            Debug.println((int)4, (String)("ErrorLogViewer: populateRows() " + exception));
        }
    }

    public int getLogLength() {
        if (!this._isInitialized) {
            return -1;
        }
        long l = System.currentTimeMillis();
        if (l - this._lastLogLengthCheckTime > LogViewerModel.UPDATE_INTERVAL && !this._logLengthCalculating) {
            this._lastLogLengthCheckTime = l;
            try {
                this._logLengthCalculating = true;
                this._logLengthAvailable = false;
                this._logLengthStringBuffer = new StringBuffer();
                URL uRL = new URL(this._url + "?op=count" + "&" + URLEncoder.encode("name=../../../../admin-serv/logs/error"));
                HttpManager httpManager = new HttpManager();
                ErrorLogLengthCommClient errorLogLengthCommClient = new ErrorLogLengthCommClient(this._username, this._password);
                httpManager.get(uRL, (CommClient)errorLogLengthCommClient, (Object)this._logLengthStringBuffer, 3);
            }
            catch (Exception exception) {
                this._logLengthCalculating = false;
                Debug.println((int)4, (String)("ErrorLogViewer: getLogLength(): " + exception));
            }
        }
        if (this._logLengthAvailable) {
            try {
                this._logLength = Integer.parseInt(this._logLengthStringBuffer.toString());
                Debug.println((int)6, (String)("ErrorLogViewer: _logLength=" + this._logLength));
            }
            catch (NumberFormatException numberFormatException) {
                Debug.println((int)4, (String)("ErrorLogViewer: Cannot convert log length: " + this._logLengthStringBuffer.toString()));
            }
        }
        return this._logLength;
    }

    public class ErrorLogLengthCommClient
    extends LogLengthCommClient {
        public ErrorLogLengthCommClient(String string, String string2) {
            super(string, string2);
            Debug.println((int)9, (String)"ErrorLogViewer: ErrorLogLengthCommClient.<init>");
        }

        public synchronized void finish() {
            super.finish();
            ErrorLogViewerModel.this._logLengthAvailable = true;
            ErrorLogViewerModel.this._logLengthCalculating = false;
            ErrorLogViewerModel.this.tableDataChanged();
            Debug.println((int)9, (String)"ErrorLogViewer: ErrorLogLengthCommClient.finish()");
        }
    }

    class ErrorLogDataClient
    extends AbstractCommClient {
        final int STATE_START = 0;
        final int STATE_DATE = 1;
        final int STATE_TIME = 2;
        final int STATE_SEVERITY = 3;
        final int STATE_DETAIL = 4;
        protected LogViewerModel _model;

        public ErrorLogDataClient(String string, String string2) {
            super(string, string2);
        }

        protected ErrorLogData parse(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            ErrorLogData errorLogData = new ErrorLogData();
            int n = stringBuffer.length();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                char c = stringBuffer.charAt(n3);
                switch (n2) {
                    case 0: {
                        if (c != '[') break;
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        if (c == ':') {
                            n2 = 2;
                            break;
                        }
                        errorLogData.date.append(c);
                        break;
                    }
                    case 2: {
                        if (c == ']') {
                            n2 = 3;
                            break;
                        }
                        errorLogData.time.append(c);
                        break;
                    }
                    case 3: {
                        if (c == ':') {
                            n2 = 4;
                            break;
                        }
                        if (c == ' ') break;
                        errorLogData.severity.append(c);
                        break;
                    }
                    case 4: {
                        errorLogData.detail.append(c);
                    }
                }
                ++n3;
            }
            return errorLogData;
        }

        public void replyHandler(InputStream inputStream, CommRecord commRecord) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ILogViewerModel iLogViewerModel = (ILogViewerModel)commRecord.getArg();
            int n = iLogViewerModel.getRowOffset();
            int n2 = iLogViewerModel.getBufferLength();
            String string = null;
            int n3 = 0;
            while (n3 < n2) {
                try {
                    string = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    Debug.println((int)4, (String)("ErrorLogViewer: repxlyHandler() " + exception));
                }
                if (string == null) break;
                ErrorLogData errorLogData = this.parse(string);
                iLogViewerModel.setValueAt(Integer.toString(n + n3), n3, 0);
                iLogViewerModel.setValueAt(errorLogData.date, n3, 1);
                iLogViewerModel.setValueAt(errorLogData.time, n3, 2);
                iLogViewerModel.setValueAt(errorLogData.severity, n3, 3);
                iLogViewerModel.setValueAt(errorLogData.detail, n3, 4);
                ++n3;
            }
            this.finish();
        }

        public synchronized void finish() {
            super.finish();
            ErrorLogViewerModel.this.tableDataChanged();
        }

        class ErrorLogData {
            StringBuffer date = new StringBuffer();
            StringBuffer time = new StringBuffer();
            StringBuffer severity = new StringBuffer();
            StringBuffer detail = new StringBuffer();

            ErrorLogData() {
            }
        }
    }
}

