/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.Framework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceModel;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceModelEvent;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.components.StatusDialog;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.AbstractServerObject;
import com.netscape.management.client.topology.AdminGroupNode;
import com.netscape.management.client.topology.CloneTarget;
import com.netscape.management.client.topology.IRemovableServerObject;
import com.netscape.management.client.topology.IServerObject;
import com.netscape.management.client.topology.PermissionDlg;
import com.netscape.management.client.topology.ProductSelectionDialog;
import com.netscape.management.client.topology.ServerLocNode;
import com.netscape.management.client.topology.ServerNode;
import com.netscape.management.client.topology.ServiceLocator;
import com.netscape.management.client.topology.TopologyModel;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.IProgressListener;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.LocalJarClassLoader;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPSortControl;

public class ServerNode
extends ServerLocNode
implements IMenuInfo,
ChangeListener {
    private static final String ERROR_PREFIX = "error";
    public static final String MENU_SET_ACL = "setAcl";
    public static final String MENU_OPEN_SERVER = "open";
    public static final String MENU_CLONE_SERVER = "clone";
    public static final String MENU_REMOVE_SERVER = "remove";
    private boolean enableSetACLMenuItem = false;
    private boolean enableOpenMenuItem = true;
    private boolean enableCloneMenuItem = false;
    private boolean enableRemoveMenuItem = false;
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.topology.topology");
    private IPage viewInstance = null;
    private JFrame parentFrame = null;
    private StatusDialog statusDialog = null;
    private ConsoleInfo consoleInfo;
    private LDAPConnection ldc;
    private LDAPEntry ldapEntry;
    private String topologyDN;
    private IServerObject serverObject;
    private static Hashtable serverObjectsCache = new Hashtable();
    private boolean isSelectPending = false;
    private Component customPanel = null;
    private int fontStyle;
    private String cacheIconPath;
    private static RemoteImage noJarIcon = new RemoteImage(resource.getString("tree", "noJarIcon"));
    private static RemoteImage failedLoadIcon = new RemoteImage(resource.getString("tree", "failedLoadIcon"));
    private static ProductSelectionDialog cloneSelection = null;
    private static String[] nicknameList = null;
    private static KeyAdapter tmpGrabKey = new /* Unavailable Anonymous Inner Class!! */;
    private static MouseAdapter tmpGrabMouse = new /* Unavailable Anonymous Inner Class!! */;

    public ServerNode(ServiceLocator serviceLocator, LDAPEntry lDAPEntry) {
        this(serviceLocator.getConsoleInfo(), serviceLocator, lDAPEntry);
    }

    public ServerNode(ConsoleInfo consoleInfo, ServiceLocator serviceLocator, LDAPEntry lDAPEntry) {
        super(serviceLocator);
        this.ldapEntry = lDAPEntry;
        this.consoleInfo = consoleInfo;
        this.ldc = consoleInfo.getLDAPConnection();
        this.setDN(lDAPEntry.getDN());
        this.initialize(lDAPEntry);
    }

    int getFontStyle() {
        return this.fontStyle;
    }

    void setFontStyle(int n) {
        this.fontStyle = n;
    }

    public void initialize(LDAPEntry lDAPEntry) {
        String string;
        String string2 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("serverProductName", LDAPUtil.getLDAPAttributeLocale()));
        if (string2 == null) {
            string2 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale()));
        }
        this.topologyDN = string = lDAPEntry.getDN();
        ((ResourceObject)((Object)this)).setName(string2);
        noJarIcon.setDescription(resource.getString("tree", "noJarIcon-description"));
        failedLoadIcon.setDescription(resource.getString("tree", "failedLoadIcon-description"));
        ((ResourceObject)((Object)this)).setIcon((Icon)noJarIcon);
        this.setFontStyle(0);
        Object v = serverObjectsCache.get(string);
        if (v != null) {
            this._fLoaded = true;
            this.changeServerObject((IServerObject)v);
        } else {
            String string3;
            String string4 = string3 = this.getJARClassName(this.ldc, string);
            if (string3.indexOf(46) > 0) {
                string4 = string3.substring(0, string3.indexOf(46));
            }
            this.cacheIconPath = "jars/" + string4 + ".icon";
            ImageIcon imageIcon = (ImageIcon)ServerNode.getIconFromCache(this.cacheIconPath);
            if (imageIcon != null) {
                ((ResourceObject)((Object)this)).setIcon(imageIcon);
            } else if (ClassLoaderUtil.isAlreadyDownload(string3)) {
                this.reload();
            } else {
                String string5 = LocalJarClassLoader.checkForNewerVersion(string3);
                if (string5 != null && ClassLoaderUtil.isAlreadyDownload(string5)) {
                    this.reload();
                }
            }
        }
    }

    public void reload() {
        if (!this._fLoaded && this.serverObject == null) {
            this._fLoaded = true;
            ServerLoadThread serverLoadThread = new ServerLoadThread(this, this.topologyDN, ((ResourceObject)((Object)this)).getName(), true);
            serverLoadThread.start();
        }
    }

    void reload(IPage iPage) {
        this.viewInstance = iPage;
        this.parentFrame = iPage.getFramework().getJFrame();
        this.reload();
    }

    private void changeServerObject(IServerObject iServerObject) {
        this.serverObject = iServerObject;
        if (((ResourceObject)((Object)this.serverObject)).getName() != null) {
            ((ResourceObject)((Object)this)).setName(((ResourceObject)((Object)this.serverObject)).getName());
        }
        if (this.serverObject instanceof AbstractServerObject) {
            AbstractServerObject abstractServerObject = (AbstractServerObject)this.serverObject;
            if (abstractServerObject.getNodeObject() != null) {
                abstractServerObject.removeChangeListener((ChangeListener)((Object)abstractServerObject.getNodeObject()));
            }
            abstractServerObject.setNodeObject((ResourceObject)((Object)this));
            abstractServerObject.addChangeListener(this);
        }
        ((ResourceObject)((Object)this)).setIcon(this.serverObject.getIcon());
    }

    /*
     * Loose catch block
     */
    private static void cacheIcon(String string, Object object) {
        block14: {
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            fileOutputStream = new FileOutputStream(new File(string));
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            Object var6_4 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block14;
            }
            catch (Exception exception) {}
            break block14;
            {
                catch (Exception exception) {
                    Debug.println((int)0, (String)("Failed to serialize " + string + " " + exception));
                    Object var6_5 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block14;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getIconFromCache(String var0) {
        var1_1 = null;
        var2_2 = null;
        try {
            try {
                var1_1 = new FileInputStream(new File(var0));
                var2_2 = new ObjectInputStream(var1_1);
                var3_3 = var2_2.readObject();
                var6_5 = null;
            }
            catch (FileNotFoundException var3_4) {
                var6_6 = null;
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    if (var1_1 == null) return null;
                    var1_1.close();
                    return null;
                }
                catch (Exception var7_10) {
                    return null;
                }
            }
            catch (Exception var4_13) {
                Debug.println((int)0, (String)("Failed to deserialize " + var0 + " " + var4_13));
                var6_7 = null;
                try {}
                catch (Exception var7_11) {
                    return null;
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                if (var1_1 == null) return null;
                var1_1.close();
                return null;
            }
        }
        catch (Throwable var5_14) {
            var6_8 = null;
            ** try [egrp 2[TRYBLOCK] [3 : 97->116)] { 
lbl38:
            // 1 sources

            if (var2_2 != null) {
                var2_2.close();
            }
            if (var1_1 == null) throw var5_14;
            var1_1.close();
            throw var5_14;
lbl43:
            // 1 sources

            catch (Exception var7_12) {
                // empty catch block
            }
            throw var5_14;
        }
        ** try [egrp 2[TRYBLOCK] [3 : 97->116)] { 
lbl48:
        // 1 sources

        if (var2_2 != null) {
            var2_2.close();
        }
        if (var1_1 == null) return var3_3;
        var1_1.close();
        return var3_3;
lbl53:
        // 1 sources

        catch (Exception var7_9) {
            // empty catch block
        }
        return var3_3;
    }

    private boolean isMCCRegistryServer() {
        String string = LDAPUtil.flatting((LDAPAttribute)this.ldapEntry.getAttribute("serverhostname", LDAPUtil.getLDAPAttributeLocale()));
        String string2 = LDAPUtil.flatting((LDAPAttribute)this.ldapEntry.getAttribute("nsserverport", LDAPUtil.getLDAPAttributeLocale()));
        return this.consoleInfo.getHost().equals(string) && String.valueOf(this.consoleInfo.getPort()).equals(string2);
    }

    public void unselect(IPage iPage) {
        if (this.serverObject != null) {
            this.serverObject.unselect(iPage);
        }
    }

    public void select(IPage iPage) {
        this.viewInstance = iPage;
        this.parentFrame = iPage.getFramework().getJFrame();
        if (this.serverObject == null) {
            this.reload();
        }
        if (this.serverObject != null) {
            if (!(iPage instanceof ResourcePage)) {
                return;
            }
            ResourcePage resourcePage = (ResourcePage)iPage;
            IResourceObject[] iResourceObjectArray = resourcePage.getSelection();
            ResourceModel resourceModel = (ResourceModel)resourcePage.getModel();
            resourcePage.changeCustomPanel(new ResourceModelEvent((Object)resourceModel, (IPage)resourcePage, this.customPanel));
            if (iResourceObjectArray != null && iResourceObjectArray.length == 1) {
                this.enableSetACLMenuItem = true;
                this.enableCloneMenuItem = true;
                if (this.serverObject instanceof AbstractServerObject) {
                    AbstractServerObject abstractServerObject = (AbstractServerObject)this.serverObject;
                    this.enableSetACLMenuItem = abstractServerObject.isACLEnabled();
                    this.enableCloneMenuItem = abstractServerObject.isCloningEnabled();
                }
                this.enableRemoveMenuItem = this.serverObject instanceof IRemovableServerObject && !this.isMCCRegistryServer();
            } else {
                this.enableSetACLMenuItem = false;
                this.enableCloneMenuItem = false;
                this.enableRemoveMenuItem = this.isRemovable(iResourceObjectArray);
            }
            if (this.enableSetACLMenuItem) {
                resourceModel.fireEnableMenuItem(iPage, MENU_SET_ACL);
            } else {
                resourceModel.fireDisableMenuItem(iPage, MENU_SET_ACL);
            }
            if (this.enableCloneMenuItem) {
                resourceModel.fireEnableMenuItem(iPage, MENU_CLONE_SERVER);
            } else {
                resourceModel.fireDisableMenuItem(iPage, MENU_CLONE_SERVER);
            }
            if (this.enableRemoveMenuItem) {
                resourceModel.fireEnableMenuItem(iPage, MENU_REMOVE_SERVER);
            } else {
                resourceModel.fireDisableMenuItem(iPage, MENU_REMOVE_SERVER);
            }
            this.serverObject.select(iPage);
        } else {
            this.isSelectPending = true;
        }
    }

    private boolean isRemovable(IResourceObject[] iResourceObjectArray) {
        ServerNode serverNode = null;
        IServerObject iServerObject = null;
        int n = 0;
        while (n < iResourceObjectArray.length) {
            if (iResourceObjectArray[n] instanceof ServerNode) {
                serverNode = (ServerNode)((Object)iResourceObjectArray[n]);
                iServerObject = serverNode.getServerObject();
                if (iServerObject == null || !(iServerObject instanceof IRemovableServerObject) || serverNode.isMCCRegistryServer()) {
                    return false;
                }
            } else {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getClassName() {
        if (this.serverObject != null) {
            return this.serverObject.getClass().getName();
        }
        return super.getClassName();
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        if (this.serverObject != null) {
            if (Debug.timeTraceEnabled()) {
                Debug.println((String)"rsptime", (String)("Open " + ((ResourceObject)((Object)this)).getName() + " ..."));
            }
            ServerRunThread serverRunThread = new ServerRunThread(this, (IResourceObject)this.serverObject, iPage, iResourceObjectArray);
            serverRunThread.start();
            return true;
        }
        this.reload();
        return false;
    }

    public Component getCustomPanel() {
        if (this.serverObject == null) {
            this.reload();
        }
        if (this.serverObject != null) {
            this.customPanel = this.serverObject.getCustomPanel();
        }
        return this.customPanel;
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("OBJECT") || string.equals("CONTEXT")) {
            return new IMenuItem[]{new MenuItemText(MENU_OPEN_SERVER, resource.getString("menu", MENU_OPEN_SERVER), "", this.enableOpenMenuItem), new MenuItemText(MENU_CLONE_SERVER, resource.getString("menu", "CloneServer"), "", this.enableCloneMenuItem), new MenuItemText(MENU_REMOVE_SERVER, resource.getString("menu", "RemoveServer"), "", this.enableRemoveMenuItem), new MenuItemSeparator(), new MenuItemText(MENU_SET_ACL, Framework._resource.getString("menu", "EditSetACL"), "", this.enableSetACLMenuItem)};
        }
        return null;
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(MENU_SET_ACL)) {
            PermissionDlg permissionDlg = new PermissionDlg(this.consoleInfo, this.topologyDN);
            permissionDlg.show();
            ModalDialogUtil.disposeAndRaise((JDialog)permissionDlg, (Frame)iPage.getFramework().getJFrame());
        } else if (iMenuItem.getID().equals(MENU_OPEN_SERVER)) {
            IResourceObject[] iResourceObjectArray;
            if (this.serverObject != null && iPage instanceof ResourcePage && this.serverObject.canRunSelection(iResourceObjectArray = ((ResourcePage)iPage).getSelection())) {
                this.run(iPage, iResourceObjectArray);
            }
        } else if (iMenuItem.getID().equals(MENU_CLONE_SERVER)) {
            if (this.serverObject != null) {
                ServerCloneThread serverCloneThread = new ServerCloneThread(this, this.consoleInfo, resource, (IResourceObject)this.serverObject, iPage);
                serverCloneThread.start();
            }
        } else if (iMenuItem.getID().equals(MENU_REMOVE_SERVER) && this.serverObject != null && this.serverObject instanceof IRemovableServerObject && JOptionPane.showConfirmDialog(iPage.getFramework().getJFrame(), resource.getString(ERROR_PREFIX, "RemoveInstanceQuestion") + ((ResourceObject)((Object)this)).getName() + "?", resource.getString(ERROR_PREFIX, "RemoveInstanceTitle"), 0) == 0) {
            ServerRemoveThread serverRemoveThread = new ServerRemoveThread(this, this.consoleInfo, resource, (IResourceObject)this.serverObject, iPage);
            serverRemoveThread.start();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ResourcePage resourcePage;
        if (this.viewInstance != null && this.viewInstance instanceof ResourcePage && (resourcePage = (ResourcePage)this.viewInstance).getTreeModel() instanceof ResourceModel && this.serverObject instanceof AbstractServerObject) {
            AbstractServerObject abstractServerObject = (AbstractServerObject)this.serverObject;
            String string = abstractServerObject.getName();
            int n = abstractServerObject.getFontStyle();
            if (!string.equals(((ResourceObject)((Object)this)).getName()) || n != this.getFontStyle()) {
                ((ResourceObject)((Object)this)).setName(string);
                this.setFontStyle(n);
                ((ResourceModel)resourcePage.getTreeModel()).fireTreeNodeChanged((ResourceObject)((Object)this));
            }
        }
    }

    public IServerObject getServerObject() {
        return this.serverObject;
    }

    public boolean isAdminServer() {
        String string = LDAPUtil.flatting((LDAPAttribute)this.ldapEntry.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale()));
        if (string == null) {
            Debug.println((String)("ERROR ServerNode.isAdminServer: could not get cn for " + this.getDN()));
            return false;
        }
        return string.indexOf("admin") != -1;
    }

    protected String getServerNickname() {
        String[] stringArray = this.getProductNicknames();
        if (stringArray == null || stringArray.length == 0) {
            Debug.println((String)"ERROR ServerNode.getServerNickname: could not get product nicknames");
            return null;
        }
        String string = LDAPUtil.flatting((LDAPAttribute)this.ldapEntry.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale()));
        string = string.toLowerCase();
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                Debug.println((String)("TRACE ServerNode.getServerNickname: nickname = " + stringArray[n]));
                return stringArray[n];
            }
            ++n;
        }
        Debug.println((String)("ERROR ServerNode.getServerNickname: no nickname for " + string));
        return null;
    }

    protected String[] getProductNicknames() {
        if (nicknameList != null) {
            return nicknameList;
        }
        String string = "cn=client, ou=admin, ou=Global Preferences," + LDAPUtil.getInstalledSoftwareDN();
        try {
            LDAPEntry lDAPEntry = this.ldc.read(string);
            if (lDAPEntry == null) {
                Debug.println((String)("ERROR ServerNode.getProductNicknames: could not get global parameters entry = " + string));
                return null;
            }
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsNickname", LDAPUtil.getLDAPAttributeLocale());
            if (lDAPAttribute == null) {
                Debug.println((String)"ERROR ServerNode.getProductNicknames: no 'nsNickname' attribute");
                return null;
            }
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = lDAPAttribute.getStringValues();
            String string2 = null;
            String string3 = null;
            int n = 0;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                n = string2.indexOf(44);
                if (n == -1) {
                    Debug.println((String)("ERROR ServerNode.getProductNicknames: malformed value (no comma): " + string2));
                    continue;
                }
                string3 = string2.substring(0, n).toLowerCase();
                vector.addElement(string3);
            }
            if (vector.size() == 0) {
                return null;
            }
            nicknameList = new String[vector.size()];
            vector.copyInto(nicknameList);
            return nicknameList;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ERROR ServerNode.getProductNicknames: " + (Object)((Object)lDAPException)));
            return null;
        }
    }

    private synchronized CloneTarget[] getCloneTargets() {
        Object object;
        LDAPSortKey lDAPSortKey;
        String string;
        String string2 = this.getServerNickname();
        if (string2 == null) {
            Debug.println((String)"ERROR ServerNode.getCloneTargets: nickname is null");
            return null;
        }
        Vector<CloneTarget> vector = new Vector<CloneTarget>();
        String string3 = this.getDN().toLowerCase();
        String string4 = string3.substring(string3.indexOf(44) + 1);
        String string5 = string4.substring(string4.indexOf(44) + 1);
        String string6 = string5.substring(string5.indexOf(44) + 1);
        String string7 = string6.substring(string6.indexOf(44) + 1);
        String string8 = "(ObjectClass=NetscapeServer)";
        LDAPSearchResults lDAPSearchResults = null;
        if (LDAPUtil.isVersion4((LDAPConnection)this.ldc)) {
            string = Locale.getDefault().getLanguage();
            lDAPSortKey = string == null || string.equals("") ? new LDAPSortKey("cn", false) : new LDAPSortKey("cn", false, string);
            object = this.ldc.getSearchConstraints();
            object.setServerControls((LDAPControl)new LDAPSortControl(lDAPSortKey, false));
        }
        try {
            lDAPSearchResults = this.ldc.search(string7, 2, string8, null, false);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ERROR ServerNode.getCloneTargets: search for server instances failed: " + (Object)((Object)lDAPException)));
            return null;
        }
        if (lDAPSearchResults == null) {
            Debug.println((String)("ERROR ServerNode.getCloneTargets: could not get server instances under " + string7));
            return null;
        }
        lDAPSortKey = null;
        string = null;
        object = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        String string18 = "cn=" + string2.toLowerCase();
        while (lDAPSearchResults.hasMoreElements()) {
            try {
                lDAPSortKey = lDAPSearchResults.next();
            }
            catch (Exception exception) {
                continue;
            }
            object = lDAPSortKey.getDN().toLowerCase();
            if (!((String)object).startsWith(string18)) {
                Debug.println((String)("TRACE ServerNode.getCloneTargets: serverDN " + (String)object + " cannot be a target."));
                Debug.println((String)("    Expected nickname is " + string2 + ". Type mismatch."));
                continue;
            }
            if (((String)object).equals(string3)) {
                Debug.println((String)("TRACE ServerNode.getCloneTargets: skipping self: " + (String)object));
                continue;
            }
            string13 = LDAPUtil.flatting((LDAPAttribute)lDAPSortKey.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale()));
            string17 = LDAPUtil.flatting((LDAPAttribute)lDAPSortKey.getAttribute("serverProductName", LDAPUtil.getLDAPAttributeLocale()));
            string15 = LDAPUtil.flatting((LDAPAttribute)lDAPSortKey.getAttribute("serverhostname", LDAPUtil.getLDAPAttributeLocale()));
            string10 = ((String)object).substring(((String)object).indexOf(44) + 1);
            string11 = string10.substring(string10.indexOf(44) + 1);
            string12 = string11.substring(0, string11.indexOf(44));
            if (string12.indexOf(40) == -1) {
                string14 = null;
            } else {
                int n = string12.indexOf(40);
                int n2 = string12.indexOf(41) + 1;
                string14 = string12.substring(n, n2);
            }
            string9 = "cn=configuration," + (String)object;
            try {
                string = this.ldc.read(string9);
                string16 = LDAPUtil.flatting((LDAPAttribute)string.getAttribute("nsserverport", LDAPUtil.getLDAPAttributeLocale()));
                Debug.println((String)("TRACE ServerNode.getCloneTargets: adding clone target: " + string13));
                vector.addElement(new CloneTarget((String)object, string13, string14, string15, string16, string17));
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("ERROR ServerNode.getCloneTargets: could not read instance DN: " + (Object)((Object)lDAPException)));
            }
        }
        if (vector.size() == 0) {
            Debug.println((String)"TRACE ServerNode.getCloneTargets: no servers available to clone to.");
            return null;
        }
        Object[] objectArray = new CloneTarget[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String getJARClassName(LDAPConnection lDAPConnection, String string) {
        if (lDAPConnection == null) {
            Debug.println((String)"ERROR ServerNode.createServerInstance: no LDAPConnection");
            return null;
        }
        String string2 = "cn=configuration," + string;
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string2);
            String string3 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsClassname", LDAPUtil.getLDAPAttributeLocale()));
            if (string3 == null) {
                Debug.println((String)("ERROR ServerNode.createServerInstance: no 'nsClassname' attribute in " + string2));
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "@");
            stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            return string4;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)"ERROR ServerNode.createServerInstance: createServerInstance failed");
            Debug.println((String)("    LDAPException: " + (Object)((Object)lDAPException)));
            return null;
        }
    }

    protected void initializeConsoleInfo(ConsoleInfo consoleInfo, String string) {
        String string2 = this.getInstanceAdminURL(this.ldc, string);
        if (string2 == null) {
            Debug.println((String)("ERROR ServerNode.initializeConsoleInfo: could not set the adminURL for " + string));
        } else {
            consoleInfo.setAdminURL(string2);
        }
        String string3 = this.getInstanceAdminOS(this.ldc, string);
        if (string3 == null) {
            Debug.println((String)("ERROR ServerNode.initializeConsoleInfo: could not set the adminOS for " + string));
        } else {
            consoleInfo.setAdminOS(string3);
        }
    }

    protected String getInstanceAdminURL(LDAPConnection lDAPConnection, String string) {
        String string2 = null;
        try {
            String string3;
            String string4 = string.substring(string.indexOf(44) + 1);
            String string5 = string4.substring(string4.indexOf(44) + 1);
            String string6 = this.getServiceLocator().getAdminServer(string5);
            if (string6 == null) {
                Debug.println((String)("ERROR ServerNode.getInstanceAdminURL: could not get admin server entry = " + string5));
                return null;
            }
            String string7 = "cn=configuration," + string6;
            string2 = string7;
            LDAPEntry lDAPEntry = lDAPConnection.read(string2);
            if (lDAPEntry == null) {
                Debug.println((String)("ERROR ServerNode.getInstanceAdminURL: could not get admin server config entry = " + string7));
                return null;
            }
            String string8 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsServerAddress"));
            String string9 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsServerport"));
            boolean bl = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsServersecurity")).equalsIgnoreCase("on");
            if (string8 == null || string8.trim().length() == 0) {
                string2 = string6;
                string3 = lDAPConnection.read(string2, new String[]{"serverhostname"});
                if (string3 == null) {
                    Debug.println((int)0, (String)("ERROR ConsoleInfo.getInstanceAdminURL: could not get serverhostname from " + string6));
                    return null;
                }
                string8 = LDAPUtil.flatting((LDAPAttribute)string3.getAttribute("serverhostname"));
            }
            string3 = "http";
            if (bl) {
                string3 = string3 + "s";
            }
            string3 = string3 + "://" + string8 + ":" + string9 + "/";
            return string3;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ERROR ServerNode.getInstanceAdminURL: LDAP error " + (Object)((Object)lDAPException) + " dn=" + string2));
            return null;
        }
    }

    protected String getInstanceAdminOS(LDAPConnection lDAPConnection, String string) {
        try {
            String string2 = string.substring(string.indexOf(44) + 1);
            String string3 = string2.substring(string2.indexOf(44) + 1);
            String string4 = string3.substring(string3.indexOf(44) + 1);
            LDAPEntry lDAPEntry = lDAPConnection.read(string4);
            if (lDAPEntry == null) {
                Debug.println((String)("ERROR ServerNode.getInstanceAdminOS: could not get host entry = " + string4));
                return null;
            }
            String string5 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsOsVersion", LDAPUtil.getLDAPAttributeLocale()));
            return string5;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ERROR ServerNode.getInstanceAdminOS: LDAP error " + (Object)((Object)lDAPException)));
            return null;
        }
    }

    private synchronized void setGrabAllInput(JFrame jFrame, boolean bl) {
        Component component = jFrame.getGlassPane();
        if (bl) {
            component.addKeyListener(tmpGrabKey);
            component.addMouseListener(tmpGrabMouse);
            component.setVisible(true);
        } else {
            component.removeKeyListener(tmpGrabKey);
            component.removeMouseListener(tmpGrabMouse);
            component.setVisible(false);
        }
    }

    private synchronized void setBusyIndicator(IPage iPage, boolean bl, String string) {
        this.setBusyIndicator(iPage, bl, string, bl ? StatusItemProgress.STATE_BUSY : new Integer(0));
    }

    private synchronized void setBusyIndicator(IPage iPage, boolean bl, String string, Object object) {
        Framework framework;
        Framework framework2 = framework = iPage != null ? (Framework)iPage.getFramework() : (Framework)UtilConsoleGlobals.getActivatedFrame();
        if (framework == null) {
            return;
        }
        this.setGrabAllInput((JFrame)framework, bl);
        framework.setBusyCursor(bl);
        if (string != null) {
            framework.changeStatusItemState("StatusItemText", (Object)string);
        }
        framework.changeStatusItemState("StatusItemProgress", object);
    }

    private synchronized void reloadModel(IPage iPage) {
        IResourceModel iResourceModel;
        if (iPage instanceof ResourcePage && (iResourceModel = ((ResourcePage)iPage).getModel()) instanceof TopologyModel) {
            TopologyModel topologyModel = (TopologyModel)iResourceModel;
            try {
                Thread.sleep(500L);
                topologyModel.refreshTree(iPage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized IServerObject createServerInstance(String string, String string2, boolean bl) {
        Object object;
        block26: {
            IServerObject iServerObject;
            block25: {
                IServerObject iServerObject2;
                block24: {
                    IServerObject iServerObject3;
                    block23: {
                        Debug.println((int)5, (String)("Instantiate  " + this.topologyDN));
                        IServerObject iServerObject4 = null;
                        Object v = serverObjectsCache.get(string);
                        if (v != null && v instanceof IServerObject) {
                            Debug.println((String)("TRACE ServerNode.createServerInstance: instance already exists: " + string2));
                            return (IServerObject)v;
                        }
                        String string3 = "cn=configuration," + string;
                        try {
                            try {
                                boolean bl2;
                                String string4;
                                this.setBusyIndicator(null, true, "", new Integer(0));
                                LDAPEntry lDAPEntry = this.ldc.read(string3);
                                String string5 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsClassname", LDAPUtil.getLDAPAttributeLocale()));
                                if (string5 == null) {
                                    Debug.println((String)("ERROR ServerNode.createServerInstance: no 'nsClassname' attribute in " + string3));
                                    IServerObject iServerObject5 = null;
                                    Object var23_13 = null;
                                    this.setBusyIndicator(null, false, null);
                                    return iServerObject5;
                                }
                                ConsoleInfo consoleInfo = null;
                                if (bl) {
                                    consoleInfo = (ConsoleInfo)this.consoleInfo.clone();
                                    if (consoleInfo == null) {
                                        Debug.println((String)"ERROR ServerNode.createServerInstance: could not clone ConsoleInfo");
                                        iServerObject3 = null;
                                        break block23;
                                    }
                                } else {
                                    consoleInfo = (ConsoleInfo)this.getServiceLocator().getConsoleInfo().clone();
                                    if (consoleInfo == null) {
                                        Debug.println((String)"ERROR ServerNode.createServerInstance: could not clone ConsoleInfo");
                                        iServerObject2 = null;
                                        break block24;
                                    }
                                    this.initializeConsoleInfo(consoleInfo, string);
                                }
                                consoleInfo.setCurrentDN(string);
                                String string6 = this.getJARClassName(this.ldc, string);
                                String string7 = UtilConsoleGlobals.getDefaultDialect();
                                String string8 = string6;
                                int n = string6.lastIndexOf(".");
                                if (n != -1) {
                                    String string9 = string6.substring(0, n);
                                    string4 = string6.substring(n);
                                    string8 = string9 + "_" + string7 + string4;
                                }
                                boolean bl3 = bl2 = ClassLoaderUtil.isAlreadyDownload(string6) && ClassLoaderUtil.isAlreadyDownload(string8);
                                if (!bl2 && this.statusDialog == null) {
                                    string4 = resource.getString("ServerNodeStatus", "Description");
                                    this.statusDialog = new StatusDialog(this.parentFrame, string2, string4);
                                    this.statusDialog.setConfirmation(2);
                                    this.statusDialog.setShowDelay(500);
                                    this.statusDialog.setHideDelay(3000);
                                }
                                string4 = new /* Unavailable Anonymous Inner Class!! */;
                                Class clazz = null;
                                try {
                                    if (!bl2) {
                                        this.statusDialog.setVisible(true);
                                    }
                                    clazz = ClassLoaderUtil.getClass(consoleInfo, string5, (IProgressListener)string4);
                                    if (!bl2) {
                                        this.statusDialog.setVisible(false);
                                    }
                                }
                                catch (Exception exception) {
                                    this.setBusyIndicator(null, false, "");
                                    if (!bl2) {
                                        // empty if block
                                    }
                                    JOptionPane.showMessageDialog(this.parentFrame, exception.getMessage(), resource.getString(ERROR_PREFIX, "ClassLoaderTitle"), 0);
                                    IServerObject iServerObject6 = null;
                                    Object var23_16 = null;
                                    this.setBusyIndicator(null, false, null);
                                    return iServerObject6;
                                }
                                this.setBusyIndicator(null, true, "", new Integer(0));
                                if (clazz == null) {
                                    Debug.println((String)("ERROR ServerNode.createServerInstance: could not get class " + string5));
                                    iServerObject = null;
                                    break block25;
                                }
                                try {
                                    iServerObject4 = (IServerObject)clazz.newInstance();
                                }
                                catch (Exception exception) {
                                    Debug.println((int)0, (String)("ERROR ServerNode.createServerInstance: could not create " + string5));
                                    Debug.println((int)0, (String)("    Exception: " + exception));
                                    this.setBusyIndicator(null, false, "");
                                    JOptionPane.showMessageDialog(this.parentFrame, MessageFormat.format(resource.getString(ERROR_PREFIX, "CreateServerObject"), string2) + "\n" + exception.getMessage(), resource.getString(ERROR_PREFIX, "ClassLoaderTitle"), 0);
                                    IServerObject iServerObject7 = null;
                                    Object var23_18 = null;
                                    this.setBusyIndicator(null, false, null);
                                    return iServerObject7;
                                }
                                if (consoleInfo.getAdminURL() == null) {
                                    object = this.getDN();
                                    String string10 = string.substring(string.indexOf(44) + 1);
                                    String string11 = string10.substring(string10.indexOf(44) + 1);
                                    String string12 = this.getServiceLocator().getAdminServer(string11);
                                    if (string12 != null) {
                                        String string13 = AdminGroupNode.findAdminURL((ConsoleInfo)consoleInfo, (String)string12);
                                        consoleInfo.setAdminURL(string13);
                                    }
                                }
                                iServerObject4.initialize(consoleInfo);
                                if (iServerObject4 instanceof ResourceObject) {
                                    ((ResourceObject)((Object)iServerObject4)).setName(string2);
                                }
                                serverObjectsCache.put(string, iServerObject4);
                                object = iServerObject4;
                                break block26;
                            }
                            catch (LDAPException lDAPException) {
                                Debug.println((String)"ERROR ServerNode.createServerInstance: createServerInstance failed");
                                Debug.println((String)("    LDAPException: " + (Object)((Object)lDAPException)));
                                IServerObject iServerObject8 = null;
                                Object var23_20 = null;
                                this.setBusyIndicator(null, false, null);
                                return iServerObject8;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var23_21 = null;
                            this.setBusyIndicator(null, false, null);
                            throw throwable;
                        }
                    }
                    Object var23_14 = null;
                    this.setBusyIndicator(null, false, null);
                    return iServerObject3;
                }
                Object var23_15 = null;
                this.setBusyIndicator(null, false, null);
                return iServerObject2;
            }
            Object var23_17 = null;
            this.setBusyIndicator(null, false, null);
            return iServerObject;
        }
        Object var23_19 = null;
        this.setBusyIndicator(null, false, null);
        return object;
    }

    static /* synthetic */ ResourceSet access$000() {
        return resource;
    }

    static /* synthetic */ StatusDialog access$100(ServerNode serverNode) {
        return serverNode.statusDialog;
    }

    static /* synthetic */ void access$200(ServerNode serverNode, IPage iPage, boolean bl, String string) {
        serverNode.setBusyIndicator(iPage, bl, string);
    }

    static /* synthetic */ IServerObject access$300(ServerNode serverNode) {
        return serverNode.serverObject;
    }

    static /* synthetic */ Hashtable access$400() {
        return serverObjectsCache;
    }

    static /* synthetic */ void access$500(ServerNode serverNode, IPage iPage) {
        serverNode.reloadModel(iPage);
    }

    static /* synthetic */ CloneTarget[] access$600(ServerNode serverNode) {
        return serverNode.getCloneTargets();
    }

    static /* synthetic */ ProductSelectionDialog access$700() {
        return cloneSelection;
    }

    static /* synthetic */ ProductSelectionDialog access$702(ProductSelectionDialog productSelectionDialog) {
        cloneSelection = productSelectionDialog;
        return cloneSelection;
    }

    static /* synthetic */ IServerObject access$302(ServerNode serverNode, IServerObject iServerObject) {
        serverNode.serverObject = iServerObject;
        return serverNode.serverObject;
    }

    static /* synthetic */ void access$800(ServerNode serverNode, IServerObject iServerObject) {
        serverNode.changeServerObject(iServerObject);
    }

    static /* synthetic */ String access$900(ServerNode serverNode) {
        return serverNode.cacheIconPath;
    }

    static /* synthetic */ void access$1000(String string, Object object) {
        ServerNode.cacheIcon(string, object);
    }

    static /* synthetic */ Component access$1102(ServerNode serverNode, Component component) {
        serverNode.customPanel = component;
        return serverNode.customPanel;
    }

    static /* synthetic */ RemoteImage access$1200() {
        return failedLoadIcon;
    }

    static /* synthetic */ boolean access$1300(ServerNode serverNode) {
        return serverNode.isSelectPending;
    }

    static /* synthetic */ IPage access$1400(ServerNode serverNode) {
        return serverNode.viewInstance;
    }

    static /* synthetic */ boolean access$1302(ServerNode serverNode, boolean bl) {
        serverNode.isSelectPending = bl;
        return serverNode.isSelectPending;
    }
}

