/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.MyEntityResolver;
import org.apache.jasper.compiler.ParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JspUtil {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";

    public static void checkAttributes(String string, Hashtable hashtable, ValidAttribute[] validAttributeArray, Mark mark) throws JasperException {
        boolean bl = true;
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        String string2 = null;
        int n = 0;
        while (n < validAttributeArray.length) {
            if (validAttributeArray[n].mandatory) {
                if (hashtable2.get(validAttributeArray[n].name) != null) {
                    hashtable2.remove(validAttributeArray[n].name);
                    bl = true;
                } else {
                    bl = false;
                    string2 = validAttributeArray[n].name;
                    break;
                }
            }
            ++n;
        }
        if (!bl) {
            throw new ParseException(mark, Constants.getString("jsp.error.mandatory.attribute", new Object[]{string, string2}));
        }
        if (hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            bl = false;
            string3 = (String)enumeration.nextElement();
            int n2 = 0;
            while (n2 < validAttributeArray.length) {
                if (string3.equals(validAttributeArray[n2].name)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            throw new ParseException(mark, Constants.getString("jsp.error.invalid.attribute", new Object[]{string, string3}));
        }
    }

    public static String escapeQueryString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        String string3 = "\\\"";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (string3.indexOf(c) != -1) {
                string2 = String.valueOf(string2) + "\\";
            }
            string2 = String.valueOf(string2) + c;
            ++n;
        }
        return string2;
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quote;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getExpr(String string) {
        int n = string.length();
        String string2 = string.startsWith(OPEN_EXPR) && string.endsWith(CLOSE_EXPR) ? string.substring(OPEN_EXPR.length(), n - CLOSE_EXPR.length()) : "";
        return string2;
    }

    public static boolean isExpression(String string) {
        return string.startsWith(OPEN_EXPR) && string.endsWith(CLOSE_EXPR);
    }

    public static Document parseXMLDoc(InputStream inputStream, String string, String string2) throws JasperException {
        return JspUtil.parseXMLDocJaxp(inputStream, string, string2);
    }

    public static Document parseXMLDocJaxp(InputStream inputStream, String string, String string2) throws JasperException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            MyEntityResolver myEntityResolver = new MyEntityResolver(string2, string);
            documentBuilder.setEntityResolver(myEntityResolver);
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JasperException(Constants.getString("jsp.error.parse.error.in.TLD", new Object[]{parserConfigurationException.getMessage()}));
        }
        catch (SAXException sAXException) {
            throw new JasperException(Constants.getString("jsp.error.parse.error.in.TLD", new Object[]{sAXException.getMessage()}));
        }
        catch (IOException iOException) {
            throw new JasperException(Constants.getString("jsp.error.unable.to.open.TLD", new Object[]{iOException.getMessage()}));
        }
    }

    public static char[] removeQuotes(char[] cArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%' && cArray[n + 1] == '\\' && cArray[n + 2] == '\\' && cArray[n + 3] == '>') {
                charArrayWriter.write(37);
                charArrayWriter.write(62);
                n += 3;
            } else {
                charArrayWriter.write(cArray[n]);
            }
            ++n;
        }
        return charArrayWriter.toCharArray();
    }

    public static class ValidAttribute {
        String name;
        boolean mandatory;

        public ValidAttribute(String string) {
            this(string, false);
        }

        public ValidAttribute(String string, boolean bl) {
            this.name = string;
            this.mandatory = bl;
        }
    }
}

