/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SunJavaCompiler;
import org.apache.jasper.servlet.JasperLoader;

public class JspEngineContext
implements JspCompilationContext {
    JspReader reader;
    ServletWriter writer;
    ServletContext context;
    JasperLoader loader;
    String classpath;
    boolean isErrPage;
    String jspFile;
    String servletClassName;
    String servletPackageName;
    String servletJavaFileName;
    String contentType;
    Options options;
    HttpServletRequest req;
    HttpServletResponse res;

    public JspEngineContext(JasperLoader jasperLoader, String string, ServletContext servletContext, String string2, boolean bl, Options options, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.loader = jasperLoader;
        this.classpath = string;
        this.context = servletContext;
        this.jspFile = string2;
        this.isErrPage = bl;
        this.options = options;
        this.req = httpServletRequest;
        this.res = httpServletResponse;
    }

    public void addJar(String string) throws IOException {
        this.loader.addJar(string);
    }

    public Compiler createCompiler() throws JasperException {
        JavaCompiler javaCompiler;
        String string = this.options.getJspCompilerPath();
        Class clazz = this.options.getJspCompilerPlugin();
        if (clazz != null) {
            try {
                javaCompiler = (JavaCompiler)clazz.newInstance();
            }
            catch (Exception exception) {
                Constants.message("jsp.warning.compiler.class.cantcreate", new Object[]{clazz, exception}, Integer.MIN_VALUE);
                javaCompiler = new SunJavaCompiler();
            }
        } else {
            javaCompiler = new SunJavaCompiler();
        }
        if (string != null) {
            javaCompiler.setCompilerPath(string);
        }
        JspCompiler jspCompiler = new JspCompiler(this);
        jspCompiler.setJavaCompiler(javaCompiler);
        return jspCompiler;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getClassPath() {
        return String.valueOf(this.loader.getClassPath()) + this.classpath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public final String getFullClassName() {
        if (this.servletPackageName == null) {
            return this.servletClassName;
        }
        return String.valueOf(this.servletPackageName) + "." + this.servletClassName;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public JspReader getReader() {
        return this.reader;
    }

    public String getRealPath(String string) {
        if (this.context != null) {
            return this.context.getRealPath(string);
        }
        return string;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public InputStream getResourceAsStream(String string) {
        return this.context.getResourceAsStream(string);
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String resolveRelativeUri(String string) {
        if (string.charAt(0) == '/') {
            return string;
        }
        String string2 = this.req.getServletPath();
        String string3 = string2.substring(0, string2.lastIndexOf(47));
        return String.valueOf(string3) + '/' + string;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setErrorPage(boolean bl) {
        this.isErrPage = bl;
    }

    public void setReader(JspReader jspReader) {
        this.reader = jspReader;
    }

    public void setServletClassName(String string) {
        this.servletClassName = string;
    }

    public void setServletJavaFileName(String string) {
        this.servletJavaFileName = string;
    }

    public void setServletPackageName(String string) {
        this.servletPackageName = string;
    }

    public void setWriter(ServletWriter servletWriter) {
        this.writer = servletWriter;
    }
}

