/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Permissions;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.ImageIcon;

public class RemoteImage
extends ImageIcon {
    private static Hashtable _imageCache = new Hashtable();
    protected static String sysLoaderCacheID = "sysLoader";
    protected ClassLoader loader = new StackLookup().getLoader();
    protected Object loaderCacheID = this.loader == null ? sysLoaderCacheID : this.loader;
    protected String loaderName = this.loader == null ? sysLoaderCacheID : "loader" + this.loader.hashCode();

    public RemoteImage() {
    }

    public RemoteImage(Image image) {
        this();
        this.setImage(image);
    }

    public RemoteImage(String string) {
        this();
        String string2 = this.getLocalizedPath(string, Locale.getDefault());
        RemoteImage remoteImage = this.getFromCache(string2);
        if (remoteImage != null) {
            this.setImage(remoteImage.getImage());
            return;
        }
        Image image = this.getSystemImage(string2);
        if (image != null) {
            this.setImage(image);
            this.setDescription(string2);
            this.putInCache(string2, this);
            return;
        }
        remoteImage = this.getFromCache(string);
        if (remoteImage != null) {
            this.setImage(remoteImage.getImage());
            return;
        }
        image = this.getSystemImage(string);
        if (image != null) {
            this.setImage(image);
            this.setDescription(string);
            this.putInCache(string, this);
            return;
        }
        if (Permissions.isApplet()) {
            Debug.println(0, "RemoteImage:RemoteImage():unable to load image (" + string + ")");
            return;
        }
        this.setImage(Toolkit.getDefaultToolkit().getImage(string));
        this.setDescription(string);
        this.putInCache(string, this);
    }

    protected Image getSystemImage(String string) {
        try {
            InputStream inputStream;
            ClassLoader classLoader = new StackLookup().getLoader();
            if (classLoader != null ? (inputStream = classLoader.getResourceAsStream(string)) == null : (inputStream = ClassLoader.getSystemResourceAsStream(string)) == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = -1;
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            return Toolkit.getDefaultToolkit().createImage(byArray);
        }
        catch (IOException iOException) {
            Debug.println(0, "RemoteImage: " + iOException + "(" + string + ")");
            return null;
        }
        catch (Exception exception) {
            Debug.println(0, "RemoteImage: " + exception + "(" + string + ")");
            return null;
        }
    }

    private RemoteImage getFromCache(String string) {
        Hashtable hashtable = (Hashtable)_imageCache.get(this.loaderCacheID);
        RemoteImage remoteImage = null;
        if (hashtable != null) {
            remoteImage = (RemoteImage)hashtable.get(string);
        }
        if (Debug.getTraceLevel() == 9) {
            Debug.println(9, "RemoteImage: " + (remoteImage == null ? "NOT " : "") + "found " + this.loaderName + ":" + string);
        }
        return remoteImage;
    }

    private void putInCache(String string, RemoteImage remoteImage) {
        Hashtable<String, RemoteImage> hashtable = (Hashtable<String, RemoteImage>)_imageCache.get(this.loaderCacheID);
        if (hashtable == null) {
            hashtable = new Hashtable<String, RemoteImage>();
            _imageCache.put(this.loaderCacheID, hashtable);
            Debug.println(9, "RemoteImage: Create RemoteImage cache for " + this.loaderName);
        }
        hashtable.put(string, remoteImage);
    }

    private String getLocalizedPath(String string, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = "_" + locale.toString();
            stringBuffer.insert(n, string2);
        }
        return stringBuffer.toString();
    }

    static class StackLookup
    extends SecurityManager {
        StackLookup() {
        }

        public ClassLoader getLoader() {
            Class<?>[] classArray = this.getClassContext();
            Class<?> clazz = classArray[3];
            return clazz == null ? null : clazz.getClassLoader();
        }
    }
}

