/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.HostException;
import com.netscape.management.client.util.ResourceSet;
import java.util.StringTokenizer;

public class IPAddressValidator {
    private static ResourceSet _i18n = new ResourceSet("com.netscape.management.client.util.default");
    private String _ipAddr;
    private boolean _ipv6Supported;
    private boolean _isWildcardAllowed = false;

    private static String i18n(String string) {
        return _i18n.getString("IPAddressValidator", string);
    }

    public IPAddressValidator() {
        this("");
    }

    public IPAddressValidator(String string) {
        this(string, false);
    }

    public IPAddressValidator(String string, boolean bl) {
        this._ipAddr = string;
        this._ipv6Supported = bl;
    }

    private String getSyntaxAllowed() {
        if (this._ipv6Supported) {
            return IPAddressValidator.i18n("ipv4SyntaxAllowed") + "\n\n" + IPAddressValidator.i18n("ipv6SyntaxAllowed");
        }
        return IPAddressValidator.i18n("ipv4SyntaxAllowed");
    }

    private String getErrorMsg() {
        if (this._ipv6Supported) {
            return IPAddressValidator.i18n("msgErrorIPAddress");
        }
        return IPAddressValidator.i18n("msgErrorIPv4OnlyAddress");
    }

    public boolean isValidatingIPv6Address() {
        return this._ipAddr.indexOf(58) != -1;
    }

    public boolean isValidatingUnspecifiedAddress() {
        if (this.isValidatingIPv6Address() || this.isValidatingIPv4CompatibleAddress()) {
            try {
                String string = this.completeAddressCompressed();
                return string.equals("0:0:0:0:0:0:0:0");
            }
            catch (HostException hostException) {
                return false;
            }
        }
        return false;
    }

    public boolean isValidatingLoopbackAddress() {
        if (this.isValidatingIPv6Address() || this.isValidatingIPv4CompatibleAddress()) {
            try {
                String string = this.completeAddressCompressed();
                return string.equals("0:0:0:0:0:0:0:1");
            }
            catch (HostException hostException) {
                return false;
            }
        }
        return false;
    }

    public boolean isValidatingIPv4CompatibleAddress() {
        return this._ipAddr.indexOf(":") != -1 && this._ipAddr.indexOf(".") != -1 && this._ipAddr.indexOf("FFFF") == -1;
    }

    public boolean isValidatingIPv4MappedIPv6Address() {
        return this._ipAddr.indexOf(":") != -1 && this._ipAddr.indexOf(".") != -1 && this._ipAddr.indexOf("FFFF") != -1;
    }

    public boolean isValidatingAnyLocalAddress() {
        return this._ipAddr.indexOf("*") != -1;
    }

    public void setWildcardAllowed(boolean bl) {
        this._isWildcardAllowed = bl;
    }

    public boolean isWildcardAllowed() {
        return this._isWildcardAllowed;
    }

    public boolean isIPv6Supported() {
        return this._ipv6Supported;
    }

    public void setIPv6Supported(boolean bl) {
        this._ipv6Supported = bl;
    }

    public String getIPAddress() {
        return this._ipAddr;
    }

    public void setIPAddress(String string) {
        this._ipAddr = string;
    }

    public void validate() throws HostException {
        if (this.isIPv6Supported() && (this.isValidatingLoopbackAddress() || this.isValidatingUnspecifiedAddress())) {
            return;
        }
        if (this.isIPv6Supported() && (this.isValidatingIPv4CompatibleAddress() || this.isValidatingIPv4MappedIPv6Address())) {
            this.validateIPv4IPv6Address(this._ipAddr);
        } else if (this.isIPv6Supported() && this.isValidatingIPv6Address()) {
            this.validateIPv6Address(this._ipAddr);
        } else {
            this.validateIPv4Address(this._ipAddr);
        }
    }

    private void validateIPv6Address(String string) throws HostException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = string.indexOf("::");
        if (n != -1 && string.substring(n + 1).indexOf("::") != -1) {
            this.throwException(2);
        }
        if (string.startsWith(":") && !string.startsWith("::") || string.endsWith(":") && !string.endsWith("::")) {
            this.throwException(2);
        }
        if (n != -1 && (stringTokenizer.countTokens() == 0 || stringTokenizer.countTokens() >= 8)) {
            this.throwException(2);
        }
        if (n == -1 && stringTokenizer.countTokens() != 8) {
            this.throwException(2);
        }
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            try {
                char[] cArray = string2.toCharArray();
                if (cArray.length > 4) {
                    this.throwException(2);
                }
                char[] cArray2 = new char[cArray.length];
                boolean bl = false;
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < cArray.length) {
                    char c = cArray[n2];
                    if (!(Character.isDigit(c) || Character.isLetter(c) && (c <= 'f' && c >= 'a' || c <= 'F' && c >= 'A') || this.isWildcardAllowed() && c == '*')) {
                        this.throwException(2);
                    }
                    ++n2;
                }
            }
            catch (HostException hostException) {
                throw new HostException(hostException.getMessage(), hostException.getResultCode(), hostException.getDetailMessage());
            }
            catch (Exception exception) {
                throw new HostException(this.getErrorMsg(), 2, exception.getMessage());
            }
        }
    }

    private void validateIPv4IPv6Address(String string) throws HostException {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 4) {
            this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
        }
        if (string.lastIndexOf(":") >= string.indexOf(".")) {
            this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
        }
        if ((n = string.indexOf("::")) != -1 && string.substring(n + 1).indexOf("::") != -1) {
            this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
        }
        if (n != -1 && stringTokenizer2.countTokens() > 6 || n == -1 && stringTokenizer2.countTokens() != 7) {
            this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
        }
        if (string.startsWith(":") && !string.startsWith("::") || string.endsWith(".")) {
            this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
        }
        String string2 = "";
        while (stringTokenizer2.hasMoreElements()) {
            string2 = (String)stringTokenizer2.nextElement();
            if (!stringTokenizer2.hasMoreElements()) continue;
            if (string2.equals("*")) {
                this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
            }
            if (string2.equals("*")) continue;
            try {
                String string3 = "0x" + string2;
                int n2 = -1;
                if (stringTokenizer2.hasMoreElements()) {
                    n2 = Integer.decode(string3);
                }
                if (n2 != 0 && n2 != 65535 && stringTokenizer2.hasMoreElements()) {
                    this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
                }
                if (n2 != 65535 || !stringTokenizer2.hasMoreElements()) continue;
                String string4 = (String)stringTokenizer2.nextElement();
                if (stringTokenizer2.hasMoreElements()) {
                    this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
                }
                string2 = string4;
            }
            catch (HostException hostException) {
                throw hostException;
            }
            catch (Exception exception) {
                this.throwException(3, "\n\n" + IPAddressValidator.i18n("msgErrorIPv4v6GlobalSyntax"));
            }
        }
        this.validateIPv4Address(string2);
    }

    private void validateIPv4Address(String string) throws HostException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4 || string.startsWith(".") || string.endsWith(".")) {
            this.throwException(1);
        }
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (!this.isWildcardAllowed() && string2.equals("*")) {
                this.throwException(1, "\n\n" + IPAddressValidator.i18n("msgErrorWildCardNotAllowed"));
            }
            if (this.isWildcardAllowed() || string2.equals("*")) continue;
            try {
                int n = Integer.parseInt(string2);
                if (n <= 255) continue;
                this.throwException(1);
            }
            catch (Exception exception) {
                this.throwException(1);
            }
        }
    }

    private void throwException(int n) throws HostException {
        throw new HostException(this.getErrorMsg(), n, this.getSyntaxAllowed());
    }

    private void throwException(int n, String string) throws HostException {
        throw new HostException(this.getErrorMsg(), n, this.getSyntaxAllowed() + string);
    }

    public String completeAddressCompressed() throws HostException {
        StringTokenizer stringTokenizer = new StringTokenizer(this._ipAddr, ":");
        int n = this._ipAddr.indexOf("::");
        String string = "";
        if (n != -1 && this._ipAddr.indexOf(":") != -1 && this._ipAddr.indexOf(".") != -1) {
            try {
                int n2 = this._ipAddr.lastIndexOf(":");
                String string2 = this._ipAddr.substring(0, n2);
                String string3 = this._ipAddr.substring(n2, this._ipAddr.length());
                string = string2.substring(0, n);
                int n3 = stringTokenizer.countTokens();
                int n4 = 0;
                while (n4 < 6 - n3 + 1) {
                    string = n4 == 0 && this._ipAddr.startsWith("::") ? string + "0" : string + ":0";
                    ++n4;
                }
                int n5 = (n3 - 1) * 2 + n;
                if (!this._ipAddr.endsWith("::")) {
                    string = string + string2.substring(n + 1, string2.length());
                }
                string = string + string3;
                return string;
            }
            catch (Exception exception) {
                this.throwException(3);
            }
        }
        if (n != -1 && this._ipAddr.indexOf(":") != -1 && this._ipAddr.indexOf(".") == -1) {
            try {
                string = this._ipAddr.substring(0, n);
                int n6 = stringTokenizer.countTokens();
                int n7 = 0;
                while (n7 < 8 - n6) {
                    string = n7 == 0 && this._ipAddr.startsWith("::") ? string + "0" : string + ":0";
                    ++n7;
                }
                int n8 = n6 * 2 + n;
                if (!this._ipAddr.endsWith("::")) {
                    string = string + this._ipAddr.substring(n + 1, this._ipAddr.length());
                }
                return string;
            }
            catch (Exception exception) {
                this.throwException(2);
            }
        }
        return this._ipAddr;
    }
}

