/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.Framework;
import com.netscape.management.client.util.BrowseHistoryListener;
import com.netscape.management.client.util.BrowseHtmlHistory;
import com.netscape.management.client.util.BrowseHtmlPane;
import com.netscape.management.client.util.Browser;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class HelpWindow
extends JDialog
implements BrowseHistoryListener,
ActionListener,
HyperlinkListener {
    public static int BACK_FORWARD = 1;
    public static int BROWSE = 2;
    public static int CLOSE = 4;
    private BrowseHtmlPane _pane = null;
    private BrowseHtmlHistory _history = null;
    private JPanel _contentPane = null;
    private JButton _backButton = null;
    private JButton _nextButton = null;
    private JButton _browseButton = null;
    private JButton _closeButton = null;
    private int _buttonOptions;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");

    public HelpWindow(String string, int n) {
        this.center();
        this._buttonOptions = n;
        this.prepareContentPane(string);
        this.setDefaultCloseOperation(1);
        this.pack();
    }

    public HelpWindow(JFrame jFrame, String string, int n) {
        super(jFrame);
        this.center();
        this._buttonOptions = n;
        this.prepareContentPane(string);
        this.setDefaultCloseOperation(1);
        this.pack();
    }

    private void prepareContentPane(String string) {
        this._pane = new BrowseHtmlPane(string);
        this.monitorTitle(this._pane);
        this._pane.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane(this._pane);
        this._contentPane = new JPanel();
        this._contentPane.setLayout(new BorderLayout());
        jScrollPane.setBorder(new EmptyBorder(9, 9, 0, 9));
        this._pane.setBorder(UIManager.getBorder("TextField.border"));
        this._contentPane.add((Component)jScrollPane, "Center");
        Dimension dimension = new Dimension(600, 450);
        this._contentPane.setMinimumSize(dimension);
        this._contentPane.setPreferredSize(dimension);
        this.addNavigationPanel(string);
        this.getContentPane().add(this._contentPane);
        this.historyStateChanged(false, false);
    }

    private void addNavigationPanel(String string) {
        this._history = new BrowseHtmlHistory();
        this._history.addBrowseHistoryListener(this);
        this._history.setPage(string);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        jPanel.setBorder(new EmptyBorder(9, 9, 9, 9));
        boolean bl = false;
        this._browseButton = JButtonFactory.create(_resource.getString(null, "BrowseButtonLabel"), this, "BROWSE");
        if ((this._buttonOptions & BROWSE) != 0) {
            jPanel.add((Component)this._browseButton, gridBagConstraints);
            bl = true;
        }
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this._backButton = JButtonFactory.create(_resource.getString(null, "BackButtonLabel"), this, "BACK");
        if ((this._buttonOptions & BACK_FORWARD) != 0) {
            if (bl) {
                jPanel.add(Box.createRigidArea(new Dimension(6, 0)), gridBagConstraints);
            }
            jPanel.add((Component)this._backButton, gridBagConstraints);
            bl = true;
        }
        this._nextButton = JButtonFactory.create(_resource.getString(null, "ForwardButtonLabel"), this, "FORWARD");
        if ((this._buttonOptions & BACK_FORWARD) != 0) {
            if (bl) {
                jPanel.add(Box.createRigidArea(new Dimension(6, 0)), gridBagConstraints);
            }
            jPanel.add((Component)this._nextButton, gridBagConstraints);
            bl = true;
        }
        JButtonFactory.resizeGroup(this._nextButton, this._backButton);
        this._closeButton = JButtonFactory.create(_resource.getString(null, "CloseButtonLabel"), this, "CLOSE");
        if ((this._buttonOptions & CLOSE) != 0) {
            if (bl) {
                jPanel.add(Box.createRigidArea(new Dimension(6, 0)), gridBagConstraints);
            }
            jPanel.add((Component)this._closeButton, gridBagConstraints);
            bl = true;
        }
        this._contentPane.add((Component)jPanel, "South");
        this.invalidate();
        this.validate();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        this.hyperlinkUpdate(hyperlinkEvent, true);
    }

    public void setUrl(String string) {
        this._history.addPage(string);
        this._pane.setPage(string);
        this.monitorTitle(this._pane);
    }

    private void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent, boolean bl) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getURL().toString();
            BrowseHtmlPane browseHtmlPane = (BrowseHtmlPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)browseHtmlPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else if (this.isLocalUrl(string)) {
                this.setUrl(string);
            } else {
                new Browser().open(string, 3);
            }
        }
    }

    private void previousPage() {
        this._history.previousPage();
        this.updateFromIndex();
    }

    private void nextPage() {
        this._history.nextPage();
        this.updateFromIndex();
    }

    private void updateFromIndex() {
        String string = this._history.getCurrentPage();
        this._pane.setPage(string);
        this.monitorTitle(this._pane);
    }

    private void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        ((Component)this).setLocation(n2, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("BACK")) {
            this.previousPage();
        } else if (actionEvent.getActionCommand().equals("FORWARD")) {
            this.nextPage();
        } else if (actionEvent.getActionCommand().equals("BROWSE")) {
            String string = this._history.getCurrentPage();
            new Browser().open(string, 3);
        } else if (actionEvent.getActionCommand().equals("CLOSE")) {
            this.dispose();
        }
    }

    public void historyStateChanged(boolean bl, boolean bl2) {
        if (this._backButton != null) {
            this._nextButton.setEnabled(bl2);
            this._backButton.setEnabled(bl);
        }
    }

    private void monitorTitle(JEditorPane jEditorPane) {
        String string = (String)jEditorPane.getDocument().getProperty("title");
        if (string != null) {
            this.setTitle(string);
            return;
        }
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                String string = (String)document.getProperty("title");
                if (string != null) {
                    HelpWindow.this.setTitle(string);
                    document.removeDocumentListener(this);
                }
            }
        };
        jEditorPane.getDocument().addDocumentListener(documentListener);
        string = (String)jEditorPane.getDocument().getProperty("title");
        if (string != null) {
            this.setTitle(string);
            jEditorPane.getDocument().removeDocumentListener(documentListener);
        }
    }

    private boolean isLocalUrl(String string) {
        URL uRL;
        JFrame jFrame;
        boolean bl = false;
        String string2 = UtilConsoleGlobals.getAdminHelpURL().toString();
        if (string2 != null) {
            boolean bl2 = bl = string.toLowerCase().indexOf(string2.toLowerCase()) >= 0;
        }
        if (!bl && (jFrame = UtilConsoleGlobals.getActivatedFrame()) != null && jFrame instanceof Framework && (uRL = ((Framework)jFrame).getHelpAdminURL()) != null) {
            string2 = uRL.toString().toLowerCase();
            bl = string.toLowerCase().indexOf(string2) >= 0;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: HelpWindow URL");
            System.exit(1);
        }
        String string = stringArray[0];
        new HelpWindow(string, BACK_FORWARD | BROWSE | CLOSE).show();
    }
}

