/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Cursor;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import netscape.ldap.util.DN;

public class VLDirectoryTableModel
extends AbstractTableModel {
    static final String EMPTY_STRING = "";
    private ResourceSet _resource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");
    private RemoteImage _userIcon;
    private RemoteImage _groupIcon;
    private RemoteImage _ouIcon;
    private RemoteImage _otherIcon;
    private int _maxResults = Integer.parseInt(this._resource.getString("SearchResult", "MaxResults"));
    private Vector _header;
    private Vector _columnName;
    private boolean _useVirtualList;
    private LDAPConnection _ldc;
    protected LDAPControl[] _pageControls;
    protected LDAPVirtualListControl _vlc;
    private Vector _entries;
    private Vector _LDAPEntries;
    protected boolean _isInitialized;
    private String _baseDN;
    private int _scope;
    private String _filter;
    protected int _beforeCount;
    protected int _afterCount;
    private int _pageSize;
    protected int _size;
    private int _top;
    private int _selectedIndex;
    private JFrame _activeFrame;

    public VLDirectoryTableModel(Vector vector, Vector vector2) {
        this._userIcon = new RemoteImage("com/netscape/management/nmclf/icons/user.gif");
        this._userIcon.setDescription(this._resource.getString("VLDirectoryTableModel", "userIcon-description"));
        this._groupIcon = new RemoteImage("com/netscape/management/nmclf/icons/group.gif");
        this._groupIcon.setDescription(this._resource.getString("VLDirectoryTableModel", "groupIcon-description"));
        this._ouIcon = new RemoteImage("com/netscape/management/nmclf/icons/ou.gif");
        this._ouIcon.setDescription(this._resource.getString("VLDirectoryTableModel", "ouIcon-description"));
        this._otherIcon = new RemoteImage("com/netscape/management/nmclf/icons/genobject.gif");
        this._otherIcon.setDescription(this._resource.getString("VLDirectoryTableModel", "otherIcon-description"));
        this._header = vector;
        this._columnName = vector2;
        this._ldc = null;
        this._vlc = null;
        this._entries = new Vector();
        this._LDAPEntries = new Vector();
        this._isInitialized = false;
        this._pageControls = null;
        this._baseDN = null;
        this._filter = null;
        this._beforeCount = 0;
        this._afterCount = 0;
        this._pageSize = 10;
        this._size = -1;
        this._top = 0;
        this._selectedIndex = 1;
        this._isInitialized = false;
        this._useVirtualList = false;
    }

    public void setColumnInfo(Vector vector, Vector vector2) {
        this._header = vector;
        this._columnName = vector2;
        this.fireTableStructureChanged();
        this._entries.removeAllElements();
        Enumeration enumeration = this._LDAPEntries.elements();
        LDAPEntry lDAPEntry = null;
        while (enumeration.hasMoreElements()) {
            lDAPEntry = (LDAPEntry)enumeration.nextElement();
            this.addEntry(this.getRow(lDAPEntry), null, false);
        }
        this.fireTableDataChanged();
    }

    public int getMaxResults() {
        return this._maxResults;
    }

    public void setMaxResults(int n) {
        this._maxResults = n;
    }

    public void cancelSearch() {
        this._useVirtualList = false;
        this.fireTableDataChanged();
        if (this._activeFrame != null) {
            this._activeFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public int getRowCount() {
        if (this._useVirtualList) {
            return Math.max(0, this._size);
        }
        return Math.max(this._LDAPEntries.size(), this._entries.size());
    }

    private boolean getPage(int n) {
        int n2 = n - this._beforeCount;
        if (n2 < 0) {
            n -= n2;
        }
        this._vlc.setRange(n, this._beforeCount, this._afterCount);
        return this.getPage();
    }

    private boolean getPage() {
        Cursor cursor = null;
        if (this._activeFrame != null) {
            cursor = this._activeFrame.getCursor();
            this._activeFrame.setCursor(Cursor.getPredefinedCursor(3));
        }
        boolean bl = this.getEntries();
        if (this._activeFrame != null && cursor != null) {
            this._activeFrame.setCursor(cursor);
        }
        if (!bl) {
            Debug.println("VLDirectoryTableModel.getPage: get entries failed");
            this._size = this._entries.size();
            this._selectedIndex = 1;
            this._top = 0;
            this._vlc.setListSize(this._size);
            return false;
        }
        LDAPControl[] lDAPControlArray = this._ldc.getResponseControls();
        if (lDAPControlArray == null) {
            Debug.println("TRACE VLDirectoryTableModel.getPage: null response controls");
            this._size = this._entries.size();
            this._selectedIndex = 1;
            this._top = 0;
            this._vlc.setListSize(this._size);
            return false;
        }
        LDAPVirtualListResponse lDAPVirtualListResponse = LDAPVirtualListResponse.parseResponse((LDAPControl[])lDAPControlArray);
        if (lDAPVirtualListResponse == null) {
            Debug.println("TRACE VLDirectoryTableModel.getPage: null virtual list response control");
            this._size = this._entries.size();
            this._selectedIndex = 1;
            this._top = 0;
            this._vlc.setListSize(this._size);
            return false;
        }
        this._selectedIndex = lDAPVirtualListResponse.getFirstPosition() - 1;
        Debug.println("VLDirectoryTableModel.getPage: _selectedIndex = " + this._selectedIndex);
        this._top = this._selectedIndex > this._beforeCount ? this._selectedIndex - this._beforeCount : 0;
        Debug.println("VLDirectoryTableModel.getPage: _top = " + this._top);
        this._size = lDAPVirtualListResponse.getContentCount();
        int n = this._entries.size();
        Debug.println("VLDirectoryTableModel.getPage: _entries size = " + n);
        if (this._size < n) {
            this._size = n;
        }
        Debug.println("VLDirectoryTableModel.getPage: _size = " + this._size);
        this._vlc.setListSize(this._size);
        return true;
    }

    private boolean getEntries() {
        if (this._ldc == null) {
            Debug.println("ERROR VLDirectoryTableModel.getEntries: no LDAP connection");
            return false;
        }
        LDAPSearchConstraints lDAPSearchConstraints = this._ldc.getSearchConstraints();
        if (this._pageControls == null) {
            Debug.println("ERROR VLDirectoryTableModel.getEntries: no page controls");
            return false;
        }
        lDAPSearchConstraints.setServerControls(this._pageControls);
        this.removeAllEntries();
        try {
            LDAPSearchResults lDAPSearchResults = this._ldc.search(this._baseDN, this._scope, this._filter, null, false, lDAPSearchConstraints);
            LDAPEntry lDAPEntry = null;
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
                if (!(lDAPEntry2 instanceof LDAPEntry)) continue;
                lDAPEntry = lDAPEntry2;
                this.addEntry(this.getRow(lDAPEntry), lDAPEntry, false);
            }
        }
        catch (LDAPException lDAPException) {
            final LDAPException lDAPException2 = lDAPException;
            Runnable runnable = new Runnable(){

                public void run() {
                    Debug.println("RESULT CODE       : " + lDAPException2.getLDAPResultCode());
                    Debug.println("LDAP ERROR MESSAGE: " + lDAPException2.getLDAPErrorMessage());
                    if (lDAPException2.getLDAPResultCode() == 2) {
                        JOptionPane.showMessageDialog(VLDirectoryTableModel.this._activeFrame, VLDirectoryTableModel.this._resource.getString("SearchError", "WrongLang"), VLDirectoryTableModel.this._resource.getString("SearchError", "Title"), 0);
                    } else if (lDAPException2.getLDAPResultCode() == 11) {
                        JOptionPane.showMessageDialog(VLDirectoryTableModel.this._activeFrame, VLDirectoryTableModel.this._resource.getString("SearchError", "AdminLimitExceeded"), VLDirectoryTableModel.this._resource.getString("SearchError", "Incomplete"), 1);
                    } else {
                        JOptionPane.showMessageDialog(VLDirectoryTableModel.this._activeFrame, VLDirectoryTableModel.this._resource.getString("SearchError", "General") + (Object)((Object)lDAPException2), VLDirectoryTableModel.this._resource.getString("SearchError", "Title"), 0);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    private Object[] getRow(LDAPEntry lDAPEntry) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        try {
            object = LDAPUtil.flatting(lDAPEntry.getAttribute("objectclass", LDAPUtil.getLDAPAttributeLocale())).toLowerCase();
            if (object != null && ((String)object).indexOf("organizationalunit") != -1) {
                bl = true;
            }
            if (!bl && object != null && ((String)object).indexOf("person") != -1) {
                bl2 = true;
            }
            if (!bl && !bl2 && object != null && ((String)object).indexOf("groupofuniquenames") != -1) {
                bl3 = true;
            }
        }
        catch (Exception exception) {
            bl4 = false;
            bl2 = true;
        }
        object = this._header.elements();
        Object[] objectArray = new Object[this._header.size()];
        int n = 0;
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (bl4) {
                if (string.equals("cn")) {
                    JLabel jLabel;
                    if (bl2) {
                        jLabel = new JLabel();
                        jLabel.setIcon(this._userIcon);
                        jLabel.setText(LDAPUtil.flatting(lDAPEntry.getAttribute(string, LDAPUtil.getLDAPAttributeLocale())));
                        objectArray[n] = jLabel;
                    } else if (bl3) {
                        jLabel = new JLabel();
                        jLabel.setIcon(this._groupIcon);
                        jLabel.setText(LDAPUtil.flatting(lDAPEntry.getAttribute(string, LDAPUtil.getLDAPAttributeLocale())));
                        objectArray[n] = jLabel;
                    } else if (bl) {
                        jLabel = new JLabel();
                        jLabel.setIcon(this._ouIcon);
                        jLabel.setText(LDAPUtil.flatting(lDAPEntry.getAttribute("ou", LDAPUtil.getLDAPAttributeLocale())));
                        objectArray[n] = jLabel;
                    } else {
                        jLabel = new JLabel();
                        jLabel.setIcon(this._otherIcon);
                        String string2 = lDAPEntry.getDN();
                        String string3 = lDAPEntry.getDN();
                        DN dN = new DN(string2);
                        string3 = dN.countRDNs() >= 1 ? dN.explodeDN(true)[0] : EMPTY_STRING;
                        jLabel.setText(string3);
                        jLabel.setToolTipText(lDAPEntry.getDN());
                        objectArray[n] = jLabel;
                    }
                } else {
                    objectArray[n] = LDAPUtil.flatting(lDAPEntry.getAttribute(string, LDAPUtil.getLDAPAttributeLocale()));
                }
            } else {
                objectArray[n] = n == 0 ? lDAPEntry.getDN() : EMPTY_STRING;
            }
            ++n;
        }
        return objectArray;
    }

    private Object[] getRow(String string) {
        Object[] objectArray = new Object[this._header.size()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = null;
            ++n;
        }
        int n2 = this._header.indexOf("cn");
        if (n2 != -1) {
            objectArray[n2] = string;
        } else {
            objectArray[0] = string;
        }
        return objectArray;
    }

    public void addRow(LDAPEntry lDAPEntry) {
        if (this._useVirtualList) {
            this.removeAllEntries();
            this._useVirtualList = false;
        }
        if (this._entries.size() == 1 && this._LDAPEntries.size() == 0) {
            this.removeAllEntries();
        }
        this.addEntry(this.getRow(lDAPEntry), lDAPEntry, true);
    }

    public void addRow(String string) {
        if (this._useVirtualList) {
            this.removeAllEntries();
            this._useVirtualList = false;
        }
        if (this._entries.size() == 1 && this._LDAPEntries.size() == 0) {
            this.removeAllEntries();
        }
        this.addEntry(this.getRow(string), null, true);
    }

    public void replaceRow(LDAPEntry lDAPEntry, int n) {
        this._LDAPEntries.setElementAt(lDAPEntry, n);
        this._entries.setElementAt(this.getRow(this.getRow(n)), n);
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this._header.size();
    }

    public String getColumnName(int n) {
        return n >= 0 && n < this._columnName.size() ? (String)this._columnName.elementAt(n) : EMPTY_STRING;
    }

    public Object getValueAt(int n, int n2) {
        if (this._useVirtualList) {
            if (!(n >= this._top && n < this._top + this._entries.size() || this.getPage(n))) {
                return null;
            }
            int n3 = n - this._top;
            if (n3 < 0 || n3 >= this._entries.size()) {
                return null;
            }
            Object[] objectArray = (Object[])this._entries.elementAt(n3);
            return objectArray[n2];
        }
        Object[] objectArray = (Object[])this._entries.elementAt(n);
        if (objectArray != null && n2 < objectArray.length) {
            return objectArray[n2];
        }
        return null;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getFirstIndex() {
        return this._top;
    }

    public void setPageSize(int n) {
        this._pageSize = n;
    }

    public LDAPEntry getRow(int n) {
        if (this._useVirtualList) {
            if (!(n >= this._top && n < this._top + this._entries.size() || this.getPage(n))) {
                return null;
            }
            int n2 = n - this._top;
            if (n2 < 0 || n2 >= this._entries.size()) {
                return null;
            }
            return (LDAPEntry)this._LDAPEntries.elementAt(n2);
        }
        if (this._LDAPEntries.size() == 0) {
            return null;
        }
        return (LDAPEntry)this._LDAPEntries.elementAt(n);
    }

    private boolean isConnected(LDAPConnection lDAPConnection) {
        try {
            if (lDAPConnection == null) {
                return false;
            }
            if (!lDAPConnection.isConnected()) {
                lDAPConnection.connect(3, lDAPConnection.getHost(), lDAPConnection.getPort(), lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword());
            }
            return lDAPConnection.isConnected();
        }
        catch (LDAPException lDAPException) {
            Debug.println("VLDirectoryTableModel.isConnected: Could not connect to LDAP server: " + (Object)((Object)lDAPException));
            return false;
        }
    }

    public void doSearch(LDAPConnection lDAPConnection, String string, String string2) {
        this.doSearch(lDAPConnection, string, 2, string2);
    }

    public void doSearch(LDAPConnection lDAPConnection, String string, int n, String string2) {
        if (this._ldc != null && this._ldc.isConnected()) {
            try {
                this._ldc.disconnect();
                this._ldc = null;
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
        if (!this.isConnected(lDAPConnection)) {
            Runnable runnable = new Runnable(){

                public void run() {
                    SuiOptionPane.showMessageDialog(null, (Object)VLDirectoryTableModel.this._resource.getString("SearchError", "NoConnection"), (String)VLDirectoryTableModel.this._resource.getString("SearchError", "Title"), (int)0);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        this._ldc = (LDAPConnection)lDAPConnection.clone();
        this._baseDN = string;
        this._scope = n;
        this._filter = string2;
        this._isInitialized = false;
        this._useVirtualList = false;
        this._activeFrame = UtilConsoleGlobals.getActivatedFrame();
        LDAPSearchConstraints lDAPSearchConstraints = this._ldc.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this._maxResults);
        if (LDAPUtil.isVersion4(this._ldc)) {
            this._beforeCount = this._pageSize * 2;
            this._afterCount = this._pageSize * 2;
            this._pageControls = new LDAPControl[2];
            LDAPSortKey[] lDAPSortKeyArray = new LDAPSortKey[2];
            int n2 = 0;
            String string3 = Locale.getDefault().getLanguage();
            if (string3 == null || string3.equals(EMPTY_STRING)) {
                lDAPSortKeyArray[n2++] = new LDAPSortKey("cn", false);
                lDAPSortKeyArray[n2++] = new LDAPSortKey("ou", false);
            } else {
                lDAPSortKeyArray[n2++] = new LDAPSortKey("cn", false, string3);
                lDAPSortKeyArray[n2++] = new LDAPSortKey("ou", false, string3);
            }
            this._pageControls[0] = new LDAPSortControl(lDAPSortKeyArray, true);
            this._vlc = new LDAPVirtualListControl("A", this._beforeCount, this._afterCount);
            this._pageControls[1] = this._vlc;
            this.getPage(0);
            this._useVirtualList = true;
            this.invokeFireTableDataChanged();
        } else {
            int n3 = 0;
            try {
                LDAPSearchResults lDAPSearchResults = this._ldc.search(this._baseDN, this._scope, this._filter, null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements() && n3 < this._maxResults) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    if (!(lDAPEntry instanceof LDAPEntry)) continue;
                    this.addRow(lDAPEntry);
                    ++n3;
                }
            }
            catch (LDAPException lDAPException) {
                final LDAPException lDAPException2 = lDAPException;
                Runnable runnable = new Runnable(){

                    public void run() {
                        block7: {
                            if (lDAPException2.getLDAPResultCode() == 2) {
                                SuiOptionPane.showMessageDialog(null, (Object)VLDirectoryTableModel.this._resource.getString("SearchError", "WrongLang"), (String)VLDirectoryTableModel.this._resource.getString("SearchError", "Title"), (int)0);
                            } else if (lDAPException2.getLDAPResultCode() == 32) {
                                try {
                                    LDAPEntry lDAPEntry = VLDirectoryTableModel.this._ldc.read(VLDirectoryTableModel.this._ldc.getAuthenticationDN());
                                }
                                catch (LDAPException lDAPException) {
                                    if (lDAPException.getLDAPResultCode() == 32) {
                                        String string = MessageFormat.format(VLDirectoryTableModel.this._resource.getString("SearchError", "WrongDN"), VLDirectoryTableModel.this._ldc.getAuthenticationDN());
                                        SuiOptionPane.showMessageDialog(null, (Object)string, (String)VLDirectoryTableModel.this._resource.getString("SearchError", "Title"), (int)0);
                                        break block7;
                                    }
                                    SuiOptionPane.showMessageDialog(null, (Object)(VLDirectoryTableModel.this._resource.getString("SearchError", "General") + (Object)((Object)lDAPException2)), (String)VLDirectoryTableModel.this._resource.getString("SearchError", "Title"), (int)0);
                                }
                            } else {
                                SuiOptionPane.showMessageDialog(null, (Object)(VLDirectoryTableModel.this._resource.getString("SearchError", "General") + (Object)((Object)lDAPException2)), (String)VLDirectoryTableModel.this._resource.getString("SearchError", "Title"), (int)0);
                            }
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
            if (n3 == this._maxResults) {
                final String string4 = this._resource.getString("SearchResult", "MaxResultsMessage1") + this._maxResults + this._resource.getString("SearchResult", "MaxResultsMessage2");
                Runnable runnable = new Runnable(){

                    public void run() {
                        SuiOptionPane.showMessageDialog(null, (Object)string4, (String)VLDirectoryTableModel.this._resource.getString("SearchResult", "DialogTitle"), (int)1);
                        ModalDialogUtil.sleep();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.invokeFireTableDataChanged();
        }
    }

    public void deleteRow(LDAPEntry lDAPEntry) {
        int n = this._LDAPEntries.indexOf(lDAPEntry);
        if (n != -1) {
            this._entries.removeElementAt(n);
            this._LDAPEntries.removeElementAt(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void deleteAllRow() {
        this.deleteAllRows();
    }

    public void deleteAllRows() {
        this._useVirtualList = false;
        this.removeAllEntries();
        this.fireTableDataChanged();
    }

    void addEntry(final Object object, final LDAPEntry lDAPEntry, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                VLDirectoryTableModel.this._entries.addElement(object);
                if (lDAPEntry != null) {
                    VLDirectoryTableModel.this._LDAPEntries.addElement(lDAPEntry);
                }
                if (bl) {
                    VLDirectoryTableModel.this.fireTableDataChanged();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Debug.println(0, "VLDirectoryTableModel.addEntry: invokeAndWait() thrown " + exception);
            }
        }
    }

    void removeAllEntries() {
        Runnable runnable = new Runnable(){

            public void run() {
                VLDirectoryTableModel.this._entries.removeAllElements();
                VLDirectoryTableModel.this._LDAPEntries.removeAllElements();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Debug.println(0, "VLDirectoryTableModel.removeAllEntries: invokeAndWait() thrown " + exception);
            }
        }
    }

    void invokeFireTableDataChanged() {
        Runnable runnable = new Runnable(){

            public void run() {
                VLDirectoryTableModel.this.fireTableDataChanged();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Debug.println(0, "VLDirectoryTableModel.invokeFireTableDataChanged: invokeAndWait() thrown " + exception);
            }
        }
    }
}

