/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.LdapCriteria;
import com.netscape.management.client.util.AbstractModalDialog;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class LdapQueryBuilderDialog
extends AbstractModalDialog {
    static final int MAX_CRITERIA_COUNT = 5;
    static final String RESOURCE_STRING_PREFIX = "dynamicQueryConstructor";
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");
    Help _helpSession;
    int _criteriaCount;
    LdapCriteria[] _criteria;
    private int _startLine = 55;
    String _queryString;
    ConsoleInfo _consoleInfo;
    JButton _moreButton;
    JButton _fewerButton;
    JComboBox _searchScope;
    JComboBox _userOrGroup;
    JLabel _host;
    JLabel _port;
    JTextField _baseDN;
    JPanel _criteriaPanel;
    JPanel _buttonPanel;
    ActionListener _actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == LdapQueryBuilderDialog.this._moreButton) {
                LdapQueryBuilderDialog.this.moreInvoked();
            } else if (object == LdapQueryBuilderDialog.this._fewerButton) {
                LdapQueryBuilderDialog.this.fewerInvoked();
            }
        }
    };

    public LdapQueryBuilderDialog(ConsoleInfo consoleInfo) {
        super((Frame)null);
        this.setTitle(this._resource.getString(RESOURCE_STRING_PREFIX, "title"));
        this._consoleInfo = consoleInfo;
        this._criteriaCount = 0;
        this._criteria = new LdapCriteria[5];
        this._helpSession = new Help(this._resource);
        this._moreButton = new JButton(this._resource.getString(RESOURCE_STRING_PREFIX, "moreButton"));
        this._moreButton.setToolTipText(this._resource.getString(RESOURCE_STRING_PREFIX, "more_tt"));
        this._moreButton.addActionListener(this._actionListener);
        this._fewerButton = new JButton(this._resource.getString(RESOURCE_STRING_PREFIX, "fewerButton"));
        this._fewerButton.setToolTipText(this._resource.getString(RESOURCE_STRING_PREFIX, "fewer_tt"));
        this._fewerButton.addActionListener(this._actionListener);
        JButtonFactory.resizeGroup(this._moreButton, this._fewerButton);
        this._fewerButton.setEnabled(false);
        this._searchScope = new JComboBox();
        this.populateComboBox(this._searchScope, RESOURCE_STRING_PREFIX, "searchScopeCount", "searchScope");
        this._searchScope.setSelectedIndex(2);
        this._userOrGroup = new JComboBox();
        this.populateComboBox(this._userOrGroup, RESOURCE_STRING_PREFIX, "searchClassCount", "searchClass");
        this._userOrGroup.setSelectedIndex(2);
        JLabel jLabel = new JLabel(this._resource.getString(RESOURCE_STRING_PREFIX, "hostLabel"));
        JLabel jLabel2 = new JLabel(this._resource.getString(RESOURCE_STRING_PREFIX, "portLabel"));
        JLabel jLabel3 = new JLabel(this._resource.getString(RESOURCE_STRING_PREFIX, "baseDNLabel"));
        JLabel jLabel4 = new JLabel(this._resource.getString(RESOURCE_STRING_PREFIX, "searchLabel"), 4);
        jLabel4.setLabelFor(this._searchScope);
        JLabel jLabel5 = new JLabel(this._resource.getString(RESOURCE_STRING_PREFIX, "searchForLabel"));
        jLabel5.setLabelFor(this._userOrGroup);
        JLabel jLabel6 = new JLabel("");
        this._host = new JLabel();
        jLabel.setLabelFor(this._host);
        this._host.setBorder(new BevelBorder(1));
        this._host.setText(this._consoleInfo.getUserHost());
        this._port = new JLabel();
        jLabel2.setLabelFor(this._port);
        this._port.setBorder(new BevelBorder(1));
        this._port.setText(Integer.toString(this._consoleInfo.getUserPort()));
        this._baseDN = new JTextField();
        jLabel3.setLabelFor(this._baseDN);
        this._baseDN.setText(this._consoleInfo.getUserBaseDN());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 0, 0);
        GridBagUtil.constrain(jPanel, this._host, 1, 0, 1, 1, 0.5, 0.0, 17, 2, 0, 6, 0, 0);
        GridBagUtil.constrain(jPanel, jLabel2, 2, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 6, 0, 0);
        GridBagUtil.constrain(jPanel, this._port, 3, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 6, 0, 0);
        GridBagUtil.constrain(jPanel, jLabel3, 4, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 6, 0, 0);
        GridBagUtil.constrain(jPanel, this._baseDN, 5, 0, 1, 1, 0.5, 0.0, 17, 2, 0, 6, 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagUtil.constrain(jPanel2, jLabel4, 0, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 0, 0);
        GridBagUtil.constrain(jPanel2, this._searchScope, 1, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 6, 0, 0);
        GridBagUtil.constrain(jPanel2, jLabel5, 2, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 6, 0, 0);
        GridBagUtil.constrain(jPanel2, this._userOrGroup, 3, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 6, 0, 0);
        this._criteriaPanel = new JPanel(new GridBagLayout());
        this._buttonPanel = new JPanel(new FlowLayout(0, 6, 0));
        this._buttonPanel.add(this._moreButton);
        this._buttonPanel.add(this._fewerButton);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagUtil.constrain(container, jPanel, 0, 0, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 0);
        GridBagUtil.constrain(container, jPanel2, 0, 1, 1, 1, 0.0, 0.0, 17, 0, 9, 0, 0, 0);
        GridBagUtil.constrain(container, this._criteriaPanel, 0, 2, 1, 1, 1.0, 0.0, 17, 2, 9, 0, 0, 0);
        GridBagUtil.constrain(container, jLabel6, 0, 3, 1, 1, 1.0, 1.0, 17, 1, 9, 0, 0, 0);
        this.addRow();
    }

    public LdapQueryBuilderDialog(String string, ConsoleInfo consoleInfo) {
        this(consoleInfo);
        this.setTitle(string);
    }

    public void initialize() {
        this._queryString = "";
    }

    public String getQueryString() {
        return this._queryString;
    }

    public void parse(String string) {
        int n = string.indexOf("<LDAPINFO>");
        while (n != -1) {
            int n2 = string.indexOf(":", n += 10) - n;
            String string2 = string.substring(n, n + n2);
            n = n + n2 + 1;
            n2 = string.indexOf("</LDAPINFO>", n) - n;
            String string3 = string.substring(n, n + n2);
            string3 = string3.trim();
            n = n + n2 + 11;
            if (string2.indexOf("BASEDN") != -1) {
                this._baseDN.setText(string3);
            }
            n = string.indexOf("<LDAPINFO>", n);
        }
    }

    private void createQueryString() {
        this._queryString = "ldap:///";
        this._queryString = this._queryString + this._baseDN.getText();
        switch (this._searchScope.getSelectedIndex()) {
            case 0: {
                this._queryString = this._queryString + "??base?";
                break;
            }
            case 1: {
                this._queryString = this._queryString + "??one?";
                break;
            }
            default: {
                this._queryString = this._queryString + "??sub?";
            }
        }
        switch (this._userOrGroup.getSelectedIndex()) {
            case 0: {
                this._queryString = this._queryString + "(&(objectclass=person)";
                break;
            }
            case 1: {
                this._queryString = this._queryString + "(&(objectclass=groupofuniquenames)";
                break;
            }
            default: {
                this._queryString = this._queryString + "(&(|(objectclass=person)(objectclass=groupofuniquenames))";
            }
        }
        int n = 0;
        while (n < this._criteriaCount) {
            this._queryString = this._criteria[n]._condition.getSelectedIndex() == 3 ? this._queryString + "(!(" : (this._criteria[n]._condition.getSelectedIndex() == 1 ? this._queryString + "(!(" : this._queryString + "(");
            this._queryString = this._queryString + (String)this._criteria[n]._attribute.getSelectedItem();
            String string = this._criteria[n]._value.getText();
            if (string.length() == 0) {
                string = "*";
            }
            switch (this._criteria[n]._condition.getSelectedIndex()) {
                case 0: {
                    this._queryString = string.charAt(0) == '*' ? this._queryString + "=" : this._queryString + "=*";
                    this._queryString = this._queryString + string;
                    if (string.charAt(string.length() - 1) == '*') {
                        this._queryString = this._queryString + ")";
                        break;
                    }
                    this._queryString = this._queryString + "*)";
                    break;
                }
                case 1: {
                    this._queryString = string.charAt(0) == '*' ? this._queryString + "=" : this._queryString + "=*";
                    this._queryString = this._queryString + string;
                    if (string.charAt(string.length() - 1) == '*') {
                        this._queryString = this._queryString + "))";
                        break;
                    }
                    this._queryString = this._queryString + "*))";
                    break;
                }
                case 2: {
                    this._queryString = this._queryString + "=";
                    this._queryString = this._queryString + string;
                    this._queryString = this._queryString + ")";
                    break;
                }
                case 3: {
                    this._queryString = this._queryString + "=";
                    this._queryString = this._queryString + string;
                    this._queryString = this._queryString + "))";
                    break;
                }
                case 4: {
                    this._queryString = this._queryString + "=";
                    this._queryString = this._queryString + string;
                    if (string.charAt(string.length() - 1) == '*') {
                        this._queryString = this._queryString + ")";
                        break;
                    }
                    this._queryString = this._queryString + "*)";
                    break;
                }
                case 5: {
                    this._queryString = string.charAt(0) == '*' ? this._queryString + "=" : this._queryString + "=*";
                    this._queryString = this._queryString + string;
                    this._queryString = this._queryString + ")";
                    break;
                }
                case 6: {
                    this._queryString = this._queryString + "~=";
                    this._queryString = this._queryString + string;
                    this._queryString = this._queryString + ")";
                    break;
                }
                default: {
                    this._queryString = this._queryString + "=";
                    this._queryString = this._queryString + string;
                    this._queryString = this._queryString + ")";
                }
            }
            ++n;
        }
        this._queryString = this._queryString + ")";
    }

    private void removeRow() {
        this.removeButtonRow();
        --this._criteriaCount;
        this._criteriaPanel.remove(this._criteria[this._criteriaCount]._value);
        this._criteriaPanel.remove(this._criteria[this._criteriaCount]._condition);
        this._criteriaPanel.remove(this._criteria[this._criteriaCount]._attribute);
        this._criteriaPanel.remove(this._criteria[this._criteriaCount]._label);
        this._criteria[this._criteriaCount] = null;
        this.addButtonRow();
        this._moreButton.setEnabled(true);
        Container container = this.getContentPane();
        container.doLayout();
        this.pack();
    }

    private void addRow() {
        this.removeButtonRow();
        this._criteria[this._criteriaCount] = new LdapCriteria(this._consoleInfo, this._resource, this._criteriaCount);
        int n = 0;
        if (this._criteriaCount > 0) {
            n = 6;
        }
        GridBagUtil.constrain(this._criteriaPanel, this._criteria[this._criteriaCount]._label, 0, this._criteriaCount, 1, 1, 0.0, 0.0, 17, 2, n, 30, 0, 0);
        GridBagUtil.constrain(this._criteriaPanel, this._criteria[this._criteriaCount]._attribute, 1, this._criteriaCount, 1, 1, 0.0, 0.0, 17, 0, n, 6, 0, 0);
        GridBagUtil.constrain(this._criteriaPanel, this._criteria[this._criteriaCount]._condition, 2, this._criteriaCount, 1, 1, 0.0, 0.0, 17, 0, n, 6, 0, 0);
        GridBagUtil.constrain(this._criteriaPanel, this._criteria[this._criteriaCount]._value, 3, this._criteriaCount, 1, 1, 1.0, 0.0, 17, 2, n, 6, 0, 0);
        ++this._criteriaCount;
        if (this._criteriaCount > 1) {
            this._fewerButton.setEnabled(true);
        }
        this.addButtonRow();
        Container container = this.getContentPane();
        container.doLayout();
        this.pack();
    }

    private void removeButtonRow() {
        if (this._criteriaCount == 0) {
            return;
        }
        this._criteriaPanel.remove(this._buttonPanel);
    }

    private void addButtonRow() {
        GridBagUtil.constrain(this._criteriaPanel, this._buttonPanel, 1, this._criteriaCount, 1, 1, 0.0, 0.0, 17, 0, 6, 0, 0, 0);
    }

    protected void okInvoked() {
        this.createQueryString();
        super.okInvoked();
    }

    protected void helpInvoked() {
        this._helpSession.contextHelp(RESOURCE_STRING_PREFIX, "help");
    }

    protected void fewerInvoked() {
        this.removeRow();
        if (this._criteriaCount == 1) {
            this._fewerButton.setEnabled(false);
        }
    }

    protected void moreInvoked() {
        this.addRow();
        if (this._criteriaCount == 5) {
            this._moreButton.setEnabled(false);
        }
    }

    private void populateComboBox(JComboBox jComboBox, String string, String string2, String string3) {
        int n = Integer.parseInt(this._resource.getString(string, string2));
        int n2 = 0;
        while (n2 < n) {
            jComboBox.addItem(this._resource.getString(string, string3 + n2));
            ++n2;
        }
    }
}

