/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.customview;

import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.topology.customview.ViewInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RenameDialog
extends AbstractDialog
implements SwingConstants,
SuiConstants {
    JTextField _textField = new JTextField(22);
    ViewInfo[] _viewInfoArray;
    Frame _frame;
    String _originalName;

    static String i18n(String string) {
        return TopologyInitializer._resource.getString("customview", string);
    }

    public RenameDialog(Frame frame, String string, ViewInfo[] viewInfoArray) {
        super(frame, RenameDialog.i18n("RenameView"), true, 11, 0);
        this._textField.setText(string);
        this._frame = frame;
        this._viewInfoArray = viewInfoArray;
        this._originalName = string;
        this.createDialogPanel();
    }

    public void showModal() {
        this.setMinimumSize(this.getSize());
        ((Component)this).setVisible(true);
    }

    protected void createDialogPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(RenameDialog.i18n("NewViewName"));
        jLabel.setLabelFor(this._textField);
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 1, 1, 1.0, 0.0, 18, 2, 0, 0, 3, 0);
        GridBagUtil.constrain(jPanel, this._textField, 0, 1, 1, 1, 1.0, 0.0, 18, 2, 0, 0, 3, 0);
        this.setFocusComponent(this._textField);
        this.enableOK();
        this._textField.getDocument().addDocumentListener(new ChangeEventListener());
        this.setPanel(jPanel);
    }

    public String getResult() {
        return this._textField.getText();
    }

    private void enableOK() {
        String string = this._textField.getText().trim();
        boolean bl = string.length() > 0;
        this.setOKButtonEnabled(bl);
    }

    protected void helpInvoked() {
        Help help = new Help(TopologyInitializer._resource);
        help.contextHelp("customview", "RenameDialogHelp");
    }

    protected void okInvoked() {
        boolean bl = false;
        if (this._viewInfoArray != null) {
            int n = 0;
            while (n < this._viewInfoArray.length) {
                if (this._viewInfoArray[n].getDisplayName().equalsIgnoreCase(this.getResult()) && !this._originalName.equals(this.getResult())) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(this._frame, RenameDialog.i18n("NameExistsMsg"), RenameDialog.i18n("NameExistsTitle"), 0);
        } else {
            super.okInvoked();
        }
    }

    class ChangeEventListener
    implements DocumentListener {
        ChangeEventListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            RenameDialog.this.enableOK();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            RenameDialog.this.enableOK();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            RenameDialog.this.enableOK();
        }
    }
}

