/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.topology.AdminGroupNode;
import com.netscape.management.client.topology.DefaultTopologyPlugin;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.ITopologyPlugin;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.NodeDataPanel;
import com.netscape.management.client.topology.ServerLocNode;
import com.netscape.management.client.topology.ServiceLocator;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;

public class HostNode
extends ServerLocNode
implements INodeInfo {
    public static ResourceSet resource = new ResourceSet("com.netscape.management.client.topology.topology");
    protected NodeData[] _nodeData;
    protected NodeData _nameNodeData;
    protected NodeDataPanel _nodeDataPanel;
    protected IPage _viewInstance;
    private static RemoteImage _icon = new RemoteImage(resource.getString("tree", "hostIcon"));
    private boolean isInitialized = false;
    private Vector _changeListeners = new Vector();
    String _os = "";
    String _platform = "";
    String _host = "";
    String _description = "";
    String _location = "";

    public HostNode(ServiceLocator serviceLocator, LDAPEntry lDAPEntry) {
        super(serviceLocator);
        this.initialize(lDAPEntry);
    }

    public HostNode(ServiceLocator serviceLocator, String string, String string2) {
        super(serviceLocator);
        this.setDN(string);
        this._host = string2;
        this.setName(this._host);
        _icon.setDescription(resource.getString("tree", "hostIcon-description"));
        this.setIcon(_icon);
    }

    private void initialize() {
        try {
            this.initialize(this._sl.getConnection().read(this.getDN()));
        }
        catch (Exception exception) {
            Debug.println("HostNode.initialize() failed");
        }
    }

    private void initialize(LDAPEntry lDAPEntry) {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setDN(lDAPEntry.getDN());
        this.setIcon(_icon);
        if (lDAPEntry != null) {
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            Enumeration enumeration = lDAPAttributeSet.getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                String string = lDAPAttribute.getName();
                if (string.equalsIgnoreCase("serverHostName")) {
                    this._host = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                    this.setName(this._host);
                    continue;
                }
                if (string.equalsIgnoreCase("description")) {
                    this._description = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                    continue;
                }
                if (string.equalsIgnoreCase("nsHostLocation")) {
                    this._location = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                    continue;
                }
                if (string.equalsIgnoreCase("nshardwareplatform")) {
                    this._platform = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                    continue;
                }
                if (!string.equalsIgnoreCase("nsosVersion")) continue;
                this._os = LDAPUtil.flatting(lDAPAttribute.getStringValues());
            }
            this._nameNodeData = new NodeData("serverHostName", this._resource.getString("ServerObject", "serverHostName"), this.getName(), true, true);
            this._nodeData = new NodeData[]{this._nameNodeData, new NodeData("description", this._resource.getString("ServerObject", "description"), this._description, true), new NodeData("nsHostLocation", this._resource.getString("HostInfoPanel", "location"), this._location, true), new NodeData("platform", this._resource.getString("HostInfoPanel", "platform"), this._platform, false), new NodeData("os", this._resource.getString("HostInfoPanel", "system"), this._os, false)};
        }
    }

    public void reload() {
        Object object;
        Hashtable hashtable;
        if (!this.isInitialized) {
            this.initialize();
        }
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
        super.reload();
        LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)this.getServiceLocator().getAdminGroup(this.getDN());
        if (lDAPSearchResults != null) {
            try {
                while (lDAPSearchResults.hasMoreElements()) {
                    hashtable = lDAPSearchResults.next();
                    object = new AdminGroupNode(this._sl, (LDAPEntry)hashtable);
                    ((AdminGroupNode)object).setAdminOS(this._os);
                    if (this.searchChildByName(object.getName()) != null) continue;
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((hashtable = TopologyInitializer.getNetworkTopologyPlugin()) != null) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                ITopologyPlugin iTopologyPlugin;
                Vector vector;
                String string = (String)object.nextElement();
                if (string.equals(DefaultTopologyPlugin.name) || (vector = (iTopologyPlugin = (ITopologyPlugin)hashtable.get(string)).getAdditionalChildren(this)) == null) continue;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    IResourceObject iResourceObject = (IResourceObject)enumeration.nextElement();
                    if (this.searchChildByName(iResourceObject.getName()) != null) continue;
                    if (iResourceObject instanceof MutableTreeNode) {
                        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)iResourceObject);
                        continue;
                    }
                    Debug.println(iResourceObject.getName() + " is not a MutableTreeNode .");
                }
            }
        }
    }

    public Component getCustomPanel() {
        this._nodeDataPanel = new NodeDataPanel(this.getIcon(), this.getName(), this);
        this._nodeDataPanel.setHelpTopic("admin", "topology-hostnode");
        return this._nodeDataPanel;
    }

    public void unselect(IPage iPage) {
        this._nodeDataPanel = null;
    }

    public void select(IPage iPage) {
        this._viewInstance = iPage;
    }

    public int getNodeDataCount() {
        this.initialize();
        return this._nodeData.length;
    }

    public NodeData getNodeData(int n) {
        return this._nodeData[n];
    }

    public void actionNodeDataChanged(NodeData nodeData) {
        String string = this.getDN();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(nodeData.getID(), (String)nodeData.getValue());
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        LDAPConnection lDAPConnection = this.getServiceLocator().getConnection();
        if (nodeData.getID().equals("serverHostName")) {
            ResourcePage resourcePage;
            this.setName((String)nodeData.getValue());
            this._nameNodeData.setValue(nodeData.getValue());
            this._nodeDataPanel.setTitle((String)nodeData.getValue());
            if (this._viewInstance != null && this._viewInstance instanceof ResourcePage && (resourcePage = (ResourcePage)this._viewInstance).getTreeModel() instanceof ResourceModel) {
                ((ResourceModel)resourcePage.getTreeModel()).fireTreeNodeChanged(this);
            }
        }
        try {
            lDAPConnection.modify(string, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 16) {
                try {
                    lDAPModification = new LDAPModification(0, lDAPAttribute);
                    lDAPConnection.modify(string, lDAPModification);
                }
                catch (LDAPException lDAPException2) {
                    Debug.println("DomainNode.actionNodeDataChanged() " + (Object)((Object)lDAPException2));
                }
            }
            Debug.println("DomainNode.actionNodeDataChanged() " + (Object)((Object)lDAPException));
        }
        this.isInitialized = false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.removeElement(changeListener);
    }
}

