/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.legacy.plugin;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class LegacyServiceLocator {
    private static final String ROOTNODE = "o=NetscapeRoot";
    LDAPConnection _ldc;
    ConsoleInfo _consoleInfo;

    public LegacyServiceLocator(ConsoleInfo consoleInfo) {
        this._consoleInfo = consoleInfo;
        this._ldc = consoleInfo.getLDAPConnection();
    }

    public LDAPConnection getConnection() {
        return this._ldc;
    }

    public Enumeration getHosts(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            this._ldc = this._consoleInfo.getLDAPConnection();
            if (this._ldc != null) {
                LDAPSearchConstraints lDAPSearchConstraints = this._ldc.getSearchConstraints();
                lDAPSearchConstraints.setBatchSize(1);
                lDAPSearchResults = this._ldc.search(string, 1, "(Objectclass=NetscapeHost)", null, false, lDAPSearchConstraints);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN());
        }
        return lDAPSearchResults;
    }

    public LDAPSearchResults getAdminGroup(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            if (!this._ldc.isConnected()) {
                this._ldc.connect(this._consoleInfo.getHost(), this._consoleInfo.getPort(), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            }
            LDAPSearchConstraints lDAPSearchConstraints = this._ldc.getSearchConstraints();
            lDAPSearchConstraints.setBatchSize(1);
            lDAPSearchResults = this._ldc.search(string, 1, "(Objectclass=nsLegacyAdminGroup)", null, false, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.print("LDAP Error : Error Code = ");
            Debug.println(n);
            Debug.println("Legacy : getAdminGroup() No such object " + string + ".  Connecting as " + this._consoleInfo.getAuthenticationDN());
        }
        return lDAPSearchResults;
    }

    public Enumeration getProductType(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            if (!this._ldc.isConnected()) {
                this._ldc.connect(this._consoleInfo.getHost(), this._consoleInfo.getPort(), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            }
            LDAPSearchConstraints lDAPSearchConstraints = this._ldc.getSearchConstraints();
            lDAPSearchConstraints.setBatchSize(1);
            lDAPSearchResults = this._ldc.search(string, 1, "(Objectclass=nsLegacyApplication)", null, false, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            Debug.println("Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN() + " " + this._consoleInfo.getAuthenticationPassword());
        }
        return lDAPSearchResults;
    }

    public Enumeration getSIE(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        try {
            if (!this._ldc.isConnected()) {
                this._ldc.connect(this._consoleInfo.getHost(), this._consoleInfo.getPort(), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            }
            LDAPSearchConstraints lDAPSearchConstraints = this._ldc.getSearchConstraints();
            lDAPSearchConstraints.setBatchSize(1);
            lDAPSearchResults = this._ldc.search(string, 1, "(Objectclass=nsLegacyServer)", null, false, lDAPSearchConstraints);
            if (lDAPSearchResults != null) {
                while (lDAPSearchResults.hasMoreElements()) {
                    String string2 = "";
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    string2 = lDAPEntry.getDN();
                    if (string2 == "") continue;
                    LDAPEntry lDAPEntry2 = this._ldc.read(string2);
                    vector.addElement(lDAPEntry2);
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN() + " " + this._consoleInfo.getAuthenticationPassword() + " " + string);
        }
        return vector.elements();
    }

    public ConsoleInfo getConsoleInfo() {
        return this._consoleInfo;
    }
}

