/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.DirModel;
import com.netscape.management.client.components.DirNode;
import com.netscape.management.client.components.IDirModel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;

public class RootDirNode
extends DirNode
implements Serializable {
    private boolean _showPrivateSuffixes = true;
    private static final String _configDN = "cn=config";
    private static final String _privateSuffixAttr = "nsslapd-privatenamespaces";

    public RootDirNode(IDirModel iDirModel, String string, boolean bl) {
        super(iDirModel, "", string);
        this._showPrivateSuffixes = bl;
        Debug.println(9, "RootDirNode.RootDirNode(3)");
    }

    public RootDirNode(IDirModel iDirModel, boolean bl) {
        LDAPConnection lDAPConnection;
        this._showPrivateSuffixes = bl;
        Debug.println(9, "RootDirNode.RootDirNode(2): private = " + this._showPrivateSuffixes);
        String string = "";
        if (iDirModel != null && (lDAPConnection = iDirModel.getLDAPConnection()) != null) {
            string = lDAPConnection.getHost() + ":" + lDAPConnection.getPort();
        }
        this.initialize(iDirModel, "", string);
    }

    public RootDirNode(IDirModel iDirModel, LDAPEntry lDAPEntry, boolean bl) {
        this(iDirModel, bl);
        Debug.println(9, "RootDirNode.DirNode(3a)");
        this._entry = lDAPEntry;
        this.initializeFromEntry(this._entry);
    }

    protected void initialize(IDirModel iDirModel, String string, String string2) {
        super.initialize(iDirModel, string, string2);
        RemoteImage remoteImage = new RemoteImage("com/netscape/management/client/images/host.gif");
        remoteImage.setDescription(DirNode._resource.getString("dirBrowser", "root-icon-description"));
        this.setIcon(remoteImage);
        this.load();
    }

    public void load() {
        Debug.println(9, "RootDirNode.load");
        this.getChildList();
    }

    public boolean isLeaf() {
        return false;
    }

    private DirNode getNode(String string) {
        Debug.println(9, "DirNode.getNode: <" + string + ">");
        if (DirNode.isRootDSE(string)) {
            return null;
        }
        DirNode dirNode = null;
        Debug.println("  NamingContext: " + string);
        LDAPEntry lDAPEntry = this.readEntry(string, DirNode._baseAttrs);
        if (lDAPEntry == null) {
            Debug.println("  Read of <" + string + "> returned null");
        } else {
            dirNode = new DirNode(this.getModel(), lDAPEntry);
        }
        if (string.equalsIgnoreCase(_configDN) || string.equalsIgnoreCase("cn=ldbm")) {
            dirNode.setIcon(((DirModel)this.getModel()).checkIcon(this._objectClasses, false));
        }
        return dirNode;
    }

    protected void addSuffixNodes(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Debug.println("RootDirNode.addSuffixNodes: <" + string + ">");
            DirNode dirNode = this.getNode(string);
            if (dirNode == null) continue;
            this.add(dirNode);
        }
    }

    protected Vector getChildList() {
        Debug.println("RootDirNode.getChildList");
        this.removeAllChildren();
        String[] stringArray = new String[]{"namingcontexts"};
        LDAPEntry lDAPEntry = this.readEntry("", stringArray);
        if (lDAPEntry == null) {
            Debug.println("RootDirNode.expandRoot: readEntry returned null");
            return null;
        }
        this._objectClasses = this.checkObjectClasses(lDAPEntry);
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
        if (lDAPAttribute == null) {
            Debug.println("RootDirNode.getChildList: <" + stringArray[0] + "> returned null");
            return null;
        }
        this.addSuffixNodes(lDAPAttribute.getStringValues());
        if (this._showPrivateSuffixes) {
            stringArray[0] = _privateSuffixAttr;
            lDAPEntry = this.readEntry(_configDN, stringArray);
            if (lDAPEntry == null) {
                Debug.println("RootDirNode.getChildList: <cn=config> returned null");
            } else {
                lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
                if (lDAPAttribute != null) {
                    this.addSuffixNodes(lDAPAttribute.getStringValues());
                }
            }
        }
        this._fLoaded = true;
        this._fContainer = true;
        this._iChildren = this.children.size();
        Debug.println("RootDirNode.getChildList found " + this._iChildren + " searchable suffixes");
        return null;
    }

    public void initializeFromEntry(LDAPEntry lDAPEntry) {
        Icon icon = this.getIcon();
        super.initializeFromEntry(lDAPEntry);
        this.setIcon(icon);
    }
}

