/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.ComponentFactory;
import com.netscape.management.client.components.DirModel;
import com.netscape.management.client.components.DirNode;
import com.netscape.management.client.components.DirNodeEvent;
import com.netscape.management.client.components.DirTree;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.components.IDirModel;
import com.netscape.management.client.components.IDirNode;
import com.netscape.management.client.components.IDirNodeListener;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.util.DN;

public class DirBrowserDialog
extends GenericDialog {
    private LDAPConnection ldc = null;
    private String baseDN = null;
    private JPanel selectionPanel;
    private JTextField selectionField;
    private TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (DirBrowserDialog.this.tree.isSelectionEmpty()) {
                DirBrowserDialog.this.setSelectionFieldText("");
            }
            DirBrowserDialog.this.updateOKButtonState();
        }
    };
    private DocumentListener documentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent documentEvent) {
            DirBrowserDialog.this.clearTreeSelection();
            DirBrowserDialog.this.updateOKButtonState();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };
    public DirTree tree;
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.components.components");

    private static String i18n(String string) {
        return resource.getString("dirBrowser", string);
    }

    public DirBrowserDialog(JFrame jFrame, LDAPConnection lDAPConnection) {
        this(jFrame, DirBrowserDialog.i18n("title"), lDAPConnection, null);
    }

    public DirBrowserDialog(JFrame jFrame, String string, LDAPConnection lDAPConnection) {
        this(jFrame, string, lDAPConnection, null);
    }

    public DirBrowserDialog(JFrame jFrame, String string, LDAPConnection lDAPConnection, String string2) {
        super(jFrame, string);
        this.ldc = lDAPConnection;
        this.baseDN = string2;
        this.setOKButtonEnabled(false);
        this.getContentPane().add(this.createPanel());
        this.setMinimumSize(this.getContentPane().getPreferredSize());
    }

    protected JPanel createPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        DirModel dirModel = new DirModel(this.ldc);
        dirModel.setCallContentChanged(false);
        dirModel.setShowsPrivateSuffixes(true);
        dirModel.setAllowsLeafNodes(true);
        dirModel.setReferralsEnabled(true);
        dirModel.setCallContentChanged(true);
        dirModel.initialize(this.baseDN != null ? new DirNode((IDirModel)dirModel, this.baseDN) : null);
        this.tree = new DirTree(dirModel){

            public void expandPath(TreePath treePath) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                super.expandPath(treePath);
                this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.tree.addDirNodeListener(new DirNodeListener());
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JPanel jPanel2 = ComponentFactory.createLabelComponent(DirBrowserDialog.i18n("treeLabel"), jScrollPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.selectionField = new JTextField("");
        this.selectionField.setEditable(false);
        this.selectionField.setBackground(UIManager.getColor("control"));
        this.selectionField.getDocument().addDocumentListener(this.documentListener);
        this.selectionPanel = ComponentFactory.createLabelComponent(DirBrowserDialog.i18n("selectionField"), this.selectionField);
        this.selectionPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.selectionPanel, gridBagConstraints);
        jPanel.add(this.selectionPanel);
        jPanel.setPreferredSize(new Dimension(250, 300));
        return jPanel;
    }

    private void clearTreeSelection() {
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.clearSelection();
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
    }

    private void setSelectionFieldText(String string) {
        Document document = this.selectionField.getDocument();
        document.removeDocumentListener(this.documentListener);
        this.selectionField.setText(string);
        document.addDocumentListener(this.documentListener);
    }

    private void updateOKButtonState() {
        String string;
        boolean bl = this.tree.getSelectionCount() >= 1 ? true : ((string = this.selectionField.getText()).length() == 0 ? true : DN.isDN((String)string));
        this.setOKButtonEnabled(bl);
    }

    public IDirModel getDirModel() {
        return (IDirModel)this.tree.getModel();
    }

    public void setDirModel(IDirModel iDirModel) {
        this.tree.setModel(iDirModel);
    }

    public void setBaseDN(String string) {
        this.baseDN = string;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setLDAPConnection(LDAPConnection lDAPConnection) {
        this.ldc = lDAPConnection;
    }

    public LDAPConnection getLDAPConnection() {
        return this.ldc;
    }

    public void setSelectionFieldVisible(boolean bl) {
        this.selectionPanel.setVisible(bl);
    }

    public boolean isSelectionFieldVisible() {
        return this.selectionPanel.isVisible();
    }

    public String getSelectedDN() {
        return this.selectionField.getText();
    }

    public void setSelectionFieldEditable(boolean bl) {
        Color color = bl ? Color.white : UIManager.getColor("control");
        this.selectionField.setEditable(bl);
        this.selectionField.setBackground(color);
        this.updateOKButtonState();
    }

    public boolean isSelectionFieldEditable() {
        return this.selectionField.isEditable();
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("directoryBrowser");
    }

    class DirNodeListener
    implements IDirNodeListener {
        DirNodeListener() {
        }

        public void selectionChanged(IDirNode[] iDirNodeArray) {
            String string;
            if (iDirNodeArray.length > 1) {
                string = "multi-selected";
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer("" + iDirNodeArray[0], "<");
                String string2 = "";
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                if ((stringTokenizer = new StringTokenizer(string2, ">")).hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                if (string2.equals(">")) {
                    string2 = "";
                }
                string = string2;
            }
            DirBrowserDialog.this.setSelectionFieldText(string);
            if (DirBrowserDialog.this.selectionField.isEditable()) {
                DirBrowserDialog.this.selectionField.selectAll();
            }
        }

        public void actionInvoked(DirNodeEvent dirNodeEvent) {
        }
    }
}

