/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.comm;

import com.netscape.management.client.comm.CommChannel;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommManager;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpChannel;
import com.netscape.management.client.comm.HttpsChannel;
import com.netscape.management.client.util.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class HttpManager
extends CommManager {
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOCONTENT = 204;
    public static final int HTTP_MOVEDTEMP = 301;
    public static final int HTTP_MOVEDPERM = 302;
    public static final int HTTP_ERROR = 400;
    public static final int HTTP_AUTHREQ = 401;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOTFOUND = 404;
    public static final int HTTP_SERVERERROR = 500;

    public void trace() {
        Debug.setTrace(true);
    }

    protected Object targetID(Object object) {
        URL uRL = (URL)object;
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = 80;
        if (uRL.getPort() != -1) {
            n = uRL.getPort();
        } else if (string.toLowerCase().equals("https")) {
            n = 443;
        }
        try {
            if (string2.indexOf(":") != -1 && string2.indexOf("[") == -1) {
                string2 = "[" + string2 + "]";
            }
            URL uRL2 = new URL(string + "://" + string2 + ":" + n + "/");
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("HttpManager:targetID():unable to create targetID (" + malformedURLException + ")");
            return null;
        }
    }

    protected CommChannel createChannel(Object object, String string) throws IOException {
        HttpChannel httpChannel = ((URL)object).getProtocol().equals("https") ? new HttpsChannel(object, string, this) : new HttpChannel(object, string, this);
        return httpChannel;
    }

    public void setBufferSize(int n) {
        HttpChannel.setBufferSize(n);
        Debug.println("HttpManager> I/O buffer size set to " + n);
    }

    public CommRecord get(URL uRL, CommClient commClient, Object object) throws IOException {
        return this.send(uRL, commClient, object, null, 0, 0);
    }

    public CommRecord get(URL uRL, CommClient commClient, Object object, int n) throws IOException {
        return this.send(uRL, commClient, object, null, 0, n);
    }

    public CommRecord get(URL uRL, CommClient commClient, Object object, String[] stringArray) throws IOException {
        return this.send(uRL, commClient, object, null, 0, 0, stringArray);
    }

    public CommRecord get(URL uRL, CommClient commClient, Object object, int n, String[] stringArray) throws IOException {
        return this.send(uRL, commClient, object, null, 0, n, stringArray);
    }

    public CommRecord post(URL uRL, CommClient commClient, Object object, InputStream inputStream, int n) throws IOException {
        return this.send(uRL, commClient, object, inputStream, n, 0);
    }

    public CommRecord post(URL uRL, CommClient commClient, Object object, InputStream inputStream, int n, int n2) throws IOException {
        return this.send(uRL, commClient, object, inputStream, n, n2);
    }

    public CommRecord post(URL uRL, CommClient commClient, Object object, InputStream inputStream, int n, String[] stringArray) throws IOException {
        return this.send(uRL, commClient, object, inputStream, n, 0, stringArray);
    }

    public CommRecord post(URL uRL, CommClient commClient, Object object, InputStream inputStream, int n, int n2, String[] stringArray) throws IOException {
        return this.send(uRL, commClient, object, inputStream, n, n2, stringArray);
    }
}

