/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acl.LdapACL;
import com.netscape.management.client.acl.LdapACLSelector;
import com.netscape.management.client.acleditor.ACLEditor;
import com.netscape.management.client.acleditor.ACLEditorWindow;
import com.netscape.management.client.acleditor.PopupErrorDialog;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import netscape.ldap.LDAPException;

public class ACLSelectorWindow
extends ACLEditorWindow
implements LdapACLSelector,
MouseListener {
    protected JList list;
    protected DefaultListModel data;
    protected Vector aci;
    protected LdapACL acl;
    protected boolean errorOccurred = false;

    public ACLSelectorWindow(ACLEditor aCLEditor) {
        super(aCLEditor.getWindowFactory(), "aclselector", aCLEditor.getWindowFactory().getSessionIdentifier());
        JPanel jPanel = this.createStandardLayout();
        this.data = new DefaultListModel();
        this.list = new JList(this.data);
        this.list.addMouseListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        jPanel.add((Component)this.createInstruction("main2"), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JScrollPane(this.list), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 10, 10));
        jPanel2.add(this.createButton("new", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLSelectorWindow.this.newACI(actionEvent);
            }
        }));
        jPanel2.add(this.createButton("delete", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLSelectorWindow.this.deleteACI(actionEvent);
            }
        }));
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.setButtons();
        this.pack();
    }

    public synchronized void newACI(ActionEvent actionEvent) {
        this.list.clearSelection();
        this.notifyAll();
        super.save(actionEvent);
    }

    public void deleteACI(ActionEvent actionEvent) {
        if (this.list.getSelectedIndex() == -1) {
            return;
        }
        String string = (String)this.aci.elementAt(this.list.getSelectedIndex());
        try {
            this.acl.deleteACI(string);
        }
        catch (LDAPException lDAPException) {
            this.showErrorDialog(LdapACL.checkLDAPError(lDAPException));
        }
        this.aci.removeElementAt(this.list.getSelectedIndex());
        this.data.removeElementAt(this.list.getSelectedIndex());
        this.setButtons();
    }

    public void error(LdapACL ldapACL, Exception exception) {
        this.setError();
        Debug.println("ACLSelectorWindow.error: " + exception.toString());
        if (exception instanceof LDAPException) {
            new PopupErrorDialog(this, LdapACL.checkLDAPError((LDAPException)((Object)exception)), "errorTitle2");
        } else {
            new PopupErrorDialog(this, exception.toString(), "errorTitle2");
        }
    }

    public synchronized String select(LdapACL ldapACL, Enumeration enumeration) {
        this.acl = ldapACL;
        this.aci = new Vector();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.aci.addElement(string);
                this.data.addElement(LdapACL.getACLName(string));
            }
        }
        this.show();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.list.getSelectedIndex() == -1) {
            return null;
        }
        return (String)this.aci.elementAt(this.list.getSelectedIndex());
    }

    protected synchronized void save(ActionEvent actionEvent) {
        if (this.list.getSelectedIndex() == -1) {
            this.showErrorDialog();
            return;
        }
        this.notifyAll();
        super.save(actionEvent);
    }

    protected synchronized void cancel(ActionEvent actionEvent) {
        this.notifyAll();
        super.cancel(actionEvent);
        this.setError();
    }

    public void setButtons() {
        this.getComponent("delete").setEnabled(this.list.getSelectedIndex() != -1);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.setButtons();
        if (this.list.getSelectedIndex() == -1) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            this.save(null);
        }
    }

    public boolean isError() {
        return this.errorOccurred;
    }

    public void setError() {
        this.errorOccurred = true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

