/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.UGTableModel;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;

class UGTable
extends Table {
    private ResourceSet resource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");
    private UGTableModel dataModel;
    private JPopupMenu tableHeaderMenu;
    private JMenuItem customizeMenuItem;
    private Hashtable map = new Hashtable();
    private Vector attributes;
    private Vector columnNames;
    private ConsoleInfo consoleInfo = null;
    private static String[] availableAttributes;
    private String baseDN;
    private int searchScope = 2;

    public UGTable() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("cn");
        vector.addElement("uid");
        vector.addElement("mail");
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(this.getDisplayFromDescDisplayPair(this.resource.getString("SearchResultPanel", "ColumnLabel0")));
        vector2.addElement(this.getDisplayFromDescDisplayPair(this.resource.getString("SearchResultPanel", "ColumnLabel1")));
        vector2.addElement(this.getDisplayFromDescDisplayPair(this.resource.getString("SearchResultPanel", "ColumnLabel2")));
        this.dataModel = new UGTableModel(vector, vector2);
        this.setModel(this.dataModel);
        this.setSelectionMode(2);
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setWidth(200);
        tableColumnModel.getColumn(1).setWidth(100);
    }

    public void setColumnInfo(Vector vector, Vector vector2) {
        if (vector != null && vector2 != null) {
            int n = vector.size();
            int n2 = vector2.size();
            if (n == 0 || n != n2) {
                Debug.println("VLDirectoryTable.setColumnInfo: invalid parameters: size of column attributes and labels differ");
                return;
            }
            this.attributes = vector;
            this.columnNames = vector2;
            this.dataModel.setColumnInfo(vector, vector2);
        } else {
            Debug.println("VLDirectoryTable.setColumnInfo: invalid parameters: column attributes and/or labels are null");
        }
    }

    public int getMaxResults() {
        return this.dataModel.getMaxResults();
    }

    public void setMaxResults(int n) {
        this.dataModel.setMaxResults(n);
    }

    public void setUserDN(String string) {
        this.baseDN = string;
    }

    public String getUserDN() {
        return this.baseDN;
    }

    public void setSearchScope(int n) {
        this.searchScope = n;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public synchronized void doSearch(LDAPConnection lDAPConnection, String string, String string2) {
        JScrollPane jScrollPane = null;
        Container container = this;
        while (jScrollPane == null && container != null) {
            if (!((container = container.getParent()) instanceof JScrollPane)) continue;
            jScrollPane = (JScrollPane)container;
        }
        int n = jScrollPane == null ? this.getSize().height : jScrollPane.getViewport().getSize().height;
        int n2 = this.getRowHeight();
        int n3 = n / n2;
        this.dataModel.setPageSize(n3);
        this.dataModel.doSearch(lDAPConnection, string, this.searchScope, string2);
        if (this.dataModel.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
    }

    public void addRow(LDAPEntry lDAPEntry) {
        this.dataModel.addRow(lDAPEntry);
    }

    public void addRow(String string) {
        this.dataModel.addRow(string);
    }

    public void replaceRow(LDAPEntry lDAPEntry, int n) {
        this.dataModel.replaceRow(lDAPEntry, n);
    }

    public Vector getSelectedEntries() {
        int[] nArray = this.getSelectedRows();
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        if (nArray.length == 1 && this.getRow(nArray[0]) == null) {
            return vector;
        }
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(this.getRow(nArray[n]));
            ++n;
        }
        return vector;
    }

    public LDAPEntry getRow(int n) {
        return this.dataModel.getRow(n);
    }

    public int getRowCount() {
        int n = 0;
        n = this.dataModel != null ? this.dataModel.getRowCount() : super.getRowCount();
        return n;
    }

    public void deleteAllRows() {
        this.dataModel.deleteAllRows();
    }

    public void deleteRow(int n) {
        if (n != -1) {
            this.dataModel.deleteRow(n);
        }
    }

    public void deleteRows(int[] nArray) {
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(this.getRow(nArray[n]));
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            this.dataModel.deleteRow((LDAPEntry)vector.elementAt(n2));
            ++n2;
        }
    }

    public void deleteRows(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.dataModel.deleteRow((LDAPEntry)vector.elementAt(n2));
            ++n2;
        }
    }

    public void cancelSearch() {
        this.dataModel.cancelSearch();
    }

    private boolean initializeAvailableAttributes() {
        if (this.consoleInfo == null) {
            Debug.println("VLDirectoryTable: no session info to get schema from");
            return false;
        }
        LDAPSchema lDAPSchema = null;
        LDAPConnection lDAPConnection = this.consoleInfo.getUserLDAPConnection();
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            try {
                lDAPSchema = new LDAPSchema();
                lDAPSchema.fetchSchema(lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                lDAPSchema = null;
            }
        }
        if (lDAPSchema == null) {
            Debug.println("VLDirectoryTable: could not get schema");
            return false;
        }
        Vector vector = new Vector();
        Vector vector2 = (Vector)ResourceEditor.getNewObjectClasses().get("newUserObjectClasses");
        Vector vector3 = (Vector)ResourceEditor.getNewObjectClasses().get("newGroupObjectClasses");
        if (vector2 == null || vector3 == null) {
            Debug.println("VLDirectoryTable: cannot get attributes since one or more objectclasses are null");
            return false;
        }
        this.getAllAttributesFor(vector, vector2, lDAPSchema);
        this.getAllAttributesFor(vector, vector3, lDAPSchema);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        availableAttributes = objectArray;
        return true;
    }

    private void getAllAttributesFor(Vector vector, Vector vector2, LDAPSchema lDAPSchema) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LDAPObjectClassSchema lDAPObjectClassSchema = lDAPSchema.getObjectClass(string);
            Enumeration enumeration2 = lDAPObjectClassSchema.getRequiredAttributes();
            Enumeration enumeration3 = lDAPObjectClassSchema.getOptionalAttributes();
            Object e = null;
            while (enumeration2.hasMoreElements()) {
                e = enumeration2.nextElement();
                if (((String)e).indexOf("binary") != -1 || vector.indexOf(e) != -1) continue;
                vector.addElement(e);
            }
            while (enumeration3.hasMoreElements()) {
                e = enumeration3.nextElement();
                if (((String)e).indexOf("binary") != -1 || vector.indexOf(e) != -1) continue;
                vector.addElement(e);
            }
        }
    }

    private String getDisplayFromDescDisplayPair(String string) {
        String string2 = string;
        int n = string.indexOf(44);
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }
}

