/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.ACIAttribute;
import com.netscape.management.client.ace.FilteredInputDocument;
import com.netscape.management.client.ace.IACITab;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.ErrorDialog;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.HostException;
import com.netscape.management.client.util.IPAddressValidator;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPConnection;

class HostTab
implements IACITab,
UIConstants {
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.ace.ace");
    private static RemoteImage hostIcon = new RemoteImage("com/netscape/management/client/images/host.gif");
    private static String KEYWORD_DNS = "dns";
    private static String KEYWORD_IP = "ip";
    private static String KEYWORD_OR = "or";
    private static String KEYWORD_AND = "and";
    private static int TAB_POSITION = 3;
    private JFrame parentFrame;
    private Table hostTable = null;
    private DefaultTableModel tableModel = null;
    private JButton addButton;
    private JButton removeButton;
    private JPanel p = new JPanel();
    private boolean isInitialized = false;
    private GenericDialog addHostDialog;
    private JTextField dnsField;
    private JTextField ipField;
    private boolean _ipv6Supported = false;

    HostTab() {
    }

    private static String i18n(String string) {
        return i18n.getString("host", string);
    }

    public void initialize(JFrame jFrame, LDAPConnection lDAPConnection, String string, LDAPConnection lDAPConnection2, String string2) {
        this.parentFrame = jFrame;
        this._ipv6Supported = LDAPUtil.isDirectoryServerSupportingIPv6(lDAPConnection);
        hostIcon.setDescription(HostTab.i18n("icon-description"));
    }

    public ACIAttribute[] aciChanged(ACIAttribute[] aCIAttributeArray, String string) {
        Vector<ACIAttribute> vector = new Vector<ACIAttribute>();
        this.tableModel.setNumRows(0);
        int n = 0;
        while (n < aCIAttributeArray.length) {
            ACIAttribute aCIAttribute = aCIAttributeArray[n];
            if (aCIAttribute.getName().equalsIgnoreCase(KEYWORD_IP) || aCIAttribute.getName().equalsIgnoreCase(KEYWORD_DNS)) {
                ACIAttribute aCIAttribute2;
                String string2;
                this.addHost(aCIAttribute.getValue(), aCIAttribute.getName().equalsIgnoreCase(KEYWORD_IP));
                vector.addElement(aCIAttribute);
                if (n > 0 && ((string2 = (aCIAttribute2 = aCIAttributeArray[n - 1]).getOperator()).equalsIgnoreCase(KEYWORD_OR) || string2.equalsIgnoreCase(KEYWORD_AND))) {
                    vector.addElement(aCIAttribute2);
                }
            }
            ++n;
        }
        return ACIAttribute.toArray(vector);
    }

    public JComponent getComponent() {
        this.tableModel = this.createTableModel();
        this.hostTable = new Table((TableModel)this.tableModel, true);
        this.hostTable.getAccessibleContext().setAccessibleDescription(HostTab.i18n("info"));
        this.p.setPreferredSize(new Dimension(480, 260));
        return this.p;
    }

    public int getPreferredPosition() {
        return TAB_POSITION;
    }

    private DefaultTableModel createTableModel() {
        DefaultTableModel defaultTableModel = new DefaultTableModel(){
            static /* synthetic */ Class class$javax$swing$JLabel;
            static /* synthetic */ Class class$java$lang$String;

            public Class getColumnClass(int n) {
                if (n == 0) {
                    return class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = 1.class$("javax.swing.JLabel")) : class$javax$swing$JLabel;
                }
                return class$java$lang$String == null ? (class$java$lang$String = 1.class$("java.lang.String")) : class$java$lang$String;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        defaultTableModel.addColumn(HostTab.i18n("columnName"));
        defaultTableModel.addColumn(HostTab.i18n("columnType"));
        return defaultTableModel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        this.addButton = ButtonFactory.createPredefinedButton("ADD", buttonActionListener);
        this.addButton.setToolTipText(HostTab.i18n("add_tt"));
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        jPanel.add(this.addButton);
        this.removeButton = ButtonFactory.createPredefinedButton("REMOVE", buttonActionListener);
        this.removeButton.setToolTipText(HostTab.i18n("remove_tt"));
        this.removeButton.setEnabled(false);
        gridBagLayout.setConstraints(this.removeButton, gridBagConstraints);
        jPanel.add(this.removeButton);
        ButtonFactory.resizeButtons(this.addButton, this.removeButton);
        return jPanel;
    }

    public String getTitle() {
        return HostTab.i18n("title");
    }

    public void tabSelected() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.p.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.p.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel();
        jLabel.setText(HostTab.i18n("info"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.p.add(jLabel);
        jLabel.setLabelFor(this.hostTable);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.hostTable.setSelectionMode(2);
        this.hostTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    HostTab.this.removeButton.setEnabled(!HostTab.this.hostTable.getSelectionModel().isSelectionEmpty());
                }
            }
        });
        this.hostTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = ((TableModel)tableModelEvent.getSource()).getRowCount();
                HostTab.this.removeButton.setEnabled(n > 0);
            }
        });
        final JScrollPane jScrollPane = new JScrollPane(this.hostTable);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.p.add(jScrollPane);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        JPanel jPanel = this.createButtonPanel();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.p.add(jPanel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = (int)(0.6 * jScrollPane.getSize().getWidth());
                TableColumnModel tableColumnModel = HostTab.this.hostTable.getColumnModel();
                tableColumnModel.getColumn(0).setPreferredWidth(n);
            }
        });
    }

    public StringBuffer createACI(StringBuffer stringBuffer) {
        int n = this.tableModel.getRowCount();
        if (n == 0) {
            return stringBuffer;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(" and \n(");
        int n2 = 0;
        while (n2 < n) {
            JLabel jLabel = (JLabel)this.hostTable.getValueAt(n2, 0);
            String string = jLabel instanceof IPFilterLabel ? KEYWORD_IP : KEYWORD_DNS;
            stringBuffer2.append(string + "=" + "\"" + jLabel.getText() + "\"");
            if (n2 < n - 1) {
                stringBuffer2.append(" or \n");
            }
            ++n2;
        }
        stringBuffer2.append(")");
        if (stringBuffer.toString().endsWith("\n;)")) {
            int n3 = stringBuffer.length() - 3;
            stringBuffer.insert(n3, (Object)stringBuffer2);
        }
        return stringBuffer;
    }

    private void showAddHostDialog() {
        this.dnsField = new JTextField(30);
        this.ipField = new JTextField(30);
        this.addHostDialog = new ACIGenericDialog(this.parentFrame, HostTab.i18n("addhostdialog-title"));
        this.addHostDialog.getAccessibleContext().setAccessibleDescription(HostTab.i18n("addhostdialog-description"));
        this.addHostDialog.getContentPane().add(this.createAddContentPanel());
        this.addHostDialog.setFocusComponent(this.dnsField);
        this.addHostDialog.setDefaultButton(1);
        this.addHostDialog.setOKButtonEnabled(false);
        this.addHostDialog.setHelpTopic("admin", "ace-addHost");
        this.addHostDialog.show();
        if (!this.addHostDialog.isCancel()) {
            if (this.ipField.isEnabled()) {
                this.addHost(this.ipField.getText(), true);
            } else {
                this.addHost(this.dnsField.getText(), false);
            }
        }
    }

    private void addHost(String string, boolean bl) {
        if (bl) {
            IPFilterLabel iPFilterLabel = new IPFilterLabel(string);
            this.tableModel.addRow(new Object[]{iPFilterLabel, HostTab.i18n(KEYWORD_IP)});
        } else {
            DNSFilterLabel dNSFilterLabel = new DNSFilterLabel(string);
            this.tableModel.addRow(new Object[]{dNSFilterLabel, HostTab.i18n(KEYWORD_DNS)});
        }
    }

    private JPanel createAddContentPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        JRadioButton jRadioButton = new JRadioButton(HostTab.i18n("dialogDNS"), true);
        JPanel jPanel2 = this.createRadioPanel(jRadioButton, this.dnsField);
        this.dnsField.setEnabled(true);
        this.dnsField.getAccessibleContext().setAccessibleName(HostTab.i18n("dialogDNS"));
        this.dnsField.getAccessibleContext().setAccessibleDescription(HostTab.i18n("dialogDNS"));
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.dnsField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.stateChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.stateChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.stateChanged();
            }

            void stateChanged() {
                if (HostTab.this.dnsField.isEnabled()) {
                    HostTab.this.addHostDialog.setOKButtonEnabled(HostTab.this.dnsField.getText().length() > 0);
                }
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        JRadioButton jRadioButton2 = new JRadioButton(HostTab.i18n("dialogIP"), false);
        JPanel jPanel3 = this.createRadioPanel(jRadioButton2, this.ipField);
        this.ipField.setEnabled(false);
        this.ipField.getAccessibleContext().setAccessibleName(HostTab.i18n("dialogIP"));
        this.ipField.getAccessibleContext().setAccessibleDescription(HostTab.i18n("dialogIP"));
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        ((JTextComponent)this.ipField).setDocument(new FilteredInputDocument("01234567890:.abcdefABCDEF*"));
        this.ipField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.stateChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.stateChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.stateChanged();
            }

            void stateChanged() {
                if (HostTab.this.ipField.isEnabled()) {
                    HostTab.this.addHostDialog.setOKButtonEnabled(HostTab.this.ipField.getText().length() > 0);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        return jPanel;
    }

    private JPanel createRadioPanel(JRadioButton jRadioButton, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
        jRadioButton.addChangeListener(new RadioChangeListener(jComponent));
        jPanel.add(jRadioButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 18, 0, 0);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        return jPanel;
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("ace-hosts");
    }

    public void okInvoked() {
    }

    public void cancelInvoked() {
    }

    private void removeHost() {
        int n = this.hostTable.getSelectedRow() - 1;
        int[] nArray = this.hostTable.getSelectedRows();
        int n2 = 0;
        while (n2 < nArray.length) {
            this.tableModel.removeRow(nArray[n2]);
            ++n2;
        }
        int n3 = this.hostTable.getRowCount();
        if (n3 > 0) {
            if (n < 0) {
                n = 0;
            }
            if (n >= n3) {
                n = n3;
            }
            ListSelectionModel listSelectionModel = this.hostTable.getSelectionModel();
            listSelectionModel.setSelectionInterval(n, n);
        }
    }

    public ACIAttribute[] getSupportedAttributes() {
        return new ACIAttribute[]{new ACIAttribute(KEYWORD_DNS, "=|!=", "\"*\""), new ACIAttribute(KEYWORD_IP, "=|!=", "\"*\""), new ACIAttribute(KEYWORD_IP, "=|!=", "\"###.###.###.###\"")};
    }

    class IPFilterLabel
    extends JLabel {
        public IPFilterLabel(String string) {
            super(string, hostIcon, 4);
        }
    }

    class DNSFilterLabel
    extends JLabel {
        public DNSFilterLabel(String string) {
            super(string, hostIcon, 4);
        }
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ADD")) {
                HostTab.this.showAddHostDialog();
            } else if (string.equals("REMOVE")) {
                HostTab.this.removeHost();
            }
        }
    }

    class RadioChangeListener
    implements ChangeListener {
        JComponent c;

        public RadioChangeListener(JComponent jComponent) {
            this.c = jComponent;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JRadioButton jRadioButton = (JRadioButton)changeEvent.getSource();
            boolean bl = jRadioButton.isSelected();
            this.c.setEnabled(bl);
            if (this.c instanceof JTextField) {
                this.c.setBackground(UIManager.getColor(bl ? "TextField.background" : "control"));
            }
        }
    }

    class ACIGenericDialog
    extends GenericDialog {
        public ACIGenericDialog(JFrame jFrame, String string) {
            super(jFrame, string);
        }

        public void helpInvoked() {
            ConsoleHelp.showContextHelp("ace-addHost");
        }

        public void validateData() throws HostException {
            if (HostTab.this.ipField.isEnabled()) {
                IPAddressValidator iPAddressValidator = new IPAddressValidator(HostTab.this.ipField.getText(), HostTab.this._ipv6Supported);
                iPAddressValidator.setWildcardAllowed(true);
                iPAddressValidator.validate();
            } else {
                this.validateHostName();
            }
        }

        public void validateHostName() throws HostException {
            String string = HostTab.this.dnsField.getText();
            if (string.length() == 0 || string.equals(" ")) {
                throw new HostException(HostTab.i18n("msgErrorHostname"), 4);
            }
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c > '\u007f') {
                    throw new HostException(HostTab.i18n("msgErrorHostname"), 4);
                }
                ++n;
            }
        }

        public void okInvoked() {
            try {
                this.validateData();
                super.okInvoked();
            }
            catch (HostException hostException) {
                String string = HostTab.i18n("hostexception");
                String string2 = hostException.getMessage();
                String string3 = null;
                String string4 = hostException.getDetailMessage();
                ErrorDialog errorDialog = new ErrorDialog(HostTab.this.parentFrame, string, string2, string3, string4, 5, 1);
                errorDialog.hideDetail();
                ((Component)errorDialog).setVisible(true);
            }
        }
    }
}

