/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.ACIAttribute;
import java.util.Enumeration;
import java.util.Vector;

class ACIParser {
    ACIParser() {
    }

    public static Vector getACIAttributes(String string) {
        int n = 0;
        Vector vector = new Vector();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            switch (string.charAt(n3)) {
                case '\n': 
                case ' ': {
                    break;
                }
                case '(': {
                    ++n3;
                }
                default: {
                    n = n3 = ACIParser.parseACIName(string, n3, vector, n);
                }
            }
            if (n3 < 0) {
                n3 = -n3;
                System.err.println("ACI ERROR: cannot parse at index " + n3);
                System.err.println(string);
                int n4 = 0;
                while (n4 < n3) {
                    System.err.print(" ");
                    ++n4;
                }
                System.err.println("^");
                break;
            }
            ++n3;
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parseACIName(String string, int n, Vector vector, int n2) {
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (n < n3) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': {
                    break;
                }
                case ' ': 
                case '(': {
                    if (stringBuffer.length() <= 0) break;
                    bl = true;
                    break;
                }
                case '!': 
                case '<': 
                case '=': 
                case '>': 
                case '|': {
                    bl = true;
                    break;
                }
                case ')': {
                    return n;
                }
                case ';': {
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            if (bl) {
                if (stringBuffer.length() <= 0) return n;
                String string2 = stringBuffer.toString();
                if (string2.equalsIgnoreCase("and") || string2.equalsIgnoreCase("or")) {
                    ACIAttribute aCIAttribute = new ACIAttribute("", string2, "", n2, n);
                    vector.addElement(aCIAttribute);
                    n2 = n + 1;
                } else {
                    if (string.charAt(n) == ' ' || string.charAt(n) == '(') {
                        ++n;
                    }
                    n2 = n = ACIParser.parseACIValue(string, n, string2, vector, n2);
                }
                if (n <= 0) return n;
                bl = false;
                stringBuffer = null;
                stringBuffer = new StringBuffer();
                --n;
            }
            ++n;
        }
        return n;
    }

    private static int parseACIValue(String string, int n, String string2, Vector vector, int n2) {
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        while (n < n3) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': {
                    break;
                }
                case '!': 
                case '<': 
                case '=': 
                case '>': 
                case '|': {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer2.append(c);
                    break;
                }
                case ' ': {
                    if (stringBuffer.length() <= 0) break;
                    stringBuffer.append(c);
                    break;
                }
                case '\"': {
                    stringBuffer.append(c);
                    boolean bl3 = bl2 = !bl2;
                    if (bl2) break;
                    bl = true;
                    break;
                }
                case '(': {
                    if (!bl2) {
                        ++n4;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case ')': {
                    if (n4 > 0 || bl2) {
                        stringBuffer.append(c);
                    }
                    if (bl2 || --n4 > 0) break;
                    bl = true;
                    break;
                }
                case ';': {
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            if (bl) {
                int n5 = stringBuffer.length();
                if (n5 <= 0) break;
                String string3 = stringBuffer.toString();
                if (string3.endsWith("\"")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1);
                }
                ACIAttribute aCIAttribute = new ACIAttribute(string2, stringBuffer2.toString(), string3, n2, n);
                vector.addElement(aCIAttribute);
                return n + 1;
            }
            ++n;
        }
        return -n;
    }

    public static void main(String[] stringArray) {
        String string = "(targetattr = \"*\") (version 3.0; acl \"<Unnamed ACI>\"; allow (all) (userdn = \"ldap:///anyone\") and (dns=\"*.mcom.com\");)";
        System.out.println("aci: " + string);
        Vector vector = ACIParser.getACIAttributes(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println((ACIAttribute)enumeration.nextElement());
        }
        int n = vector.indexOf(new ACIAttribute("acl"));
        if (n != -1) {
            System.out.println("\nThe name of this ACI is '" + ((ACIAttribute)vector.elementAt(n)).getValue() + "'");
        }
    }
}

